/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.tasks.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.tasks.NoSuchProposalException;
import com.liferay.portlet.tasks.ProposalDueDateException;
import com.liferay.portlet.tasks.model.TasksProposal;
import com.liferay.portlet.tasks.service.base.TasksProposalLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TasksProposalLocalServiceImpl
extends TasksProposalLocalServiceBaseImpl {
    public TasksProposal addProposal(long userId, long groupId, String className, String classPK, String name, String description, long reviewUserId, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        return this.addProposal(userId, groupId, className, classPK, name, description, reviewUserId, addCommunityPermissions, addGuestPermissions, null, null);
    }

    public TasksProposal addProposal(long userId, long groupId, String className, String classPK, String name, String description, long reviewUserId, Boolean addCommunityPermissions, Boolean addGuestPermissions, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long classNameId = PortalUtil.getClassNameId((String)className);
        Date now = new Date();
        long proposalId = this.counterLocalService.increment();
        TasksProposal proposal = this.tasksProposalPersistence.create(proposalId);
        proposal.setGroupId(groupId);
        proposal.setCompanyId(user.getCompanyId());
        proposal.setUserId(user.getUserId());
        proposal.setUserName(user.getFullName());
        proposal.setCreateDate(now);
        proposal.setModifiedDate(now);
        proposal.setClassNameId(classNameId);
        proposal.setClassPK(classPK);
        proposal.setName(name);
        proposal.setDescription(description);
        proposal = (TasksProposal)this.tasksProposalPersistence.update((BaseModel)proposal, false);
        if (addCommunityPermissions != null && addGuestPermissions != null) {
            this.addProposalResources(proposal, (boolean)addCommunityPermissions, (boolean)addGuestPermissions);
        } else {
            this.addProposalResources(proposal, communityPermissions, guestPermissions);
        }
        long assignedByUserId = userId;
        int stage = 1;
        this.tasksReviewLocalService.addReview(reviewUserId, proposal.getProposalId(), assignedByUserId, stage);
        this.mbMessageLocalService.addDiscussionMessage(userId, proposal.getUserName(), TasksProposal.class.getName(), proposalId);
        this.socialActivityLocalService.addActivity(userId, groupId, TasksProposal.class.getName(), proposalId, 1, "", 0L);
        return proposal;
    }

    public TasksProposal addProposal(long userId, long groupId, String className, String classPK, String name, String description, long reviewUserId, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        return this.addProposal(userId, groupId, className, classPK, name, description, reviewUserId, null, null, communityPermissions, guestPermissions);
    }

    public void addProposalResources(long proposalId, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        TasksProposal proposal = this.tasksProposalPersistence.findByPrimaryKey(proposalId);
        this.addProposalResources(proposal, addCommunityPermissions, addGuestPermissions);
    }

    public void addProposalResources(long proposalId, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        TasksProposal proposal = this.tasksProposalPersistence.findByPrimaryKey(proposalId);
        this.addProposalResources(proposal, communityPermissions, guestPermissions);
    }

    public void addProposalResources(TasksProposal proposal, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(proposal.getCompanyId(), proposal.getGroupId(), proposal.getUserId(), TasksProposal.class.getName(), proposal.getProposalId(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addProposalResources(TasksProposal proposal, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(proposal.getCompanyId(), proposal.getGroupId(), proposal.getUserId(), TasksProposal.class.getName(), proposal.getProposalId(), communityPermissions, guestPermissions);
    }

    public void deleteProposal(long proposalId) throws PortalException, SystemException {
        TasksProposal proposal = this.tasksProposalPersistence.findByPrimaryKey(proposalId);
        this.deleteProposal(proposal);
    }

    public void deleteProposal(long classNameId, String classPK) throws PortalException, SystemException {
        try {
            TasksProposal proposal = this.getProposal(classNameId, classPK);
            this.deleteProposal(proposal);
        }
        catch (NoSuchProposalException nspe) {
            // empty catch block
        }
    }

    public void deleteProposal(String className, String classPK) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        this.deleteProposal(classNameId, classPK);
    }

    public void deleteProposal(TasksProposal proposal) throws PortalException, SystemException {
        this.tasksProposalPersistence.remove((BaseModel)proposal);
        this.resourceLocalService.deleteResource(proposal.getCompanyId(), TasksProposal.class.getName(), 4, proposal.getProposalId());
        this.tasksReviewLocalService.deleteReviews(proposal.getProposalId());
        this.mbMessageLocalService.deleteDiscussionMessages(TasksProposal.class.getName(), proposal.getProposalId());
        this.socialActivityLocalService.deleteActivities(TasksProposal.class.getName(), proposal.getProposalId());
    }

    public void deleteProposals(long groupId) throws PortalException, SystemException {
        List proposals = this.tasksProposalPersistence.findByGroupId(groupId);
        for (TasksProposal proposal : proposals) {
            this.deleteProposal(proposal);
        }
    }

    public TasksProposal getProposal(long proposalId) throws PortalException, SystemException {
        return this.tasksProposalPersistence.findByPrimaryKey(proposalId);
    }

    public TasksProposal getProposal(long classNameId, String classPK) throws PortalException, SystemException {
        return this.tasksProposalPersistence.findByC_C(classNameId, classPK);
    }

    public TasksProposal getProposal(String className, String classPK) throws PortalException, SystemException {
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.getProposal(classNameId, classPK);
    }

    public List<TasksProposal> getProposals(long groupId, int start, int end) throws SystemException {
        return this.tasksProposalPersistence.findByGroupId(groupId, start, end);
    }

    public int getProposalsCount(long groupId) throws SystemException {
        return this.tasksProposalPersistence.countByGroupId(groupId);
    }

    public List<TasksProposal> getReviewProposals(long groupId, long userId, int start, int end) throws SystemException {
        return this.tasksProposalFinder.findByG_U(groupId, userId, start, end);
    }

    public int getReviewProposalsCount(long groupId, long userId) throws SystemException {
        return this.tasksProposalFinder.countByG_U(groupId, userId);
    }

    public List<TasksProposal> getUserProposals(long groupId, long userId, int start, int end) throws SystemException {
        return this.tasksProposalPersistence.findByG_U(groupId, userId, start, end);
    }

    public int getUserProposalsCount(long groupId, long userId) throws SystemException {
        return this.tasksProposalPersistence.countByG_U(groupId, userId);
    }

    public TasksProposal updateProposal(long userId, long proposalId, String description, int dueDateMonth, int dueDateDay, int dueDateYear, int dueDateHour, int dueDateMinute) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date dueDate = PortalUtil.getDate((int)dueDateMonth, (int)dueDateDay, (int)dueDateYear, (int)dueDateHour, (int)dueDateMinute, (TimeZone)user.getTimeZone(), (PortalException)new ProposalDueDateException());
        TasksProposal proposal = this.tasksProposalPersistence.findByPrimaryKey(proposalId);
        proposal.setModifiedDate(new Date());
        proposal.setDescription(description);
        proposal.setDueDate(dueDate);
        this.tasksProposalPersistence.update((BaseModel)proposal, false);
        return proposal;
    }
}

