/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.tasks.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portlet.tasks.DuplicateReviewUserIdException;
import com.liferay.portlet.tasks.model.TasksProposal;
import com.liferay.portlet.tasks.model.TasksReview;
import com.liferay.portlet.tasks.service.base.TasksReviewLocalServiceBaseImpl;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TasksReviewLocalServiceImpl
extends TasksReviewLocalServiceBaseImpl {
    public TasksReview addReview(long userId, long proposalId, long assignedByUserId, int stage) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        TasksProposal proposal = this.tasksProposalPersistence.findByPrimaryKey(proposalId);
        User assignedByUser = this.userPersistence.findByPrimaryKey(assignedByUserId);
        Date now = new Date();
        long reviewId = this.counterLocalService.increment();
        TasksReview review = this.tasksReviewPersistence.create(reviewId);
        review.setGroupId(proposal.getGroupId());
        review.setCompanyId(user.getCompanyId());
        review.setUserId(user.getUserId());
        review.setUserName(user.getFullName());
        review.setCreateDate(now);
        review.setModifiedDate(now);
        review.setProposalId(proposalId);
        review.setAssignedByUserId(assignedByUserId);
        review.setAssignedByUserName(assignedByUser.getFullName());
        review.setStage(stage);
        review.setCompleted(false);
        review.setRejected(false);
        this.tasksReviewPersistence.update((BaseModel)review, false);
        JSONObject extraData = JSONFactoryUtil.createJSONObject();
        extraData.put("stage", review.getStage());
        extraData.put("completed", review.getCompleted());
        extraData.put("rejected", review.getRejected());
        this.socialActivityLocalService.addActivity(assignedByUserId, proposal.getGroupId(), TasksProposal.class.getName(), proposalId, 2, extraData.toString(), userId);
        return review;
    }

    public TasksReview approveReview(long userId, long proposalId, int stage) throws PortalException, SystemException {
        return this.updateReview(userId, proposalId, stage, false);
    }

    public void deleteReview(long reviewId) throws PortalException, SystemException {
        TasksReview review = this.tasksReviewPersistence.findByPrimaryKey(reviewId);
        this.deleteReview(review);
    }

    public void deleteReview(TasksReview review) throws SystemException {
        this.tasksReviewPersistence.remove((BaseModel)review);
    }

    public void deleteReviews(long proposalId) throws SystemException {
        List reviews = this.tasksReviewPersistence.findByProposalId(proposalId);
        for (TasksReview review : reviews) {
            this.deleteReview(review);
        }
    }

    public TasksReview getReview(long reviewId) throws PortalException, SystemException {
        return this.tasksReviewPersistence.findByPrimaryKey(reviewId);
    }

    public TasksReview getReview(long userId, long proposalId) throws PortalException, SystemException {
        return this.tasksReviewPersistence.findByU_P(userId, proposalId);
    }

    public List<TasksReview> getReviews(long proposalId) throws SystemException {
        return this.tasksReviewPersistence.findByProposalId(proposalId);
    }

    public List<TasksReview> getReviews(long proposalId, int stage) throws SystemException {
        return this.tasksReviewPersistence.findByP_S(proposalId, stage);
    }

    public List<TasksReview> getReviews(long proposalId, int stage, boolean completed) throws SystemException {
        return this.tasksReviewPersistence.findByP_S_C(proposalId, stage, completed);
    }

    public List<TasksReview> getReviews(long proposalId, int stage, boolean completed, boolean rejected) throws SystemException {
        return this.tasksReviewPersistence.findByP_S_C_R(proposalId, stage, completed, rejected);
    }

    public TasksReview rejectReview(long userId, long proposalId, int stage) throws PortalException, SystemException {
        return this.updateReview(userId, proposalId, stage, true);
    }

    public void updateReviews(long proposalId, long assignedByUserId, long[][] userIdsPerStage) throws PortalException, SystemException {
        Object userIds;
        int i;
        HashSet<Long> assignedUserIds = new HashSet<Long>();
        for (i = 0; i < userIdsPerStage.length; ++i) {
            for (long userId : userIds = userIdsPerStage[i]) {
                if (assignedUserIds.contains(userId)) {
                    throw new DuplicateReviewUserIdException();
                }
                assignedUserIds.add(userId);
            }
        }
        for (i = 0; i < userIdsPerStage.length; ++i) {
            userIds = SetUtil.fromArray((long[])userIdsPerStage[i]);
            this.updateReviews(proposalId, assignedByUserId, i + 2, (Set<Long>)userIds);
        }
    }

    protected TasksReview updateReview(long userId, long proposalId, int stage, boolean rejected) throws PortalException, SystemException {
        TasksReview review = this.tasksReviewPersistence.findByU_P(userId, proposalId);
        review.setModifiedDate(new Date());
        review.setCompleted(true);
        review.setRejected(rejected);
        this.tasksReviewPersistence.update((BaseModel)review, false);
        JSONObject extraData = JSONFactoryUtil.createJSONObject();
        extraData.put("stage", review.getStage());
        extraData.put("completed", review.getCompleted());
        extraData.put("rejected", review.getRejected());
        this.socialActivityLocalService.addActivity(userId, review.getGroupId(), TasksProposal.class.getName(), proposalId, 3, extraData.toString(), review.getAssignedByUserId());
        return review;
    }

    protected void updateReviews(long proposalId, long assignedByUserId, int stage, Set<Long> userIds) throws PortalException, SystemException {
        HashSet<Long> reviewUserIds = new HashSet<Long>();
        List reviews = this.tasksReviewPersistence.findByP_S(proposalId, stage);
        for (TasksReview review : reviews) {
            if (!userIds.contains(review.getUserId())) {
                this.deleteReview(review);
                continue;
            }
            reviewUserIds.add(review.getUserId());
        }
        Iterator<Object> i$ = userIds.iterator();
        while (i$.hasNext()) {
            long userId = (Long)i$.next();
            if (reviewUserIds.contains(userId)) continue;
            this.addReview(userId, proposalId, assignedByUserId, stage);
        }
    }
}

