/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.tasks.service.permission;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.tasks.model.TasksProposal;
import com.liferay.portlet.tasks.service.TasksProposalLocalServiceUtil;

public class TasksProposalPermission {
    public static void check(PermissionChecker permissionChecker, long proposalId, String actionId) throws PortalException, SystemException {
        if (!TasksProposalPermission.contains(permissionChecker, proposalId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, TasksProposal proposal, String actionId) throws PortalException {
        if (!TasksProposalPermission.contains(permissionChecker, proposal, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long proposalId, String actionId) throws PortalException, SystemException {
        TasksProposal proposal = TasksProposalLocalServiceUtil.getProposal((long)proposalId);
        return TasksProposalPermission.contains(permissionChecker, proposal, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, TasksProposal proposal, String actionId) {
        if (permissionChecker.hasOwnerPermission(proposal.getCompanyId(), TasksProposal.class.getName(), proposal.getProposalId(), proposal.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(proposal.getGroupId(), TasksProposal.class.getName(), proposal.getProposalId(), actionId);
    }
}

