/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.webproxy;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.StringServletResponse;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.RenderResponseImpl;
import java.io.IOException;
import java.io.PrintWriter;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.portletbridge.portlet.PortletBridgePortlet;

public class WebProxyPortlet
extends PortletBridgePortlet {
    private static Log _log = LogFactoryUtil.getLog(WebProxyPortlet.class);
    private boolean _enabled;

    public void init() {
        block3: {
            try {
                super.init();
                this._enabled = true;
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)e.getMessage());
            }
        }
        if (!this._enabled && ServerDetector.isWebLogic() && _log.isInfoEnabled()) {
            _log.info((Object)"WebProxyPortlet will not be enabled unless Liferay's serializer.jar and xalan.jar files are copied to the JDK's endorsed directory");
        }
    }

    public void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (!this._enabled) {
            this.printError(renderResponse);
            return;
        }
        PortletPreferences preferences = renderRequest.getPreferences();
        String initUrl = preferences.getValue("initUrl", "");
        if (Validator.isNull((String)initUrl)) {
            PortletRequestDispatcher portletRequestDispatcher = this.getPortletContext().getRequestDispatcher("/html/portal/portlet_not_setup.jsp");
            portletRequestDispatcher.include(renderRequest, renderResponse);
        } else {
            super.doView(renderRequest, renderResponse);
            RenderResponseImpl renderResponseImpl = (RenderResponseImpl)renderResponse;
            StringServletResponse stringResponse = (StringServletResponse)renderResponseImpl.getHttpServletResponse();
            String output = stringResponse.getString();
            output = StringUtil.replace((String)output, (String)"//pbhs/", (String)"/pbhs/");
            stringResponse.setString(output);
        }
    }

    protected void printError(RenderResponse renderResponse) throws IOException {
        renderResponse.setContentType("text/html; charset=UTF-8");
        PrintWriter writer = renderResponse.getWriter();
        writer.print("WebProxyPortlet will not be enabled unless Liferay's serializer.jar and xalan.jar files are copied to the JDK's endorsed directory");
        writer.close();
    }
}

