/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki;

import com.liferay.portal.kernel.portlet.BaseFriendlyURLMapper;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiFriendlyURLMapper
extends BaseFriendlyURLMapper {
    private static final String _MAPPING = "wiki";
    private static final String _PORTLET_ID = "36";

    public String buildPath(LiferayPortletURL portletURL) {
        String friendlyURLPath = null;
        String strutsAction = GetterUtil.getString((String)portletURL.getParameter("struts_action"));
        if (strutsAction.equals("/wiki/view") || strutsAction.equals("/wiki/view_all_pages") || strutsAction.equals("/wiki/view_orphan_pages") || strutsAction.equals("/wiki/view_recent_changes")) {
            String nodeId = portletURL.getParameter("nodeId");
            String nodeName = portletURL.getParameter("nodeName");
            if (Validator.isNotNull((String)nodeId) || Validator.isNotNull((String)nodeName)) {
                StringBuilder sb = new StringBuilder();
                sb.append("/");
                sb.append(_MAPPING);
                sb.append("/");
                if (Validator.isNotNull((String)nodeId)) {
                    sb.append(nodeId);
                    portletURL.addParameterIncludedInPath("nodeId");
                } else if (Validator.isNotNull((String)nodeName)) {
                    sb.append(nodeName);
                    portletURL.addParameterIncludedInPath("nodeName");
                }
                if (strutsAction.equals("/wiki/view")) {
                    String title = portletURL.getParameter("title");
                    if (Validator.isNotNull((String)title)) {
                        sb.append("/");
                        sb.append(HttpUtil.encodeURL((String)title));
                        portletURL.addParameterIncludedInPath("title");
                    }
                } else {
                    sb.append("/");
                    sb.append(strutsAction.substring(11));
                }
                friendlyURLPath = sb.toString();
            }
        } else if (strutsAction.equals("/wiki/view_tagged_pages")) {
            boolean folksonomy = GetterUtil.getBoolean((String)portletURL.getParameter("folksonomy"));
            String tag = portletURL.getParameter("tag");
            StringBuilder sb = new StringBuilder();
            if (Validator.isNotNull((String)tag)) {
                sb.append("/");
                sb.append(_MAPPING);
                sb.append("/");
                if (folksonomy) {
                    sb.append("tag");
                } else {
                    sb.append("category");
                }
                sb.append("/");
                sb.append(HttpUtil.encodeURL((String)tag));
                portletURL.addParameterIncludedInPath("nodeId");
                portletURL.addParameterIncludedInPath("nodeName");
                portletURL.addParameterIncludedInPath("tag");
            }
            friendlyURLPath = sb.toString();
        }
        if (Validator.isNotNull(friendlyURLPath)) {
            portletURL.addParameterIncludedInPath("p_p_id");
            portletURL.addParameterIncludedInPath("struts_action");
            WindowState windowState = portletURL.getWindowState();
            if (!windowState.equals((Object)WindowState.NORMAL)) {
                friendlyURLPath = friendlyURLPath + "/" + windowState;
            }
        }
        return friendlyURLPath;
    }

    public String getMapping() {
        return _MAPPING;
    }

    public String getPortletId() {
        return _PORTLET_ID;
    }

    public void populateParams(String friendlyURLPath, Map<String, String[]> params) {
        this.addParam(params, "p_p_id", _PORTLET_ID);
        this.addParam(params, "p_p_lifecycle", "0");
        this.addParam(params, "p_p_mode", PortletMode.VIEW);
        this.addParam(params, "struts_action", "/wiki/view");
        int x = friendlyURLPath.indexOf("/", 1);
        String[] urlFragments = StringUtil.split((String)friendlyURLPath.substring(x + 1), (String)"/");
        if (urlFragments.length >= 1) {
            String urlFragment0 = urlFragments[0];
            if (urlFragment0.equals("category") || urlFragment0.equals("tag")) {
                if (urlFragments.length >= 2) {
                    this.addParam(params, "struts_action", "/wiki/view_tagged_pages");
                    String tag = HttpUtil.decodeURL((String)urlFragments[1]);
                    boolean folksonomy = true;
                    if (urlFragment0.equals("category")) {
                        folksonomy = false;
                    }
                    this.addParam(params, "tag", tag);
                    this.addParam(params, "folksonomy", folksonomy);
                }
            } else {
                if (Validator.isNumber((String)urlFragment0)) {
                    this.addParam(params, "nodeId", urlFragment0);
                    this.addParam(params, "nodeName", "");
                } else {
                    this.addParam(params, "nodeId", "");
                    this.addParam(params, "nodeName", urlFragment0);
                }
                if (urlFragments.length >= 2) {
                    String urlFragments1 = HttpUtil.decodeURL((String)urlFragments[1]);
                    if (urlFragments1.equals("all_pages") || urlFragments1.equals("orphan_pages") || urlFragments1.equals("recent_changes")) {
                        this.addParam(params, "struts_action", "/wiki/view_" + urlFragments1);
                    } else {
                        this.addParam(params, "title", urlFragments1);
                    }
                }
            }
            if (urlFragments.length >= 3) {
                String windowState = urlFragments[2];
                this.addParam(params, "p_p_state", windowState);
            }
        }
    }
}

