/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.action;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.wiki.NoSuchPageException;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.model.impl.WikiPageImpl;
import com.liferay.portlet.wiki.service.WikiNodeLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiNodeServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageServiceUtil;
import com.liferay.portlet.wiki.util.WikiUtil;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.servlet.http.HttpServletRequest;

public class ActionUtil {
    public static WikiNode getFirstVisibleNode(RenderRequest renderRequest) throws PortalException, SystemException {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("THEME_DISPLAY");
        WikiNode node = null;
        int nodesCount = WikiNodeLocalServiceUtil.getNodesCount((long)themeDisplay.getScopeGroupId());
        if (nodesCount == 0) {
            String nodeName = PropsUtil.get("wiki.initial.node.name");
            Layout layout = themeDisplay.getLayout();
            ServiceContext serviceContext = ServiceContextFactory.getInstance((String)WikiNode.class.getName(), (PortletRequest)renderRequest);
            serviceContext.setAddCommunityPermissions(true);
            if (layout.isPublicLayout()) {
                serviceContext.setAddGuestPermissions(true);
            } else {
                serviceContext.setAddGuestPermissions(false);
            }
            node = WikiNodeLocalServiceUtil.addNode((long)themeDisplay.getUserId(), (String)nodeName, (String)"", (ServiceContext)serviceContext);
        } else {
            List<WikiNode> nodes = WikiUtil.getNodes(renderRequest);
            if (nodes.size() == 0) {
                throw new PrincipalException();
            }
            node = nodes.get(0);
        }
        renderRequest.setAttribute("WIKI_NODE", (Object)node);
        return node;
    }

    public static WikiNode getNode(ActionRequest actionRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        return ActionUtil.getNode(request);
    }

    public static WikiNode getNode(RenderRequest renderRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
        return ActionUtil.getNode(request);
    }

    public static WikiNode getNode(HttpServletRequest request) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        long nodeId = ParamUtil.getLong((HttpServletRequest)request, (String)"nodeId");
        String nodeName = ParamUtil.getString((HttpServletRequest)request, (String)"nodeName");
        WikiNode node = null;
        if (nodeId > 0L) {
            node = WikiNodeServiceUtil.getNode((long)nodeId);
        } else if (Validator.isNotNull((String)nodeName)) {
            node = WikiNodeServiceUtil.getNode((long)themeDisplay.getScopeGroupId(), (String)nodeName);
        }
        request.setAttribute("WIKI_NODE", (Object)node);
        return node;
    }

    public static void getPage(ActionRequest actionRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        ActionUtil.getPage(request);
    }

    public static void getPage(RenderRequest renderRequest) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)renderRequest);
        ActionUtil.getPage(request);
    }

    public static void getPage(HttpServletRequest request) throws Exception {
        WikiNode node;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("THEME_DISPLAY");
        long nodeId = ParamUtil.getLong((HttpServletRequest)request, (String)"nodeId");
        String title = ParamUtil.getString((HttpServletRequest)request, (String)"title");
        double version = ParamUtil.getDouble((HttpServletRequest)request, (String)"version");
        if (nodeId == 0L && (node = (WikiNode)request.getAttribute("WIKI_NODE")) != null) {
            nodeId = node.getNodeId();
        }
        if (Validator.isNull((String)title)) {
            title = WikiPageImpl.FRONT_PAGE;
        }
        WikiPage page = null;
        try {
            page = WikiPageServiceUtil.getPage((long)nodeId, (String)title, (double)version);
        }
        catch (NoSuchPageException nspe) {
            if (title.equals(WikiPageImpl.FRONT_PAGE) && version == 0.0) {
                long userId = PortalUtil.getUserId((HttpServletRequest)request);
                if (userId == 0L) {
                    long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
                    userId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
                }
                ServiceContext serviceContext = new ServiceContext();
                Layout layout = themeDisplay.getLayout();
                serviceContext.setAddCommunityPermissions(true);
                if (layout.isPublicLayout()) {
                    serviceContext.setAddGuestPermissions(true);
                } else {
                    serviceContext.setAddGuestPermissions(false);
                }
                page = WikiPageLocalServiceUtil.addPage((long)userId, (long)nodeId, (String)title, null, (String)"New", (boolean)true, (ServiceContext)serviceContext);
            }
            throw nspe;
        }
        request.setAttribute("WIKI_PAGE", (Object)page);
    }
}

