/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.action;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.DiffUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.wiki.NoSuchPageException;
import com.liferay.portlet.wiki.action.ActionUtil;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiPageServiceUtil;
import com.liferay.portlet.wiki.util.WikiUtil;
import java.io.Reader;
import java.util.List;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CompareVersionsAction
extends PortletAction {
    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getNode(renderRequest);
            ActionUtil.getPage(renderRequest);
            this.compareVersions(renderRequest, renderResponse);
        }
        catch (Exception e) {
            if (e instanceof NoSuchPageException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.wiki.error");
            }
            throw e;
        }
        return mapping.findForward("portlet.wiki.compare_versions");
    }

    protected void compareVersions(RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)renderRequest.getAttribute("THEME_DISPLAY");
        long nodeId = ParamUtil.getLong((PortletRequest)renderRequest, (String)"nodeId");
        String title = ParamUtil.getString((PortletRequest)renderRequest, (String)"title");
        double sourceVersion = ParamUtil.getDouble((PortletRequest)renderRequest, (String)"sourceVersion");
        double targetVersion = ParamUtil.getDouble((PortletRequest)renderRequest, (String)"targetVersion");
        String type = ParamUtil.getString((PortletRequest)renderRequest, (String)"type", (String)"escape");
        WikiPage sourcePage = WikiPageServiceUtil.getPage((long)nodeId, (String)title, (double)sourceVersion);
        WikiPage targetPage = WikiPageServiceUtil.getPage((long)nodeId, (String)title, (double)targetVersion);
        if (type.equals("html")) {
            WikiNode sourceNode = sourcePage.getNode();
            PortletURL viewPageURL = renderResponse.createRenderURL();
            viewPageURL.setParameter("struts_action", "/wiki/view");
            viewPageURL.setParameter("nodeName", sourceNode.getName());
            PortletURL editPageURL = renderResponse.createRenderURL();
            editPageURL.setParameter("struts_action", "/wiki/edit_page");
            editPageURL.setParameter("nodeId", String.valueOf(nodeId));
            editPageURL.setParameter("title", title);
            String attachmentURLPrefix = themeDisplay.getPathMain() + "/wiki/get_page_attachment?" + "p_l_id=" + themeDisplay.getPlid() + "&nodeId=" + nodeId + "&title=" + HttpUtil.encodeURL((String)title) + "&fileName=";
            String htmlDiffResult = WikiUtil.diffHtml(sourcePage, targetPage, viewPageURL, editPageURL, attachmentURLPrefix);
            renderRequest.setAttribute("DIFF_HTML_RESULTS", (Object)htmlDiffResult);
        } else {
            String sourceContent = sourcePage.getContent();
            String targetContent = targetPage.getContent();
            sourceContent = WikiUtil.processContent(sourceContent);
            targetContent = WikiUtil.processContent(targetContent);
            if (type.equals("escape")) {
                sourceContent = HtmlUtil.escape((String)sourceContent);
                targetContent = HtmlUtil.escape((String)targetContent);
            } else if (type.equals("strip")) {
                sourceContent = HtmlUtil.extractText((String)sourceContent);
                targetContent = HtmlUtil.extractText((String)targetContent);
            }
            List[] diffResults = DiffUtil.diff((Reader)new UnsyncStringReader(sourceContent), (Reader)new UnsyncStringReader(targetContent));
            renderRequest.setAttribute("DIFF_RESULTS", (Object)diffResults);
        }
        renderRequest.setAttribute("WIKI_NODE_ID", (Object)nodeId);
        renderRequest.setAttribute("TITLE", (Object)title);
        renderRequest.setAttribute("SOURCE_VERSION", (Object)sourceVersion);
        renderRequest.setAttribute("TARGET_VERSION", (Object)targetVersion);
    }
}

