/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.action;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.ActionRequestImpl;
import com.liferay.portlet.PortletURLImpl;
import com.liferay.portlet.documentlibrary.util.DocumentConversionUtil;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiPageServiceUtil;
import com.liferay.portlet.wiki.util.WikiUtil;
import com.liferay.util.servlet.ServletResponseUtil;
import java.io.InputStream;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class ExportPageAction
extends PortletAction {
    private static final boolean _CHECK_METHOD_ON_PROCESS_ACTION = false;
    private static Log _log = LogFactoryUtil.getLog(ExportPageAction.class);

    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            long nodeId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"nodeId");
            String nodeName = ParamUtil.getString((PortletRequest)actionRequest, (String)"nodeName");
            String title = ParamUtil.getString((PortletRequest)actionRequest, (String)"title");
            double version = ParamUtil.getDouble((PortletRequest)actionRequest, (String)"version");
            String targetExtension = ParamUtil.getString((PortletRequest)actionRequest, (String)"targetExtension");
            ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("THEME_DISPLAY");
            PortletURLImpl viewPageURL = new PortletURLImpl((ActionRequestImpl)actionRequest, portletConfig.getPortletName(), themeDisplay.getPlid(), "RENDER_PHASE");
            viewPageURL.setPortletMode(PortletMode.VIEW);
            viewPageURL.setWindowState(WindowState.MAXIMIZED);
            viewPageURL.setParameter("struts_action", "/wiki/view");
            viewPageURL.setParameter("nodeName", nodeName);
            viewPageURL.setParameter("title", title);
            PortletURLImpl editPageURL = new PortletURLImpl((ActionRequestImpl)actionRequest, portletConfig.getPortletName(), themeDisplay.getPlid(), "RENDER_PHASE");
            editPageURL.setPortletMode(PortletMode.VIEW);
            editPageURL.setWindowState(WindowState.MAXIMIZED);
            editPageURL.setParameter("struts_action", "/wiki/edit_page");
            editPageURL.setParameter("nodeId", String.valueOf(nodeId));
            editPageURL.setParameter("title", title);
            HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
            HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
            this.getFile(nodeId, title, version, targetExtension, viewPageURL, editPageURL, themeDisplay, request, response);
            this.setForward((PortletRequest)actionRequest, "/common/null.jsp");
        }
        catch (Exception e) {
            PortalUtil.sendError((Exception)e, (ActionRequest)actionRequest, (ActionResponse)actionResponse);
        }
    }

    protected void getFile(long nodeId, String title, double version, String targetExtension, PortletURL viewPageURL, PortletURL editPageURL, ThemeDisplay themeDisplay, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String id;
        InputStream convertedIS;
        WikiPage page = WikiPageServiceUtil.getPage((long)nodeId, (String)title, (double)version);
        String content = page.getContent();
        String attachmentURLPrefix = themeDisplay.getPathMain() + "/wiki/get_page_attachment?" + "p_l_id=" + themeDisplay.getPlid() + "&nodeId=" + nodeId + "&title=" + HttpUtil.encodeURL((String)title) + "&fileName=";
        try {
            content = WikiUtil.convert(page, viewPageURL, editPageURL, attachmentURLPrefix);
        }
        catch (Exception e) {
            _log.error((Object)("Error formatting the wiki page " + page.getPageId() + " with the format " + page.getFormat()), (Throwable)e);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<head>");
        sb.append("<meta content=\"");
        sb.append("text/html; charset=UTF-8");
        sb.append("\" http-equiv=\"content-type\" />");
        sb.append("<base href=\"");
        sb.append(themeDisplay.getPortalURL());
        sb.append("\" />");
        sb.append("</head>");
        sb.append("<body>");
        sb.append("<h1>");
        sb.append(title);
        sb.append("</h1>");
        sb.append(content);
        sb.append("</body>");
        sb.append("</html>");
        Object is = new UnsyncByteArrayInputStream(sb.toString().getBytes("UTF-8"));
        String sourceExtension = "html";
        sb = new StringBuilder();
        sb.append(title);
        sb.append(".");
        sb.append(sourceExtension);
        String fileName = sb.toString();
        if (Validator.isNotNull((String)targetExtension) && (convertedIS = DocumentConversionUtil.convert(id = page.getUuid(), (InputStream)is, sourceExtension, targetExtension)) != null && convertedIS != is) {
            sb = new StringBuilder();
            sb.append(title);
            sb.append(".");
            sb.append(targetExtension);
            fileName = sb.toString();
            is = convertedIS;
        }
        String contentType = MimeTypesUtil.getContentType((String)fileName);
        ServletResponseUtil.sendFile((HttpServletResponse)response, (String)fileName, (InputStream)is, (String)contentType);
    }

    protected boolean isCheckMethodOnProcessAction() {
        return false;
    }
}

