/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.action;

import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.NotificationThreadLocal;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ProgressTracker;
import com.liferay.portal.kernel.util.ProgressTrackerThreadLocal;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.wiki.ImportFilesException;
import com.liferay.portlet.wiki.NoSuchNodeException;
import com.liferay.portlet.wiki.action.ActionUtil;
import com.liferay.portlet.wiki.service.WikiNodeServiceUtil;
import com.liferay.portlet.wiki.util.WikiCacheThreadLocal;
import com.liferay.portlet.wiki.util.WikiCacheUtil;
import java.io.File;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class ImportPagesAction
extends PortletAction {
    public void processAction(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        try {
            this.importPages(actionRequest, actionResponse);
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e) {
            if (e instanceof NoSuchNodeException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
                this.setForward((PortletRequest)actionRequest, "portlet.wiki.error");
            }
            if (e instanceof ImportFilesException || e instanceof NoSuchNodeException) {
                SessionErrors.add((PortletRequest)actionRequest, (String)e.getClass().getName());
            }
            throw e;
        }
    }

    public ActionForward render(ActionMapping mapping, ActionForm form, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getNode(renderRequest);
        }
        catch (Exception e) {
            if (e instanceof NoSuchNodeException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, (String)e.getClass().getName());
                return mapping.findForward("portlet.wiki.error");
            }
            throw e;
        }
        return mapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.wiki.import_pages"));
    }

    protected void importPages(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        UploadPortletRequest uploadRequest = PortalUtil.getUploadPortletRequest((ActionRequest)actionRequest);
        String importProgressId = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"importProgressId");
        ProgressTracker progressTracker = new ProgressTracker((PortletRequest)actionRequest, importProgressId);
        ProgressTrackerThreadLocal.setProgressTracker((ProgressTracker)progressTracker);
        progressTracker.start();
        long nodeId = ParamUtil.getLong((HttpServletRequest)uploadRequest, (String)"nodeId");
        String importer = ParamUtil.getString((HttpServletRequest)uploadRequest, (String)"importer");
        int filesCount = ParamUtil.getInteger((HttpServletRequest)uploadRequest, (String)"filesCount", (int)10);
        File[] files = new File[filesCount];
        for (int i = 0; i < filesCount; ++i) {
            files[i] = uploadRequest.getFile("file" + i);
        }
        NotificationThreadLocal.setEnabled((boolean)false);
        WikiCacheThreadLocal.setClearCache(false);
        WikiNodeServiceUtil.importPages((long)nodeId, (String)importer, (File[])files, (Map)actionRequest.getParameterMap());
        WikiCacheUtil.clearCache(nodeId);
        progressTracker.finish();
    }
}

