/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.engines.friki;

import com.efsol.friki.PageRepository;
import com.efsol.friki.RepositoryDriver;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portlet.wiki.PageContentException;
import com.liferay.portlet.wiki.engines.WikiEngine;
import com.liferay.portlet.wiki.engines.friki.NodeFilter;
import com.liferay.portlet.wiki.engines.friki.NodeRepository;
import com.liferay.portlet.wiki.model.WikiPage;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.portlet.PortletURL;
import org.stringtree.factory.Fetcher;
import org.stringtree.factory.TractFetcher;
import org.stringtree.factory.memory.MapStringRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrikiEngine
implements WikiEngine {
    private String _mainConfiguration;
    private Map<String, String> _remoteNames;

    @Override
    public String convert(WikiPage page, PortletURL portletURL) throws PageContentException {
        try {
            return this.convert(this.getFilter(portletURL, page.getNodeId()), page.getContent());
        }
        catch (IOException ioe) {
            throw new PageContentException((Throwable)ioe);
        }
    }

    @Override
    public Map<String, Boolean> getOutgoingLinks(WikiPage page) throws PageContentException {
        NodeFilter filter = this.getFilter(page.getNodeId());
        try {
            this.convert(filter, page.getContent());
            return filter.getTitles();
        }
        catch (IOException ioe) {
            throw new PageContentException((Throwable)ioe);
        }
    }

    @Override
    public void setInterWikiConfiguration(String interWikiConfiguration) {
        this._remoteNames = this.buildRemoteNamesMap(interWikiConfiguration);
    }

    @Override
    public void setMainConfiguration(String mainConfiguration) {
        this._mainConfiguration = mainConfiguration;
    }

    @Override
    public boolean validate(long nodeId, String newContent) {
        try {
            NodeFilter filter = this.getFilter(nodeId);
            this.convert(filter, newContent);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected Map<String, String> buildRemoteNamesMap(String names) {
        HashMap<String, String> remoteNames = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(names, "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken().trim();
            int sep = line.indexOf(" ");
            if (sep <= 0) continue;
            String name = line.substring(0, sep);
            String url = line.substring(sep + 1);
            remoteNames.put(name, url);
        }
        return remoteNames;
    }

    protected String convert(NodeFilter filter, String content) throws IOException {
        if (content == null) {
            return "";
        }
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter(true);
        filter.filter((Reader)new UnsyncStringReader(content), (Writer)unsyncStringWriter);
        return unsyncStringWriter.toString();
    }

    protected NodeFilter getFilter(long nodeId) {
        return this.getFilter(null, nodeId);
    }

    protected NodeFilter getFilter(PortletURL portletURL, long nodeId) {
        MapStringRepository context = new MapStringRepository();
        NodeRepository nodeRepository = new NodeRepository(nodeId);
        PageRepository pageRepository = new PageRepository((RepositoryDriver)nodeRepository);
        NodeFilter filter = new NodeFilter((Fetcher)context, (TractFetcher)pageRepository, this._remoteNames, this._mainConfiguration, nodeRepository, portletURL, nodeId);
        return filter;
    }
}

