/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.engines.jspwiki;

import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiException;
import com.ecyrd.jspwiki.WikiPage;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.wiki.PageContentException;
import com.liferay.portlet.wiki.engines.WikiEngine;
import com.liferay.portlet.wiki.engines.jspwiki.LiferayJSPWikiEngine;
import com.liferay.portlet.wiki.engines.jspwiki.LiferayPageProvider;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.portlet.PortletURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSPWikiEngine
implements WikiEngine {
    private static Log _log = LogFactoryUtil.getLog(JSPWikiEngine.class);
    private Properties _props;
    private Map<Long, LiferayJSPWikiEngine> _engines = new HashMap<Long, LiferayJSPWikiEngine>();

    @Override
    public String convert(com.liferay.portlet.wiki.model.WikiPage page, PortletURL portletURL) throws PageContentException {
        try {
            return this.convert(page);
        }
        catch (WikiException we) {
            throw new PageContentException((Throwable)we);
        }
    }

    @Override
    public Map<String, Boolean> getOutgoingLinks(com.liferay.portlet.wiki.model.WikiPage page) throws PageContentException {
        if (Validator.isNull((String)page.getContent())) {
            return Collections.EMPTY_MAP;
        }
        try {
            LiferayJSPWikiEngine engine = this.getEngine(page.getNodeId());
            WikiPage jspWikiPage = LiferayPageProvider.toJSPWikiPage(page, engine);
            Collection<String> titles = engine.scanWikiLinks(jspWikiPage, page.getContent());
            HashMap<String, Boolean> links = new HashMap<String, Boolean>();
            for (String title : titles) {
                Boolean existsObj;
                if (title.startsWith("[[")) {
                    title = title.substring(2);
                } else if (title.startsWith("[")) {
                    title = title.substring(1);
                }
                if (title.endsWith("]]")) {
                    title = title.substring(title.length() - 2, title.length());
                } else if (title.startsWith("[")) {
                    title = title.substring(title.length() - 1, title.length());
                }
                if ((existsObj = (Boolean)links.get(title)) != null) continue;
                existsObj = WikiPageLocalServiceUtil.getPagesCount((long)page.getNodeId(), (String)title, (boolean)true) > 0 ? Boolean.TRUE : Boolean.FALSE;
                links.put(title.toLowerCase(), existsObj);
            }
            return links;
        }
        catch (SystemException se) {
            throw new PageContentException((Throwable)se);
        }
        catch (WikiException we) {
            throw new PageContentException((Throwable)we);
        }
    }

    @Override
    public void setInterWikiConfiguration(String interWikiConfiguration) {
    }

    @Override
    public void setMainConfiguration(String mainConfiguration) {
        this.setProperties(mainConfiguration);
    }

    @Override
    public boolean validate(long nodeId, String newContent) {
        return true;
    }

    protected String convert(com.liferay.portlet.wiki.model.WikiPage page) throws WikiException {
        String content = page.getContent();
        if (Validator.isNull((String)content)) {
            return "";
        }
        LiferayJSPWikiEngine engine = this.getEngine(page.getNodeId());
        WikiPage jspWikiPage = LiferayPageProvider.toJSPWikiPage(page, engine);
        WikiContext wikiContext = new WikiContext((com.ecyrd.jspwiki.WikiEngine)engine, jspWikiPage);
        return engine.textToHTML(wikiContext, content);
    }

    protected LiferayJSPWikiEngine getEngine(long nodeId) throws WikiException {
        LiferayJSPWikiEngine engine = this._engines.get(nodeId);
        if (engine == null) {
            Properties nodeProps = new Properties(this._props);
            nodeProps.setProperty("nodeId", String.valueOf(nodeId));
            String appName = nodeProps.getProperty("jspwiki.applicationName");
            nodeProps.setProperty("jspwiki.applicationName", appName + " for node " + nodeId);
            engine = new LiferayJSPWikiEngine(nodeProps);
            this._engines.put(nodeId, engine);
        }
        return engine;
    }

    protected synchronized void setProperties(String configuration) {
        this._props = new Properties();
        UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(configuration.getBytes());
        try {
            this._props.load((InputStream)is);
        }
        catch (IOException ioe) {
            _log.error((Object)ioe, (Throwable)ioe);
        }
    }
}

