/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.engines.jspwiki;

import com.ecyrd.jspwiki.QueryItem;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.providers.ProviderException;
import com.ecyrd.jspwiki.providers.WikiPageProvider;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portlet.wiki.NoSuchPageException;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiferayPageProvider
implements WikiPageProvider {
    private static Log _log = LogFactoryUtil.getLog(LiferayPageProvider.class);
    private WikiEngine _engine;
    private long _nodeId;

    public static com.ecyrd.jspwiki.WikiPage toJSPWikiPage(WikiPage page, WikiEngine engine) {
        com.ecyrd.jspwiki.WikiPage jspWikiPage = new com.ecyrd.jspwiki.WikiPage(engine, page.getTitle());
        jspWikiPage.setAuthor(page.getUserName());
        jspWikiPage.setVersion((int)(page.getVersion() * 10.0));
        jspWikiPage.setLastModified(page.getCreateDate());
        return jspWikiPage;
    }

    public void deletePage(String name) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking deletePage(" + name + ")"));
        }
    }

    public void deleteVersion(String title, int version) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking deleteVersion(" + title + ", " + version + ")"));
        }
    }

    public Collection<com.ecyrd.jspwiki.WikiPage> findPages(QueryItem[] query) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking findPages(" + query + ")"));
        }
        return Collections.EMPTY_LIST;
    }

    public Collection<com.ecyrd.jspwiki.WikiPage> getAllChangedSince(Date date) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking getAllChangedSince(" + date + ")"));
        }
        try {
            return this.getAllPages();
        }
        catch (ProviderException e) {
            _log.error((Object)"Could not get changed pages", (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    public Collection<com.ecyrd.jspwiki.WikiPage> getAllPages() throws ProviderException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Invoking getAllPages()");
        }
        ArrayList<com.ecyrd.jspwiki.WikiPage> jspWikiPages = new ArrayList<com.ecyrd.jspwiki.WikiPage>();
        try {
            int count = WikiPageLocalServiceUtil.getPagesCount((long)this._nodeId, (boolean)true);
            List pages = WikiPageLocalServiceUtil.getPages((long)this._nodeId, (boolean)true, (int)0, (int)count);
            for (WikiPage page : pages) {
                jspWikiPages.add(LiferayPageProvider.toJSPWikiPage(page, this._engine));
            }
        }
        catch (SystemException se) {
            throw new ProviderException(se.toString());
        }
        return jspWikiPages;
    }

    public int getPageCount() throws ProviderException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Invoking getPageCount()");
        }
        try {
            return WikiPageLocalServiceUtil.getPagesCount((long)this._nodeId);
        }
        catch (SystemException se) {
            throw new ProviderException(se.toString());
        }
    }

    public com.ecyrd.jspwiki.WikiPage getPageInfo(String title, int version) throws ProviderException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking getPageInfo(" + title + ", " + version + ")"));
        }
        try {
            WikiPage page = WikiPageLocalServiceUtil.getPage((long)this._nodeId, (String)title);
            return LiferayPageProvider.toJSPWikiPage(page, this._engine);
        }
        catch (NoSuchPageException nspe) {
            return null;
        }
        catch (Exception e) {
            throw new ProviderException(e.toString());
        }
    }

    public String getPageText(String title, int version) throws ProviderException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking getPageText(" + title + ", " + version + ")"));
        }
        try {
            WikiPage page = WikiPageLocalServiceUtil.getPage((long)this._nodeId, (String)title);
            return page.getContent();
        }
        catch (Exception e) {
            throw new ProviderException(e.toString());
        }
    }

    public String getProviderInfo() {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Invoking getProviderInfo()");
        }
        return LiferayPageProvider.class.getName();
    }

    public List<com.ecyrd.jspwiki.WikiPage> getVersionHistory(String title) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking getVersionHistory(" + title + ")"));
        }
        return Collections.EMPTY_LIST;
    }

    public void initialize(WikiEngine engine, Properties props) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking initialize(" + engine + ", " + props + ")"));
        }
        this._engine = engine;
        this._nodeId = GetterUtil.getLong((String)props.getProperty("nodeId"));
    }

    public void movePage(String from, String to) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking movePage(" + from + ", " + to + ")"));
        }
    }

    public boolean pageExists(String title) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking pageExists(" + title + ")"));
        }
        try {
            return WikiPageLocalServiceUtil.getPagesCount((long)this._nodeId, (String)title, (boolean)true) > 0;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return false;
        }
    }

    public void putPageText(com.ecyrd.jspwiki.WikiPage page, String text) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Invoking putPageText(" + page + ", " + text + ")"));
        }
    }
}

