/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.filters;

import org.stringtree.factory.AbstractStringFetcher;
import org.stringtree.factory.Container;
import org.stringtree.factory.Fetcher;
import org.stringtree.juicer.Initialisable;
import org.stringtree.regex.Matcher;
import org.stringtree.regex.Pattern;

public class MediaWikiLocalLink
extends AbstractStringFetcher
implements Initialisable {
    private static Pattern _pattern = Pattern.compile((String)"(^|\\p{Punct}|\\p{Space})(\\[\\s*(((\\p{Lu}\\p{Ll}+)\\s?)+)\\s*\\|\\s*((([\\p{Alpha}\\p{Digit}]+)\\s?)+)\\s*\\])(\\z|\\n|\\p{Punct}|\\p{Space})");
    private Container _pages;

    public MediaWikiLocalLink() {
        this(null);
    }

    public MediaWikiLocalLink(Container pages) {
        this._pages = pages;
    }

    public void init(Fetcher context) {
        this._pages = (Container)context.getObject("wiki.pages");
    }

    public Object getObject(String key) {
        String value = key;
        Matcher match = _pattern.matcher(key);
        if (match.find()) {
            key = this.encodeKey(match.group(3).trim());
            String title = match.group(6).trim();
            value = this._pages.contains(key) ? "\nview_mw{" + title + "," + key + "}\n" : "\nedit_mw{" + title + "," + key + "}\n";
        }
        return value;
    }

    protected String encodeKey(String key) {
        return key.replaceAll("\\W", "_");
    }
}

