/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.lar;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.lar.BasePortletDataHandler;
import com.liferay.portal.lar.PortletDataContext;
import com.liferay.portal.lar.PortletDataException;
import com.liferay.portal.lar.PortletDataHandlerBoolean;
import com.liferay.portal.lar.PortletDataHandlerControl;
import com.liferay.portlet.wiki.NoSuchNodeException;
import com.liferay.portlet.wiki.lar.WikiPortletDataHandlerImpl;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.persistence.WikiNodeUtil;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class WikiDisplayPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final String _NAMESPACE = "wiki";
    private static final PortletDataHandlerBoolean _nodesAndPages = new PortletDataHandlerBoolean("wiki", "wikis-and-pages", true, true);
    private static final PortletDataHandlerBoolean _attachments = new PortletDataHandlerBoolean("wiki", "attachments");
    private static final PortletDataHandlerBoolean _categories = new PortletDataHandlerBoolean("wiki", "categories");
    private static final PortletDataHandlerBoolean _comments = new PortletDataHandlerBoolean("wiki", "comments");
    private static final PortletDataHandlerBoolean _tags = new PortletDataHandlerBoolean("wiki", "tags");
    private static Log _log = LogFactoryUtil.getLog(WikiDisplayPortletDataHandlerImpl.class);

    public PortletPreferences deleteData(PortletDataContext context, String portletId, PortletPreferences preferences) throws PortletDataException {
        try {
            preferences.setValue("title", "");
            preferences.setValue("node-id", "");
            return preferences;
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    public String exportData(PortletDataContext context, String portletId, PortletPreferences preferences) throws PortletDataException {
        try {
            WikiNode node;
            block9: {
                long nodeId = GetterUtil.getLong((String)preferences.getValue("node-id", ""));
                if (nodeId <= 0L) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("No node id found in preferences of portlet " + portletId));
                    }
                    return "";
                }
                String title = preferences.getValue("title", null);
                if (title == null) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("No title found in preferences of portlet " + portletId));
                    }
                    return "";
                }
                node = null;
                try {
                    node = WikiNodeUtil.findByPrimaryKey((long)nodeId);
                }
                catch (NoSuchNodeException nsne) {
                    if (!_log.isWarnEnabled()) break block9;
                    _log.warn((Throwable)nsne);
                }
            }
            if (node == null) {
                return "";
            }
            Document doc = SAXReaderUtil.createDocument();
            Element root = doc.addElement("wiki-display-data");
            root.addAttribute("group-id", String.valueOf(context.getGroupId()));
            Element nodesEl = root.addElement("nodes");
            Element pagesEl = root.addElement("pages");
            WikiPortletDataHandlerImpl.exportNode(context, nodesEl, pagesEl, node);
            return doc.formattedString();
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_nodesAndPages, _attachments, _categories, _comments, _tags};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_nodesAndPages, _attachments, _categories, _comments, _tags};
    }

    public PortletPreferences importData(PortletDataContext context, String portletId, PortletPreferences preferences, String data) throws PortletDataException {
        try {
            if (Validator.isNull((String)data)) {
                return null;
            }
            Document doc = SAXReaderUtil.read((String)data);
            Element root = doc.getRootElement();
            List nodeEls = root.element("nodes").elements("node");
            Map nodePKs = context.getNewPrimaryKeysMap(WikiNode.class);
            for (Element nodeEl : nodeEls) {
                String path = nodeEl.attributeValue("path");
                if (!context.isPathNotProcessed(path)) continue;
                WikiNode node = (WikiNode)context.getZipEntryAsObject(path);
                WikiPortletDataHandlerImpl.importNode(context, nodePKs, node);
            }
            List pageEls = root.element("pages").elements("page");
            for (Element pageEl : pageEls) {
                String path = pageEl.attributeValue("path");
                if (!context.isPathNotProcessed(path)) continue;
                WikiPage page = (WikiPage)context.getZipEntryAsObject(path);
                WikiPortletDataHandlerImpl.importPage(context, nodePKs, pageEl, page);
            }
            long nodeId = GetterUtil.getLong((String)preferences.getValue("node-id", ""));
            if (nodeId > 0L) {
                nodeId = MapUtil.getLong((Map)nodePKs, (long)nodeId, (long)nodeId);
                preferences.setValue("node-id", String.valueOf(nodeId));
            }
            return preferences;
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }
}

