/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.lar;

import com.liferay.documentlibrary.service.DLServiceUtil;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.lar.BasePortletDataHandler;
import com.liferay.portal.lar.PortletDataContext;
import com.liferay.portal.lar.PortletDataException;
import com.liferay.portal.lar.PortletDataHandlerBoolean;
import com.liferay.portal.lar.PortletDataHandlerControl;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.wiki.NoSuchNodeException;
import com.liferay.portlet.wiki.NoSuchPageException;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiNodeLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.service.persistence.WikiNodeUtil;
import com.liferay.portlet.wiki.service.persistence.WikiPageUtil;
import com.liferay.portlet.wiki.util.comparator.PageCreateDateComparator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiPortletDataHandlerImpl
extends BasePortletDataHandler {
    private static final String _NAMESPACE = "wiki";
    private static final PortletDataHandlerBoolean _nodesAndPages = new PortletDataHandlerBoolean("wiki", "wikis-and-pages", true, true);
    private static final PortletDataHandlerBoolean _attachments = new PortletDataHandlerBoolean("wiki", "attachments");
    private static final PortletDataHandlerBoolean _categories = new PortletDataHandlerBoolean("wiki", "categories");
    private static final PortletDataHandlerBoolean _comments = new PortletDataHandlerBoolean("wiki", "comments");
    private static final PortletDataHandlerBoolean _tags = new PortletDataHandlerBoolean("wiki", "tags");
    private static Log _log = LogFactoryUtil.getLog(WikiPortletDataHandlerImpl.class);

    public static void exportNode(PortletDataContext context, Element nodesEl, Element pagesEl, WikiNode node) throws PortalException, SystemException {
        String path;
        if (context.isWithinDateRange(node.getModifiedDate()) && context.isPathNotProcessed(path = WikiPortletDataHandlerImpl.getNodePath(context, node))) {
            Element nodeEl = nodesEl.addElement("node");
            nodeEl.addAttribute("path", path);
            node.setUserUuid(node.getUserUuid());
            context.addZipEntry(path, (Object)node);
        }
        List nodePages = WikiPageUtil.findByNodeId((long)node.getNodeId(), (int)-1, (int)-1, (OrderByComparator)new PageCreateDateComparator(true));
        for (WikiPage page : nodePages) {
            WikiPortletDataHandlerImpl.exportPage(context, nodesEl, pagesEl, page);
        }
    }

    public static void importNode(PortletDataContext context, Map<Long, Long> nodePKs, WikiNode node) throws Exception {
        long userId = context.getUserId(node.getUserUuid());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setScopeGroupId(context.getGroupId());
        WikiNode existingNode = null;
        if (context.getDataStrategy().equals("DATA_STRATEGY_MIRROR")) {
            existingNode = WikiNodeUtil.fetchByUUID_G((String)node.getUuid(), (long)context.getGroupId());
            String nodeName = PropsUtil.get("wiki.initial.node.name");
            if (existingNode == null && node.getName().equals(nodeName)) {
                try {
                    WikiNodeUtil.removeByG_N((long)context.getGroupId(), (String)node.getName());
                }
                catch (NoSuchNodeException nsne) {
                    // empty catch block
                }
            }
            existingNode = existingNode == null ? WikiNodeLocalServiceUtil.addNode((String)node.getUuid(), (long)userId, (String)node.getName(), (String)node.getDescription(), (ServiceContext)serviceContext) : WikiNodeLocalServiceUtil.updateNode((long)existingNode.getNodeId(), (String)node.getName(), (String)node.getDescription());
        } else {
            String nodeName = PropsUtil.get("wiki.initial.node.name");
            if (node.getName().equals(nodeName)) {
                try {
                    WikiNodeUtil.removeByG_N((long)context.getGroupId(), (String)node.getName());
                }
                catch (NoSuchNodeException nsne) {
                    // empty catch block
                }
            }
            existingNode = WikiNodeLocalServiceUtil.addNode((long)userId, (String)node.getName(), (String)node.getDescription(), (ServiceContext)serviceContext);
        }
        nodePKs.put(node.getNodeId(), existingNode.getNodeId());
    }

    public static void importPage(PortletDataContext context, Map<Long, Long> nodePKs, Element pageEl, WikiPage page) throws Exception {
        long userId = context.getUserId(page.getUserUuid());
        long nodeId = MapUtil.getLong(nodePKs, (long)page.getNodeId(), (long)page.getNodeId());
        String[] tagsCategories = null;
        String[] tagsEntries = null;
        if (context.getBooleanParameter(_NAMESPACE, "categories")) {
            tagsCategories = context.getTagsCategories(WikiPage.class, page.getResourcePrimKey());
        }
        if (context.getBooleanParameter(_NAMESPACE, "tags")) {
            tagsEntries = context.getTagsEntries(WikiPage.class, page.getResourcePrimKey());
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddCommunityPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setTagsCategories(tagsCategories);
        serviceContext.setTagsEntries(tagsEntries);
        WikiPage existingPage = null;
        try {
            WikiNodeUtil.findByPrimaryKey((long)nodeId);
            if (context.getDataStrategy().equals("DATA_STRATEGY_MIRROR")) {
                try {
                    existingPage = WikiPageUtil.findByUUID_G((String)page.getUuid(), (long)context.getGroupId());
                }
                catch (NoSuchPageException nspe) {
                    // empty catch block
                }
                if (existingPage == null) {
                    try {
                        existingPage = WikiPageLocalServiceUtil.getPage((long)nodeId, (String)page.getTitle());
                    }
                    catch (NoSuchPageException nspe) {
                        // empty catch block
                    }
                }
                existingPage = existingPage != null ? WikiPageLocalServiceUtil.updatePage((long)userId, (long)nodeId, (String)existingPage.getTitle(), (double)0.0, (String)page.getContent(), (String)page.getSummary(), (boolean)true, (String)page.getFormat(), (String)page.getParentTitle(), (String)page.getRedirectTitle(), (ServiceContext)serviceContext) : WikiPageLocalServiceUtil.addPage((String)page.getUuid(), (long)userId, (long)nodeId, (String)page.getTitle(), (double)page.getVersion(), (String)page.getContent(), (String)page.getSummary(), (boolean)true, (String)page.getFormat(), (boolean)page.getHead(), (String)page.getParentTitle(), (String)page.getRedirectTitle(), (ServiceContext)serviceContext);
            } else {
                existingPage = WikiPageLocalServiceUtil.addPage(null, (long)userId, (long)nodeId, (String)page.getTitle(), (double)page.getVersion(), (String)page.getContent(), (String)page.getSummary(), (boolean)true, (String)page.getFormat(), (boolean)page.getHead(), (String)page.getParentTitle(), (String)page.getRedirectTitle(), (ServiceContext)serviceContext);
            }
            if (context.getBooleanParameter(_NAMESPACE, "attachments") && page.isHead()) {
                List attachmentEls = pageEl.elements("attachment");
                ArrayList<ObjectValuePair> files = new ArrayList<ObjectValuePair>();
                for (Element attachmentEl : attachmentEls) {
                    String name = attachmentEl.attributeValue("name");
                    String binPath = attachmentEl.attributeValue("bin-path");
                    byte[] bytes = context.getZipEntryAsByteArray(binPath);
                    files.add(new ObjectValuePair((Object)name, (Object)bytes));
                }
                if (files.size() > 0) {
                    WikiPageLocalServiceUtil.addPageAttachments((long)nodeId, (String)page.getTitle(), files);
                }
            }
            if (context.getBooleanParameter(_NAMESPACE, "comments") && page.isHead()) {
                context.importComments(WikiPage.class, page.getResourcePrimKey(), existingPage.getResourcePrimKey(), context.getGroupId());
            }
            if (context.getBooleanParameter(_NAMESPACE, "ratings")) {
                context.importRatingsEntries(WikiPage.class, page.getResourcePrimKey(), existingPage.getResourcePrimKey());
            }
        }
        catch (NoSuchNodeException nsne) {
            _log.error((Object)("Could not find the node for page " + page.getPageId()));
        }
    }

    public PortletPreferences deleteData(PortletDataContext context, String portletId, PortletPreferences preferences) throws PortletDataException {
        try {
            if (!context.addPrimaryKey(WikiPortletDataHandlerImpl.class, "deleteData")) {
                WikiNodeLocalServiceUtil.deleteNodes((long)context.getGroupId());
            }
            return null;
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    public String exportData(PortletDataContext context, String portletId, PortletPreferences preferences) throws PortletDataException {
        try {
            Document doc = SAXReaderUtil.createDocument();
            Element root = doc.addElement("wiki-data");
            root.addAttribute("group-id", String.valueOf(context.getGroupId()));
            Element nodesEl = root.addElement("nodes");
            Element pagesEl = root.addElement("pages");
            List nodes = WikiNodeUtil.findByGroupId((long)context.getGroupId());
            for (WikiNode node : nodes) {
                WikiPortletDataHandlerImpl.exportNode(context, nodesEl, pagesEl, node);
            }
            return doc.formattedString();
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    public PortletDataHandlerControl[] getExportControls() {
        return new PortletDataHandlerControl[]{_nodesAndPages, _attachments, _categories, _comments, _tags};
    }

    public PortletDataHandlerControl[] getImportControls() {
        return new PortletDataHandlerControl[]{_nodesAndPages, _attachments, _categories, _comments, _tags};
    }

    public PortletPreferences importData(PortletDataContext context, String portletId, PortletPreferences preferences, String data) throws PortletDataException {
        try {
            Document doc = SAXReaderUtil.read((String)data);
            Element root = doc.getRootElement();
            List nodeEls = root.element("nodes").elements("node");
            Map nodePKs = context.getNewPrimaryKeysMap(WikiNode.class);
            for (Element nodeEl : nodeEls) {
                String path = nodeEl.attributeValue("path");
                if (!context.isPathNotProcessed(path)) continue;
                WikiNode node = (WikiNode)context.getZipEntryAsObject(path);
                WikiPortletDataHandlerImpl.importNode(context, nodePKs, node);
            }
            List pageEls = root.element("pages").elements("page");
            for (Element pageEl : pageEls) {
                String path = pageEl.attributeValue("path");
                if (!context.isPathNotProcessed(path)) continue;
                WikiPage page = (WikiPage)context.getZipEntryAsObject(path);
                WikiPortletDataHandlerImpl.importPage(context, nodePKs, pageEl, page);
            }
            return null;
        }
        catch (Exception e) {
            throw new PortletDataException((Throwable)e);
        }
    }

    protected static void exportNode(PortletDataContext context, Element nodesEl, long nodeId) throws PortalException, SystemException {
        if (!context.hasDateRange()) {
            return;
        }
        WikiNode node = WikiNodeUtil.findByPrimaryKey((long)nodeId);
        String path = WikiPortletDataHandlerImpl.getNodePath(context, node);
        if (!context.isPathNotProcessed(path)) {
            return;
        }
        Element nodeEl = nodesEl.addElement("node");
        nodeEl.addAttribute("path", path);
        node.setUserUuid(node.getUserUuid());
        context.addZipEntry(path, (Object)node);
    }

    protected static void exportPage(PortletDataContext context, Element nodesEl, Element pagesEl, WikiPage page) throws PortalException, SystemException {
        if (!context.isWithinDateRange(page.getModifiedDate())) {
            return;
        }
        String path = WikiPortletDataHandlerImpl.getPagePath(context, page);
        if (context.isPathNotProcessed(path)) {
            Element pageEl = pagesEl.addElement("page");
            pageEl.addAttribute("path", path);
            page.setUserUuid(page.getUserUuid());
            if (context.getBooleanParameter(_NAMESPACE, "categories")) {
                context.addTagsCategories(WikiPage.class, page.getResourcePrimKey());
            }
            if (context.getBooleanParameter(_NAMESPACE, "comments")) {
                context.addComments(WikiPage.class, page.getResourcePrimKey());
            }
            if (context.getBooleanParameter(_NAMESPACE, "tags")) {
                context.addTagsEntries(WikiPage.class, page.getResourcePrimKey());
            }
            if (context.getBooleanParameter(_NAMESPACE, "attachments") && page.isHead()) {
                for (String attachment : page.getAttachmentsFiles()) {
                    int pos = attachment.lastIndexOf("/");
                    String name = attachment.substring(pos + 1);
                    String binPath = WikiPortletDataHandlerImpl.getPageAttachementBinPath(context, page, name);
                    Element attachmentEl = pageEl.addElement("attachment");
                    attachmentEl.addAttribute("name", name);
                    attachmentEl.addAttribute("bin-path", binPath);
                    byte[] bytes = DLServiceUtil.getFile((long)context.getCompanyId(), (long)0L, (String)attachment);
                    context.addZipEntry(binPath, bytes);
                }
                page.setAttachmentsDir(page.getAttachmentsDir());
            }
            context.addZipEntry(path, (Object)page);
        }
        WikiPortletDataHandlerImpl.exportNode(context, nodesEl, page.getNodeId());
    }

    protected static String getNodePath(PortletDataContext context, WikiNode node) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath("36"));
        sb.append("/nodes/");
        sb.append(node.getNodeId());
        sb.append(".xml");
        return sb.toString();
    }

    protected static String getPageAttachementBinPath(PortletDataContext context, WikiPage page, String attachment) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath("36"));
        sb.append("/bin/");
        sb.append(page.getPageId());
        sb.append("/");
        sb.append(attachment);
        return sb.toString();
    }

    protected static String getPagePath(PortletDataContext context, WikiPage page) {
        StringBuilder sb = new StringBuilder();
        sb.append(context.getPortletPath("36"));
        sb.append("/pages/");
        sb.append(page.getPageId());
        sb.append(".xml");
        return sb.toString();
    }
}

