/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.messaging;

import com.liferay.mail.service.MailServiceUtil;
import com.liferay.portal.NoSuchUserException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mail.MailMessage;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Subscription;
import com.liferay.portal.model.User;
import com.liferay.portal.service.SubscriptionLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.mail.internet.InternetAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiMessageListener
implements MessageListener {
    private static Log _log = LogFactoryUtil.getLog(WikiMessageListener.class);

    public void receive(Message message) {
        try {
            this.doReceive(message);
        }
        catch (Exception e) {
            _log.error((Object)("Unable to process message " + message), (Throwable)e);
        }
    }

    protected void doReceive(Message message) throws Exception {
        long companyId = message.getLong("companyId");
        long userId = message.getLong("userId");
        long nodeId = message.getLong("nodeId");
        long pageResourcePrimKey = message.getLong("pageResourcePrimKey");
        String fromName = message.getString("fromName");
        String fromAddress = message.getString("fromAddress");
        String subject = message.getString("subject");
        String body = message.getString("body");
        String replyToAddress = message.getString("replyToAddress");
        String mailId = message.getString("mailId");
        boolean htmlFormat = message.getBoolean("htmlFormat");
        HashSet<Long> sent = new HashSet<Long>();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Sending notifications for {mailId=" + mailId + ", pageResourcePrimKey=" + pageResourcePrimKey + ", nodeId=" + nodeId + "}"));
        }
        List subscriptions = SubscriptionLocalServiceUtil.getSubscriptions((long)companyId, (String)WikiPage.class.getName(), (long)pageResourcePrimKey);
        this.sendEmail(userId, fromName, fromAddress, subject, body, subscriptions, sent, replyToAddress, mailId, htmlFormat);
        subscriptions = SubscriptionLocalServiceUtil.getSubscriptions((long)companyId, (String)WikiNode.class.getName(), (long)nodeId);
        this.sendEmail(userId, fromName, fromAddress, subject, body, subscriptions, sent, replyToAddress, mailId, htmlFormat);
        if (_log.isInfoEnabled()) {
            _log.info((Object)"Finished sending notifications");
        }
    }

    protected void sendEmail(long userId, String fromName, String fromAddress, String subject, String body, List<Subscription> subscriptions, Set<Long> sent, String replyToAddress, String mailId, boolean htmlFormat) throws Exception {
        for (Subscription subscription : subscriptions) {
            long subscribedUserId = subscription.getUserId();
            if (sent.contains(subscribedUserId)) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Do not send a duplicate email to user " + subscribedUserId));
                continue;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Add user " + subscribedUserId + " to the list of users who have received an email"));
            }
            sent.add(subscribedUserId);
            User user = null;
            try {
                user = UserLocalServiceUtil.getUserById((long)subscription.getUserId());
            }
            catch (NoSuchUserException nsue) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Subscription " + subscription.getSubscriptionId() + " is stale and will be deleted"));
                }
                SubscriptionLocalServiceUtil.deleteSubscription((long)subscription.getSubscriptionId());
                continue;
            }
            if (!user.isActive()) continue;
            try {
                InternetAddress from = new InternetAddress(fromAddress, fromName);
                InternetAddress to = new InternetAddress(user.getEmailAddress(), user.getFullName());
                String curSubject = StringUtil.replace((String)subject, (String[])new String[]{"[$TO_ADDRESS$]", "[$TO_NAME$]"}, (String[])new String[]{user.getFullName(), user.getEmailAddress()});
                String curBody = StringUtil.replace((String)body, (String[])new String[]{"[$TO_ADDRESS$]", "[$TO_NAME$]"}, (String[])new String[]{user.getFullName(), user.getEmailAddress()});
                InternetAddress replyTo = new InternetAddress(replyToAddress, replyToAddress);
                MailMessage message = new MailMessage(from, to, curSubject, curBody, htmlFormat);
                message.setReplyTo(new InternetAddress[]{replyTo});
                message.setMessageId(mailId);
                MailServiceUtil.sendEmail((MailMessage)message);
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        }
    }
}

