/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiNodeSoap;
import com.liferay.portlet.wiki.service.WikiNodeServiceUtil;
import java.rmi.RemoteException;

public class WikiNodeServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(WikiNodeServiceSoap.class);

    public static WikiNodeSoap addNode(String name, String description, ServiceContext serviceContext) throws RemoteException {
        try {
            WikiNode returnValue = WikiNodeServiceUtil.addNode((String)name, (String)description, (ServiceContext)serviceContext);
            return WikiNodeSoap.toSoapModel((WikiNode)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteNode(long nodeId) throws RemoteException {
        try {
            WikiNodeServiceUtil.deleteNode((long)nodeId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static WikiNodeSoap getNode(long nodeId) throws RemoteException {
        try {
            WikiNode returnValue = WikiNodeServiceUtil.getNode((long)nodeId);
            return WikiNodeSoap.toSoapModel((WikiNode)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static WikiNodeSoap getNode(long groupId, String name) throws RemoteException {
        try {
            WikiNode returnValue = WikiNodeServiceUtil.getNode((long)groupId, (String)name);
            return WikiNodeSoap.toSoapModel((WikiNode)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void subscribeNode(long nodeId) throws RemoteException {
        try {
            WikiNodeServiceUtil.subscribeNode((long)nodeId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void unsubscribeNode(long nodeId) throws RemoteException {
        try {
            WikiNodeServiceUtil.unsubscribeNode((long)nodeId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static WikiNodeSoap updateNode(long nodeId, String name, String description) throws RemoteException {
        try {
            WikiNode returnValue = WikiNodeServiceUtil.updateNode((long)nodeId, (String)name, (String)description);
            return WikiNodeSoap.toSoapModel((WikiNode)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }
}

