/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.TermQuery;
import com.liferay.portal.kernel.search.TermQueryFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.wiki.DuplicateNodeNameException;
import com.liferay.portlet.wiki.NodeNameException;
import com.liferay.portlet.wiki.importers.WikiImporter;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.base.WikiNodeLocalServiceBaseImpl;
import com.liferay.portlet.wiki.util.Indexer;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiNodeLocalServiceImpl
extends WikiNodeLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(WikiNodeLocalServiceImpl.class);
    private Map<String, WikiImporter> _wikiImporters = new HashMap<String, WikiImporter>();

    public WikiNode addNode(long userId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addNode(null, userId, name, description, serviceContext);
    }

    public WikiNode addNode(String uuid, long userId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        long groupId = serviceContext.getScopeGroupId();
        Date now = new Date();
        this.validate(groupId, name);
        long nodeId = this.counterLocalService.increment();
        WikiNode node = this.wikiNodePersistence.create(nodeId);
        node.setUuid(uuid);
        node.setGroupId(groupId);
        node.setCompanyId(user.getCompanyId());
        node.setUserId(user.getUserId());
        node.setUserName(user.getFullName());
        node.setCreateDate(now);
        node.setModifiedDate(now);
        node.setName(name);
        node.setDescription(description);
        try {
            this.wikiNodePersistence.update((BaseModel)node, false);
        }
        catch (SystemException se) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Add failed, fetch {groupId=" + groupId + ", name=" + name + "}"));
            }
            if ((node = this.wikiNodePersistence.fetchByG_N(groupId, name, false)) == null) {
                throw se;
            }
            return node;
        }
        if (serviceContext.getAddCommunityPermissions() || serviceContext.getAddGuestPermissions()) {
            this.addNodeResources(node, serviceContext.getAddCommunityPermissions(), serviceContext.getAddGuestPermissions());
        } else {
            this.addNodeResources(node, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
        }
        return node;
    }

    public void addNodeResources(long nodeId, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        this.addNodeResources(node, addCommunityPermissions, addGuestPermissions);
    }

    public void addNodeResources(WikiNode node, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(node.getCompanyId(), node.getGroupId(), node.getUserId(), WikiNode.class.getName(), node.getNodeId(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addNodeResources(long nodeId, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        this.addNodeResources(node, communityPermissions, guestPermissions);
    }

    public void addNodeResources(WikiNode node, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(node.getCompanyId(), node.getGroupId(), node.getUserId(), WikiNode.class.getName(), node.getNodeId(), communityPermissions, guestPermissions);
    }

    public void deleteNode(long nodeId) throws PortalException, SystemException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        this.deleteNode(node);
    }

    public void deleteNode(WikiNode node) throws PortalException, SystemException {
        try {
            Indexer.deletePages(node.getCompanyId(), node.getNodeId());
        }
        catch (SearchException se) {
            _log.error((Object)("Deleting index " + node.getNodeId()), (Throwable)se);
        }
        this.subscriptionLocalService.deleteSubscriptions(node.getCompanyId(), WikiNode.class.getName(), node.getNodeId());
        this.wikiPageLocalService.deletePages(node.getNodeId());
        this.resourceLocalService.deleteResource(node.getCompanyId(), WikiNode.class.getName(), 4, node.getNodeId());
        this.wikiNodePersistence.remove((BaseModel)node);
    }

    public void deleteNodes(long groupId) throws PortalException, SystemException {
        for (WikiNode node : this.wikiNodePersistence.findByGroupId(groupId)) {
            this.deleteNode(node);
        }
    }

    public WikiNode getNode(long nodeId) throws PortalException, SystemException {
        return this.wikiNodePersistence.findByPrimaryKey(nodeId);
    }

    public WikiNode getNode(long groupId, String nodeName) throws PortalException, SystemException {
        return this.wikiNodePersistence.findByG_N(groupId, nodeName);
    }

    public List<WikiNode> getNodes(long groupId) throws SystemException {
        return this.wikiNodePersistence.findByGroupId(groupId);
    }

    public List<WikiNode> getNodes(long groupId, int start, int end) throws SystemException {
        return this.wikiNodePersistence.findByGroupId(groupId, start, end);
    }

    public int getNodesCount(long groupId) throws SystemException {
        return this.wikiNodePersistence.countByGroupId(groupId);
    }

    public void importPages(long userId, long nodeId, String importer, File[] files, Map<String, String[]> options) throws PortalException, SystemException {
        WikiNode node = this.getNode(nodeId);
        this.getWikiImporter(importer).importPages(userId, node, files, options);
    }

    public void reIndex(String[] ids) throws SystemException {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        long companyId = GetterUtil.getLong((String)ids[0]);
        try {
            this.reIndexNodes(companyId);
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public Hits search(long companyId, long groupId, long userId, long[] nodeIds, String keywords, int start, int end) throws SystemException {
        try {
            BooleanQuery contextQuery = BooleanQueryFactoryUtil.create();
            contextQuery.addRequiredTerm("portletId", "36");
            if (groupId > 0L) {
                Group group = this.groupLocalService.getGroup(groupId);
                if (group.isLayout()) {
                    contextQuery.addRequiredTerm("scopeGroupId", groupId);
                    groupId = group.getParentGroupId();
                }
                contextQuery.addRequiredTerm("groupId", groupId);
            }
            if (nodeIds != null && nodeIds.length > 0) {
                BooleanQuery nodeIdsQuery = BooleanQueryFactoryUtil.create();
                for (long nodeId : nodeIds) {
                    if (userId > 0L) {
                        try {
                            this.wikiNodeService.getNode(nodeId);
                        }
                        catch (Exception e) {
                            continue;
                        }
                    }
                    TermQuery termQuery = TermQueryFactoryUtil.create((String)"nodeId", (long)nodeId);
                    nodeIdsQuery.add((Query)termQuery, BooleanClauseOccur.SHOULD);
                }
                contextQuery.add((Query)nodeIdsQuery, BooleanClauseOccur.MUST);
            }
            BooleanQuery searchQuery = BooleanQueryFactoryUtil.create();
            if (Validator.isNotNull((String)keywords)) {
                searchQuery.addTerm("title", keywords);
                searchQuery.addTerm("content", keywords);
                searchQuery.addTerm("tagsEntries", keywords, true);
            }
            BooleanQuery fullQuery = BooleanQueryFactoryUtil.create();
            fullQuery.add((Query)contextQuery, BooleanClauseOccur.MUST);
            if (searchQuery.clauses().size() > 0) {
                fullQuery.add((Query)searchQuery, BooleanClauseOccur.MUST);
            }
            return SearchEngineUtil.search((long)companyId, (long)groupId, (long)userId, (String)WikiPage.class.getName(), (Query)fullQuery, (int)start, (int)end);
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }

    public void subscribeNode(long userId, long nodeId) throws PortalException, SystemException {
        this.subscriptionLocalService.addSubscription(userId, WikiNode.class.getName(), nodeId);
    }

    public void unsubscribeNode(long userId, long nodeId) throws PortalException, SystemException {
        this.subscriptionLocalService.deleteSubscription(userId, WikiNode.class.getName(), nodeId);
    }

    public WikiNode updateNode(long nodeId, String name, String description) throws PortalException, SystemException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        this.validate(nodeId, node.getGroupId(), name);
        node.setModifiedDate(new Date());
        node.setName(name);
        node.setDescription(description);
        this.wikiNodePersistence.update((BaseModel)node, false);
        return node;
    }

    protected WikiImporter getWikiImporter(String importer) throws SystemException {
        WikiImporter wikiImporter = this._wikiImporters.get(importer);
        if (wikiImporter == null) {
            String importerClass = PropsUtil.get("wiki.importers.class", new Filter(importer));
            if (importerClass != null) {
                wikiImporter = (WikiImporter)InstancePool.get((String)importerClass);
                this._wikiImporters.put(importer, wikiImporter);
            }
            if (importer == null) {
                throw new SystemException("Unable to instantiate wiki importer class " + importerClass);
            }
        }
        return wikiImporter;
    }

    protected void reIndexNodes(long companyId) throws SystemException {
        int nodeCount = this.wikiNodePersistence.countByCompanyId(companyId);
        int nodePages = nodeCount / 1000;
        for (int i = 0; i <= nodePages; ++i) {
            int nodeStart = i * 1000;
            int nodeEnd = nodeStart + 1000;
            this.reIndexNodes(companyId, nodeStart, nodeEnd);
        }
    }

    protected void reIndexNodes(long companyId, int nodeStart, int nodeEnd) throws SystemException {
        List nodes = this.wikiNodePersistence.findByCompanyId(companyId, nodeStart, nodeEnd);
        for (WikiNode node : nodes) {
            long nodeId = node.getNodeId();
            int pageCount = this.wikiPagePersistence.countByN_H(nodeId, true);
            int pagePages = pageCount / 1000;
            for (int i = 0; i <= pagePages; ++i) {
                int pageStart = i * 1000;
                int pageEnd = pageStart + 1000;
                this.reIndexPages(nodeId, pageStart, pageEnd);
            }
        }
    }

    protected void reIndexPages(long nodeId, int pageStart, int pageEnd) throws SystemException {
        List pages = this.wikiPagePersistence.findByN_H(nodeId, true, pageStart, pageEnd);
        for (WikiPage page : pages) {
            this.wikiPageLocalService.reIndex(page);
        }
    }

    protected void validate(long groupId, String name) throws PortalException, SystemException {
        this.validate(0L, groupId, name);
    }

    protected void validate(long nodeId, long groupId, String name) throws PortalException, SystemException {
        if (name.equalsIgnoreCase("tag")) {
            throw new NodeNameException(name + " is reserved");
        }
        if (!Validator.isName((String)name)) {
            throw new NodeNameException();
        }
        WikiNode node = this.wikiNodePersistence.fetchByG_N(groupId, name);
        if (node != null && node.getNodeId() != nodeId) {
            throw new DuplicateNodeNameException();
        }
    }
}

