/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.service.base.WikiNodeServiceBaseImpl;
import com.liferay.portlet.wiki.service.permission.WikiNodePermission;
import com.liferay.portlet.wiki.service.permission.WikiPermission;
import java.io.File;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiNodeServiceImpl
extends WikiNodeServiceBaseImpl {
    public WikiNode addNode(String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        WikiPermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "ADD_NODE");
        return this.wikiNodeLocalService.addNode(this.getUserId(), name, description, serviceContext);
    }

    public void deleteNode(long nodeId) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "DELETE");
        this.wikiNodeLocalService.deleteNode(nodeId);
    }

    public WikiNode getNode(long nodeId) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "VIEW");
        return this.wikiNodeLocalService.getNode(nodeId);
    }

    public WikiNode getNode(long groupId, String name) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), groupId, name, "VIEW");
        return this.wikiNodeLocalService.getNode(groupId, name);
    }

    public void importPages(long nodeId, String importer, File[] files, Map<String, String[]> options) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "IMPORT");
        this.wikiNodeLocalService.importPages(this.getUserId(), nodeId, importer, files, options);
    }

    public void subscribeNode(long nodeId) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "SUBSCRIBE");
        this.wikiNodeLocalService.subscribeNode(this.getUserId(), nodeId);
    }

    public void unsubscribeNode(long nodeId) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "SUBSCRIBE");
        this.wikiNodeLocalService.unsubscribeNode(this.getUserId(), nodeId);
    }

    public WikiNode updateNode(long nodeId, String name, String description) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "UPDATE");
        return this.wikiNodeLocalService.updateNode(nodeId, name, description);
    }
}

