/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.service.impl;

import com.liferay.documentlibrary.DuplicateDirectoryException;
import com.liferay.documentlibrary.DuplicateFileException;
import com.liferay.documentlibrary.NoSuchDirectoryException;
import com.liferay.documentlibrary.NoSuchFileException;
import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MathUtil;
import com.liferay.portal.kernel.util.NotificationThreadLocal;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Company;
import com.liferay.portal.model.CompanyConstants;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.wiki.DuplicatePageException;
import com.liferay.portlet.wiki.NoSuchPageException;
import com.liferay.portlet.wiki.NoSuchPageResourceException;
import com.liferay.portlet.wiki.PageContentException;
import com.liferay.portlet.wiki.PageTitleException;
import com.liferay.portlet.wiki.PageVersionException;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.model.WikiPageDisplay;
import com.liferay.portlet.wiki.model.WikiPageResource;
import com.liferay.portlet.wiki.model.impl.WikiPageDisplayImpl;
import com.liferay.portlet.wiki.model.impl.WikiPageImpl;
import com.liferay.portlet.wiki.service.base.WikiPageLocalServiceBaseImpl;
import com.liferay.portlet.wiki.util.Indexer;
import com.liferay.portlet.wiki.util.WikiCacheThreadLocal;
import com.liferay.portlet.wiki.util.WikiCacheUtil;
import com.liferay.portlet.wiki.util.WikiUtil;
import com.liferay.portlet.wiki.util.comparator.PageCreateDateComparator;
import com.liferay.util.UniqueList;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiPageLocalServiceImpl
extends WikiPageLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(WikiPageLocalServiceImpl.class);

    public WikiPage addPage(long userId, long nodeId, String title, String content, String summary, boolean minorEdit, ServiceContext serviceContext) throws PortalException, SystemException {
        String uuid = null;
        double version = 1.0;
        String format = WikiPageImpl.DEFAULT_FORMAT;
        boolean head = true;
        String parentTitle = null;
        String redirectTitle = null;
        return this.addPage(uuid, userId, nodeId, title, version, content, summary, minorEdit, format, head, parentTitle, redirectTitle, serviceContext);
    }

    public WikiPage addPage(String uuid, long userId, long nodeId, String title, double version, String content, String summary, boolean minorEdit, String format, boolean head, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        Date now = new Date();
        this.validate(title, nodeId, content, format);
        long pageId = this.counterLocalService.increment();
        long resourcePrimKey = this.wikiPageResourceLocalService.getPageResourcePrimKey(nodeId, title);
        WikiPage page = this.wikiPagePersistence.create(pageId);
        page.setUuid(uuid);
        page.setResourcePrimKey(resourcePrimKey);
        page.setGroupId(node.getGroupId());
        page.setCompanyId(user.getCompanyId());
        page.setUserId(user.getUserId());
        page.setUserName(user.getFullName());
        page.setCreateDate(now);
        page.setModifiedDate(now);
        page.setNodeId(nodeId);
        page.setTitle(title);
        page.setVersion(version);
        page.setMinorEdit(minorEdit);
        page.setContent(content);
        page.setSummary(summary);
        page.setFormat(format);
        page.setHead(head);
        page.setParentTitle(parentTitle);
        page.setRedirectTitle(redirectTitle);
        this.wikiPagePersistence.update((BaseModel)page, false);
        if (serviceContext.getAddCommunityPermissions() || serviceContext.getAddGuestPermissions()) {
            this.addPageResources(page, serviceContext.getAddCommunityPermissions(), serviceContext.getAddGuestPermissions());
        } else {
            this.addPageResources(page, serviceContext.getCommunityPermissions(), serviceContext.getGuestPermissions());
        }
        node.setLastPostDate(now);
        this.wikiNodePersistence.update((BaseModel)node, false);
        if (PropsValues.WIKI_PAGE_COMMENTS_ENABLED) {
            this.mbMessageLocalService.addDiscussionMessage(userId, page.getUserName(), WikiPage.class.getName(), resourcePrimKey);
        }
        this.socialActivityLocalService.addActivity(userId, page.getGroupId(), WikiPage.class.getName(), resourcePrimKey, 1, "", 0L);
        if (!minorEdit && NotificationThreadLocal.isEnabled()) {
            this.notifySubscribers(node, page, serviceContext, false);
        }
        this.updateTagsAsset(userId, page, serviceContext.getTagsCategories(), serviceContext.getTagsEntries());
        this.reIndex(page);
        this.clearPageCache(page);
        this.clearReferralsCache(page);
        return page;
    }

    public void addPageAttachments(long nodeId, String title, List<ObjectValuePair<String, byte[]>> files) throws PortalException, SystemException {
        if (files.size() == 0) {
            return;
        }
        WikiPage page = this.getPage(nodeId, title);
        long companyId = page.getCompanyId();
        String portletId = CompanyConstants.SYSTEM_STRING;
        long groupId = 0L;
        long repositoryId = 0L;
        String dirName = page.getAttachmentsDir();
        try {
            this.dlService.addDirectory(companyId, repositoryId, dirName);
        }
        catch (DuplicateDirectoryException dde) {
            // empty catch block
        }
        for (int i = 0; i < files.size(); ++i) {
            ObjectValuePair<String, byte[]> ovp = files.get(i);
            String fileName = (String)ovp.getKey();
            byte[] bytes = (byte[])ovp.getValue();
            if (Validator.isNull((String)fileName)) continue;
            try {
                this.dlService.addFile(companyId, portletId, groupId, repositoryId, dirName + "/" + fileName, 0L, "", page.getModifiedDate(), new String[0], new String[0], bytes);
                continue;
            }
            catch (DuplicateFileException dfe) {
                // empty catch block
            }
        }
    }

    public void addPageResources(long nodeId, String title, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        WikiPage page = this.getPage(nodeId, title);
        this.addPageResources(page, addCommunityPermissions, addGuestPermissions);
    }

    public void addPageResources(WikiPage page, boolean addCommunityPermissions, boolean addGuestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addResources(page.getCompanyId(), page.getGroupId(), page.getUserId(), WikiPage.class.getName(), page.getResourcePrimKey(), false, addCommunityPermissions, addGuestPermissions);
    }

    public void addPageResources(long nodeId, String title, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        WikiPage page = this.getPage(nodeId, title);
        this.addPageResources(page, communityPermissions, guestPermissions);
    }

    public void addPageResources(WikiPage page, String[] communityPermissions, String[] guestPermissions) throws PortalException, SystemException {
        this.resourceLocalService.addModelResources(page.getCompanyId(), page.getGroupId(), page.getUserId(), WikiPage.class.getName(), page.getResourcePrimKey(), communityPermissions, guestPermissions);
    }

    public void changeParent(long userId, long nodeId, String title, String newParentTitle, ServiceContext serviceContext) throws PortalException, SystemException {
        WikiPage parentPage;
        if (Validator.isNotNull((String)newParentTitle) && Validator.isNotNull((String)(parentPage = this.getPage(nodeId, newParentTitle)).getRedirectTitle())) {
            newParentTitle = parentPage.getRedirectTitle();
        }
        WikiPage page = this.getPage(nodeId, title);
        String originalParentTitle = page.getParentTitle();
        double version = page.getVersion();
        String content = page.getContent();
        String summary = LanguageUtil.format((Locale)ServiceContextUtil.getLocale((ServiceContext)serviceContext), (String)"changed-parent-from-x", (Object)originalParentTitle);
        boolean minorEdit = false;
        String format = page.getFormat();
        String redirectTitle = page.getRedirectTitle();
        String[] tagsCategories = this.tagsEntryLocalService.getEntryNames(WikiPage.class.getName(), page.getResourcePrimKey(), false);
        String[] tagsEntries = this.tagsEntryLocalService.getEntryNames(WikiPage.class.getName(), page.getResourcePrimKey(), true);
        serviceContext.setTagsCategories(tagsCategories);
        serviceContext.setTagsEntries(tagsEntries);
        this.updatePage(userId, nodeId, title, version, content, summary, minorEdit, format, newParentTitle, redirectTitle, serviceContext);
        List oldPages = this.wikiPagePersistence.findByN_T_H(nodeId, title, false);
        for (WikiPage oldPage : oldPages) {
            oldPage.setParentTitle(originalParentTitle);
            this.wikiPagePersistence.update((BaseModel)oldPage, false);
        }
    }

    public void deletePage(long nodeId, String title) throws PortalException, SystemException {
        List pages = this.wikiPagePersistence.findByN_T_H(nodeId, title, true, 0, 1);
        if (pages.size() > 0) {
            WikiPage page = (WikiPage)pages.iterator().next();
            this.deletePage(page);
        }
    }

    public void deletePage(WikiPage page) throws PortalException, SystemException {
        List children = this.wikiPagePersistence.findByN_H_P(page.getNodeId(), true, page.getTitle());
        for (WikiPage curPage : children) {
            this.deletePage(curPage);
        }
        try {
            Indexer.deletePage(page.getCompanyId(), page.getNodeId(), page.getTitle());
        }
        catch (SearchException se) {
            _log.error((Object)("Deleting index " + page.getPrimaryKey()), (Throwable)se);
        }
        long companyId = page.getCompanyId();
        String portletId = CompanyConstants.SYSTEM_STRING;
        long repositoryId = 0L;
        String dirName = page.getAttachmentsDir();
        try {
            this.dlService.deleteDirectory(companyId, portletId, repositoryId, dirName);
        }
        catch (NoSuchDirectoryException nsde) {
            // empty catch block
        }
        this.tagsAssetLocalService.deleteAsset(WikiPage.class.getName(), page.getResourcePrimKey());
        this.subscriptionLocalService.deleteSubscriptions(page.getCompanyId(), WikiPage.class.getName(), page.getPageId());
        this.socialActivityLocalService.deleteActivities(WikiPage.class.getName(), page.getResourcePrimKey());
        this.mbMessageLocalService.deleteDiscussionMessages(WikiPage.class.getName(), page.getResourcePrimKey());
        this.resourceLocalService.deleteResource(page.getCompanyId(), WikiPage.class.getName(), 4, page.getResourcePrimKey());
        try {
            this.wikiPageResourceLocalService.deletePageResource(page.getNodeId(), page.getTitle());
        }
        catch (NoSuchPageResourceException nspre) {
            // empty catch block
        }
        this.wikiPagePersistence.removeByN_T(page.getNodeId(), page.getTitle());
        this.wikiPagePersistence.removeByN_R(page.getNodeId(), page.getTitle());
        this.clearPageCache(page);
        this.clearReferralsCache(page);
    }

    public void deletePageAttachment(long nodeId, String title, String fileName) throws PortalException, SystemException {
        if (Validator.isNull((String)fileName)) {
            return;
        }
        WikiPage page = this.getPage(nodeId, title);
        long companyId = page.getCompanyId();
        String portletId = CompanyConstants.SYSTEM_STRING;
        long repositoryId = 0L;
        try {
            this.dlService.deleteFile(companyId, portletId, repositoryId, fileName);
        }
        catch (NoSuchFileException nsfe) {
            // empty catch block
        }
    }

    public void deletePages(long nodeId) throws PortalException, SystemException {
        for (WikiPage page : this.wikiPagePersistence.findByN_H_P(nodeId, true, "")) {
            this.deletePage(page);
        }
    }

    public List<WikiPage> getChildren(long nodeId, boolean head, String parentTitle) throws SystemException {
        return this.wikiPagePersistence.findByN_H_P(nodeId, head, parentTitle);
    }

    public List<WikiPage> getIncomingLinks(long nodeId, String title) throws PortalException, SystemException {
        UniqueList links = new UniqueList();
        List pages = this.wikiPagePersistence.findByN_H(nodeId, true);
        for (WikiPage page : pages) {
            if (!this.isLinkedTo(page, title)) continue;
            links.add(page);
        }
        List referrals = this.wikiPagePersistence.findByN_R(nodeId, title);
        for (WikiPage referral : referrals) {
            for (WikiPage page : pages) {
                if (!this.isLinkedTo(page, referral.getTitle())) continue;
                links.add(page);
            }
        }
        return ListUtil.sort((List)links);
    }

    public List<WikiPage> getNoAssetPages() throws SystemException {
        return this.wikiPageFinder.findByNoAssets();
    }

    public List<WikiPage> getOrphans(long nodeId) throws PortalException, SystemException {
        ArrayList<Map<String, Boolean>> pageTitles = new ArrayList<Map<String, Boolean>>();
        List pages = this.wikiPagePersistence.findByN_H(nodeId, true);
        for (WikiPage page : pages) {
            pageTitles.add(WikiCacheUtil.getOutgoingLinks(page));
        }
        HashSet<WikiPage> notOrphans = new HashSet<WikiPage>();
        block1: for (WikiPage page : pages) {
            for (Map map : pageTitles) {
                if (map.get(page.getTitle().toLowerCase()) == null) continue;
                notOrphans.add(page);
                continue block1;
            }
        }
        ArrayList<WikiPage> orphans = new ArrayList();
        for (WikiPage page : pages) {
            if (notOrphans.contains(page)) continue;
            orphans.add(page);
        }
        orphans = ListUtil.sort(orphans);
        return orphans;
    }

    public List<WikiPage> getOutgoingLinks(long nodeId, String title) throws PortalException, SystemException {
        WikiPage page = this.getPage(nodeId, title);
        LinkedHashMap<String, WikiPage> pages = new LinkedHashMap<String, WikiPage>();
        Map<String, Boolean> links = WikiCacheUtil.getOutgoingLinks(page);
        for (String curTitle : links.keySet()) {
            Boolean exists = links.get(curTitle);
            if (exists.booleanValue()) {
                if (pages.containsKey(curTitle)) continue;
                pages.put(curTitle, this.getPage(nodeId, curTitle));
                continue;
            }
            WikiPageImpl newPage = new WikiPageImpl();
            newPage.setNew(true);
            newPage.setNodeId(nodeId);
            newPage.setTitle(curTitle);
            if (pages.containsKey(curTitle)) continue;
            pages.put(curTitle, newPage);
        }
        return ListUtil.fromCollection(pages.values());
    }

    public WikiPage getPage(long resourcePrimKey) throws PortalException, SystemException {
        WikiPageResource wikiPageResource = this.wikiPageResourceLocalService.getPageResource(resourcePrimKey);
        return this.getPage(wikiPageResource.getNodeId(), wikiPageResource.getTitle());
    }

    public WikiPage getPage(long nodeId, String title) throws PortalException, SystemException {
        List pages = this.wikiPagePersistence.findByN_T_H(nodeId, title, true, 0, 1);
        if (pages.size() > 0) {
            return (WikiPage)pages.get(0);
        }
        throw new NoSuchPageException();
    }

    public WikiPage getPage(long nodeId, String title, double version) throws PortalException, SystemException {
        WikiPage page = null;
        page = version == 0.0 ? this.getPage(nodeId, title) : this.wikiPagePersistence.findByN_T_V(nodeId, title, version);
        return page;
    }

    public WikiPageDisplay getPageDisplay(long nodeId, String title, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) throws PortalException, SystemException {
        WikiPage page = this.getPage(nodeId, title);
        String formattedContent = WikiUtil.convert(page, viewPageURL, editPageURL, attachmentURLPrefix);
        return new WikiPageDisplayImpl(page.getUserId(), page.getNodeId(), page.getTitle(), page.getVersion(), page.getContent(), formattedContent, page.getFormat(), page.getHead(), page.getAttachmentsFiles());
    }

    public List<WikiPage> getPages(long nodeId, int start, int end) throws SystemException {
        return this.wikiPagePersistence.findByNodeId(nodeId, start, end, (OrderByComparator)new PageCreateDateComparator(false));
    }

    public List<WikiPage> getPages(String format) throws SystemException {
        return this.wikiPagePersistence.findByFormat(format);
    }

    public List<WikiPage> getPages(long nodeId, String title, int start, int end) throws SystemException {
        return this.wikiPagePersistence.findByN_T(nodeId, title, start, end, (OrderByComparator)new PageCreateDateComparator(false));
    }

    public List<WikiPage> getPages(long nodeId, String title, int start, int end, OrderByComparator obc) throws SystemException {
        return this.wikiPagePersistence.findByN_T(nodeId, title, start, end, obc);
    }

    public List<WikiPage> getPages(long nodeId, boolean head, int start, int end) throws SystemException {
        return this.wikiPagePersistence.findByN_H(nodeId, head, start, end, (OrderByComparator)new PageCreateDateComparator(false));
    }

    public List<WikiPage> getPages(long nodeId, String title, boolean head, int start, int end) throws SystemException {
        return this.wikiPagePersistence.findByN_T_H(nodeId, title, head, start, end, (OrderByComparator)new PageCreateDateComparator(false));
    }

    public int getPagesCount(long nodeId) throws SystemException {
        return this.wikiPagePersistence.countByNodeId(nodeId);
    }

    public int getPagesCount(long nodeId, String title) throws SystemException {
        return this.wikiPagePersistence.countByN_T(nodeId, title);
    }

    public int getPagesCount(long nodeId, boolean head) throws SystemException {
        return this.wikiPagePersistence.countByN_H(nodeId, head);
    }

    public int getPagesCount(long nodeId, String title, boolean head) throws SystemException {
        return this.wikiPagePersistence.countByN_T_H(nodeId, title, head);
    }

    public int getPagesCount(String format) throws SystemException {
        return this.wikiPagePersistence.countByFormat(format);
    }

    public List<WikiPage> getRecentChanges(long nodeId, int start, int end) throws SystemException {
        Calendar cal = CalendarFactoryUtil.getCalendar();
        cal.add(3, -1);
        return this.wikiPageFinder.findByCreateDate(nodeId, cal.getTime(), false, start, end);
    }

    public int getRecentChangesCount(long nodeId) throws SystemException {
        Calendar cal = CalendarFactoryUtil.getCalendar();
        cal.add(3, -1);
        return this.wikiPageFinder.countByCreateDate(nodeId, cal.getTime(), false);
    }

    public void movePage(long userId, long nodeId, String title, String newTitle, ServiceContext serviceContext) throws PortalException, SystemException {
        this.movePage(userId, nodeId, title, newTitle, true, serviceContext);
    }

    public void movePage(long userId, long nodeId, String title, String newTitle, boolean strict, ServiceContext serviceContext) throws PortalException, SystemException {
        WikiPage page3;
        List pageVersions;
        this.validateTitle(newTitle);
        if (title.equalsIgnoreCase(newTitle)) {
            throw new DuplicatePageException(newTitle);
        }
        if (this.isUsedTitle(nodeId, newTitle)) {
            WikiPage page2 = this.getPage(nodeId, newTitle);
            if (page2.getVersion() == 1.0 && page2.getContent().length() < 200 || !strict) {
                this.deletePage(nodeId, newTitle);
            } else {
                throw new DuplicatePageException(newTitle);
            }
        }
        if ((pageVersions = this.wikiPagePersistence.findByN_T(nodeId, title)).size() == 0) {
            return;
        }
        for (WikiPage page3 : pageVersions) {
            page3.setTitle(newTitle);
            this.wikiPagePersistence.update((BaseModel)page3, false);
        }
        List children = this.wikiPagePersistence.findByN_P(nodeId, title);
        for (WikiPage page4 : children) {
            page4.setParentTitle(newTitle);
            this.wikiPagePersistence.update((BaseModel)page4, false);
        }
        page3 = (WikiPage)pageVersions.get(pageVersions.size() - 1);
        long resourcePrimKey = page3.getResourcePrimKey();
        WikiPageResource wikiPageResource = this.wikiPageResourcePersistence.findByPrimaryKey(resourcePrimKey);
        wikiPageResource.setTitle(newTitle);
        this.wikiPageResourcePersistence.update((BaseModel)wikiPageResource, false);
        String uuid = null;
        double version = 1.0;
        String summary = "Moved to " + title;
        String format = page3.getFormat();
        boolean head = true;
        String parentTitle = page3.getParentTitle();
        String redirectTitle = page3.getTitle();
        String content = "[[" + redirectTitle + "]]";
        this.addPage(uuid, userId, nodeId, title, version, content, summary, false, format, head, parentTitle, redirectTitle, serviceContext);
        List redirectedPages = this.wikiPagePersistence.findByN_R(nodeId, title);
        for (WikiPage redirectedPage : redirectedPages) {
            redirectedPage.setRedirectTitle(newTitle);
            this.wikiPagePersistence.update((BaseModel)redirectedPage, false);
        }
        String[] tagsCategories = this.tagsEntryLocalService.getEntryNames(WikiPage.class.getName(), resourcePrimKey, false);
        String[] tagsEntries = this.tagsEntryLocalService.getEntryNames(WikiPage.class.getName(), resourcePrimKey, true);
        this.updateTagsAsset(userId, page3, tagsCategories, tagsEntries);
        try {
            Indexer.deletePage(page3.getCompanyId(), page3.getGroupId(), title);
        }
        catch (SearchException se) {
            _log.error((Object)("Indexing " + newTitle), (Throwable)se);
        }
        this.reIndex(page3);
    }

    public void reIndex(long resourcePrimKey) throws SystemException {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        WikiPage page = null;
        try {
            page = this.wikiPageFinder.findByResourcePrimKey(resourcePrimKey);
        }
        catch (NoSuchPageException nspe) {
            return;
        }
        this.reIndex(page);
    }

    public void reIndex(WikiPage page) throws SystemException {
        if (Validator.isNotNull((String)page.getRedirectTitle())) {
            return;
        }
        long companyId = page.getCompanyId();
        long groupId = page.getGroupId();
        long resourcePrimKey = page.getResourcePrimKey();
        long nodeId = page.getNodeId();
        String title = page.getTitle();
        String content = page.getContent();
        Date modifiedDate = page.getModifiedDate();
        String[] tagsCategories = this.tagsEntryLocalService.getEntryNames(WikiPage.class.getName(), resourcePrimKey, false);
        String[] tagsEntries = this.tagsEntryLocalService.getEntryNames(WikiPage.class.getName(), resourcePrimKey);
        ExpandoBridge expandoBridge = page.getExpandoBridge();
        try {
            Indexer.updatePage(companyId, groupId, resourcePrimKey, nodeId, title, content, modifiedDate, tagsCategories, tagsEntries, expandoBridge);
        }
        catch (SearchException se) {
            _log.error((Object)("Reindexing " + page.getPrimaryKey()), (Throwable)se);
        }
    }

    public WikiPage revertPage(long userId, long nodeId, String title, double version, ServiceContext serviceContext) throws PortalException, SystemException {
        WikiPage oldPage = this.getPage(nodeId, title, version);
        return this.updatePage(userId, nodeId, title, 0.0, oldPage.getContent(), "Reverted to " + version, false, oldPage.getFormat(), this.getParentPageTitle(oldPage), oldPage.getRedirectTitle(), serviceContext);
    }

    public void subscribePage(long userId, long nodeId, String title) throws PortalException, SystemException {
        WikiPage page = this.getPage(nodeId, title);
        this.subscriptionLocalService.addSubscription(userId, WikiPage.class.getName(), page.getResourcePrimKey());
    }

    public void unsubscribePage(long userId, long nodeId, String title) throws PortalException, SystemException {
        WikiPage page = this.getPage(nodeId, title);
        this.subscriptionLocalService.deleteSubscription(userId, WikiPage.class.getName(), page.getResourcePrimKey());
    }

    public WikiPage updatePage(long userId, long nodeId, String title, double version, String content, String summary, boolean minorEdit, String format, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        this.validate(nodeId, content, format);
        WikiPage page = null;
        try {
            page = this.getPage(nodeId, title);
        }
        catch (NoSuchPageException nspe) {
            return this.addPage(null, userId, nodeId, title, 1.0, content, summary, minorEdit, format, true, parentTitle, redirectTitle, serviceContext);
        }
        double oldVersion = page.getVersion();
        if (version > 0.0 && version != oldVersion) {
            throw new PageVersionException();
        }
        long resourcePrimKey = page.getResourcePrimKey();
        long groupId = page.getGroupId();
        page.setHead(false);
        page.setModifiedDate(now);
        this.wikiPagePersistence.update((BaseModel)page, false);
        double newVersion = MathUtil.format((double)(oldVersion + 0.1), (int)1, (int)1);
        long pageId = this.counterLocalService.increment();
        page = this.wikiPagePersistence.create(pageId);
        page.setResourcePrimKey(resourcePrimKey);
        page.setGroupId(groupId);
        page.setCompanyId(user.getCompanyId());
        page.setUserId(user.getUserId());
        page.setUserName(user.getFullName());
        page.setCreateDate(now);
        page.setModifiedDate(now);
        page.setNodeId(nodeId);
        page.setTitle(title);
        page.setVersion(newVersion);
        page.setMinorEdit(minorEdit);
        page.setContent(content);
        page.setSummary(summary);
        page.setFormat(format);
        page.setHead(true);
        if (Validator.isNotNull((String)parentTitle)) {
            page.setParentTitle(parentTitle);
        }
        if (Validator.isNotNull((String)redirectTitle)) {
            page.setRedirectTitle(redirectTitle);
        }
        this.wikiPagePersistence.update((BaseModel)page, false);
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        node.setLastPostDate(now);
        this.wikiNodePersistence.update((BaseModel)node, false);
        this.socialActivityLocalService.addActivity(userId, page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey(), 2, "", 0L);
        if (!minorEdit && NotificationThreadLocal.isEnabled()) {
            this.notifySubscribers(node, page, serviceContext, true);
        }
        this.updateTagsAsset(userId, page, serviceContext.getTagsCategories(), serviceContext.getTagsEntries());
        this.reIndex(page);
        this.clearPageCache(page);
        return page;
    }

    public void updateTagsAsset(long userId, WikiPage page, String[] tagsCategories, String[] tagsEntries) throws PortalException, SystemException {
        this.tagsAssetLocalService.updateAsset(userId, page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey(), tagsCategories, tagsEntries, true, null, null, null, null, "text/html", page.getTitle(), null, null, null, 0, 0, null, false);
    }

    public void validateTitle(String title) throws PortalException {
        Pattern pattern;
        Matcher matcher;
        if (title.equals("all_pages") || title.equals("orphan_pages") || title.equals("recent_changes")) {
            throw new PageTitleException(title + " is reserved");
        }
        if (Validator.isNotNull((String)PropsValues.WIKI_PAGE_TITLES_REGEXP) && !(matcher = (pattern = Pattern.compile(PropsValues.WIKI_PAGE_TITLES_REGEXP)).matcher(title)).matches()) {
            throw new PageTitleException();
        }
    }

    protected void clearPageCache(WikiPage page) {
        if (!WikiCacheThreadLocal.isClearCache()) {
            return;
        }
        WikiCacheUtil.clearCache(page.getNodeId(), page.getTitle());
    }

    protected void clearReferralsCache(WikiPage page) throws PortalException, SystemException {
        if (!WikiCacheThreadLocal.isClearCache()) {
            return;
        }
        List<WikiPage> links = this.getIncomingLinks(page.getNodeId(), page.getTitle());
        for (WikiPage curPage : links) {
            WikiCacheUtil.clearCache(curPage.getNodeId(), curPage.getTitle());
        }
    }

    protected String getParentPageTitle(WikiPage page) {
        try {
            WikiPage parentPage = this.getPage(page.getNodeId(), page.getParentTitle());
            return parentPage.getTitle();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected WikiPage getPreviousVersionPage(WikiPage page) throws PortalException, SystemException {
        double previousVersion = MathUtil.format((double)(page.getVersion() - 0.1), (int)1, (int)1);
        if (previousVersion < 1.0) {
            return null;
        }
        return this.getPage(page.getNodeId(), page.getTitle(), previousVersion);
    }

    protected boolean isLinkedTo(WikiPage page, String targetTitle) throws PortalException {
        Map<String, Boolean> links = WikiCacheUtil.getOutgoingLinks(page);
        Boolean link = links.get(targetTitle.toLowerCase());
        return link != null;
    }

    protected boolean isUsedTitle(long nodeId, String title) throws SystemException {
        return this.getPagesCount(nodeId, title, true) > 0;
    }

    protected void notifySubscribers(WikiNode node, WikiPage page, ServiceContext serviceContext, boolean update) throws PortalException, SystemException {
        String fromAddress;
        PortletPreferences preferences = ServiceContextUtil.getPortletPreferences((ServiceContext)serviceContext);
        if (preferences == null) {
            long ownerId = node.getGroupId();
            int ownerType = 2;
            long plid = 0L;
            String portletId = "36";
            String defaultPreferences = null;
            preferences = this.portletPreferencesLocalService.getPreferences(node.getCompanyId(), ownerId, ownerType, plid, portletId, defaultPreferences);
        }
        if (!(!update && WikiUtil.getEmailPageAddedEnabled(preferences) || update && WikiUtil.getEmailPageUpdatedEnabled(preferences))) {
            return;
        }
        Company company = this.companyPersistence.findByPrimaryKey(page.getCompanyId());
        Group group = this.groupPersistence.findByPrimaryKey(node.getGroupId());
        User user = this.userPersistence.findByPrimaryKey(page.getUserId());
        String portalURL = serviceContext.getPortalURL();
        String layoutFullURL = serviceContext.getLayoutFullURL();
        WikiPage previousVersionPage = this.getPreviousVersionPage(page);
        String attachmentURLPrefix = portalURL + serviceContext.getPathMain() + "/wiki/get_page_attachment?p_l_id=" + serviceContext.getPlid() + "&nodeId=" + page.getNodeId() + "&title=" + HttpUtil.encodeURL((String)page.getTitle()) + "&fileName=";
        String pageDiffs = "";
        try {
            pageDiffs = WikiUtil.diffHtml(previousVersionPage, page, null, null, attachmentURLPrefix);
        }
        catch (Exception e) {
            // empty catch block
        }
        String pageContent = null;
        if (Validator.equals((Object)page.getFormat(), (Object)"creole")) {
            pageContent = WikiUtil.convert(page, null, null, attachmentURLPrefix);
        } else {
            pageContent = page.getContent();
            pageContent = WikiUtil.processContent(pageContent);
        }
        String pageURL = "";
        String diffsURL = "";
        if (Validator.isNotNull((String)layoutFullURL)) {
            pageURL = layoutFullURL + "/-/" + "wiki/" + node.getNodeId() + "/" + HttpUtil.encodeURL((String)page.getTitle());
            if (previousVersionPage != null) {
                StringBuilder sb = new StringBuilder();
                sb.append(layoutFullURL);
                sb.append("?p_p_id=");
                sb.append("36");
                sb.append("&p_p_state=");
                sb.append(WindowState.MAXIMIZED);
                sb.append("&struts_action=");
                sb.append(HttpUtil.encodeURL((String)"/wiki/compare_versions"));
                sb.append("&nodeId=");
                sb.append(node.getNodeId());
                sb.append("&title=");
                sb.append(HttpUtil.encodeURL((String)page.getTitle()));
                sb.append("&sourceVersion=");
                sb.append(previousVersionPage.getVersion());
                sb.append("&targetVersion=");
                sb.append(page.getVersion());
                sb.append("&type=html");
                diffsURL = sb.toString();
            }
        }
        String portletName = PortalUtil.getPortletTitle((String)"36", (User)user);
        String fromName = WikiUtil.getEmailFromName(preferences);
        String replyToAddress = fromAddress = WikiUtil.getEmailFromAddress(preferences);
        String mailId = WikiUtil.getMailId(company.getMx(), page.getNodeId(), page.getPageId());
        fromName = StringUtil.replace((String)fromName, (String[])new String[]{"[$COMPANY_ID$]", "[$COMPANY_MX$]", "[$COMPANY_NAME$]", "[$COMMUNITY_NAME$]", "[$PAGE_USER_ADDRESS$]", "[$PAGE_USER_NAME$]", "[$PORTLET_NAME$]"}, (String[])new String[]{String.valueOf(company.getCompanyId()), company.getMx(), company.getName(), group.getName(), user.getEmailAddress(), user.getFullName(), portletName});
        fromAddress = StringUtil.replace((String)fromAddress, (String[])new String[]{"[$COMPANY_ID$]", "[$COMPANY_MX$]", "[$COMPANY_NAME$]", "[$COMMUNITY_NAME$]", "[$PAGE_USER_ADDRESS$]", "[$PAGE_USER_NAME$]", "[$PORTLET_NAME$]"}, (String[])new String[]{String.valueOf(company.getCompanyId()), company.getMx(), company.getName(), group.getName(), user.getEmailAddress(), user.getFullName(), portletName});
        String subjectPrefix = null;
        String body = null;
        String signature = null;
        if (update) {
            subjectPrefix = WikiUtil.getEmailPageUpdatedSubjectPrefix(preferences);
            body = WikiUtil.getEmailPageUpdatedBody(preferences);
            signature = WikiUtil.getEmailPageUpdatedSignature(preferences);
        } else {
            subjectPrefix = WikiUtil.getEmailPageAddedSubjectPrefix(preferences);
            body = WikiUtil.getEmailPageAddedBody(preferences);
            signature = WikiUtil.getEmailPageAddedSignature(preferences);
        }
        if (Validator.isNotNull((String)signature)) {
            body = body + "\n" + signature;
        }
        subjectPrefix = StringUtil.replace((String)subjectPrefix, (String[])new String[]{"[$COMPANY_ID$]", "[$COMPANY_MX$]", "[$COMPANY_NAME$]", "[$COMMUNITY_NAME$]", "[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$NODE_NAME$]", "[$PAGE_CONTENT$]", "[$PAGE_ID$]", "[$PAGE_TITLE$]", "[$PAGE_USER_ADDRESS$]", "[$PAGE_USER_NAME$]", "[$PORTAL_URL$]", "[$PORTLET_NAME$]"}, (String[])new String[]{String.valueOf(company.getCompanyId()), company.getMx(), company.getName(), group.getName(), fromAddress, fromName, node.getName(), pageContent, String.valueOf(page.getPageId()), page.getTitle(), user.getEmailAddress(), user.getFullName(), company.getVirtualHost(), portletName});
        body = StringUtil.replace((String)body, (String[])new String[]{"[$COMPANY_ID$]", "[$COMPANY_MX$]", "[$COMPANY_NAME$]", "[$COMMUNITY_NAME$]", "[$DIFFS_URL$]", "[$FROM_ADDRESS$]", "[$FROM_NAME$]", "[$NODE_NAME$]", "[$PAGE_CONTENT$]", "[$PAGE_DATE_UPDATE$]", "[$PAGE_DIFFS$]", "[$PAGE_ID$]", "[$PAGE_SUMMARY$]", "[$PAGE_TITLE$]", "[$PAGE_URL$]", "[$PAGE_USER_ADDRESS$]", "[$PAGE_USER_NAME$]", "[$PORTAL_URL$]", "[$PORTLET_NAME$]"}, (String[])new String[]{String.valueOf(company.getCompanyId()), company.getMx(), company.getName(), group.getName(), diffsURL, fromAddress, fromName, node.getName(), pageContent, String.valueOf(page.getModifiedDate()), this.replaceStyles(pageDiffs), String.valueOf(page.getPageId()), page.getSummary(), page.getTitle(), pageURL, user.getEmailAddress(), user.getFullName(), company.getVirtualHost(), portletName});
        String subject = page.getTitle();
        if (subject.indexOf(subjectPrefix) == -1) {
            subject = subjectPrefix + " " + subject;
        }
        Message message = new Message();
        message.put("companyId", (Object)node.getCompanyId());
        message.put("userId", (Object)node.getUserId());
        message.put("nodeId", (Object)node.getNodeId());
        message.put("pageResourcePrimKey", (Object)page.getResourcePrimKey());
        message.put("fromName", (Object)fromName);
        message.put("fromAddress", (Object)fromAddress);
        message.put("subject", (Object)subject);
        message.put("body", (Object)body);
        message.put("replyToAddress", (Object)replyToAddress);
        message.put("mailId", (Object)mailId);
        message.put("htmlFormat", (Object)Boolean.TRUE);
        MessageBusUtil.sendMessage((String)"liferay/wiki", (Message)message);
    }

    protected String replaceStyles(String html) {
        return StringUtil.replace((String)html, (String[])new String[]{"class=\"diff-html-added\"", "class=\"diff-html-removed\"", "class=\"diff-html-changed\"", "changeType=\"diff-added-image\"", "changeType=\"diff-removed-image\"", "changeType=\"diff-changed-image\""}, (String[])new String[]{"style=\"background-color: #CFC;\"", "style=\"background-color: #FDC6C6; text-decoration: line-through;\"", "style=\"border-bottom: 2px dotted blue;\"", "style=\"border: 10px solid #CFC;\"", "style=\"border: 10px solid #FDC6C6;\"", "style=\"border: 10px solid blue;\""});
    }

    protected void validate(long nodeId, String content, String format) throws PortalException {
        if (!WikiUtil.validate(nodeId, content, format)) {
            throw new PageContentException();
        }
    }

    protected void validate(String title, long nodeId, String content, String format) throws PortalException, SystemException {
        if (Validator.isNull((String)title)) {
            throw new PageTitleException();
        }
        if (this.isUsedTitle(nodeId, title)) {
            throw new DuplicatePageException();
        }
        this.validateTitle(title);
        this.validate(nodeId, content, format);
    }
}

