/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.service.impl;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.DiffUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.velocity.VelocityContext;
import com.liferay.portal.kernel.velocity.VelocityEngineUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.ContentUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.base.WikiPageServiceBaseImpl;
import com.liferay.portlet.wiki.service.permission.WikiNodePermission;
import com.liferay.portlet.wiki.service.permission.WikiPagePermission;
import com.liferay.portlet.wiki.util.WikiUtil;
import com.liferay.portlet.wiki.util.comparator.PageCreateDateComparator;
import com.liferay.util.RSSUtil;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.FeedException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiPageServiceImpl
extends WikiPageServiceBaseImpl {
    private static final int _RSS_ABSTRACT_LENGTH = GetterUtil.getInteger((String)PropsUtil.get("wiki.rss.abstract.length"));

    public WikiPage addPage(long nodeId, String title, String content, String summary, boolean minorEdit, ServiceContext serviceContext) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "ADD_PAGE");
        return this.wikiPageLocalService.addPage(this.getUserId(), nodeId, title, content, summary, minorEdit, serviceContext);
    }

    public WikiPage addPage(long nodeId, String title, String content, String summary, boolean minorEdit, String format, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "ADD_PAGE");
        return this.wikiPageLocalService.addPage(null, this.getUserId(), nodeId, title, 1.0, content, summary, minorEdit, format, true, parentTitle, redirectTitle, serviceContext);
    }

    public void addPageAttachments(long nodeId, String title, List<ObjectValuePair<String, byte[]>> files) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "ADD_ATTACHMENT");
        this.wikiPageLocalService.addPageAttachments(nodeId, title, files);
    }

    public void changeParent(long nodeId, String title, String newParentTitle, ServiceContext serviceContext) throws PortalException, SystemException {
        WikiPagePermission.check(this.getPermissionChecker(), nodeId, title, "DELETE");
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "ADD_PAGE");
        this.wikiPageLocalService.changeParent(this.getUserId(), nodeId, title, newParentTitle, serviceContext);
    }

    public void deletePage(long nodeId, String title) throws PortalException, SystemException {
        WikiPagePermission.check(this.getPermissionChecker(), nodeId, title, "DELETE");
        this.wikiPageLocalService.deletePage(nodeId, title);
    }

    public void deletePageAttachment(long nodeId, String title, String fileName) throws PortalException, SystemException {
        WikiPagePermission.check(this.getPermissionChecker(), nodeId, title, "DELETE");
        this.wikiPageLocalService.deletePageAttachment(nodeId, title, fileName);
    }

    public List<WikiPage> getNodePages(long nodeId, int max) throws PortalException, SystemException {
        ArrayList<WikiPage> pages = new ArrayList<WikiPage>();
        int lastIntervalStart = 0;
        boolean listNotExhausted = true;
        while (pages.size() < max && listNotExhausted) {
            List pageList = this.wikiPageLocalService.getPages(nodeId, true, lastIntervalStart, lastIntervalStart + max);
            Iterator itr = pageList.iterator();
            lastIntervalStart += max;
            boolean bl = listNotExhausted = pageList.size() == max;
            while (itr.hasNext() && pages.size() < max) {
                WikiPage page = (WikiPage)itr.next();
                if (!WikiPagePermission.contains(this.getPermissionChecker(), page, "VIEW")) continue;
                pages.add(page);
            }
        }
        return pages;
    }

    public String getNodePagesRSS(long nodeId, int max, String type, double version, String displayStyle, String feedURL, String entryURL) throws PortalException, SystemException {
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "VIEW");
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        long companyId = node.getCompanyId();
        String name = node.getName();
        String description = node.getDescription();
        List<WikiPage> pages = this.getNodePages(nodeId, max);
        boolean diff = false;
        Locale locale = null;
        return this.exportToRSS(companyId, name, description, type, version, displayStyle, feedURL, entryURL, pages, diff, locale);
    }

    public WikiPage getPage(long nodeId, String title) throws PortalException, SystemException {
        WikiPagePermission.check(this.getPermissionChecker(), nodeId, title, "VIEW");
        return this.wikiPageLocalService.getPage(nodeId, title);
    }

    public WikiPage getPage(long nodeId, String title, double version) throws PortalException, SystemException {
        WikiPagePermission.check(this.getPermissionChecker(), nodeId, title, "VIEW");
        return this.wikiPageLocalService.getPage(nodeId, title, version);
    }

    public String getPagesRSS(long companyId, long nodeId, String title, int max, String type, double version, String displayStyle, String feedURL, String entryURL, Locale locale) throws PortalException, SystemException {
        WikiPagePermission.check(this.getPermissionChecker(), nodeId, title, "VIEW");
        String description = title;
        List pages = this.wikiPageLocalService.getPages(nodeId, title, 0, max, (OrderByComparator)new PageCreateDateComparator(true));
        boolean diff = true;
        return this.exportToRSS(companyId, title, description, type, version, displayStyle, feedURL, entryURL, pages, diff, locale);
    }

    public void movePage(long nodeId, String title, String newTitle, ServiceContext serviceContext) throws PortalException, SystemException {
        WikiPagePermission.check(this.getPermissionChecker(), nodeId, title, "DELETE");
        WikiNodePermission.check(this.getPermissionChecker(), nodeId, "ADD_PAGE");
        this.wikiPageLocalService.movePage(this.getUserId(), nodeId, title, newTitle, serviceContext);
    }

    public WikiPage revertPage(long nodeId, String title, double version, ServiceContext serviceContext) throws PortalException, SystemException {
        WikiPagePermission.check(this.getPermissionChecker(), nodeId, title, "UPDATE");
        return this.wikiPageLocalService.revertPage(this.getUserId(), nodeId, title, version, serviceContext);
    }

    public void subscribePage(long nodeId, String title) throws PortalException, SystemException {
        WikiPagePermission.check(this.getPermissionChecker(), nodeId, title, "SUBSCRIBE");
        this.wikiPageLocalService.subscribePage(this.getUserId(), nodeId, title);
    }

    public void unsubscribePage(long nodeId, String title) throws PortalException, SystemException {
        WikiPagePermission.check(this.getPermissionChecker(), nodeId, title, "SUBSCRIBE");
        this.wikiPageLocalService.unsubscribePage(this.getUserId(), nodeId, title);
    }

    public WikiPage updatePage(long nodeId, String title, double version, String content, String summary, boolean minorEdit, String format, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws PortalException, SystemException {
        WikiPagePermission.check(this.getPermissionChecker(), nodeId, title, "UPDATE");
        return this.wikiPageLocalService.updatePage(this.getUserId(), nodeId, title, version, content, summary, minorEdit, format, parentTitle, redirectTitle, serviceContext);
    }

    protected String exportToRSS(long companyId, String name, String description, String type, double version, String displayStyle, String feedURL, String entryURL, List<WikiPage> pages, boolean diff, Locale locale) throws SystemException {
        SyndFeedImpl syndFeed = new SyndFeedImpl();
        syndFeed.setFeedType(RSSUtil.getFeedType((String)type, (double)version));
        syndFeed.setTitle(name);
        syndFeed.setLink(feedURL);
        syndFeed.setDescription(description);
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        syndFeed.setEntries(entries);
        WikiPage latestPage = null;
        for (WikiPage page : pages) {
            String value;
            String author = PortalUtil.getUserName((long)page.getUserId(), (String)page.getUserName());
            String title = page.getTitle() + " " + page.getVersion();
            if (page.isMinorEdit()) {
                title = title + " (" + LanguageUtil.get((Locale)locale, (String)"minor-edit") + ")";
            }
            StringBuilder link = new StringBuilder();
            link.append(entryURL);
            link.append("&");
            link.append(HttpUtil.encodeURL((String)page.getTitle()));
            SyndEntryImpl syndEntry = new SyndEntryImpl();
            syndEntry.setAuthor(author);
            syndEntry.setTitle(title);
            syndEntry.setPublishedDate(page.getCreateDate());
            syndEntry.setUpdatedDate(page.getModifiedDate());
            SyndContentImpl syndContent = new SyndContentImpl();
            syndContent.setType("html");
            if (diff) {
                if (latestPage != null) {
                    link.append("?");
                    link.append(PortalUtil.getPortletNamespace((String)"36"));
                    link.append("version=");
                    link.append(page.getVersion());
                    value = this.getPageDiff(companyId, latestPage, page, locale);
                    syndContent.setValue(value);
                    syndEntry.setDescription((SyndContent)syndContent);
                    entries.add(syndEntry);
                }
            } else {
                value = null;
                value = displayStyle.equals("abstract") ? StringUtil.shorten((String)HtmlUtil.extractText((String)page.getContent()), (int)_RSS_ABSTRACT_LENGTH, (String)"") : (displayStyle.equals("title") ? "" : page.getContent());
                syndContent.setValue(value);
                syndEntry.setDescription((SyndContent)syndContent);
                entries.add(syndEntry);
            }
            syndEntry.setLink(link.toString());
            syndEntry.setUri(syndEntry.getLink());
            latestPage = page;
        }
        try {
            return RSSUtil.export((SyndFeed)syndFeed);
        }
        catch (FeedException fe) {
            throw new SystemException((Throwable)fe);
        }
    }

    protected String getPageDiff(long companyId, WikiPage latestPage, WikiPage page, Locale locale) throws SystemException {
        String sourceContent = WikiUtil.processContent(latestPage.getContent());
        String targetContent = WikiUtil.processContent(page.getContent());
        sourceContent = HtmlUtil.escape((String)sourceContent);
        targetContent = HtmlUtil.escape((String)targetContent);
        List[] diffResults = DiffUtil.diff((Reader)new UnsyncStringReader(sourceContent), (Reader)new UnsyncStringReader(targetContent));
        String velocityTemplateId = "com/liferay/portlet/wiki/dependencies/rss.vm";
        String velocityTemplateContent = ContentUtil.get(velocityTemplateId);
        VelocityContext velocityContext = VelocityEngineUtil.getWrappedStandardToolsContext();
        velocityContext.put("companyId", (Object)companyId);
        velocityContext.put("contextLine", (Object)"#context#line#");
        velocityContext.put("diffUtil", (Object)new DiffUtil());
        velocityContext.put("languageUtil", (Object)LanguageUtil.getLanguage());
        velocityContext.put("locale", (Object)locale);
        velocityContext.put("sourceResults", (Object)diffResults[0]);
        velocityContext.put("targetResults", (Object)diffResults[1]);
        try {
            UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter(true);
            VelocityEngineUtil.mergeTemplate((String)velocityTemplateId, (String)velocityTemplateContent, (VelocityContext)velocityContext, (Writer)unsyncStringWriter);
            return unsyncStringWriter.toString();
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
    }
}

