/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.service.permission;

import com.liferay.portal.PortalException;
import com.liferay.portal.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portlet.wiki.NoSuchPageException;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.service.permission.WikiNodePermission;

public class WikiPagePermission {
    public static void check(PermissionChecker permissionChecker, long resourcePrimKey, String actionId) throws PortalException, SystemException {
        if (!WikiPagePermission.contains(permissionChecker, resourcePrimKey, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long nodeId, String title, String actionId) throws PortalException, SystemException {
        if (!WikiPagePermission.contains(permissionChecker, nodeId, title, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, WikiPage page, String actionId) throws PortalException {
        if (!WikiPagePermission.contains(permissionChecker, page, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long resourcePrimKey, String actionId) throws PortalException, SystemException {
        WikiPage page = WikiPageLocalServiceUtil.getPage((long)resourcePrimKey);
        return WikiPagePermission.contains(permissionChecker, page, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long nodeId, String title, String actionId) throws PortalException, SystemException {
        try {
            WikiPage page = WikiPageLocalServiceUtil.getPage((long)nodeId, (String)title);
            return WikiPagePermission.contains(permissionChecker, page, actionId);
        }
        catch (NoSuchPageException nspe) {
            return WikiNodePermission.contains(permissionChecker, nodeId, "ADD_PAGE");
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, WikiPage page, String actionId) {
        if (permissionChecker.hasOwnerPermission(page.getCompanyId(), WikiPage.class.getName(), page.getPageId(), page.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(page.getGroupId(), WikiPage.class.getName(), page.getResourcePrimKey(), actionId);
    }
}

