/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.service.persistence;

import com.liferay.portal.NoSuchModelException;
import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.annotation.BeanReference;
import com.liferay.portal.kernel.cache.CacheRegistry;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.ModelListener;
import com.liferay.portal.service.persistence.BatchSessionUtil;
import com.liferay.portal.service.persistence.GroupPersistence;
import com.liferay.portal.service.persistence.ResourcePersistence;
import com.liferay.portal.service.persistence.SubscriptionPersistence;
import com.liferay.portal.service.persistence.UserPersistence;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.wiki.NoSuchNodeException;
import com.liferay.portlet.wiki.model.WikiNode;
import com.liferay.portlet.wiki.model.impl.WikiNodeImpl;
import com.liferay.portlet.wiki.model.impl.WikiNodeModelImpl;
import com.liferay.portlet.wiki.service.persistence.WikiNodePersistence;
import com.liferay.portlet.wiki.service.persistence.WikiPagePersistence;
import com.liferay.portlet.wiki.service.persistence.WikiPageResourcePersistence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiNodePersistenceImpl
extends BasePersistenceImpl<WikiNode>
implements WikiNodePersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = WikiNodeImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST = FINDER_CLASS_NAME_ENTITY + ".List";
    public static final FinderPath FINDER_PATH_FIND_BY_UUID = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findByUuid", new String[]{String.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_BY_OBC_UUID = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findByUuid", new String[]{String.class.getName(), "java.lang.Integer", "java.lang.Integer", "com.liferay.portal.kernel.util.OrderByComparator"});
    public static final FinderPath FINDER_PATH_COUNT_BY_UUID = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByUuid", new String[]{String.class.getName()});
    public static final FinderPath FINDER_PATH_FETCH_BY_UUID_G = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_ENTITY, "fetchByUUID_G", new String[]{String.class.getName(), Long.class.getName()});
    public static final FinderPath FINDER_PATH_COUNT_BY_UUID_G = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByUUID_G", new String[]{String.class.getName(), Long.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_BY_GROUPID = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findByGroupId", new String[]{Long.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_BY_OBC_GROUPID = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findByGroupId", new String[]{Long.class.getName(), "java.lang.Integer", "java.lang.Integer", "com.liferay.portal.kernel.util.OrderByComparator"});
    public static final FinderPath FINDER_PATH_COUNT_BY_GROUPID = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByGroupId", new String[]{Long.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_BY_COMPANYID = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findByCompanyId", new String[]{Long.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_BY_OBC_COMPANYID = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findByCompanyId", new String[]{Long.class.getName(), "java.lang.Integer", "java.lang.Integer", "com.liferay.portal.kernel.util.OrderByComparator"});
    public static final FinderPath FINDER_PATH_COUNT_BY_COMPANYID = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByCompanyId", new String[]{Long.class.getName()});
    public static final FinderPath FINDER_PATH_FETCH_BY_G_N = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_ENTITY, "fetchByG_N", new String[]{Long.class.getName(), String.class.getName()});
    public static final FinderPath FINDER_PATH_COUNT_BY_G_N = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countByG_N", new String[]{Long.class.getName(), String.class.getName()});
    public static final FinderPath FINDER_PATH_FIND_ALL = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeModelImpl.FINDER_CACHE_ENABLED, FINDER_CLASS_NAME_LIST, "countAll", new String[0]);
    @BeanReference(name="com.liferay.portlet.wiki.service.persistence.WikiNodePersistence")
    protected WikiNodePersistence wikiNodePersistence;
    @BeanReference(name="com.liferay.portlet.wiki.service.persistence.WikiPagePersistence")
    protected WikiPagePersistence wikiPagePersistence;
    @BeanReference(name="com.liferay.portlet.wiki.service.persistence.WikiPageResourcePersistence")
    protected WikiPageResourcePersistence wikiPageResourcePersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.GroupPersistence")
    protected GroupPersistence groupPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.ResourcePersistence")
    protected ResourcePersistence resourcePersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.SubscriptionPersistence")
    protected SubscriptionPersistence subscriptionPersistence;
    @BeanReference(name="com.liferay.portal.service.persistence.UserPersistence")
    protected UserPersistence userPersistence;
    private static final String _SQL_SELECT_WIKINODE = "SELECT wikiNode FROM WikiNode wikiNode";
    private static final String _SQL_SELECT_WIKINODE_WHERE = "SELECT wikiNode FROM WikiNode wikiNode WHERE ";
    private static final String _SQL_COUNT_WIKINODE = "SELECT COUNT(wikiNode) FROM WikiNode wikiNode";
    private static final String _SQL_COUNT_WIKINODE_WHERE = "SELECT COUNT(wikiNode) FROM WikiNode wikiNode WHERE ";
    private static final String _FINDER_COLUMN_UUID_UUID_1 = "wikiNode.uuid IS NULL";
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "wikiNode.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(wikiNode.uuid IS NULL OR wikiNode.uuid = ?)";
    private static final String _FINDER_COLUMN_UUID_G_UUID_1 = "wikiNode.uuid IS NULL AND ";
    private static final String _FINDER_COLUMN_UUID_G_UUID_2 = "wikiNode.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_G_UUID_3 = "(wikiNode.uuid IS NULL OR wikiNode.uuid = ?) AND ";
    private static final String _FINDER_COLUMN_UUID_G_GROUPID_2 = "wikiNode.groupId = ?";
    private static final String _FINDER_COLUMN_GROUPID_GROUPID_2 = "wikiNode.groupId = ?";
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "wikiNode.companyId = ?";
    private static final String _FINDER_COLUMN_G_N_GROUPID_2 = "wikiNode.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_N_NAME_1 = "wikiNode.name IS NULL";
    private static final String _FINDER_COLUMN_G_N_NAME_2 = "wikiNode.name = ?";
    private static final String _FINDER_COLUMN_G_N_NAME_3 = "(wikiNode.name IS NULL OR wikiNode.name = ?)";
    private static final String _ORDER_BY_ENTITY_ALIAS = "wikiNode.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No WikiNode exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No WikiNode exists with the key {";
    private static Log _log = LogFactoryUtil.getLog(WikiNodePersistenceImpl.class);

    public void cacheResult(WikiNode wikiNode) {
        EntityCacheUtil.putResult((boolean)WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeImpl.class, (Serializable)Long.valueOf(wikiNode.getPrimaryKey()), (Object)wikiNode);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_UUID_G, (Object[])new Object[]{wikiNode.getUuid(), new Long(wikiNode.getGroupId())}, (Object)wikiNode);
        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_G_N, (Object[])new Object[]{new Long(wikiNode.getGroupId()), wikiNode.getName()}, (Object)wikiNode);
    }

    public void cacheResult(List<WikiNode> wikiNodes) {
        for (WikiNode wikiNode : wikiNodes) {
            if (EntityCacheUtil.getResult((boolean)WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeImpl.class, (Serializable)Long.valueOf(wikiNode.getPrimaryKey()), (SessionFactory)this) != null) continue;
            this.cacheResult(wikiNode);
        }
    }

    public void clearCache() {
        CacheRegistry.clear((String)WikiNodeImpl.class.getName());
        EntityCacheUtil.clearCache((String)WikiNodeImpl.class.getName());
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
    }

    public WikiNode create(long nodeId) {
        WikiNodeImpl wikiNode = new WikiNodeImpl();
        wikiNode.setNew(true);
        wikiNode.setPrimaryKey(nodeId);
        String uuid = PortalUUIDUtil.generate();
        wikiNode.setUuid(uuid);
        return wikiNode;
    }

    public WikiNode remove(Serializable primaryKey) throws NoSuchModelException, SystemException {
        return this.remove((Long)primaryKey);
    }

    public WikiNode remove(long nodeId) throws NoSuchNodeException, SystemException {
        Session session = null;
        try {
            session = this.openSession();
            WikiNode wikiNode = (WikiNode)session.get(WikiNodeImpl.class, (Serializable)new Long(nodeId));
            if (wikiNode == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + nodeId));
                }
                throw new NoSuchNodeException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + nodeId);
            }
            WikiNode wikiNode2 = this.remove(wikiNode);
            return wikiNode2;
        }
        catch (NoSuchNodeException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public WikiNode remove(WikiNode wikiNode) throws SystemException {
        for (ModelListener listener : this.listeners) {
            listener.onBeforeRemove((Object)wikiNode);
        }
        wikiNode = this.removeImpl(wikiNode);
        for (ModelListener listener : this.listeners) {
            listener.onAfterRemove((Object)wikiNode);
        }
        return wikiNode;
    }

    protected WikiNode removeImpl(WikiNode wikiNode) throws SystemException {
        wikiNode = this.toUnwrappedModel(wikiNode);
        Session session = null;
        try {
            Object staleObject;
            session = this.openSession();
            if ((wikiNode.isCachedModel() || BatchSessionUtil.isEnabled()) && (staleObject = session.get(WikiNodeImpl.class, wikiNode.getPrimaryKeyObj())) != null) {
                session.evict(staleObject);
            }
            session.delete((Object)wikiNode);
            session.flush();
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
        WikiNodeModelImpl wikiNodeModelImpl = (WikiNodeModelImpl)wikiNode;
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_UUID_G, (Object[])new Object[]{wikiNodeModelImpl.getOriginalUuid(), new Long(wikiNodeModelImpl.getOriginalGroupId())});
        FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_G_N, (Object[])new Object[]{new Long(wikiNodeModelImpl.getOriginalGroupId()), wikiNodeModelImpl.getOriginalName()});
        EntityCacheUtil.removeResult((boolean)WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeImpl.class, (Serializable)Long.valueOf(wikiNode.getPrimaryKey()));
        return wikiNode;
    }

    public WikiNode update(WikiNode wikiNode) throws SystemException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Using the deprecated update(WikiNode wikiNode) method. Use update(WikiNode wikiNode, boolean merge) instead.");
        }
        return (WikiNode)this.update((BaseModel)wikiNode, false);
    }

    public WikiNode updateImpl(WikiNode wikiNode, boolean merge) throws SystemException {
        wikiNode = this.toUnwrappedModel(wikiNode);
        boolean isNew = wikiNode.isNew();
        WikiNodeModelImpl wikiNodeModelImpl = (WikiNodeModelImpl)wikiNode;
        if (Validator.isNull((String)wikiNode.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            wikiNode.setUuid(uuid);
        }
        Session session = null;
        try {
            session = this.openSession();
            BatchSessionUtil.update((Session)session, (BaseModel)wikiNode, (boolean)merge);
            wikiNode.setNew(false);
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache((String)FINDER_CLASS_NAME_LIST);
        EntityCacheUtil.putResult((boolean)WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeImpl.class, (Serializable)Long.valueOf(wikiNode.getPrimaryKey()), (Object)wikiNode);
        if (!(isNew || Validator.equals((Object)wikiNode.getUuid(), (Object)wikiNodeModelImpl.getOriginalUuid()) && wikiNode.getGroupId() == wikiNodeModelImpl.getOriginalGroupId())) {
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_UUID_G, (Object[])new Object[]{wikiNodeModelImpl.getOriginalUuid(), new Long(wikiNodeModelImpl.getOriginalGroupId())});
        }
        if (isNew || !Validator.equals((Object)wikiNode.getUuid(), (Object)wikiNodeModelImpl.getOriginalUuid()) || wikiNode.getGroupId() != wikiNodeModelImpl.getOriginalGroupId()) {
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_UUID_G, (Object[])new Object[]{wikiNode.getUuid(), new Long(wikiNode.getGroupId())}, (Object)wikiNode);
        }
        if (!(isNew || wikiNode.getGroupId() == wikiNodeModelImpl.getOriginalGroupId() && Validator.equals((Object)wikiNode.getName(), (Object)wikiNodeModelImpl.getOriginalName()))) {
            FinderCacheUtil.removeResult((FinderPath)FINDER_PATH_FETCH_BY_G_N, (Object[])new Object[]{new Long(wikiNodeModelImpl.getOriginalGroupId()), wikiNodeModelImpl.getOriginalName()});
        }
        if (isNew || wikiNode.getGroupId() != wikiNodeModelImpl.getOriginalGroupId() || !Validator.equals((Object)wikiNode.getName(), (Object)wikiNodeModelImpl.getOriginalName())) {
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_G_N, (Object[])new Object[]{new Long(wikiNode.getGroupId()), wikiNode.getName()}, (Object)wikiNode);
        }
        return wikiNode;
    }

    protected WikiNode toUnwrappedModel(WikiNode wikiNode) {
        if (wikiNode instanceof WikiNodeImpl) {
            return wikiNode;
        }
        WikiNodeImpl wikiNodeImpl = new WikiNodeImpl();
        wikiNodeImpl.setNew(wikiNode.isNew());
        wikiNodeImpl.setPrimaryKey(wikiNode.getPrimaryKey());
        wikiNodeImpl.setUuid(wikiNode.getUuid());
        wikiNodeImpl.setNodeId(wikiNode.getNodeId());
        wikiNodeImpl.setGroupId(wikiNode.getGroupId());
        wikiNodeImpl.setCompanyId(wikiNode.getCompanyId());
        wikiNodeImpl.setUserId(wikiNode.getUserId());
        wikiNodeImpl.setUserName(wikiNode.getUserName());
        wikiNodeImpl.setCreateDate(wikiNode.getCreateDate());
        wikiNodeImpl.setModifiedDate(wikiNode.getModifiedDate());
        wikiNodeImpl.setName(wikiNode.getName());
        wikiNodeImpl.setDescription(wikiNode.getDescription());
        wikiNodeImpl.setLastPostDate(wikiNode.getLastPostDate());
        return wikiNodeImpl;
    }

    public WikiNode findByPrimaryKey(Serializable primaryKey) throws NoSuchModelException, SystemException {
        return this.findByPrimaryKey((Long)primaryKey);
    }

    public WikiNode findByPrimaryKey(long nodeId) throws NoSuchNodeException, SystemException {
        WikiNode wikiNode = this.fetchByPrimaryKey(nodeId);
        if (wikiNode == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + nodeId));
            }
            throw new NoSuchNodeException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + nodeId);
        }
        return wikiNode;
    }

    public WikiNode fetchByPrimaryKey(Serializable primaryKey) throws SystemException {
        return this.fetchByPrimaryKey((Long)primaryKey);
    }

    public WikiNode fetchByPrimaryKey(long nodeId) throws SystemException {
        WikiNode wikiNode = (WikiNode)EntityCacheUtil.getResult((boolean)WikiNodeModelImpl.ENTITY_CACHE_ENABLED, WikiNodeImpl.class, (Serializable)Long.valueOf(nodeId), (SessionFactory)this);
        if (wikiNode == null) {
            Session session = null;
            try {
                session = this.openSession();
                wikiNode = (WikiNode)session.get(WikiNodeImpl.class, (Serializable)new Long(nodeId));
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (wikiNode != null) {
                    this.cacheResult(wikiNode);
                }
                this.closeSession(session);
            }
        }
        return wikiNode;
    }

    public List<WikiNode> findByUuid(String uuid) throws SystemException {
        Object[] finderArgs = new Object[]{uuid};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_UUID, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(3);
                query.append(_SQL_SELECT_WIKINODE_WHERE);
                if (uuid == null) {
                    query.append(_FINDER_COLUMN_UUID_UUID_1);
                } else if (uuid.equals("")) {
                    query.append(_FINDER_COLUMN_UUID_UUID_3);
                } else {
                    query.append(_FINDER_COLUMN_UUID_UUID_2);
                }
                query.append(" ORDER BY wikiNode.name ASC");
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (uuid != null) {
                    qPos.add(uuid);
                }
                if ((list = q.list()) == null) {
                    list = new ArrayList();
                }
                this.cacheResult(list);
            }
            catch (Exception e) {
                try {
                    throw this.processException(e);
                }
                catch (Throwable throwable) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_UUID, (Object[])finderArgs, list);
                    this.closeSession(session);
                    throw throwable;
                }
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_UUID, (Object[])finderArgs, list);
            this.closeSession(session);
        }
        return list;
    }

    public List<WikiNode> findByUuid(String uuid, int start, int end) throws SystemException {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<WikiNode> findByUuid(String uuid, int start, int end, OrderByComparator obc) throws SystemException {
        Object[] finderArgs = new Object[]{uuid, String.valueOf(start), String.valueOf(end), String.valueOf(obc)};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_OBC_UUID, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = null;
                query = obc != null ? new StringBundler(3 + obc.getOrderByFields().length * 3) : new StringBundler(3);
                query.append(_SQL_SELECT_WIKINODE_WHERE);
                if (uuid == null) {
                    query.append(_FINDER_COLUMN_UUID_UUID_1);
                } else if (uuid.equals("")) {
                    query.append(_FINDER_COLUMN_UUID_UUID_3);
                } else {
                    query.append(_FINDER_COLUMN_UUID_UUID_2);
                }
                if (obc != null) {
                    this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, obc);
                } else {
                    query.append(" ORDER BY wikiNode.name ASC");
                }
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (uuid != null) {
                    qPos.add(uuid);
                }
                if ((list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end)) == null) {
                    list = new ArrayList();
                }
                this.cacheResult(list);
            }
            catch (Exception e) {
                try {
                    throw this.processException(e);
                }
                catch (Throwable throwable) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_OBC_UUID, (Object[])finderArgs, list);
                    this.closeSession(session);
                    throw throwable;
                }
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_OBC_UUID, (Object[])finderArgs, list);
            this.closeSession(session);
        }
        return list;
    }

    public WikiNode findByUuid_First(String uuid, OrderByComparator obc) throws NoSuchNodeException, SystemException {
        List<WikiNode> list = this.findByUuid(uuid, 0, 1, obc);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("uuid=");
            msg.append(uuid);
            msg.append("}");
            throw new NoSuchNodeException(msg.toString());
        }
        return list.get(0);
    }

    public WikiNode findByUuid_Last(String uuid, OrderByComparator obc) throws NoSuchNodeException, SystemException {
        int count = this.countByUuid(uuid);
        List<WikiNode> list = this.findByUuid(uuid, count - 1, count, obc);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("uuid=");
            msg.append(uuid);
            msg.append("}");
            throw new NoSuchNodeException(msg.toString());
        }
        return list.get(0);
    }

    public WikiNode[] findByUuid_PrevAndNext(long nodeId, String uuid, OrderByComparator obc) throws NoSuchNodeException, SystemException {
        WikiNode wikiNode = this.findByPrimaryKey(nodeId);
        int count = this.countByUuid(uuid);
        Session session = null;
        try {
            session = this.openSession();
            StringBundler query = null;
            query = obc != null ? new StringBundler(3 + obc.getOrderByFields().length * 3) : new StringBundler(3);
            query.append(_SQL_SELECT_WIKINODE_WHERE);
            if (uuid == null) {
                query.append(_FINDER_COLUMN_UUID_UUID_1);
            } else if (uuid.equals("")) {
                query.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                query.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (obc != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, obc);
            } else {
                query.append(" ORDER BY wikiNode.name ASC");
            }
            String sql = query.toString();
            Query q = session.createQuery(sql);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            if (uuid != null) {
                qPos.add(uuid);
            }
            Comparable[] objArray = QueryUtil.getPrevAndNext((Query)q, (int)count, (OrderByComparator)obc, (Comparable)wikiNode);
            WikiNode[] array = new WikiNodeImpl[]{(WikiNode)objArray[0], (WikiNode)objArray[1], (WikiNode)objArray[2]};
            WikiNode[] wikiNodeArray = array;
            return wikiNodeArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public WikiNode findByUUID_G(String uuid, long groupId) throws NoSuchNodeException, SystemException {
        WikiNode wikiNode = this.fetchByUUID_G(uuid, groupId);
        if (wikiNode == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("uuid=");
            msg.append(uuid);
            msg.append(", groupId=");
            msg.append(groupId);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchNodeException(msg.toString());
        }
        return wikiNode;
    }

    public WikiNode fetchByUUID_G(String uuid, long groupId) throws SystemException {
        return this.fetchByUUID_G(uuid, groupId, true);
    }

    public WikiNode fetchByUUID_G(String uuid, long groupId, boolean retrieveFromCache) throws SystemException {
        Object[] finderArgs = new Object[]{uuid, new Long(groupId)};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_UUID_G, (Object[])finderArgs, (SessionFactory)this);
        }
        if (result == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(4);
                query.append(_SQL_SELECT_WIKINODE_WHERE);
                if (uuid == null) {
                    query.append(_FINDER_COLUMN_UUID_G_UUID_1);
                } else if (uuid.equals("")) {
                    query.append(_FINDER_COLUMN_UUID_G_UUID_3);
                } else {
                    query.append(_FINDER_COLUMN_UUID_G_UUID_2);
                }
                query.append("wikiNode.groupId = ?");
                query.append(" ORDER BY wikiNode.name ASC");
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (uuid != null) {
                    qPos.add(uuid);
                }
                qPos.add(groupId);
                List list = q.list();
                result = list;
                WikiNode wikiNode = null;
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_UUID_G, (Object[])finderArgs, (Object)list);
                } else {
                    wikiNode = (WikiNode)list.get(0);
                    this.cacheResult(wikiNode);
                    if (wikiNode.getUuid() == null || !wikiNode.getUuid().equals(uuid) || wikiNode.getGroupId() != groupId) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_UUID_G, (Object[])finderArgs, (Object)wikiNode);
                    }
                }
                WikiNode wikiNode2 = wikiNode;
                return wikiNode2;
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (result == null) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_UUID_G, (Object[])finderArgs, new ArrayList());
                }
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (WikiNode)result;
    }

    public List<WikiNode> findByGroupId(long groupId) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(groupId)};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_GROUPID, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(3);
                query.append(_SQL_SELECT_WIKINODE_WHERE);
                query.append("wikiNode.groupId = ?");
                query.append(" ORDER BY wikiNode.name ASC");
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                list = q.list();
                if (list == null) {
                    list = new ArrayList();
                }
                this.cacheResult(list);
            }
            catch (Exception e) {
                try {
                    throw this.processException(e);
                }
                catch (Throwable throwable) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_GROUPID, (Object[])finderArgs, list);
                    this.closeSession(session);
                    throw throwable;
                }
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_GROUPID, (Object[])finderArgs, list);
            this.closeSession(session);
        }
        return list;
    }

    public List<WikiNode> findByGroupId(long groupId, int start, int end) throws SystemException {
        return this.findByGroupId(groupId, start, end, null);
    }

    public List<WikiNode> findByGroupId(long groupId, int start, int end, OrderByComparator obc) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(groupId), String.valueOf(start), String.valueOf(end), String.valueOf(obc)};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_OBC_GROUPID, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = null;
                query = obc != null ? new StringBundler(3 + obc.getOrderByFields().length * 3) : new StringBundler(3);
                query.append(_SQL_SELECT_WIKINODE_WHERE);
                query.append("wikiNode.groupId = ?");
                if (obc != null) {
                    this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, obc);
                } else {
                    query.append(" ORDER BY wikiNode.name ASC");
                }
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                if (list == null) {
                    list = new ArrayList();
                }
                this.cacheResult(list);
            }
            catch (Exception e) {
                try {
                    throw this.processException(e);
                }
                catch (Throwable throwable) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_OBC_GROUPID, (Object[])finderArgs, list);
                    this.closeSession(session);
                    throw throwable;
                }
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_OBC_GROUPID, (Object[])finderArgs, list);
            this.closeSession(session);
        }
        return list;
    }

    public WikiNode findByGroupId_First(long groupId, OrderByComparator obc) throws NoSuchNodeException, SystemException {
        List<WikiNode> list = this.findByGroupId(groupId, 0, 1, obc);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append("}");
            throw new NoSuchNodeException(msg.toString());
        }
        return list.get(0);
    }

    public WikiNode findByGroupId_Last(long groupId, OrderByComparator obc) throws NoSuchNodeException, SystemException {
        int count = this.countByGroupId(groupId);
        List<WikiNode> list = this.findByGroupId(groupId, count - 1, count, obc);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append("}");
            throw new NoSuchNodeException(msg.toString());
        }
        return list.get(0);
    }

    public WikiNode[] findByGroupId_PrevAndNext(long nodeId, long groupId, OrderByComparator obc) throws NoSuchNodeException, SystemException {
        WikiNode wikiNode = this.findByPrimaryKey(nodeId);
        int count = this.countByGroupId(groupId);
        Session session = null;
        try {
            session = this.openSession();
            StringBundler query = null;
            query = obc != null ? new StringBundler(3 + obc.getOrderByFields().length * 3) : new StringBundler(3);
            query.append(_SQL_SELECT_WIKINODE_WHERE);
            query.append("wikiNode.groupId = ?");
            if (obc != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, obc);
            } else {
                query.append(" ORDER BY wikiNode.name ASC");
            }
            String sql = query.toString();
            Query q = session.createQuery(sql);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            Comparable[] objArray = QueryUtil.getPrevAndNext((Query)q, (int)count, (OrderByComparator)obc, (Comparable)wikiNode);
            WikiNode[] array = new WikiNodeImpl[]{(WikiNode)objArray[0], (WikiNode)objArray[1], (WikiNode)objArray[2]};
            WikiNode[] wikiNodeArray = array;
            return wikiNodeArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<WikiNode> findByCompanyId(long companyId) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(companyId)};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_COMPANYID, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(3);
                query.append(_SQL_SELECT_WIKINODE_WHERE);
                query.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
                query.append(" ORDER BY wikiNode.name ASC");
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                list = q.list();
                if (list == null) {
                    list = new ArrayList();
                }
                this.cacheResult(list);
            }
            catch (Exception e) {
                try {
                    throw this.processException(e);
                }
                catch (Throwable throwable) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_COMPANYID, (Object[])finderArgs, list);
                    this.closeSession(session);
                    throw throwable;
                }
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_COMPANYID, (Object[])finderArgs, list);
            this.closeSession(session);
        }
        return list;
    }

    public List<WikiNode> findByCompanyId(long companyId, int start, int end) throws SystemException {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<WikiNode> findByCompanyId(long companyId, int start, int end, OrderByComparator obc) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(companyId), String.valueOf(start), String.valueOf(end), String.valueOf(obc)};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_BY_OBC_COMPANYID, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = null;
                query = obc != null ? new StringBundler(3 + obc.getOrderByFields().length * 3) : new StringBundler(3);
                query.append(_SQL_SELECT_WIKINODE_WHERE);
                query.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
                if (obc != null) {
                    this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, obc);
                } else {
                    query.append(" ORDER BY wikiNode.name ASC");
                }
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                if (list == null) {
                    list = new ArrayList();
                }
                this.cacheResult(list);
            }
            catch (Exception e) {
                try {
                    throw this.processException(e);
                }
                catch (Throwable throwable) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_OBC_COMPANYID, (Object[])finderArgs, list);
                    this.closeSession(session);
                    throw throwable;
                }
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_BY_OBC_COMPANYID, (Object[])finderArgs, list);
            this.closeSession(session);
        }
        return list;
    }

    public WikiNode findByCompanyId_First(long companyId, OrderByComparator obc) throws NoSuchNodeException, SystemException {
        List<WikiNode> list = this.findByCompanyId(companyId, 0, 1, obc);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("companyId=");
            msg.append(companyId);
            msg.append("}");
            throw new NoSuchNodeException(msg.toString());
        }
        return list.get(0);
    }

    public WikiNode findByCompanyId_Last(long companyId, OrderByComparator obc) throws NoSuchNodeException, SystemException {
        int count = this.countByCompanyId(companyId);
        List<WikiNode> list = this.findByCompanyId(companyId, count - 1, count, obc);
        if (list.isEmpty()) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("companyId=");
            msg.append(companyId);
            msg.append("}");
            throw new NoSuchNodeException(msg.toString());
        }
        return list.get(0);
    }

    public WikiNode[] findByCompanyId_PrevAndNext(long nodeId, long companyId, OrderByComparator obc) throws NoSuchNodeException, SystemException {
        WikiNode wikiNode = this.findByPrimaryKey(nodeId);
        int count = this.countByCompanyId(companyId);
        Session session = null;
        try {
            session = this.openSession();
            StringBundler query = null;
            query = obc != null ? new StringBundler(3 + obc.getOrderByFields().length * 3) : new StringBundler(3);
            query.append(_SQL_SELECT_WIKINODE_WHERE);
            query.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            if (obc != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, obc);
            } else {
                query.append(" ORDER BY wikiNode.name ASC");
            }
            String sql = query.toString();
            Query q = session.createQuery(sql);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(companyId);
            Comparable[] objArray = QueryUtil.getPrevAndNext((Query)q, (int)count, (OrderByComparator)obc, (Comparable)wikiNode);
            WikiNode[] array = new WikiNodeImpl[]{(WikiNode)objArray[0], (WikiNode)objArray[1], (WikiNode)objArray[2]};
            WikiNode[] wikiNodeArray = array;
            return wikiNodeArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public WikiNode findByG_N(long groupId, String name) throws NoSuchNodeException, SystemException {
        WikiNode wikiNode = this.fetchByG_N(groupId, name);
        if (wikiNode == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append(", name=");
            msg.append(name);
            msg.append("}");
            if (_log.isWarnEnabled()) {
                _log.warn((Object)msg.toString());
            }
            throw new NoSuchNodeException(msg.toString());
        }
        return wikiNode;
    }

    public WikiNode fetchByG_N(long groupId, String name) throws SystemException {
        return this.fetchByG_N(groupId, name, true);
    }

    public WikiNode fetchByG_N(long groupId, String name, boolean retrieveFromCache) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(groupId), name};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FETCH_BY_G_N, (Object[])finderArgs, (SessionFactory)this);
        }
        if (result == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(4);
                query.append(_SQL_SELECT_WIKINODE_WHERE);
                query.append(_FINDER_COLUMN_G_N_GROUPID_2);
                if (name == null) {
                    query.append(_FINDER_COLUMN_G_N_NAME_1);
                } else if (name.equals("")) {
                    query.append(_FINDER_COLUMN_G_N_NAME_3);
                } else {
                    query.append(_FINDER_COLUMN_G_N_NAME_2);
                }
                query.append(" ORDER BY wikiNode.name ASC");
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                if (name != null) {
                    qPos.add(name);
                }
                List list = q.list();
                result = list;
                WikiNode wikiNode = null;
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_G_N, (Object[])finderArgs, (Object)list);
                } else {
                    wikiNode = (WikiNode)list.get(0);
                    this.cacheResult(wikiNode);
                    if (wikiNode.getGroupId() != groupId || wikiNode.getName() == null || !wikiNode.getName().equals(name)) {
                        FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_G_N, (Object[])finderArgs, (Object)wikiNode);
                    }
                }
                WikiNode wikiNode2 = wikiNode;
                return wikiNode2;
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (result == null) {
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FETCH_BY_G_N, (Object[])finderArgs, new ArrayList());
                }
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (WikiNode)result;
    }

    public List<Object> findWithDynamicQuery(DynamicQuery dynamicQuery) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            dynamicQuery.compile(session);
            List list = dynamicQuery.list();
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Object> findWithDynamicQuery(DynamicQuery dynamicQuery, int start, int end) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            dynamicQuery.setLimit(start, end);
            dynamicQuery.compile(session);
            List list = dynamicQuery.list();
            return list;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<WikiNode> findAll() throws SystemException {
        return this.findAll(-1, -1, null);
    }

    public List<WikiNode> findAll(int start, int end) throws SystemException {
        return this.findAll(start, end, null);
    }

    public List<WikiNode> findAll(int start, int end, OrderByComparator obc) throws SystemException {
        Object[] finderArgs = new Object[]{String.valueOf(start), String.valueOf(end), String.valueOf(obc)};
        List list = (ArrayList)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs, (SessionFactory)this);
        if (list == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = null;
                String sql = null;
                if (obc != null) {
                    query = new StringBundler(2 + obc.getOrderByFields().length * 3);
                    query.append(_SQL_SELECT_WIKINODE);
                    this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, obc);
                    sql = query.toString();
                } else {
                    sql = _SQL_SELECT_WIKINODE.concat(" ORDER BY wikiNode.name ASC");
                }
                Query q = session.createQuery(sql);
                if (obc == null) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                if (list == null) {
                    list = new ArrayList();
                }
                this.cacheResult(list);
            }
            catch (Exception e) {
                try {
                    throw this.processException(e);
                }
                catch (Throwable throwable) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    this.cacheResult(list);
                    FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs, list);
                    this.closeSession(session);
                    throw throwable;
                }
            }
            FinderCacheUtil.putResult((FinderPath)FINDER_PATH_FIND_ALL, (Object[])finderArgs, list);
            this.closeSession(session);
        }
        return list;
    }

    public void removeByUuid(String uuid) throws SystemException {
        for (WikiNode wikiNode : this.findByUuid(uuid)) {
            this.remove(wikiNode);
        }
    }

    public void removeByUUID_G(String uuid, long groupId) throws NoSuchNodeException, SystemException {
        WikiNode wikiNode = this.findByUUID_G(uuid, groupId);
        this.remove(wikiNode);
    }

    public void removeByGroupId(long groupId) throws SystemException {
        for (WikiNode wikiNode : this.findByGroupId(groupId)) {
            this.remove(wikiNode);
        }
    }

    public void removeByCompanyId(long companyId) throws SystemException {
        for (WikiNode wikiNode : this.findByCompanyId(companyId)) {
            this.remove(wikiNode);
        }
    }

    public void removeByG_N(long groupId, String name) throws NoSuchNodeException, SystemException {
        WikiNode wikiNode = this.findByG_N(groupId, name);
        this.remove(wikiNode);
    }

    public void removeAll() throws SystemException {
        for (WikiNode wikiNode : this.findAll()) {
            this.remove(wikiNode);
        }
    }

    public int countByUuid(String uuid) throws SystemException {
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_UUID, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(2);
                query.append(_SQL_COUNT_WIKINODE_WHERE);
                if (uuid == null) {
                    query.append(_FINDER_COLUMN_UUID_UUID_1);
                } else if (uuid.equals("")) {
                    query.append(_FINDER_COLUMN_UUID_UUID_3);
                } else {
                    query.append(_FINDER_COLUMN_UUID_UUID_2);
                }
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (uuid != null) {
                    qPos.add(uuid);
                }
                count = (Long)q.uniqueResult();
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_UUID, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByUUID_G(String uuid, long groupId) throws SystemException {
        Object[] finderArgs = new Object[]{uuid, new Long(groupId)};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_UUID_G, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(3);
                query.append(_SQL_COUNT_WIKINODE_WHERE);
                if (uuid == null) {
                    query.append(_FINDER_COLUMN_UUID_G_UUID_1);
                } else if (uuid.equals("")) {
                    query.append(_FINDER_COLUMN_UUID_G_UUID_3);
                } else {
                    query.append(_FINDER_COLUMN_UUID_G_UUID_2);
                }
                query.append("wikiNode.groupId = ?");
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (uuid != null) {
                    qPos.add(uuid);
                }
                qPos.add(groupId);
                count = (Long)q.uniqueResult();
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_UUID_G, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByGroupId(long groupId) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(groupId)};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_GROUPID, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(2);
                query.append(_SQL_COUNT_WIKINODE_WHERE);
                query.append("wikiNode.groupId = ?");
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                count = (Long)q.uniqueResult();
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_GROUPID, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByCompanyId(long companyId) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(companyId)};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_COMPANYID, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(2);
                query.append(_SQL_COUNT_WIKINODE_WHERE);
                query.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(companyId);
                count = (Long)q.uniqueResult();
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_COMPANYID, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countByG_N(long groupId, String name) throws SystemException {
        Object[] finderArgs = new Object[]{new Long(groupId), name};
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_BY_G_N, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                StringBundler query = new StringBundler(3);
                query.append(_SQL_COUNT_WIKINODE_WHERE);
                query.append(_FINDER_COLUMN_G_N_GROUPID_2);
                if (name == null) {
                    query.append(_FINDER_COLUMN_G_N_NAME_1);
                } else if (name.equals("")) {
                    query.append(_FINDER_COLUMN_G_N_NAME_3);
                } else {
                    query.append(_FINDER_COLUMN_G_N_NAME_2);
                }
                String sql = query.toString();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                if (name != null) {
                    qPos.add(name);
                }
                count = (Long)q.uniqueResult();
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_BY_G_N, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int countAll() throws SystemException {
        Object[] finderArgs = new Object[0];
        Long count = (Long)FinderCacheUtil.getResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])finderArgs, (SessionFactory)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_WIKINODE);
                count = (Long)q.uniqueResult();
            }
            catch (Exception e) {
                throw this.processException(e);
            }
            finally {
                if (count == null) {
                    count = 0L;
                }
                FinderCacheUtil.putResult((FinderPath)FINDER_PATH_COUNT_ALL, (Object[])finderArgs, (Object)count);
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public void afterPropertiesSet() {
        String[] listenerClassNames = StringUtil.split((String)GetterUtil.getString((String)PropsUtil.get("value.object.listener.com.liferay.portlet.wiki.model.WikiNode")));
        if (listenerClassNames.length > 0) {
            try {
                ArrayList<ModelListener> listenersList = new ArrayList<ModelListener>();
                for (String listenerClassName : listenerClassNames) {
                    listenersList.add((ModelListener)Class.forName(listenerClassName).newInstance());
                }
                this.listeners = listenersList.toArray(new ModelListener[listenersList.size()]);
            }
            catch (Exception e) {
                _log.error((Throwable)e);
            }
        }
    }
}

