/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.service.persistence;

import com.liferay.portal.SystemException;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portlet.wiki.NoSuchPageException;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.model.impl.WikiPageImpl;
import com.liferay.portlet.wiki.service.persistence.WikiPageFinder;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiPageFinderImpl
extends BasePersistenceImpl<WikiPage>
implements WikiPageFinder {
    public static String COUNT_BY_CREATE_DATE = WikiPageFinder.class.getName() + ".countByCreateDate";
    public static String FIND_BY_RESOURCE_PRIM_KEY = WikiPageFinder.class.getName() + ".findByResourcePrimKey";
    public static String FIND_BY_CREATE_DATE = WikiPageFinder.class.getName() + ".findByCreateDate";
    public static String FIND_BY_NO_ASSETS = WikiPageFinder.class.getName() + ".findByNoAssets";

    public int countByCreateDate(long nodeId, Date createDate, boolean before) throws SystemException {
        return this.countByCreateDate(nodeId, new Timestamp(createDate.getTime()), before);
    }

    public int countByCreateDate(long nodeId, Timestamp createDate, boolean before) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String createDateComparator = ">";
            if (before) {
                createDateComparator = "<";
            }
            String sql = CustomSQLUtil.get((String)COUNT_BY_CREATE_DATE);
            sql = StringUtil.replace((String)sql, (String)"[$CREATE_DATE_COMPARATOR$]", (String)createDateComparator);
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(nodeId);
            qPos.add(createDate);
            qPos.add(true);
            Iterator itr = q.list().iterator();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public WikiPage findByResourcePrimKey(long resourcePrimKey) throws NoSuchPageException, SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_RESOURCE_PRIM_KEY);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("WikiPage", WikiPageImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(resourcePrimKey);
            List list = q.list();
            if (list.size() == 0) {
                StringBuilder sb = new StringBuilder();
                sb.append("No WikiPage exists with the key {resourcePrimKey");
                sb.append(resourcePrimKey);
                sb.append("}");
                throw new NoSuchPageException(sb.toString());
            }
            WikiPage wikiPage = (WikiPage)list.get(0);
            return wikiPage;
        }
        catch (NoSuchPageException nspe) {
            throw nspe;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<WikiPage> findByCreateDate(long nodeId, Date createDate, boolean before, int start, int end) throws SystemException {
        return this.findByCreateDate(nodeId, new Timestamp(createDate.getTime()), before, start, end);
    }

    public List<WikiPage> findByCreateDate(long nodeId, Timestamp createDate, boolean before, int start, int end) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String createDateComparator = ">";
            if (before) {
                createDateComparator = "<";
            }
            String sql = CustomSQLUtil.get((String)FIND_BY_CREATE_DATE);
            sql = StringUtil.replace((String)sql, (String)"[$CREATE_DATE_COMPARATOR$]", (String)createDateComparator);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("WikiPage", WikiPageImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(nodeId);
            qPos.add(createDate);
            qPos.add(true);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<WikiPage> findByNoAssets() throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_BY_NO_ASSETS);
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("WikiPage", WikiPageImpl.class);
            List list = q.list();
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }
}

