/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.util;

import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.BooleanQueryFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentImpl;
import com.liferay.portal.kernel.search.DocumentSummary;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Group;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeIndexerUtil;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.service.WikiNodeLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import java.util.Date;
import javax.portlet.PortletURL;

public class Indexer
implements com.liferay.portal.kernel.search.Indexer {
    public static final String PORTLET_ID = "36";
    private static final String[] _CLASS_NAMES = new String[]{WikiPage.class.getName()};

    public static void addPage(long companyId, long groupId, long resourcePrimKey, long nodeId, String title, String content, Date modifiedDate, String[] tagsCategories, String[] tagsEntries, ExpandoBridge expandoBridge) throws SearchException {
        try {
            Indexer.deletePage(companyId, nodeId, title);
        }
        catch (SearchException se) {
            // empty catch block
        }
        Document doc = Indexer.getPageDocument(companyId, groupId, resourcePrimKey, nodeId, title, content, modifiedDate, tagsCategories, tagsEntries, expandoBridge);
        SearchEngineUtil.addDocument((long)companyId, (Document)doc);
    }

    public static void deletePage(long companyId, long nodeId, String title) throws SearchException {
        SearchEngineUtil.deleteDocument((long)companyId, (String)Indexer.getPageUID(nodeId, title));
    }

    public static void deletePages(long companyId, long nodeId) throws SearchException {
        BooleanQuery booleanQuery = BooleanQueryFactoryUtil.create();
        booleanQuery.addRequiredTerm("portletId", PORTLET_ID);
        booleanQuery.addRequiredTerm("nodeId", nodeId);
        Hits hits = SearchEngineUtil.search((long)companyId, (Query)booleanQuery, (int)-1, (int)-1);
        for (int i = 0; i < hits.getLength(); ++i) {
            Document doc = hits.doc(i);
            SearchEngineUtil.deleteDocument((long)companyId, (String)doc.get("uid"));
        }
    }

    public static Document getPageDocument(long companyId, long groupId, long resourcePrimKey, long nodeId, String title, String content, Date modifiedDate, String[] tagsCategories, String[] tagsEntries, ExpandoBridge expandoBridge) {
        long scopeGroupId = groupId;
        try {
            Group group = GroupLocalServiceUtil.getGroup((long)groupId);
            if (group.isLayout()) {
                groupId = group.getParentGroupId();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        content = HtmlUtil.extractText((String)content);
        DocumentImpl doc = new DocumentImpl();
        doc.addUID(PORTLET_ID, nodeId, title);
        doc.addModifiedDate(modifiedDate);
        doc.addKeyword("companyId", companyId);
        doc.addKeyword("portletId", PORTLET_ID);
        doc.addKeyword("groupId", groupId);
        doc.addKeyword("scopeGroupId", scopeGroupId);
        doc.addText("title", title);
        doc.addText("content", content);
        doc.addKeyword("tagsCategories", tagsCategories);
        doc.addKeyword("tagsEntries", tagsEntries);
        doc.addKeyword("entryClassName", WikiPage.class.getName());
        doc.addKeyword("entryClassPK", resourcePrimKey);
        doc.addKeyword("nodeId", nodeId);
        ExpandoBridgeIndexerUtil.addAttributes((Document)doc, (ExpandoBridge)expandoBridge);
        return doc;
    }

    public static String getPageUID(long nodeId, String title) {
        DocumentImpl doc = new DocumentImpl();
        doc.addUID(PORTLET_ID, nodeId, title);
        return doc.get("uid");
    }

    public static void updatePage(long companyId, long groupId, long resourcePrimKey, long nodeId, String title, String content, Date modifiedDate, String[] tagsCategories, String[] tagsEntries, ExpandoBridge expandoBridge) throws SearchException {
        Document doc = Indexer.getPageDocument(companyId, groupId, resourcePrimKey, nodeId, title, content, modifiedDate, tagsCategories, tagsEntries, expandoBridge);
        SearchEngineUtil.updateDocument((long)companyId, (String)doc.get("uid"), (Document)doc);
    }

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    public DocumentSummary getDocumentSummary(Document doc, String snippet, PortletURL portletURL) {
        String title = doc.get("title");
        String content = snippet;
        if (Validator.isNull((String)snippet)) {
            content = StringUtil.shorten((String)doc.get("content"), (int)200);
        }
        String nodeId = doc.get("nodeId");
        portletURL.setParameter("struts_action", "/wiki/view");
        portletURL.setParameter("nodeId", nodeId);
        portletURL.setParameter("title", title);
        return new DocumentSummary(title, content, portletURL);
    }

    public void reIndex(String className, long classPK) throws SearchException {
        try {
            WikiPageLocalServiceUtil.reIndex((long)classPK);
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }

    public void reIndex(String[] ids) throws SearchException {
        try {
            WikiNodeLocalServiceUtil.reIndex((String[])ids);
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }
}

