/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.words.util;

import com.liferay.portlet.words.ScramblerException;
import com.liferay.portlet.words.util.comparator.WordComparator;
import java.util.Set;
import java.util.TreeSet;

public class Scrambler {
    private String _word;
    private Set<String> _words;

    public Scrambler(String word) throws ScramblerException {
        if (word == null || word.length() < 3) {
            throw new ScramblerException();
        }
        this._word = word;
        this._words = new TreeSet<String>(new WordComparator());
    }

    public String[] scramble() {
        if (this._word == null) {
            return new String[0];
        }
        this._scramble(0, this._word.length(), this._word.toCharArray());
        return this._words.toArray(new String[this._words.size()]);
    }

    private void _rotate(char[] charArray, int start) {
        char temp = charArray[start];
        for (int i = charArray.length - start - 1; i > 0; --i) {
            charArray[start++] = charArray[start];
        }
        charArray[start] = temp;
    }

    private void _scramble(int start, int length, char[] charArray) {
        if (length == 0) {
            String word = new String(charArray);
            for (int i = 3; i <= charArray.length; ++i) {
                this._words.add(word.substring(0, i));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                this._scramble(start + 1, length - 1, charArray);
                this._rotate(charArray, start);
            }
        }
    }
}

