drop table ActivityTracker;

create table AnnouncementsDelivery (
	deliveryId bigint not null primary key,
	companyId bigint,
	userId bigint,
	type_ nvarchar(75) null,
	email bit,
	sms bit,
	website bit
);

create table AnnouncementsEntry (
	uuid_ nvarchar(75) null,
	entryId bigint not null primary key,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime null,
	modifiedDate datetime null,
	classNameId bigint,
	classPK bigint,
	title nvarchar(75) null,
	content nvarchar(2000) null,
	url nvarchar(2000) null,
	type_ nvarchar(75) null,
	displayDate datetime null,
	expirationDate datetime null,
	priority int,
	alert bit
);

create table AnnouncementsFlag (
	flagId bigint not null primary key,
	userId bigint,
	createDate datetime null,
	entryId bigint,
	value int
);

create table ExpandoColumn (
	columnId bigint not null primary key,
	tableId bigint,
	name nvarchar(75) null,
	type_ int
);

create table ExpandoRow (
	rowId_ bigint not null primary key,
	tableId bigint,
	classPK bigint
);

create table ExpandoTable (
	tableId bigint not null primary key,
	classNameId bigint,
	name nvarchar(75) null
);

create table ExpandoValue (
	valueId bigint not null primary key,
	tableId bigint,
	columnId bigint,
	rowId_ bigint,
	classNameId bigint,
	classPK bigint,
	data_ nvarchar(75) null
);

alter table IGImage add name nvarchar(75) null;
alter table IGImage add custom1ImageId bigint null;
alter table IGImage add custom2ImageId bigint null;

update Group_ set type_ = 3 where type_ = 0;

update Image set type_ = 'jpg' where type_ = 'jpeg';

create table PortletItem (
	portletItemId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime null,
	modifiedDate datetime null,
	name nvarchar(75) null,
	portletId nvarchar(75) null,
	classNameId bigint
);

create table SocialActivity (
	activityId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	createDate datetime null,
	classNameId bigint,
	classPK bigint,
	type_ nvarchar(75) null,
	extraData ntext null,
	receiverUserId bigint
);

create table SocialRelation (
	uuid_ nvarchar(75) null,
	relationId bigint not null primary key,
	companyId bigint,
	createDate datetime null,
	userId1 bigint,
	userId2 bigint,
	type_ int
);

create table TasksProposal (
	proposalId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime null,
	modifiedDate datetime null,
	classNameId bigint,
	classPK nvarchar(75) null,
	name nvarchar(75) null,
	description nvarchar(2000) null,
	publishDate datetime null,
	dueDate datetime null
);

create table TasksReview (
	reviewId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime null,
	modifiedDate datetime null,
	proposalId bigint,
	assignedByUserId bigint,
	assignedByUserName nvarchar(75) null,
	stage int,
	completed bit,
	rejected bit
);

alter table WikiPage add parentTitle nvarchar(75) null;
alter table WikiPage add redirectTitle nvarchar(75) null;
