/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.registry;

import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceRankingUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class ServiceTrackerFieldUpdaterCustomizer<S, T>
implements ServiceTrackerCustomizer<S, T> {
    private final T _dummyTrackedService;
    private final Field _serviceField;
    private final Reference<?> _serviceHolderReference;
    private final Map<ServiceReference<S>, T> _trackedServices = new ConcurrentHashMap<ServiceReference<S>, T>();

    public ServiceTrackerFieldUpdaterCustomizer(Field serviceField, Object serviceHolder, T dummyTrackedService) {
        if (!Modifier.isVolatile(serviceField.getModifiers())) {
            throw new IllegalArgumentException(serviceField + " is not volatile");
        }
        this._serviceField = serviceField;
        this._serviceHolderReference = serviceHolder == null ? null : new WeakReference<Object>(serviceHolder);
        this._dummyTrackedService = dummyTrackedService;
    }

    @Override
    public final T addingService(ServiceReference<S> serviceReference) {
        T trackedService = this.doAddingService(serviceReference);
        if (trackedService != null) {
            this._trackedServices.put(serviceReference, trackedService);
            this._updateService();
        }
        return trackedService;
    }

    @Override
    public final void modifiedService(ServiceReference<S> serviceReference, T service) {
        this.doModifiedService(serviceReference, service);
        this._updateService();
    }

    @Override
    public final void removedService(ServiceReference<S> serviceReference, T service) {
        if (this._trackedServices.remove(serviceReference, service)) {
            this._updateService();
        }
        this.doRemovedService(serviceReference, service);
    }

    protected void afterServiceUpdate(T oldService, T newService) {
    }

    protected void beforeServiceUpdate(T oldService, T newService) {
    }

    protected T doAddingService(ServiceReference<S> serviceReference) {
        Registry registry = RegistryUtil.getRegistry();
        return (T)registry.getService(serviceReference);
    }

    protected void doModifiedService(ServiceReference<S> serviceReference, T service) {
    }

    protected void doRemovedService(ServiceReference<S> serviceReference, T service) {
        Registry registry = RegistryUtil.getRegistry();
        registry.ungetService(serviceReference);
    }

    protected void doServiceUpdate(T newService) {
        Object serviceHolder = null;
        if (this._serviceHolderReference != null && (serviceHolder = this._serviceHolderReference.get()) == null) {
            return;
        }
        try {
            Object oldService = this._serviceField.get(serviceHolder);
            if (newService != oldService) {
                this.beforeServiceUpdate(oldService, newService);
                this._serviceField.set(serviceHolder, newService);
                this.afterServiceUpdate(oldService, newService);
            }
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    private void _updateService() {
        Optional<Map.Entry<ServiceReference<S>, Map.Entry>> optionalEntry = ServiceRankingUtil.getHighestRankingEntry(this._trackedServices);
        Optional<Object> optionalService = optionalEntry.map(Map.Entry::getValue);
        this.doServiceUpdate(optionalService.orElse(this._dummyTrackedService));
    }
}

