/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.registry.dependency;

import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.dependency.ServiceDependencyVerifier;

public class ClassServiceDependencyVerifier
implements ServiceDependencyVerifier {
    private final Class<?> _clazz;

    public ClassServiceDependencyVerifier(Class<?> clazz) {
        this._clazz = clazz;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this._clazz.equals(object);
    }

    public int hashCode() {
        return this._clazz.hashCode();
    }

    public String toString() {
        return this._clazz.getName();
    }

    @Override
    public boolean verify(ServiceReference<?> serviceReference) {
        Class<?>[] interfaceClasses;
        Registry registry = RegistryUtil.getRegistry();
        Object service = registry.getService(serviceReference);
        Class<?> serviceClass = service.getClass();
        if (serviceClass.equals(this._clazz)) {
            return true;
        }
        for (Class<?> interfaceClass : interfaceClasses = serviceClass.getInterfaces()) {
            if (!interfaceClass.equals(this._clazz)) continue;
            return true;
        }
        return false;
    }
}

