/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.types.Type;

public class ColumnBase {
    private String name;
    private String table;
    private String schema;
    private String catalog;
    private boolean isWriteable;
    private boolean isSearchable;
    protected byte parameterMode;
    protected boolean isIdentity;
    protected byte nullability = 1;
    protected Type dataType;

    ColumnBase() {
    }

    public ColumnBase(String catalog, String schema, String table, String name) {
        this.catalog = catalog;
        this.schema = schema;
        this.table = table;
        this.name = name;
    }

    public ColumnBase(String catalog, ColumnSchema other) {
        this.catalog = catalog;
        this.schema = other.getSchemaNameString();
        this.table = other.getTableNameString();
        this.name = other.getNameString();
        this.nullability = other.getNullability();
        this.isIdentity = other.isIdentity();
        this.isSearchable = other.isSearchable();
        this.isWriteable = other.isWriteable();
    }

    public String getNameString() {
        return this.name;
    }

    public String getTableNameString() {
        return this.table;
    }

    public String getSchemaNameString() {
        return this.schema;
    }

    public String getCatalogNameString() {
        return this.catalog;
    }

    public void setIdentity(boolean value) {
        this.isIdentity = value;
    }

    public boolean isIdentity() {
        return this.isIdentity;
    }

    protected void setType(ColumnBase other) {
        this.nullability = other.nullability;
        this.dataType = other.dataType;
    }

    public void setType(Type type) {
        this.dataType = type;
    }

    public boolean isNullable() {
        return !this.isIdentity && this.nullability == 1;
    }

    protected void setNullable(boolean value) {
        this.nullability = value ? (byte)1 : 0;
    }

    public byte getNullability() {
        return this.isIdentity ? (byte)0 : this.nullability;
    }

    public void setNullability(byte value) {
        this.nullability = value;
    }

    public boolean isWriteable() {
        return this.isWriteable;
    }

    public void setWriteable(boolean value) {
        this.isWriteable = value;
    }

    public boolean isSearchable() {
        return this.isSearchable;
    }

    public void setSearchable(boolean value) {
        this.isSearchable = value;
    }

    public Type getDataType() {
        return this.dataType;
    }

    public byte getParameterMode() {
        return this.parameterMode;
    }

    public void setParameterMode(byte mode) {
        this.parameterMode = mode;
    }
}

