/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionArithmetic;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionOp;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionSQL;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.Tokens;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.map.BitMap;
import org.hsqldb.map.ValuePool;
import org.hsqldb.persist.Crypto;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BinaryType;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.LobData;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class FunctionCustom
extends FunctionSQL {
    public static final String[] openGroupNumericFunctions = new String[]{"ABS", "ACOS", "ASIN", "ATAN", "ATAN2", "BITAND", "BITOR", "BITXOR", "CEILING", "COS", "COT", "DEGREES", "EXP", "FLOOR", "LOG", "LOG10", "MOD", "PI", "POWER", "RADIANS", "RAND", "ROUND", "ROUNDMAGIC", "SIGN", "SIN", "SQRT", "TAN", "TRUNCATE"};
    public static final String[] openGroupStringFunctions = new String[]{"ASCII", "CHAR", "CONCAT", "DIFFERENCE", "HEXTORAW", "INSERT", "LCASE", "LEFT", "LENGTH", "LOCATE", "LTRIM", "RAWTOHEX", "REPEAT", "REPLACE", "RIGHT", "RTRIM", "SOUNDEX", "SPACE", "SUBSTR", "UCASE"};
    public static final String[] openGroupDateTimeFunctions = new String[]{"CURDATE", "CURTIME", "DATEDIFF", "DAYNAME", "DAYOFMONTH", "DAYOFWEEK", "DAYOFYEAR", "HOUR", "MINUTE", "MONTH", "MONTHNAME", "NOW", "QUARTER", "SECOND", "SECONDS_SINCE_MIDNIGHT", "TIMESTAMPADD", "TIMESTAMPDIFF", "TO_CHAR", "WEEK", "YEAR"};
    public static final String[] openGroupSystemFunctions = new String[]{"DATABASE", "IFNULL", "USER"};
    private static final int FUNC_ACOS = 71;
    private static final int FUNC_ACTION_ID = 72;
    private static final int FUNC_ADD_MONTHS = 73;
    private static final int FUNC_ASCII = 74;
    private static final int FUNC_ASIN = 75;
    private static final int FUNC_ATAN = 76;
    private static final int FUNC_ATAN2 = 77;
    private static final int FUNC_BITAND = 78;
    private static final int FUNC_BITANDNOT = 79;
    private static final int FUNC_BITNOT = 80;
    private static final int FUNC_BITOR = 81;
    private static final int FUNC_BITXOR = 82;
    private static final int FUNC_CHAR = 83;
    private static final int FUNC_CONCAT = 84;
    private static final int FUNC_COS = 85;
    private static final int FUNC_COT = 86;
    private static final int FUNC_CRYPT_KEY = 87;
    private static final int FUNC_DATABASE = 88;
    private static final int FUNC_DATABASE_ISOLATION_LEVEL = 89;
    private static final int FUNC_DATABASE_NAME = 90;
    private static final int FUNC_DATABASE_TIMEZONE = 91;
    private static final int FUNC_DATABASE_VERSION = 92;
    private static final int FUNC_DATE_ADD = 93;
    private static final int FUNC_DATE_SUB = 94;
    private static final int FUNC_DATEADD = 95;
    private static final int FUNC_DATEDIFF = 96;
    private static final int FUNC_DAYS = 97;
    private static final int FUNC_DBTIMEZONE = 98;
    private static final int FUNC_DEGREES = 99;
    private static final int FUNC_DIAGNOSTICS = 100;
    private static final int FUNC_DIFFERENCE = 101;
    private static final int FUNC_FROM_TZ = 102;
    private static final int FUNC_HEXTORAW = 103;
    private static final int FUNC_IDENTITY = 104;
    private static final int FUNC_INSTR = 105;
    private static final int FUNC_ISAUTOCOMMIT = 106;
    private static final int FUNC_ISOLATION_LEVEL = 107;
    private static final int FUNC_ISREADONLYDATABASE = 108;
    private static final int FUNC_ISREADONLYDATABASEFILES = 109;
    private static final int FUNC_ISREADONLYSESSION = 110;
    private static final int FUNC_LAST_DAY = 111;
    private static final int FUNC_LEFT = 112;
    private static final int FUNC_LOAD_FILE = 113;
    private static final int FUNC_LOB_ID = 114;
    private static final int FUNC_LOCATE = 115;
    private static final int FUNC_LOG10 = 116;
    private static final int FUNC_LPAD = 117;
    private static final int FUNC_LTRIM = 118;
    private static final int FUNC_MONTHS_BETWEEN = 119;
    private static final int FUNC_NEW_TIME = 120;
    private static final int FUNC_NEXT_DAY = 121;
    private static final int FUNC_NUMTODSINTERVAL = 122;
    private static final int FUNC_NUMTOYMINTERVAL = 123;
    private static final int FUNC_PI = 124;
    private static final int FUNC_POSITION_ARRAY = 125;
    private static final int FUNC_RADIANS = 126;
    private static final int FUNC_RAND = 127;
    private static final int FUNC_RAWTOHEX = 128;
    private static final int FUNC_REGEXP_MATCHES = 129;
    private static final int FUNC_REGEXP_SUBSTRING = 130;
    private static final int FUNC_REGEXP_SUBSTRING_ARRAY = 131;
    private static final int FUNC_REPEAT = 132;
    private static final int FUNC_REPLACE = 133;
    private static final int FUNC_REVERSE = 134;
    private static final int FUNC_RIGHT = 135;
    private static final int FUNC_ROUND = 136;
    private static final int FUNC_ROUNDMAGIC = 137;
    private static final int FUNC_RPAD = 138;
    private static final int FUNC_RTRIM = 139;
    private static final int FUNC_SECONDS_MIDNIGHT = 140;
    private static final int FUNC_SEQUENCE_ARRAY = 141;
    private static final int FUNC_SESSION_ID = 142;
    private static final int FUNC_SESSION_ISOLATION_LEVEL = 143;
    private static final int FUNC_SESSION_TIMEZONE = 144;
    private static final int FUNC_SESSIONTIMEZONE = 145;
    private static final int FUNC_SIGN = 146;
    private static final int FUNC_SIN = 147;
    private static final int FUNC_SOUNDEX = 148;
    private static final int FUNC_SORT_ARRAY = 149;
    private static final int FUNC_SPACE = 150;
    private static final int FUNC_SUBSTR = 151;
    private static final int FUNC_SYS_EXTRACT_UTC = 152;
    private static final int FUNC_SYSDATE = 153;
    private static final int FUNC_SYSTIMESTAMP = 154;
    private static final int FUNC_TAN = 155;
    private static final int FUNC_TIMESTAMP = 156;
    private static final int FUNC_TIMESTAMP_WITH_ZONE = 157;
    private static final int FUNC_TIMESTAMPADD = 158;
    private static final int FUNC_TIMESTAMPDIFF = 159;
    private static final int FUNC_TIMEZONE = 160;
    private static final int FUNC_TO_CHAR = 161;
    private static final int FUNC_TO_DATE = 162;
    private static final int FUNC_TO_DSINTERVAL = 163;
    private static final int FUNC_TO_YMINTERVAL = 164;
    private static final int FUNC_TO_NUMBER = 165;
    private static final int FUNC_TO_TIMESTAMP = 166;
    private static final int FUNC_TO_TIMESTAMP_TZ = 167;
    private static final int FUNC_TRANSACTION_CONTROL = 168;
    private static final int FUNC_TRANSACTION_ID = 169;
    private static final int FUNC_TRANSACTION_SIZE = 170;
    private static final int FUNC_TRANSLATE = 171;
    private static final int FUNC_TRUNC = 172;
    private static final int FUNC_TRUNCATE = 173;
    private static final int FUNC_UUID = 174;
    private static final int FUNC_UNIX_TIMESTAMP = 175;
    private static final int FUNC_UNIX_MILLIS = 176;
    static final IntKeyIntValueHashMap customRegularFuncMap = new IntKeyIntValueHashMap();
    static final IntKeyIntValueHashMap customValueFuncMap;
    private int extractSpec;
    private Pattern pattern;
    private IntKeyIntValueHashMap charLookup;

    public static FunctionSQL newCustomFunction(String token, int tokenType) {
        int id = customRegularFuncMap.get(tokenType, -1);
        if (id == -1) {
            id = customValueFuncMap.get(tokenType, -1);
        }
        if (id == -1) {
            return null;
        }
        switch (tokenType) {
            case 431: 
            case 651: 
            case 698: 
            case 703: 
            case 719: 
            case 779: {
                return new FunctionSQL(id);
            }
            case 661: 
            case 662: 
            case 716: 
            case 772: {
                FunctionSQL function = new FunctionSQL(id);
                function.parseList = optionalNoParamList;
                return function;
            }
            case 756: {
                FunctionSQL function = new FunctionSQL(id);
                function.parseList = tripleParamList;
                return function;
            }
        }
        FunctionCustom function = new FunctionCustom(id);
        if (id == 31) {
            switch (tokenType) {
                case 706: {
                    function.extractSpec = 151;
                    break;
                }
                case 733: {
                    function.extractSpec = 286;
                }
            }
        }
        if (id == 5) {
            switch (tokenType) {
                case 675: {
                    function.extractSpec = 671;
                    break;
                }
                case 709: {
                    function.extractSpec = 708;
                    break;
                }
                case 676: {
                    function.extractSpec = 672;
                    break;
                }
                case 677: {
                    function.extractSpec = 673;
                    break;
                }
                case 678: {
                    function.extractSpec = 674;
                    break;
                }
                case 790: {
                    function.extractSpec = 791;
                    break;
                }
                default: {
                    function.extractSpec = tokenType;
                }
            }
        }
        if (function.name == null) {
            function.name = token;
        }
        return function;
    }

    public static boolean isRegularFunction(int tokenType) {
        return customRegularFuncMap.get(tokenType, -1) != -1;
    }

    public static boolean isValueFunction(int tokenType) {
        return customValueFuncMap.get(tokenType, -1) != -1;
    }

    private FunctionCustom(int id) {
        this.funcType = id;
        this.isDeterministic = !nonDeterministicFuncSet.contains(id);
        switch (id) {
            case 153: 
            case 154: {
                this.parseList = optionalNoParamList;
                break;
            }
            case 72: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 98: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 124: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 160: 
            case 168: 
            case 169: 
            case 170: {
                this.parseList = emptyParamList;
                break;
            }
            case 71: 
            case 74: 
            case 75: 
            case 76: 
            case 80: 
            case 83: 
            case 85: 
            case 86: 
            case 97: 
            case 99: 
            case 103: 
            case 111: 
            case 114: 
            case 116: 
            case 126: 
            case 128: 
            case 134: 
            case 137: 
            case 146: 
            case 147: 
            case 148: 
            case 150: 
            case 152: 
            case 155: 
            case 157: 
            case 163: 
            case 164: 
            case 165: {
                this.parseList = singleParamList;
                break;
            }
            case 73: 
            case 77: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 84: 
            case 87: 
            case 101: 
            case 102: 
            case 112: 
            case 119: 
            case 121: 
            case 122: 
            case 123: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 135: 
            case 161: {
                this.parseList = doubleParamList;
                break;
            }
            case 113: 
            case 136: 
            case 156: 
            case 162: 
            case 166: 
            case 167: 
            case 172: 
            case 173: {
                this.parseList = optionalDoubleParamList;
                break;
            }
            case 96: {
                this.parseList = new short[]{816, 818, 804, 818, 864, 2, 804, 818, 802};
                break;
            }
            case 93: 
            case 94: {
                this.parseList = doubleParamList;
                break;
            }
            case 95: 
            case 120: 
            case 141: 
            case 171: {
                this.parseList = tripleParamList;
                break;
            }
            case 1: 
            case 117: 
            case 133: 
            case 138: {
                this.parseList = new short[]{816, 818, 804, 818, 864, 2, 804, 818, 802};
                break;
            }
            case 174: 
            case 175: 
            case 176: {
                this.parseList = optionalSingleParamList;
                break;
            }
            case 5: {
                this.name = "EXTRACT";
                this.parseList = singleParamList;
                break;
            }
            case 31: {
                this.name = "TRIM";
                this.parseList = singleParamList;
                break;
            }
            case 32: {
                this.name = "OVERLAY";
                this.parseList = quadParamList;
                break;
            }
            case 104: {
                this.name = "IDENTITY";
                this.parseList = emptyParamList;
                break;
            }
            case 100: {
                this.parseList = new short[]{816, 495, 802};
                break;
            }
            case 125: {
                this.parseList = new short[]{816, 818, 130, 818, 864, 2, 115, 818, 802};
                break;
            }
            case 149: {
                this.parseList = new short[]{816, 818, 864, 4, 863, 2, 338, 389, 864, 5, 451, 863, 2, 401, 430, 802};
                break;
            }
            case 158: {
                this.name = "TIMESTAMPADD";
                this.parseList = new short[]{816, 863, 10, 852, 853, 854, 855, 856, 857, 858, 859, 860, 861, 804, 818, 804, 818, 802};
                break;
            }
            case 159: {
                this.name = "TIMESTAMPDIFF";
                this.parseList = new short[]{816, 863, 10, 852, 853, 854, 855, 856, 857, 858, 859, 860, 861, 804, 818, 804, 818, 802};
                break;
            }
            case 127: {
                this.parseList = optionalSingleParamList;
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionCustom");
            }
        }
    }

    @Override
    public void setArguments(Expression[] nodes) {
        switch (this.funcType) {
            case 1: {
                Expression[] newNodes = new Expression[4];
                if ("LOCATE".equals(this.name)) {
                    newNodes[0] = nodes[0];
                    newNodes[1] = nodes[1];
                    newNodes[3] = nodes[2];
                    nodes = newNodes;
                    break;
                }
                if (!"INSTR".equals(this.name)) break;
                newNodes[0] = nodes[1];
                newNodes[1] = nodes[0];
                newNodes[3] = nodes[2];
                nodes = newNodes;
                break;
            }
            case 32: {
                Expression start = nodes[1];
                Expression length = nodes[2];
                nodes[1] = nodes[3];
                nodes[2] = start;
                nodes[3] = length;
                break;
            }
            case 5: {
                Expression[] newNodes = new Expression[]{new ExpressionValue(ValuePool.getInt(this.extractSpec), Type.SQL_INTEGER), nodes[0]};
                nodes = newNodes;
                break;
            }
            case 31: {
                Expression[] newNodes = new Expression[]{new ExpressionValue(ValuePool.getInt(this.extractSpec), Type.SQL_INTEGER), new ExpressionValue(" ", Type.SQL_CHAR), nodes[0]};
                nodes = newNodes;
            }
        }
        super.setArguments(nodes);
    }

    @Override
    public Expression getFunctionExpression() {
        switch (this.funcType) {
            case 84: {
                return new ExpressionArithmetic(36, this.nodes[0], this.nodes[1]);
            }
        }
        return super.getFunctionExpression();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object getValue(Session session, Object[] data) {
        switch (this.funcType) {
            case 1: 
            case 5: 
            case 31: 
            case 32: {
                return super.getValue(session, data);
            }
            case 88: {
                return session.getDatabase().getPath();
            }
            case 90: {
                return session.getDatabase().getUniqueName();
            }
            case 106: {
                return session.isAutoCommit() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 110: {
                return session.isReadOnlyDefault() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 108: {
                return session.getDatabase().databaseReadOnly ? Boolean.TRUE : Boolean.FALSE;
            }
            case 109: {
                return session.getDatabase().isFilesReadOnly() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 107: {
                return Session.getIsolationString(session.isolationLevel);
            }
            case 143: {
                return Session.getIsolationString(session.isolationLevelDefault);
            }
            case 89: {
                return Session.getIsolationString(session.database.defaultIsolationLevel);
            }
            case 168: {
                switch (session.database.txManager.getTransactionControl()) {
                    case 2: {
                        return "MVCC";
                    }
                    case 1: {
                        return "MVLOCKS";
                    }
                }
                return "LOCKS";
            }
            case 160: {
                return new IntervalSecondData(session.getZoneSeconds(), 0);
            }
            case 144: {
                return new IntervalSecondData(session.sessionTimeZoneSeconds, 0);
            }
            case 91: {
                int sec = HsqlDateTime.getZoneSeconds(HsqlDateTime.tempCalDefault);
                return new IntervalSecondData(sec, 0);
            }
            case 92: {
                return "2.3.3";
            }
            case 142: {
                return session.getId();
            }
            case 72: {
                return session.actionTimestamp;
            }
            case 169: {
                return session.transactionTimestamp;
            }
            case 170: {
                return (long)session.actionIndex;
            }
            case 114: {
                LobData lob = (LobData)data[0];
                if (lob == null) {
                    return null;
                }
                return lob.getId();
            }
            case 104: {
                Number id = session.getLastIdentity();
                if (id instanceof Long) {
                    return id;
                }
                return ValuePool.getLong(id.longValue());
            }
            case 100: {
                return session.sessionContext.diagnosticsVariables[this.exprSubType];
            }
            case 141: {
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                HsqlArrayList list = new HsqlArrayList();
                Object current = data[0];
                Type type = this.nodes[0].getDataType();
                boolean ascending = type.compare(session, data[1], data[0]) >= 0;
                while (true) {
                    int compare = type.compare(session, current, data[1]);
                    if (ascending ? compare > 0 : compare < 0) break;
                    list.add(current);
                    Object newValue = type.add(session, current, data[2], this.nodes[2].getDataType());
                    compare = type.compare(session, current, newValue);
                    if (ascending ? compare >= 0 : compare <= 0) break;
                    current = newValue;
                }
                Object[] array = list.toArray();
                return array;
            }
            case 158: {
                if (data[1] == null || data[2] == null) {
                    return null;
                }
                data[1] = Type.SQL_BIGINT.convertToType(session, data[1], this.nodes[1].getDataType());
                int part = ((Number)this.nodes[0].valueData).intValue();
                long units = ((Number)data[1]).longValue();
                TimestampData source = (TimestampData)data[2];
                switch (part) {
                    case 852: {
                        long seconds = units / 1000000000L;
                        int nanos = (int)(units % 1000000000L);
                        IntervalType t = Type.SQL_INTERVAL_SECOND_MAX_FRACTION;
                        IntervalSecondData o = new IntervalSecondData(seconds, nanos, t);
                        return this.dataType.add(session, source, o, t);
                    }
                    case 853: {
                        long seconds = units / 1000L;
                        int nanos = (int)(units % 1000L) * 1000000;
                        IntervalType t = Type.SQL_INTERVAL_SECOND_MAX_FRACTION;
                        IntervalSecondData o = new IntervalSecondData(seconds, nanos, t);
                        return this.dataType.add(session, source, o, t);
                    }
                    case 854: {
                        IntervalType t = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        IntervalSecondData o = IntervalSecondData.newIntervalSeconds(units, t);
                        return this.dataType.add(session, source, o, t);
                    }
                    case 855: {
                        IntervalType t = Type.SQL_INTERVAL_MINUTE_MAX_PRECISION;
                        IntervalSecondData o = IntervalSecondData.newIntervalMinute(units, t);
                        return this.dataType.add(session, source, o, t);
                    }
                    case 856: {
                        IntervalType t = Type.SQL_INTERVAL_HOUR_MAX_PRECISION;
                        IntervalSecondData o = IntervalSecondData.newIntervalHour(units, t);
                        return this.dataType.add(session, source, o, t);
                    }
                    case 857: {
                        IntervalType t = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        IntervalSecondData o = IntervalSecondData.newIntervalDay(units, t);
                        return this.dataType.add(session, source, o, t);
                    }
                    case 858: {
                        IntervalType t = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        IntervalSecondData o = IntervalSecondData.newIntervalDay(units * 7L, t);
                        return this.dataType.add(session, source, o, t);
                    }
                    case 859: {
                        IntervalType t = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        IntervalMonthData o = IntervalMonthData.newIntervalMonth(units, t);
                        return this.dataType.add(session, source, o, t);
                    }
                    case 860: {
                        IntervalType t = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        IntervalMonthData o = IntervalMonthData.newIntervalMonth(units * 3L, t);
                        return this.dataType.add(session, source, o, t);
                    }
                    case 861: {
                        IntervalType t = Type.SQL_INTERVAL_YEAR_MAX_PRECISION;
                        IntervalMonthData o = IntervalMonthData.newIntervalMonth(units * 12L, t);
                        return this.dataType.add(session, source, o, t);
                    }
                }
                throw Error.runtimeError(201, "FunctionCustom");
            }
            case 159: {
                if (data[1] == null || data[2] == null) {
                    return null;
                }
                int part = ((Number)this.nodes[0].valueData).intValue();
                TimestampData a = (TimestampData)data[2];
                TimestampData b = (TimestampData)data[1];
                if (this.nodes[2].dataType.isDateTimeTypeWithZone()) {
                    a = (TimestampData)Type.SQL_TIMESTAMP.convertToType(session, a, Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
                }
                if (this.nodes[1].dataType.isDateTimeTypeWithZone()) {
                    b = (TimestampData)Type.SQL_TIMESTAMP.convertToType(session, b, Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
                }
                switch (part) {
                    case 852: {
                        IntervalType t = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        IntervalSecondData interval = (IntervalSecondData)t.subtract(session, a, b, null);
                        return new Long(1000000000L * interval.getSeconds() + (long)interval.getNanos());
                    }
                    case 853: {
                        IntervalType t = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        IntervalSecondData interval = (IntervalSecondData)t.subtract(session, a, b, null);
                        return new Long(1000L * interval.getSeconds() + (long)(interval.getNanos() / 1000000));
                    }
                    case 854: {
                        IntervalType t = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        return new Long(t.convertToLongEndUnits(t.subtract(session, a, b, null)));
                    }
                    case 855: {
                        IntervalType t = Type.SQL_INTERVAL_MINUTE_MAX_PRECISION;
                        return new Long(t.convertToLongEndUnits(t.subtract(session, a, b, null)));
                    }
                    case 856: {
                        IntervalType t = Type.SQL_INTERVAL_HOUR_MAX_PRECISION;
                        return new Long(t.convertToLongEndUnits(t.subtract(session, a, b, null)));
                    }
                    case 857: {
                        IntervalType t = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        return new Long(t.convertToLongEndUnits(t.subtract(session, a, b, null)));
                    }
                    case 858: {
                        IntervalType t = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        return new Long(t.convertToLongEndUnits(t.subtract(session, a, b, null)) / 7L);
                    }
                    case 859: {
                        IntervalType t = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        return new Long(t.convertToLongEndUnits(t.subtract(session, a, b, null)));
                    }
                    case 860: {
                        IntervalType t = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        return new Long(t.convertToLongEndUnits(t.subtract(session, a, b, null)) / 3L);
                    }
                    case 861: {
                        IntervalType t = Type.SQL_INTERVAL_YEAR_MAX_PRECISION;
                        return new Long(t.convertToLongEndUnits(t.subtract(session, a, b, null)));
                    }
                }
                throw Error.runtimeError(201, "FunctionCustom");
            }
            case 93: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                return this.dataType.add(session, data[0], data[1], this.nodes[1].dataType);
            }
            case 94: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                return this.dataType.subtract(session, data[0], data[1], this.nodes[1].dataType);
            }
            case 97: {
                if (data[0] == null) {
                    return null;
                }
                IntervalSecondData diff = (IntervalSecondData)Type.SQL_INTERVAL_DAY_MAX_PRECISION.subtract(session, data[0], DateTimeType.epochTimestamp, Type.SQL_DATE);
                return ValuePool.getInt((int)(diff.getSeconds() / 86400L + 1L));
            }
            case 136: 
            case 172: {
                int interval = 103;
                if (data[0] == null) {
                    return null;
                }
                if (this.dataType.isDateTimeType()) {
                    DateTimeType type = (DateTimeType)this.dataType;
                    if (this.nodes.length > 1 && this.nodes[1] != null) {
                        if (data[1] == null) {
                            return null;
                        }
                        interval = HsqlDateTime.toStandardIntervalPart((String)data[1]);
                    }
                    if (interval < 0) {
                        throw Error.error(5566, (String)data[1]);
                    }
                    return this.funcType == 136 ? type.round(data[0], interval) : type.truncate(data[0], interval);
                }
            }
            case 173: {
                int offset = 0;
                if (data[0] == null) {
                    return null;
                }
                if (this.nodes.length > 1) {
                    if (data[1] == null) {
                        return null;
                    }
                    data[1] = Type.SQL_INTEGER.convertToType(session, data[1], this.nodes[1].getDataType());
                    offset = ((Number)data[1]).intValue();
                }
                return this.funcType == 136 ? ((NumberType)this.dataType).round(data[0], offset) : ((NumberType)this.dataType).truncate(data[0], offset);
            }
            case 161: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                SimpleDateFormat format = session.getSimpleDateFormatGMT();
                Date date = (Date)((DateTimeType)this.nodes[0].dataType).convertSQLToJavaGMT(session, data[0]);
                return HsqlDateTime.toFormattedDate(date, (String)data[1], format);
            }
            case 165: {
                if (data[0] == null) {
                    return null;
                }
                return this.dataType.convertToType(session, data[0], this.nodes[0].dataType);
            }
            case 162: 
            case 166: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                SimpleDateFormat format = session.getSimpleDateFormatGMT();
                TimestampData value = HsqlDateTime.toDate((String)data[0], (String)data[1], format);
                if (this.funcType == 162) {
                    value.clearNanos();
                }
                return value;
            }
            case 156: {
                boolean unary;
                boolean bl = unary = this.nodes[1] == null;
                if (data[0] == null) {
                    return null;
                }
                if (unary) {
                    if (this.nodes[0].dataType.isNumberType()) {
                        return new TimestampData(((Number)data[0]).longValue());
                    }
                    try {
                        return Type.SQL_TIMESTAMP.convertToType(session, data[0], this.nodes[0].dataType);
                    }
                    catch (HsqlException e) {
                        return Type.SQL_DATE.convertToType(session, data[0], this.nodes[0].dataType);
                    }
                }
                if (data[1] == null) {
                    return null;
                }
                TimestampData date = (TimestampData)Type.SQL_DATE.convertToType(session, data[0], this.nodes[0].dataType);
                TimeData time = (TimeData)Type.SQL_TIME.convertToType(session, data[1], this.nodes[1].dataType);
                return new TimestampData(date.getSeconds() + (long)time.getSeconds(), time.getNanos());
            }
            case 157: {
                int zone;
                long seconds;
                Calendar calendar = session.getCalendar();
                int nanos = 0;
                if (data[0] == null) {
                    return null;
                }
                if (this.nodes[0].dataType.isNumberType()) {
                    seconds = ((Number)data[0]).longValue();
                } else if (this.nodes[0].dataType.typeCode == 93) {
                    seconds = ((TimestampData)data[0]).getSeconds();
                    seconds = HsqlDateTime.convertMillisToCalendar(calendar, seconds * 1000L) / 1000L;
                } else if (this.nodes[0].dataType.typeCode == 95) {
                    seconds = ((TimestampData)data[0]).getSeconds();
                } else {
                    throw Error.error(5566, (String)data[1]);
                }
                Calendar o = calendar;
                synchronized (o) {
                    calendar.setTimeInMillis(seconds * 1000L);
                    zone = HsqlDateTime.getZoneSeconds(calendar);
                }
                return new TimestampData(seconds, nanos, zone);
            }
            case 124: {
                return new Double(Math.PI);
            }
            case 127: {
                if (this.nodes[0] == null) {
                    return new Double(session.random());
                }
                data[0] = Type.SQL_BIGINT.convertToType(session, data[0], this.nodes[0].getDataType());
                long seed = ((Number)data[0]).longValue();
                return new Double(session.random(seed));
            }
            case 174: {
                if (this.nodes[0] == null) {
                    UUID uuid = UUID.randomUUID();
                    long hi = uuid.getMostSignificantBits();
                    long lo = uuid.getLeastSignificantBits();
                    return new BinaryData(ArrayUtil.toByteArray(hi, lo), false);
                }
                if (data[0] == null) {
                    return null;
                }
                if (this.dataType.isBinaryType()) {
                    return new BinaryData(StringConverter.toBinaryUUID((String)data[0]), false);
                }
                return StringConverter.toStringUUID(((BinaryData)data[0]).getBytes());
            }
            case 176: {
                TimestampData ts;
                if (this.nodes[0] == null) {
                    ts = session.getCurrentTimestamp(true);
                } else {
                    if (data[0] == null) {
                        return null;
                    }
                    ts = (TimestampData)data[0];
                }
                long millis = ts.getSeconds() * 1000L + (long)(ts.getNanos() / 1000000);
                return millis;
            }
            case 175: {
                TimestampData ts;
                if (this.nodes[0] == null) {
                    ts = session.getCurrentTimestamp(true);
                } else {
                    if (data[0] == null) {
                        return null;
                    }
                    ts = (TimestampData)data[0];
                }
                return ts.getSeconds();
            }
            case 71: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return new Double(Math.acos(d));
            }
            case 75: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return new Double(Math.asin(d));
            }
            case 76: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return new Double(Math.atan(d));
            }
            case 85: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return new Double(Math.cos(d));
            }
            case 86: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                double c = 1.0 / Math.tan(d);
                return new Double(c);
            }
            case 99: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return new Double(Math.toDegrees(d));
            }
            case 147: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return new Double(Math.sin(d));
            }
            case 155: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return new Double(Math.tan(d));
            }
            case 116: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return new Double(Math.log10(d));
            }
            case 126: {
                if (data[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(data[0]);
                return new Double(Math.toRadians(d));
            }
            case 146: {
                if (data[0] == null) {
                    return null;
                }
                int val = ((NumberType)this.nodes[0].dataType).compareToZero(data[0]);
                return ValuePool.getInt(val);
            }
            case 77: {
                if (data[0] == null) {
                    return null;
                }
                double a = NumberType.toDouble(data[0]);
                double b = NumberType.toDouble(data[1]);
                return new Double(Math.atan2(a, b));
            }
            case 74: {
                if (data[0] == null) {
                    return null;
                }
                String arg = this.nodes[0].dataType.isLobType() ? ((ClobData)data[0]).getSubString(session, 0L, 1) : (String)data[0];
                if (arg.length() == 0) {
                    return null;
                }
                return ValuePool.getInt(arg.charAt(0));
            }
            case 83: {
                if (data[0] == null) {
                    return null;
                }
                data[0] = Type.SQL_INTEGER.convertToType(session, data[0], this.nodes[0].getDataType());
                int arg = ((Number)data[0]).intValue();
                if (Character.isValidCodePoint(arg) && Character.isValidCodePoint((char)arg)) {
                    return String.valueOf((char)arg);
                }
                throw Error.error(3472);
            }
            case 137: {
                int offset = 0;
                if (data[0] == null) {
                    return null;
                }
                if (this.nodes.length > 1) {
                    if (data[1] == null) {
                        return null;
                    }
                    offset = ((Number)data[1]).intValue();
                }
                return ((NumberType)this.dataType).round(data[0], offset);
            }
            case 148: {
                if (data[0] == null) {
                    return null;
                }
                String s = (String)data[0];
                return new String(FunctionCustom.soundex(s), 0, 4);
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                byte[] v;
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                if (this.dataType.isNumberType()) {
                    long v2 = 0L;
                    long b = 0L;
                    data[0] = Type.SQL_BIGINT.convertToType(session, data[0], this.nodes[0].getDataType());
                    long a = ((Number)data[0]).longValue();
                    if (this.funcType != 80) {
                        data[1] = Type.SQL_BIGINT.convertToType(session, data[1], this.nodes[1].getDataType());
                        b = ((Number)data[1]).longValue();
                    }
                    switch (this.funcType) {
                        case 78: {
                            v2 = a & b;
                            break;
                        }
                        case 79: {
                            v2 = a & (b ^ 0xFFFFFFFFFFFFFFFFL);
                            break;
                        }
                        case 80: {
                            v2 = a ^ 0xFFFFFFFFFFFFFFFFL;
                            break;
                        }
                        case 81: {
                            v2 = a | b;
                            break;
                        }
                        case 82: {
                            v2 = a ^ b;
                        }
                    }
                    switch (this.dataType.typeCode) {
                        case 2: 
                        case 3: {
                            return BigDecimal.valueOf(v2);
                        }
                        case 25: {
                            return ValuePool.getLong(v2);
                        }
                        case -6: 
                        case 4: 
                        case 5: {
                            return ValuePool.getInt((int)v2);
                        }
                    }
                    throw Error.error(5561);
                }
                byte[] a = ((BinaryData)data[0]).getBytes();
                byte[] b = null;
                if (this.funcType != 80) {
                    b = ((BinaryData)data[1]).getBytes();
                }
                switch (this.funcType) {
                    case 78: {
                        v = BitMap.and(a, b);
                        break;
                    }
                    case 79: {
                        b = BitMap.not(b);
                        v = BitMap.and(a, b);
                        break;
                    }
                    case 80: {
                        v = BitMap.not(a);
                        break;
                    }
                    case 81: {
                        v = BitMap.or(a, b);
                        break;
                    }
                    case 82: {
                        v = BitMap.xor(a, b);
                        break;
                    }
                    default: {
                        throw Error.error(5561);
                    }
                }
                return new BinaryData(v, this.dataType.precision);
            }
            case 101: {
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                char[] s1 = FunctionCustom.soundex((String)data[0]);
                char[] s2 = FunctionCustom.soundex((String)data[1]);
                int e = 0;
                if (s1[0] == s2[0]) {
                    ++e;
                }
                int js = 1;
                block160: for (int i = 1; i < 4; ++i) {
                    for (int j = js; j < 4; ++j) {
                        if (s1[j] != s2[i]) continue;
                        ++e;
                        js = j + 1;
                        continue block160;
                    }
                }
                return ValuePool.getInt(e);
            }
            case 103: {
                if (data[0] == null) {
                    return null;
                }
                return this.dataType.convertToType(session, data[0], this.nodes[0].dataType);
            }
            case 128: {
                if (data[0] == null) {
                    return null;
                }
                BlobData binary = (BlobData)data[0];
                byte[] bytes = binary.getBytes(session, 0L, (int)binary.length(session));
                return StringConverter.byteArrayToHexString(bytes);
            }
            case 132: {
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                data[1] = Type.SQL_INTEGER.convertToType(session, data[1], this.nodes[1].getDataType());
                String string = (String)data[0];
                int i = ((Number)data[1]).intValue();
                StringBuffer sb = new StringBuffer(string.length() * i);
                while (i-- > 0) {
                    sb.append(string);
                }
                return sb.toString();
            }
            case 133: {
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                String string = (String)data[0];
                String find = (String)data[1];
                String replace = (String)data[2];
                StringBuffer sb = new StringBuffer();
                int start = 0;
                if (find.length() == 0) {
                    return string;
                }
                while (true) {
                    int i;
                    if ((i = string.indexOf(find, start)) == -1) break;
                    sb.append(string.substring(start, i));
                    sb.append(replace);
                    start = i + find.length();
                }
                sb.append(string.substring(start));
                return sb.toString();
            }
            case 112: 
            case 135: {
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                int count = ((Number)data[1]).intValue();
                return ((CharacterType)this.dataType).substring(session, data[0], 0L, count, true, this.funcType == 135);
            }
            case 150: {
                if (data[0] == null) {
                    return null;
                }
                data[0] = Type.SQL_INTEGER.convertToType(session, data[0], this.nodes[0].getDataType());
                int count = ((Number)data[0]).intValue();
                char[] array = new char[count];
                ArrayUtil.fillArray(array, 0, ' ');
                return String.valueOf(array);
            }
            case 134: {
                if (data[0] == null) {
                    return null;
                }
                StringBuffer sb = new StringBuffer((String)data[0]);
                sb = sb.reverse();
                return sb.toString();
            }
            case 129: 
            case 130: 
            case 131: {
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] != null) continue;
                    return null;
                }
                Pattern currentPattern = this.pattern;
                if (currentPattern == null) {
                    String matchPattern = (String)data[1];
                    currentPattern = Pattern.compile(matchPattern);
                }
                Matcher matcher = currentPattern.matcher((String)data[0]);
                switch (this.funcType) {
                    case 129: {
                        boolean match = matcher.matches();
                        return match;
                    }
                    case 130: {
                        boolean match = matcher.find();
                        if (match) {
                            return matcher.group();
                        }
                        return null;
                    }
                    case 131: {
                        HsqlArrayList list = new HsqlArrayList();
                        while (matcher.find()) {
                            list.add(matcher.group());
                        }
                        return list.toArray();
                    }
                }
            }
            case 87: {
                byte[] bytes = Crypto.getNewKey((String)data[0], (String)data[1]);
                return StringConverter.byteArrayToHexString(bytes);
            }
            case 113: {
                String fileName = (String)data[0];
                if (fileName == null) {
                    return null;
                }
                switch (this.dataType.typeCode) {
                    case 40: {
                        return session.sessionData.createClobFromFile(fileName, (String)data[1]);
                    }
                }
                return session.sessionData.createBlobFromFile(fileName);
            }
            case 117: 
            case 138: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                String value = this.nodes[0].dataType.typeCode == 40 ? (String)Type.SQL_VARCHAR.convertToType(session, data[0], this.nodes[0].dataType) : (this.nodes[0].dataType.isCharacterType() ? (String)data[0] : this.nodes[0].dataType.convertToString(data[0]));
                int length = (Integer)Type.SQL_INTEGER.convertToType(session, data[1], this.nodes[1].dataType);
                String pad = " ";
                if (this.nodes[2] != null && (pad = this.nodes[2].dataType.convertToString(data[2])).length() == 0) {
                    pad = " ";
                }
                value = (String)Type.SQL_VARCHAR.trim(session, value, ' ', true, true);
                value = StringUtil.toPaddedString(value, length, pad, this.funcType == 138);
                if (this.dataType.isLobType()) {
                    return this.dataType.convertToType(session, value, Type.SQL_VARCHAR);
                }
                return value;
            }
            case 125: {
                if (data[1] == null) {
                    return null;
                }
                if (data[2] == null) {
                    return null;
                }
                Object[] array = (Object[])data[1];
                ArrayType dt = (ArrayType)this.nodes[1].dataType;
                Type elementType = dt.collectionBaseType();
                int start = ((Number)Type.SQL_INTEGER.convertToType(session, data[2], this.nodes[2].dataType)).intValue();
                if (start <= 0) {
                    throw Error.error(3403);
                }
                for (int i = --start; i < array.length; ++i) {
                    if (elementType.compare(session, data[0], array[i]) != 0) continue;
                    return ValuePool.getInt(i + 1);
                }
                return ValuePool.INTEGER_0;
            }
            case 149: {
                if (data[0] == null) {
                    return null;
                }
                ArrayType dt = (ArrayType)this.dataType;
                SortAndSlice exprSort = new SortAndSlice();
                exprSort.prepareSingleColumn(1);
                exprSort.sortDescending[0] = ((Number)data[1]).intValue() == 389;
                exprSort.sortNullsLast[0] = ((Number)data[2]).intValue() == 430;
                Object array = ArrayUtil.duplicateArray(data[0]);
                dt.sort(session, array, exprSort);
                return array;
            }
            case 73: {
                if (data[0] == null) {
                    return null;
                }
                if (data[1] == null) {
                    return null;
                }
                TimestampData ts = (TimestampData)data[0];
                int months = ((Number)data[1]).intValue();
                return Type.SQL_TIMESTAMP_NO_FRACTION.addMonthsSpecial(session, ts, months);
            }
            case 98: {
                TimestampData timestamp = session.getSystemTimestamp(true);
                IntervalSecondData zone = new IntervalSecondData(timestamp.getZone(), 0);
                return Type.SQL_INTERVAL_HOUR_TO_MINUTE.convertToString(zone);
            }
            case 102: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                TimestampData timestamp = (TimestampData)data[0];
                IntervalSecondData zone = (IntervalSecondData)Type.SQL_INTERVAL_HOUR_TO_MINUTE.convertToDefaultType(session, data[1]);
                return new TimestampData(timestamp.getSeconds() - zone.getSeconds(), timestamp.getNanos(), (int)zone.getSeconds());
            }
            case 111: {
                if (data[0] == null) {
                    return null;
                }
                return Type.SQL_TIMESTAMP_NO_FRACTION.getLastDayOfMonth(session, data[0]);
            }
            case 119: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                return DateTimeType.subtractMonthsSpecial(session, (TimestampData)data[0], (TimestampData)data[1]);
            }
            case 120: {
                if (data[0] == null || data[1] == null || data[2] == null) {
                    return null;
                }
                IntervalSecondData zone1 = (IntervalSecondData)Type.SQL_INTERVAL_HOUR_TO_MINUTE.convertToDefaultType(session, data[1]);
                IntervalSecondData zone2 = (IntervalSecondData)Type.SQL_INTERVAL_HOUR_TO_MINUTE.convertToDefaultType(session, data[1]);
                Object val = Type.SQL_TIMESTAMP_WITH_TIME_ZONE.changeZone(data[0], Type.SQL_TIMESTAMP, (int)zone2.getSeconds(), (int)zone1.getSeconds());
                return Type.SQL_TIMESTAMP.convertToType(session, val, Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
            }
            case 121: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
            }
            case 122: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                Object st = Type.SQL_VARCHAR.trim(session, data[1], ' ', true, true);
                st = Type.SQL_VARCHAR.upper(session, st);
                st = Type.SQL_VARCHAR.convertToDefaultType(session, st);
                int token = Tokens.get((String)st);
                int typeCode = IntervalType.getFieldNameTypeForToken(token);
                switch (typeCode) {
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: {
                        break;
                    }
                    default: {
                        throw Error.error(5566);
                    }
                }
                double value = ((Number)data[0]).doubleValue();
                return IntervalSecondData.newInterval(value, typeCode);
            }
            case 123: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                Object st = Type.SQL_VARCHAR.trim(session, data[1], ' ', true, true);
                st = Type.SQL_VARCHAR.upper(session, st);
                st = Type.SQL_VARCHAR.convertToDefaultType(session, st);
                int token = Tokens.get((String)st);
                int typeCode = IntervalType.getFieldNameTypeForToken(token);
                switch (typeCode) {
                    case 101: 
                    case 102: {
                        break;
                    }
                    default: {
                        throw Error.error(5566);
                    }
                }
                double value = ((Number)data[0]).doubleValue();
                return IntervalMonthData.newInterval(value, typeCode);
            }
            case 145: {
                IntervalSecondData zone = new IntervalSecondData(session.sessionTimeZoneSeconds, 0);
                return Type.SQL_INTERVAL_HOUR_TO_MINUTE.convertToString(zone);
            }
            case 152: {
                if (data[0] == null) {
                    return null;
                }
                return Type.SQL_TIMESTAMP_WITH_TIME_ZONE.changeZone(data[0], Type.SQL_TIMESTAMP_WITH_TIME_ZONE, 0, 0);
            }
            case 153: {
                TimestampData timestamp = session.getSystemTimestamp(false);
                return Type.SQL_TIMESTAMP_NO_FRACTION.convertToType(session, timestamp, Type.SQL_TIMESTAMP);
            }
            case 154: {
                return session.getSystemTimestamp(true);
            }
            case 163: {
                if (data[0] == null) {
                    return null;
                }
                return Type.SQL_INTERVAL_DAY_TO_SECOND.convertToType(session, data[0], Type.SQL_VARCHAR);
            }
            case 164: {
                if (data[0] == null) {
                    return null;
                }
                return Type.SQL_INTERVAL_YEAR_TO_MONTH_MAX_PRECISION.convertToType(session, data[0], Type.SQL_VARCHAR);
            }
            case 167: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
            }
            case 171: {
                if (data[0] == null || data[1] == null || data[2] == null) {
                    return null;
                }
                IntKeyIntValueHashMap map = this.charLookup;
                if (map == null) {
                    map = this.getTranslationMap((String)data[1], (String)data[2]);
                }
                return this.translateWithMap((String)data[0], map);
            }
        }
        throw Error.runtimeError(201, "FunctionCustom");
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        int i;
        for (i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        block0 : switch (this.funcType) {
            case 1: 
            case 5: 
            case 31: 
            case 32: {
                super.resolveTypes(session, parent);
                return;
            }
            case 88: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 90: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 106: 
            case 108: 
            case 109: 
            case 110: {
                this.dataType = Type.SQL_BOOLEAN;
                return;
            }
            case 89: 
            case 92: 
            case 107: 
            case 143: 
            case 168: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 91: 
            case 144: 
            case 160: {
                this.dataType = Type.SQL_INTERVAL_HOUR_TO_MINUTE;
                return;
            }
            case 72: 
            case 104: 
            case 114: 
            case 142: 
            case 169: 
            case 170: {
                this.dataType = Type.SQL_BIGINT;
                return;
            }
            case 100: {
                this.exprSubType = 2;
                this.dataType = Type.SQL_INTEGER;
                return;
            }
            case 141: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType;
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (this.nodes[0].dataType.isNumberType()) {
                    if (this.nodes[2].dataType == null) {
                        this.nodes[2].dataType = this.nodes[0].dataType;
                    }
                } else if (this.nodes[0].dataType.isDateTimeType()) {
                    if (this.nodes[2].dataType == null) {
                        throw Error.error(5561);
                    }
                    if (!this.nodes[2].dataType.isIntervalType()) {
                        throw Error.error(5561);
                    }
                }
                this.dataType = new ArrayType(this.nodes[0].getDataType(), Integer.MAX_VALUE);
                return;
            }
            case 95: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5575);
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                int part = this.getTSIToken((String)this.nodes[0].valueData);
                this.nodes[0].valueData = ValuePool.getInt(part);
                this.nodes[0].dataType = Type.SQL_INTEGER;
                this.funcType = 158;
            }
            case 158: {
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_BIGINT;
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_TIMESTAMP;
                }
                if (!this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[2].dataType.typeCode != 91 && this.nodes[2].dataType.typeCode != 93 && this.nodes[2].dataType.typeCode != 95) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[2].dataType;
                return;
            }
            case 96: {
                int part;
                if (this.nodes[2] == null) {
                    this.nodes[2] = this.nodes[0];
                    this.nodes[0] = new ExpressionValue(ValuePool.getInt(857), Type.SQL_INTEGER);
                } else {
                    if (!this.nodes[0].dataType.isCharacterType()) {
                        throw Error.error(5563);
                    }
                    part = this.getTSIToken((String)this.nodes[0].valueData);
                    this.nodes[0].valueData = ValuePool.getInt(part);
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                this.funcType = 159;
            }
            case 159: {
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[2].dataType;
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_TIMESTAMP;
                    this.nodes[2].dataType = Type.SQL_TIMESTAMP;
                }
                block66 : switch (this.nodes[1].dataType.typeCode) {
                    case 91: {
                        if (this.nodes[2].dataType.typeCode == 92 || this.nodes[2].dataType.typeCode == 94) {
                            throw Error.error(5563);
                        }
                        switch ((Integer)this.nodes[0].valueData) {
                            case 857: 
                            case 858: 
                            case 859: 
                            case 860: 
                            case 861: {
                                break block66;
                            }
                        }
                        throw Error.error(5563);
                    }
                    case 93: 
                    case 95: {
                        if (this.nodes[2].dataType.typeCode != 92 && this.nodes[2].dataType.typeCode != 94) break;
                        throw Error.error(5563);
                    }
                    default: {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_BIGINT;
                return;
            }
            case 93: 
            case 94: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DATE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (this.nodes[0].dataType.isCharacterType()) {
                    this.nodes[0] = new ExpressionOp(this.nodes[0], Type.SQL_TIMESTAMP);
                }
                if (this.nodes[1].dataType.isIntegralType()) {
                    this.nodes[1] = new ExpressionOp(this.nodes[1], Type.SQL_INTERVAL_DAY);
                }
                this.nodes[0].resolveTypes(session, this);
                this.nodes[1].resolveTypes(session, this);
                this.dataType = this.nodes[0].dataType;
                return;
            }
            case 97: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DATE;
                }
                switch (this.nodes[0].dataType.typeCode) {
                    case 91: 
                    case 93: 
                    case 95: {
                        break;
                    }
                    default: {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_INTEGER;
                return;
            }
            case 136: 
            case 172: {
                boolean single;
                boolean bl = single = this.nodes.length == 1 || this.nodes[1] == null;
                if (this.nodes[0].dataType == null) {
                    if (single) {
                        if (parent instanceof ExpressionLogical || parent instanceof ExpressionArithmetic) {
                            for (int i2 = 0; i2 < parent.nodes.length; ++i2) {
                                if (parent.nodes[i2].dataType == null) continue;
                                this.nodes[0].dataType = parent.nodes[i2].dataType;
                                break;
                            }
                        }
                        if (this.nodes[0].dataType == null) {
                            this.nodes[0].dataType = Type.SQL_DECIMAL;
                        }
                        if (this.nodes[0].dataType.isNumberType()) {
                            this.nodes[0].dataType = Type.SQL_DECIMAL;
                        }
                    } else {
                        if (this.nodes[1].dataType == null) {
                            this.nodes[1].dataType = Type.SQL_INTEGER;
                        }
                        this.nodes[0].dataType = this.nodes[1].dataType.isNumberType() ? Type.SQL_DECIMAL : Type.SQL_TIMESTAMP;
                    }
                }
                if (this.nodes[0].dataType.isDateTimeType()) {
                    if (!single && !this.nodes[1].dataType.isCharacterType()) {
                        throw Error.error(5566);
                    }
                    this.dataType = this.nodes[0].dataType;
                    break;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
            }
            case 173: {
                Number offset = null;
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[1] == null) {
                    this.nodes[1] = new ExpressionValue(ValuePool.INTEGER_0, Type.SQL_INTEGER);
                    offset = ValuePool.INTEGER_0;
                } else {
                    if (this.nodes[1].dataType == null) {
                        this.nodes[1].dataType = Type.SQL_INTEGER;
                    } else if (!this.nodes[1].dataType.isIntegralType()) {
                        throw Error.error(5563);
                    }
                    if (this.nodes[1].opType == 1) {
                        offset = (Number)this.nodes[1].getValue(session);
                    }
                }
                this.dataType = this.nodes[0].dataType;
                if (offset != null) {
                    int scale = offset;
                    if (scale < 0) {
                        scale = 0;
                    } else if (scale > this.dataType.scale) {
                        scale = this.dataType.scale;
                    }
                    if ((this.dataType.typeCode == 3 || this.dataType.typeCode == 2) && scale != this.dataType.scale) {
                        this.dataType = new NumberType(this.dataType.typeCode, this.dataType.precision - (long)this.dataType.scale + (long)scale, scale);
                    }
                }
                return;
            }
            case 161: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[0].dataType.isDateTimeType()) {
                    throw Error.error(5563);
                }
                this.dataType = CharacterType.getCharacterType(12, 64L);
                return;
            }
            case 165: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_DECIMAL_DEFAULT;
                return;
            }
            case 162: 
            case 166: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1] == null) {
                    String format = "DD-MON-YYYY HH24:MI:SS";
                    if (this.funcType == 166) {
                        format = "DD-MON-YYYY HH24:MI:SS.FF";
                    }
                    this.nodes[1] = new ExpressionValue(format, Type.SQL_VARCHAR);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType() || !this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = this.funcType == 162 ? Type.SQL_TIMESTAMP_NO_FRACTION : Type.SQL_TIMESTAMP;
                return;
            }
            case 156: {
                Type argType = this.nodes[0].dataType;
                if (this.nodes[1] == null) {
                    if (argType == null) {
                        argType = this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (!argType.isCharacterType() && argType.typeCode != 93 && argType.typeCode != 95 && !argType.isNumberType()) {
                        throw Error.error(5561);
                    }
                } else {
                    if (argType == null) {
                        if (this.nodes[1].dataType == null) {
                            this.nodes[0].dataType = this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                            argType = this.nodes[1].dataType;
                        } else {
                            argType = this.nodes[1].dataType.isCharacterType() ? (this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT) : (this.nodes[0].dataType = Type.SQL_DATE);
                        }
                    }
                    if (this.nodes[1].dataType == null) {
                        if (argType.isCharacterType()) {
                            this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                        } else if (argType.typeCode == 91) {
                            this.nodes[1].dataType = Type.SQL_TIME;
                        }
                    }
                    if (!(argType.typeCode == 91 && this.nodes[1].dataType.typeCode == 92 || argType.isCharacterType() && this.nodes[1].dataType.isCharacterType())) {
                        throw Error.error(5561);
                    }
                }
                this.dataType = Type.SQL_TIMESTAMP;
                return;
            }
            case 157: {
                Type argType = this.nodes[0].dataType;
                if (argType == null) {
                    argType = this.nodes[0].dataType = Type.SQL_BIGINT;
                }
                if (argType.typeCode != 93 && argType.typeCode != 95 && !argType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                return;
            }
            case 124: {
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 174: {
                if (this.nodes[0] == null) {
                    this.dataType = Type.SQL_BINARY_16;
                    break;
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                    this.dataType = Type.SQL_BINARY_16;
                    break;
                }
                if (this.nodes[0].dataType.isCharacterType()) {
                    this.dataType = Type.SQL_BINARY_16;
                    break;
                }
                if (this.nodes[0].dataType.isBinaryType() && !this.nodes[0].dataType.isLobType()) {
                    this.dataType = Type.SQL_CHAR_16;
                    break;
                }
                throw Error.error(5563);
            }
            case 175: 
            case 176: {
                if (this.nodes[0] != null) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_TIMESTAMP;
                    } else if (!this.nodes[0].dataType.isDateTimeType() || this.nodes[0].dataType.typeCode == 92 || this.nodes[0].dataType.typeCode == 94) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_BIGINT;
                break;
            }
            case 127: {
                if (this.nodes[0] != null) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_BIGINT;
                    } else if (!this.nodes[0].dataType.isExactNumberType()) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 71: 
            case 75: 
            case 76: 
            case 85: 
            case 86: 
            case 99: 
            case 116: 
            case 126: 
            case 137: 
            case 147: 
            case 155: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 146: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 77: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType() || !this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 148: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = CharacterType.getCharacterType(12, 4L);
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType;
                }
                if (this.funcType == 80) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_INTEGER;
                    }
                    this.dataType = this.nodes[0].dataType;
                } else {
                    this.dataType = this.nodes[0].dataType;
                    if (this.nodes[1].dataType == null) {
                        this.nodes[1].dataType = this.nodes[0].dataType;
                    }
                    for (i = 0; i < this.nodes.length; ++i) {
                        if (this.nodes[i].dataType != null) continue;
                        this.nodes[i].dataType = Type.SQL_INTEGER;
                    }
                    this.dataType = this.nodes[0].dataType.getAggregateType(this.nodes[1].dataType);
                }
                switch (this.dataType.typeCode) {
                    case -6: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 8: 
                    case 25: {
                        break block0;
                    }
                    case 14: 
                    case 15: {
                        break block0;
                    }
                }
                throw Error.error(5561);
            }
            case 74: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 83: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[0].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = CharacterType.getCharacterType(12, 1L);
                break;
            }
            case 101: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 103: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARBINARY_DEFAULT : BinaryType.getBinaryType(61, this.nodes[0].dataType.precision / 2L);
                break;
            }
            case 128: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARBINARY;
                }
                if (!this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARCHAR_DEFAULT : CharacterType.getCharacterType(12, this.nodes[0].dataType.precision * 2L);
                break;
            }
            case 132: {
                boolean isChar;
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!(isChar = this.nodes[0].dataType.isCharacterType()) && !this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5561);
                }
                if (!this.nodes[1].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = isChar ? Type.SQL_VARCHAR_DEFAULT : Type.SQL_VARBINARY_DEFAULT;
                break;
            }
            case 133: {
                if (this.nodes[2] == null) {
                    this.nodes[2] = new ExpressionValue("", Type.SQL_VARCHAR);
                }
                for (i = 0; i < this.nodes.length; ++i) {
                    if (this.nodes[i].dataType == null) {
                        this.nodes[i].dataType = Type.SQL_VARCHAR;
                        continue;
                    }
                    if (this.nodes[i].dataType.isCharacterType()) continue;
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 112: 
            case 135: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[1].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARCHAR_DEFAULT : ((CharacterType)this.nodes[0].dataType).getCharacterType(this.nodes[0].dataType.precision);
                break;
            }
            case 150: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[0].dataType.isIntegralType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 134: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.isCharacterType() && !this.dataType.isLobType()) break;
                throw Error.error(5561);
            }
            case 129: 
            case 130: 
            case 131: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType() || !this.nodes[1].dataType.isCharacterType() || this.nodes[1].dataType.isLobType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1].exprSubType == 1) {
                    String matchPattern = (String)this.nodes[1].getValue(session);
                    this.pattern = Pattern.compile(matchPattern);
                }
                switch (this.funcType) {
                    case 129: {
                        this.dataType = Type.SQL_BOOLEAN;
                        break;
                    }
                    case 130: {
                        this.dataType = Type.SQL_VARCHAR_DEFAULT;
                        break;
                    }
                    case 131: {
                        this.dataType = Type.getDefaultArrayType(12);
                    }
                }
                break;
            }
            case 87: {
                for (i = 0; i < this.nodes.length; ++i) {
                    if (this.nodes[i].dataType == null) {
                        this.nodes[i].dataType = Type.SQL_VARCHAR;
                        continue;
                    }
                    if (this.nodes[i].dataType.isCharacterType()) continue;
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 113: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1] == null) {
                    this.dataType = Type.SQL_BLOB;
                    break;
                }
                this.dataType = Type.SQL_CLOB;
                if (this.nodes[1].dataType != null && this.nodes[1].dataType.isCharacterType()) break;
                throw Error.error(5561);
            }
            case 117: 
            case 138: {
                Number value;
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[1].dataType.isIntegralType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[2] != null) {
                    if (this.nodes[2].dataType == null) {
                        this.nodes[2].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (!this.nodes[2].dataType.isCharacterType()) {
                        throw Error.error(5561);
                    }
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.typeCode != 40) {
                    this.dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].opType != 1 || (value = (Number)this.nodes[1].getValue(session)) == null) break;
                this.dataType = ((CharacterType)this.dataType).getCharacterType(value.longValue());
                break;
            }
            case 125: {
                if (this.nodes[1].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[1].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = ((ArrayType)this.nodes[1].dataType).collectionBaseType();
                }
                if (!((ArrayType)this.nodes[1].dataType).collectionBaseType().canCompareDirect(this.nodes[0].dataType)) {
                    throw Error.error(5563);
                }
                if (this.nodes[2] == null) {
                    this.nodes[2] = new ExpressionValue(ValuePool.INTEGER_1, Type.SQL_INTEGER);
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[2].dataType.isIntegralType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 149: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[1] == null) {
                    this.nodes[1] = new ExpressionValue(ValuePool.getInt(338), Type.SQL_INTEGER);
                }
                if (this.nodes[2] == null) {
                    this.nodes[2] = new ExpressionValue(ValuePool.getInt(401), Type.SQL_INTEGER);
                }
                this.dataType = this.nodes[0].dataType;
                break;
            }
            case 73: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (!this.nodes[0].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 98: {
                this.dataType = CharacterType.getCharacterType(12, 6L);
                break;
            }
            case 102: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                break;
            }
            case 111: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (!this.nodes[0].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 119: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (!this.nodes[0].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[1].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_DECIMAL_DEFAULT;
                break;
            }
            case 120: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 121: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 122: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_INTERVAL_DAY_TO_SECOND_MAX_PRECISION;
                break;
            }
            case 123: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_INTERVAL_YEAR_TO_MONTH_MAX_PRECISION;
                break;
            }
            case 145: {
                this.dataType = CharacterType.getCharacterType(12, 6L);
                break;
            }
            case 152: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                }
                this.dataType = Type.SQL_TIMESTAMP;
                break;
            }
            case 153: {
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 154: {
                this.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                break;
            }
            case 163: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_INTERVAL_DAY_TO_SECOND_MAX_PRECISION;
                break;
            }
            case 164: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_INTERVAL_YEAR_TO_MONTH_MAX_PRECISION;
                break;
            }
            case 167: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1] == null) {
                    String format = "DD-MON-YYYY HH24:MI:SS:FF TZH:TZM";
                    this.nodes[1] = new ExpressionValue(format, Type.SQL_VARCHAR);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType() || !this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5567);
                }
                this.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                break;
            }
            case 171: {
                for (i = 0; i < this.nodes.length; ++i) {
                    if (this.nodes[i].dataType == null) {
                        this.nodes[i].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (this.nodes[i].dataType.isCharacterType() && !this.nodes[i].dataType.isLobType()) continue;
                    throw Error.error(5563);
                }
                if (this.nodes[1].valueData != null && this.nodes[2].valueData != null) {
                    this.charLookup = this.getTranslationMap((String)this.nodes[1].valueData, (String)this.nodes[2].valueData);
                }
                this.dataType = this.nodes[0].dataType;
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionCustom");
            }
        }
    }

    @Override
    public String getSQL() {
        switch (this.funcType) {
            case 1: {
                StringBuffer sb = new StringBuffer("LOCATE").append("(").append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL());
                if (this.nodes.length > 3 && this.nodes[3] != null) {
                    sb.append(",").append(this.nodes[3].getSQL());
                }
                sb.append(")").toString();
                return sb.toString();
            }
            case 117: 
            case 138: {
                StringBuffer sb = new StringBuffer(this.name);
                sb.append("(").append(this.nodes[0].getSQL());
                sb.append(",").append(this.nodes[1].getSQL());
                if (this.nodes[2] != null) {
                    sb.append(",").append(this.nodes[2].getSQL());
                }
                sb.append(")").toString();
                return sb.toString();
            }
            case 5: 
            case 31: 
            case 32: {
                return super.getSQL();
            }
            case 125: {
                StringBuffer sb = new StringBuffer(this.name).append('(');
                sb.append(this.nodes[0].getSQL()).append(' ').append("IN");
                sb.append(' ').append(this.nodes[1].getSQL());
                if (((Number)this.nodes[1].valueData).intValue() == 389) {
                    sb.append(' ').append("FROM");
                    sb.append(' ').append(this.nodes[2].getSQL());
                }
                sb.append(')');
                return sb.toString();
            }
            case 149: {
                StringBuffer sb = new StringBuffer(this.name).append('(');
                sb.append(this.nodes[0].getSQL());
                if (((Number)this.nodes[1].valueData).intValue() == 389) {
                    sb.append(' ').append("DESC");
                }
                if (((Number)this.nodes[2].valueData).intValue() == 430) {
                    sb.append(' ').append("NULLS").append(' ');
                    sb.append("LAST");
                }
                sb.append(')');
                return sb.toString();
            }
            case 153: 
            case 154: {
                return this.name;
            }
            case 72: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 104: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 124: 
            case 142: 
            case 143: 
            case 144: 
            case 160: 
            case 168: 
            case 169: 
            case 170: {
                return new StringBuffer(this.name).append("(").append(")").toString();
            }
            case 158: {
                String token = Tokens.getSQLTSIString(((Number)this.nodes[0].getValue(null)).intValue());
                return new StringBuffer("TIMESTAMPADD").append("(").append(token).append(",").append(this.nodes[1].getSQL()).append(",").append(this.nodes[2].getSQL()).append(")").toString();
            }
            case 159: {
                String token = Tokens.getSQLTSIString(((Number)this.nodes[0].getValue(null)).intValue());
                return new StringBuffer("TIMESTAMPDIFF").append("(").append(token).append(",").append(this.nodes[1].getSQL()).append(",").append(this.nodes[2].getSQL()).append(")").toString();
            }
            case 93: {
                return new StringBuffer(this.nodes[0].getSQL()).append(' ').append('+').append(this.nodes[1].getSQL()).toString();
            }
            case 94: {
                return new StringBuffer(this.nodes[0].getSQL()).append(' ').append('-').append(this.nodes[1].getSQL()).toString();
            }
            case 127: 
            case 175: 
            case 176: {
                StringBuffer sb = new StringBuffer(this.name).append('(');
                if (this.nodes[0] != null) {
                    sb.append(this.nodes[0].getSQL());
                }
                sb.append(')');
                return sb.toString();
            }
            case 113: 
            case 136: 
            case 156: 
            case 162: 
            case 165: 
            case 166: 
            case 167: 
            case 172: 
            case 173: {
                StringBuffer sb = new StringBuffer(this.name).append('(');
                sb.append(this.nodes[0].getSQL());
                if (this.nodes.length > 1 && this.nodes[1] != null) {
                    sb.append(',').append(this.nodes[1].getSQL());
                }
                sb.append(')');
                return sb.toString();
            }
            case 71: 
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 85: 
            case 86: 
            case 97: 
            case 99: 
            case 103: 
            case 114: 
            case 116: 
            case 126: 
            case 128: 
            case 134: 
            case 137: 
            case 146: 
            case 147: 
            case 148: 
            case 150: 
            case 155: {
                return new StringBuffer(this.name).append('(').append(this.nodes[0].getSQL()).append(')').toString();
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 87: 
            case 101: 
            case 112: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 135: 
            case 161: {
                return new StringBuffer(this.name).append('(').append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL()).append(')').toString();
            }
            case 100: {
                StringBuffer sb = new StringBuffer(this.name).append('(');
                sb.append("ROW_COUNT");
                sb.append(')');
                return sb.toString();
            }
            case 133: 
            case 141: {
                return new StringBuffer(this.name).append('(').append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL()).append(",").append(this.nodes[2].getSQL()).append(')').toString();
            }
            case 73: 
            case 98: 
            case 102: 
            case 111: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 145: 
            case 152: 
            case 163: 
            case 164: 
            case 171: {
                return this.getSQLSimple();
            }
        }
        return super.getSQL();
    }

    private String getSQLSimple() {
        StringBuffer sb = new StringBuffer(this.name).append('(');
        for (int i = 0; i < this.nodes.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.nodes[i].getSQL());
        }
        sb.append(')');
        return sb.toString();
    }

    public static char[] soundex(String s) {
        if (s == null) {
            return null;
        }
        s = s.toUpperCase(Locale.ENGLISH);
        int len = s.length();
        char[] b = new char[]{'0', '0', '0', '0'};
        int lastdigit = 48;
        int j = 0;
        for (int i = 0; i < len && j < 4; ++i) {
            int newdigit;
            char c = s.charAt(i);
            if ("AEIOUY".indexOf(c) != -1) {
                newdigit = 55;
            } else if (c == 'H' || c == 'W') {
                newdigit = 56;
            } else if ("BFPV".indexOf(c) != -1) {
                newdigit = 49;
            } else if ("CGJKQSXZ".indexOf(c) != -1) {
                newdigit = 50;
            } else if (c == 'D' || c == 'T') {
                newdigit = 51;
            } else if (c == 'L') {
                newdigit = 52;
            } else if (c == 'M' || c == 'N') {
                newdigit = 53;
            } else {
                if (c != 'R') continue;
                newdigit = 54;
            }
            if (j == 0) {
                b[j++] = c;
                lastdigit = newdigit;
                continue;
            }
            if (newdigit <= 54) {
                if (newdigit == lastdigit) continue;
                b[j++] = newdigit;
                lastdigit = newdigit;
                continue;
            }
            if (newdigit != 55) continue;
            lastdigit = newdigit;
        }
        return b;
    }

    int getTSIToken(String string) {
        int part;
        if ("yy".equalsIgnoreCase(string) || "year".equalsIgnoreCase(string)) {
            part = 861;
        } else if ("mm".equalsIgnoreCase(string) || "month".equalsIgnoreCase(string)) {
            part = 859;
        } else if ("dd".equalsIgnoreCase(string) || "day".equalsIgnoreCase(string)) {
            part = 857;
        } else if ("hh".equalsIgnoreCase(string) || "hour".equalsIgnoreCase(string)) {
            part = 856;
        } else if ("mi".equalsIgnoreCase(string) || "minute".equalsIgnoreCase(string)) {
            part = 855;
        } else if ("ss".equalsIgnoreCase(string) || "second".equalsIgnoreCase(string)) {
            part = 854;
        } else if ("ms".equalsIgnoreCase(string) || "millisecond".equalsIgnoreCase(string)) {
            part = 853;
        } else {
            throw Error.error(5566, string);
        }
        return part;
    }

    IntKeyIntValueHashMap getTranslationMap(String source, String dest) {
        IntKeyIntValueHashMap map = new IntKeyIntValueHashMap();
        for (int i = 0; i < source.length(); ++i) {
            char character = source.charAt(i);
            if (i >= dest.length()) {
                map.put(character, -1);
                continue;
            }
            char value = dest.charAt(i);
            map.put(character, value);
        }
        return map;
    }

    String translateWithMap(String source, IntKeyIntValueHashMap map) {
        StringBuffer sb = new StringBuffer(source.length());
        for (int i = 0; i < source.length(); ++i) {
            char character = source.charAt(i);
            int value = map.get((int)character, -2);
            if (value == -2) {
                sb.append(character);
                continue;
            }
            if (value == -1) continue;
            sb.append((char)value);
        }
        return sb.toString();
    }

    static {
        nonDeterministicFuncSet.add(72);
        nonDeterministicFuncSet.add(87);
        nonDeterministicFuncSet.add(88);
        nonDeterministicFuncSet.add(89);
        nonDeterministicFuncSet.add(91);
        nonDeterministicFuncSet.add(104);
        nonDeterministicFuncSet.add(106);
        nonDeterministicFuncSet.add(110);
        nonDeterministicFuncSet.add(108);
        nonDeterministicFuncSet.add(109);
        nonDeterministicFuncSet.add(107);
        nonDeterministicFuncSet.add(142);
        nonDeterministicFuncSet.add(143);
        nonDeterministicFuncSet.add(144);
        nonDeterministicFuncSet.add(145);
        nonDeterministicFuncSet.add(153);
        nonDeterministicFuncSet.add(154);
        nonDeterministicFuncSet.add(156);
        nonDeterministicFuncSet.add(160);
        nonDeterministicFuncSet.add(168);
        nonDeterministicFuncSet.add(169);
        nonDeterministicFuncSet.add(170);
        nonDeterministicFuncSet.add(174);
        nonDeterministicFuncSet.add(175);
        nonDeterministicFuncSet.add(176);
        customRegularFuncMap.put(640, 71);
        customRegularFuncMap.put(641, 72);
        customRegularFuncMap.put(644, 73);
        customRegularFuncMap.put(642, 149);
        customRegularFuncMap.put(643, 74);
        customRegularFuncMap.put(645, 75);
        customRegularFuncMap.put(646, 76);
        customRegularFuncMap.put(647, 77);
        customRegularFuncMap.put(649, 78);
        customRegularFuncMap.put(650, 79);
        customRegularFuncMap.put(651, 6);
        customRegularFuncMap.put(652, 80);
        customRegularFuncMap.put(653, 81);
        customRegularFuncMap.put(654, 82);
        customRegularFuncMap.put(33, 83);
        customRegularFuncMap.put(655, 83);
        customRegularFuncMap.put(656, 84);
        customRegularFuncMap.put(658, 85);
        customRegularFuncMap.put(659, 86);
        customRegularFuncMap.put(660, 87);
        customRegularFuncMap.put(661, 43);
        customRegularFuncMap.put(662, 51);
        customRegularFuncMap.put(582, 88);
        customRegularFuncMap.put(664, 90);
        customRegularFuncMap.put(663, 89);
        customRegularFuncMap.put(665, 91);
        customRegularFuncMap.put(666, 92);
        customRegularFuncMap.put(667, 93);
        customRegularFuncMap.put(668, 94);
        customRegularFuncMap.put(669, 95);
        customRegularFuncMap.put(670, 96);
        customRegularFuncMap.put(73, 5);
        customRegularFuncMap.put(675, 5);
        customRegularFuncMap.put(676, 5);
        customRegularFuncMap.put(677, 5);
        customRegularFuncMap.put(678, 5);
        customRegularFuncMap.put(679, 97);
        customRegularFuncMap.put(680, 98);
        customRegularFuncMap.put(682, 99);
        customRegularFuncMap.put(391, 100);
        customRegularFuncMap.put(683, 101);
        customRegularFuncMap.put(685, 102);
        customRegularFuncMap.put(686, 103);
        customRegularFuncMap.put(127, 5);
        customRegularFuncMap.put(128, 104);
        customRegularFuncMap.put(135, 32);
        customRegularFuncMap.put(690, 1);
        customRegularFuncMap.put(691, 106);
        customRegularFuncMap.put(692, 108);
        customRegularFuncMap.put(693, 109);
        customRegularFuncMap.put(694, 110);
        customRegularFuncMap.put(695, 107);
        customRegularFuncMap.put(697, 111);
        customRegularFuncMap.put(698, 26);
        customRegularFuncMap.put(153, 112);
        customRegularFuncMap.put(431, 7);
        customRegularFuncMap.put(700, 113);
        customRegularFuncMap.put(707, 114);
        customRegularFuncMap.put(701, 1);
        customRegularFuncMap.put(703, 14);
        customRegularFuncMap.put(704, 116);
        customRegularFuncMap.put(705, 117);
        customRegularFuncMap.put(706, 31);
        customRegularFuncMap.put(169, 5);
        customRegularFuncMap.put(173, 5);
        customRegularFuncMap.put(709, 5);
        customRegularFuncMap.put(710, 119);
        customRegularFuncMap.put(713, 120);
        customRegularFuncMap.put(717, 122);
        customRegularFuncMap.put(718, 123);
        customRegularFuncMap.put(719, 8);
        customRegularFuncMap.put(720, 124);
        customRegularFuncMap.put(721, 125);
        customRegularFuncMap.put(722, 5);
        customRegularFuncMap.put(723, 126);
        customRegularFuncMap.put(724, 127);
        customRegularFuncMap.put(725, 128);
        customRegularFuncMap.put(726, 129);
        customRegularFuncMap.put(727, 130);
        customRegularFuncMap.put(728, 131);
        customRegularFuncMap.put(234, 132);
        customRegularFuncMap.put(729, 133);
        customRegularFuncMap.put(730, 134);
        customRegularFuncMap.put(240, 135);
        customRegularFuncMap.put(731, 136);
        customRegularFuncMap.put(732, 137);
        customRegularFuncMap.put(734, 138);
        customRegularFuncMap.put(733, 31);
        customRegularFuncMap.put(250, 5);
        customRegularFuncMap.put(735, 5);
        customRegularFuncMap.put(736, 141);
        customRegularFuncMap.put(737, 142);
        customRegularFuncMap.put(738, 143);
        customRegularFuncMap.put(739, 144);
        customRegularFuncMap.put(740, 145);
        customRegularFuncMap.put(741, 146);
        customRegularFuncMap.put(742, 147);
        customRegularFuncMap.put(743, 149);
        customRegularFuncMap.put(744, 148);
        customRegularFuncMap.put(514, 150);
        customRegularFuncMap.put(756, 23);
        customRegularFuncMap.put(757, 152);
        customRegularFuncMap.put(758, 153);
        customRegularFuncMap.put(759, 154);
        customRegularFuncMap.put(760, 155);
        customRegularFuncMap.put(282, 156);
        customRegularFuncMap.put(761, 157);
        customRegularFuncMap.put(762, 158);
        customRegularFuncMap.put(763, 159);
        customRegularFuncMap.put(764, 160);
        customRegularFuncMap.put(765, 161);
        customRegularFuncMap.put(766, 162);
        customRegularFuncMap.put(767, 163);
        customRegularFuncMap.put(768, 164);
        customRegularFuncMap.put(769, 165);
        customRegularFuncMap.put(770, 166);
        customRegularFuncMap.put(774, 168);
        customRegularFuncMap.put(775, 169);
        customRegularFuncMap.put(776, 170);
        customRegularFuncMap.put(287, 171);
        customRegularFuncMap.put(777, 172);
        customRegularFuncMap.put(295, 173);
        customRegularFuncMap.put(779, 27);
        customRegularFuncMap.put(780, 176);
        customRegularFuncMap.put(781, 175);
        customRegularFuncMap.put(782, 174);
        customRegularFuncMap.put(790, 5);
        customRegularFuncMap.put(323, 5);
        customValueFuncMap = new IntKeyIntValueHashMap();
        customValueFuncMap.put(772, 43);
        customValueFuncMap.put(716, 52);
    }
}

