/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.constant.Constable;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionSQL;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDDL;
import org.hsqldb.RangeGroup;
import org.hsqldb.Routine;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementCommand;
import org.hsqldb.StatementSession;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.map.ValuePool;
import org.hsqldb.result.Result;
import org.hsqldb.rights.User;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Type;

public class ParserCommand
extends ParserDDL {
    ParserCommand(Session session, Scanner t) {
        super(session, t);
    }

    Statement compileStatement(int props) {
        Statement cs = this.compilePart(props);
        if (this.token.tokenType == 872) {
            if (cs.getSchemaName() == null) {
                cs.setSchemaHsqlName(this.session.getCurrentSchemaHsqlName());
            }
            return cs;
        }
        throw this.unexpectedToken();
    }

    HsqlArrayList compileStatements(String sql, Result cmd) {
        HsqlArrayList list = new HsqlArrayList();
        Statement cs = null;
        this.reset(sql);
        while (this.token.tokenType != 872) {
            try {
                this.lastError = null;
                cs = this.compilePart(cmd.getExecuteProperties());
            }
            catch (HsqlException e) {
                if (this.lastError != null && this.lastError.getLevel() > e.getLevel()) {
                    throw this.lastError;
                }
                throw e;
            }
            if (!cs.isExplain && cs.getParametersMetaData().getColumnCount() > 0) {
                throw Error.error(5575);
            }
            cs.setCompileTimestamp(this.database.txManager.getGlobalChangeTimestamp());
            list.add(cs);
        }
        int returnType = cmd.getStatementType();
        if (returnType != 0) {
            int group = cs.getGroup();
            if (group == 2003) {
                if (returnType == 1) {
                    throw Error.error(1253);
                }
            } else if (returnType == 2) {
                // empty if block
            }
        }
        return list;
    }

    private Statement compilePart(int props) {
        Statement cs;
        this.compileContext.reset();
        this.setParsePosition(this.getPosition());
        if (this.token.tokenType == 873) {
            this.read();
        }
        switch (this.token.tokenType) {
            case 251: 
            case 278: 
            case 319: 
            case 816: {
                cs = this.compileCursorSpecification(RangeGroup.emptyArray, props, false);
                break;
            }
            case 308: {
                RangeGroup[] ranges = this.session.sessionContext.sessionVariableRangeGroups;
                this.compileContext.setOuterRanges(ranges);
                cs = this.compileShortCursorSpecification(props);
                break;
            }
            case 135: {
                cs = this.compileInsertStatement(RangeGroup.emptyArray);
                break;
            }
            case 303: {
                cs = this.compileUpdateStatement(RangeGroup.emptyArray);
                break;
            }
            case 166: {
                cs = this.compileMergeStatement(RangeGroup.emptyArray);
                break;
            }
            case 79: {
                cs = this.compileDeleteStatement(RangeGroup.emptyArray);
                break;
            }
            case 295: {
                cs = this.compileTruncateStatement();
                break;
            }
            case 729: {
                cs = this.compileInsertStatement(RangeGroup.emptyArray);
                break;
            }
            case 25: {
                cs = this.compileCallStatement(this.session.sessionContext.sessionVariableRangeGroups, false);
                break;
            }
            case 254: {
                cs = this.compileSet();
                break;
            }
            case 119: {
                cs = this.compileGetStatement(this.session.sessionContext.sessionVariableRangeGroups);
                break;
            }
            case 267: {
                cs = this.compileStartTransaction();
                break;
            }
            case 44: {
                cs = this.compileCommit();
                break;
            }
            case 241: {
                cs = this.compileRollback();
                break;
            }
            case 246: {
                cs = this.compileSavepoint();
                break;
            }
            case 233: {
                cs = this.compileReleaseSavepoint();
                break;
            }
            case 55: {
                cs = this.compileCreate();
                break;
            }
            case 4: {
                cs = this.compileAlter();
                break;
            }
            case 88: {
                cs = this.compileDrop();
                break;
            }
            case 121: 
            case 239: {
                cs = this.compileGrantOrRevoke();
                break;
            }
            case 576: {
                cs = this.compileComment();
                break;
            }
            case 602: {
                cs = this.compileLock();
                break;
            }
            case 47: {
                cs = this.compileConnect();
                break;
            }
            case 84: {
                cs = this.compileDisconnect();
                break;
            }
            case 627: {
                cs = this.compileScript();
                break;
            }
            case 629: {
                cs = this.compileShutdown();
                break;
            }
            case 562: {
                cs = this.compileBackup();
                break;
            }
            case 572: {
                cs = this.compileCheckpoint();
                break;
            }
            case 588: {
                int position = this.getPosition();
                cs = this.compileExplainPlan();
                cs.setSQL(this.getLastPart(position));
                break;
            }
            case 77: {
                cs = this.compileDeclare();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        switch (cs.type) {
            case 11: 
            case 62: 
            case 1093: 
            case 1151: {
                break;
            }
            default: {
                cs.setSQL(this.getLastPart());
            }
        }
        if (this.token.tokenType == 821) {
            this.read();
        } else if (this.token.tokenType == 872) {
            // empty if block
        }
        return cs;
    }

    private Statement compileDeclare() {
        Statement cs = this.compileDeclareLocalTableOrNull();
        if (cs != null) {
            return cs;
        }
        ColumnSchema[] variables = this.readLocalVariableDeclarationOrNull();
        if (variables != null) {
            Object[] args = new Object[]{variables};
            cs = new StatementSession(1127, args);
            return cs;
        }
        cs = this.compileDeclareCursorOrNull(RangeGroup.emptyArray, false);
        if (cs == null) {
            throw this.lastError == null ? this.unexpectedToken() : this.lastError;
        }
        return cs;
    }

    private Statement compileScript() {
        String name = null;
        this.read();
        if (this.token.tokenType == 869) {
            name = this.readQuotedString();
        }
        HsqlNameManager.HsqlName[] names = this.database.schemaManager.getCatalogAndBaseTableNames();
        Object[] args = new Object[]{name};
        return new StatementCommand(1004, args, null, names);
    }

    private Statement compileConnect() {
        String password = null;
        this.read();
        this.readThis(305);
        this.checkIsSimpleName();
        String userName = this.token.tokenString;
        this.read();
        if (!this.session.isProcessingLog()) {
            this.readThis(616);
            password = this.readPassword();
        }
        Expression[] args = new Expression[]{new ExpressionValue(userName, Type.SQL_VARCHAR), new ExpressionValue(password, Type.SQL_VARCHAR)};
        StatementSession cs = new StatementSession(76, args);
        return cs;
    }

    private StatementCommand compileSetDefault() {
        this.read();
        switch (this.token.tokenType) {
            case 599: {
                this.read();
                this.readThis(497);
                HsqlNameManager.HsqlName schema = this.database.schemaManager.getSchemaHsqlName(this.token.tokenString);
                this.read();
                Object[] args = new Object[]{schema};
                return new StatementCommand(1034, args);
            }
            case 236: {
                this.read();
                this.readThis(608);
                this.readThis(245);
                Integer size = this.readIntegerObject();
                Object[] args = new Object[]{size};
                return new StatementCommand(1046, args);
            }
            case 278: {
                int type;
                this.read();
                this.readThis(535);
                switch (this.token.tokenType) {
                    case 608: {
                        type = 4;
                        break;
                    }
                    case 570: {
                        type = 5;
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                this.read();
                Object[] args = new Object[]{ValuePool.getInt(type)};
                return new StatementCommand(1035, args);
            }
            case 424: {
                int level;
                this.read();
                this.readThis(432);
                switch (this.token.tokenType) {
                    case 480: {
                        this.read();
                        this.readThis(365);
                        level = 2;
                        break;
                    }
                    case 506: {
                        this.read();
                        level = 8;
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                Object[] args = new Object[]{ValuePool.getInt(level)};
                return new StatementCommand(1053, args);
            }
        }
        throw this.unexpectedToken();
    }

    private StatementCommand compileSetProperty() {
        Object value;
        this.read();
        this.checkIsSimpleName();
        this.checkIsDelimitedIdentifier();
        String property = this.token.tokenString;
        this.read();
        if (this.token.tokenType == 294) {
            value = Boolean.TRUE;
        } else if (this.token.tokenType == 106) {
            value = Boolean.FALSE;
        } else {
            this.checkIsValue();
            value = this.token.tokenValue;
        }
        this.read();
        Object[] args = new Object[]{property, value};
        return new StatementCommand(1039, args);
    }

    private Statement compileSet() {
        int position = super.getPosition();
        this.read();
        switch (this.token.tokenType) {
            case 348: {
                this.read();
                Expression e = this.XreadValueSpecificationOrNull();
                if (e == null) {
                    HsqlNameManager.HsqlName name = this.readSchemaName();
                    Object[] args = new Object[]{name};
                    return new StatementSession(66, args);
                }
                if (!e.getDataType().isCharacterType()) {
                    throw Error.error(2200);
                }
                if (!(e.getType() == 1 || e.getType() == 28 && ((FunctionSQL)e).isValueFunction())) {
                    throw Error.error(2200);
                }
                Expression[] args = new Expression[]{e};
                return new StatementSession(66, args);
            }
            case 497: {
                this.read();
                Expression e = this.XreadValueSpecificationOrNull();
                if (e == null) {
                    HsqlNameManager.HsqlName name = this.readSchemaName();
                    Object[] args = new Object[]{name};
                    return new StatementSession(74, args);
                }
                if (!e.getDataType().isCharacterType()) {
                    throw Error.error(2200);
                }
                if (!(e.getType() == 1 || e.getType() == 28 && ((FunctionSQL)e).isValueFunction())) {
                    throw Error.error(2200);
                }
                Expression[] args = new Expression[]{e};
                return new StatementSession(74, args);
            }
            case 180: {
                this.read();
                this.readThis(358);
                HsqlArrayList charsets = null;
                if (this.readIfThis(112)) {
                    charsets = new HsqlArrayList();
                    while (true) {
                        SchemaObject charset = this.readSchemaObjectName(14);
                        charsets.add(charset);
                        if (this.token.tokenType != 804) break;
                        this.read();
                    }
                }
                Object[] args = new Object[]{null, Boolean.FALSE, charsets};
                return new StatementSession(136, args);
            }
            case 358: {
                this.read();
                Expression e = this.XreadValueSpecificationOrNull();
                if (e == null || !e.getDataType().isCharacterType()) {
                    throw Error.error(4650);
                }
                HsqlArrayList charsets = null;
                if (this.readIfThis(112)) {
                    charsets = new HsqlArrayList();
                    while (true) {
                        SchemaObject charset = this.readSchemaObjectName(14);
                        charsets.add(charset);
                        if (this.token.tokenType != 804) break;
                        this.read();
                    }
                }
                Object[] args = new Object[]{e, Boolean.TRUE, charsets};
                return new StatementSession(136, args);
            }
            case 281: {
                this.read();
                return this.compileSetTimeZone();
            }
            case 490: {
                this.read();
                return this.compileSetRole();
            }
            case 508: {
                this.read();
                return this.compileSessionSettings();
            }
            case 526: {
                this.read();
                Object[] args = this.processTransactionCharacteristics();
                if (args[0] == null && args[1] == null) {
                    throw this.unexpectedToken();
                }
                return new StatementSession(75, args);
            }
            case 560: {
                this.read();
                Boolean mode = this.processTrueOrFalseObject();
                Object[] args = new Object[]{mode};
                return new StatementSession(1114, args);
            }
            case 621: {
                this.read();
                Boolean readonly = this.processTrueOrFalseObject();
                Object[] args = new Object[]{readonly};
                return new StatementSession(109, args);
            }
            case 595: {
                this.read();
                Boolean mode = this.processTrueOrFalseObject();
                Object[] args = new Object[]{mode};
                return new StatementSession(1048, args);
            }
            case 606: {
                this.read();
                Integer size = this.readIntegerObject();
                Object[] args = new Object[]{size};
                return new StatementSession(1116, args);
            }
            case 78: {
                int type;
                this.read();
                this.readThis(278);
                this.readThis(535);
                switch (this.token.tokenType) {
                    case 608: {
                        type = 4;
                        break;
                    }
                    case 570: {
                        type = 5;
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                this.read();
                Object[] args = new Object[]{ValuePool.getInt(type)};
                return new StatementCommand(1035, args);
            }
            case 278: {
                return this.compileSetTable();
            }
            case 637: {
                this.read();
                int delay = 0;
                if (this.token.tokenType == 294) {
                    delay = this.database.getProperties().getDefaultWriteDelay();
                    this.read();
                } else if (this.token.tokenType == 106) {
                    delay = 0;
                    this.read();
                } else {
                    delay = this.readInteger();
                    if (delay < 0) {
                        delay = 0;
                    }
                    if (this.token.tokenType == 609) {
                        this.read();
                    } else {
                        delay *= 1000;
                    }
                }
                Object[] args = new Object[]{new Integer(delay)};
                return new StatementCommand(1033, args, null, null);
            }
            case 616: {
                boolean isDigest = false;
                this.read();
                if (this.readIfThis(586)) {
                    isDigest = true;
                }
                String password = this.readPassword();
                Object[] args = new Object[]{null, password, isDigest};
                StatementCommand cs = new StatementCommand(1093, args);
                String sql = User.getSetCurrentPasswordDigestSQL(this.database.granteeManager, password, isDigest);
                cs.setSQL(sql);
                return cs;
            }
            case 599: {
                this.read();
                this.readThis(497);
                HsqlNameManager.HsqlName schema = this.token.tokenType == 78 ? null : this.database.schemaManager.getSchemaHsqlName(this.token.tokenString);
                this.read();
                Object[] args = new Object[]{null, schema};
                return new StatementCommand(1092, args);
            }
            case 591: {
                return this.compileSetFilesProperty();
            }
            case 582: {
                return this.compileSetDatabaseProperty();
            }
            case 619: {
                return this.compileSetProperty();
            }
        }
        return this.compileSetStatement(this.session.sessionContext.sessionVariableRangeGroups, this.session.sessionContext.sessionVariablesRange);
    }

    StatementCommand compileSetTable() {
        this.read();
        Table table = this.readTableName();
        Object[] args = new Object[]{table.getName(), null};
        switch (this.token.tokenType) {
            default: {
                throw this.unexpectedToken();
            }
            case 513: {
                this.read();
                return this.compileTableSource(table);
            }
            case 480: {
                this.read();
                boolean readonly = false;
                if (this.token.tokenType == 547) {
                    this.read();
                } else {
                    this.readThis(195);
                    readonly = true;
                }
                args[1] = readonly;
                return new StatementCommand(1154, args, null, new HsqlNameManager.HsqlName[]{table.getName()});
            }
            case 621: {
                this.read();
                Boolean readonly = this.processTrueOrFalseObject();
                args[1] = readonly;
                return new StatementCommand(1154, args, null, new HsqlNameManager.HsqlName[]{table.getName()});
            }
            case 598: {
                this.read();
                this.checkIsValue();
                String value = this.token.tokenString;
                this.read();
                args[1] = value;
                return new StatementCommand(1153, args, null, new HsqlNameManager.HsqlName[]{table.getName()});
            }
            case 535: {
                int newType;
                this.read();
                switch (this.token.tokenType) {
                    case 608: {
                        newType = 4;
                        break;
                    }
                    case 570: {
                        newType = 5;
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                switch (table.getTableType()) {
                    case 4: 
                    case 5: {
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                this.read();
                args[1] = new Integer(newType);
                return new StatementCommand(1157, args, null, new HsqlNameManager.HsqlName[]{table.getName()});
            }
            case 575: {
                this.read();
                this.readThis(194);
                OrderedHashSet set = new OrderedHashSet();
                this.readThis(816);
                this.readSimpleColumnNames(set, table, false);
                this.readThis(802);
                int[] colIndex = table.getColumnIndexes(set);
                args[1] = colIndex;
                return new StatementCommand(1158, args, null, new HsqlNameManager.HsqlName[]{table.getName()});
            }
            case 179: {
                this.read();
                this.readThis(514);
                args = new Object[]{table.getName()};
                HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
                return new StatementCommand(1159, args, null, writeLockNames);
            }
            case 514: 
        }
        this.read();
        Integer id = super.readIntegerObject();
        args = new Object[]{table.getName(), id};
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementCommand(1160, args, null, writeLockNames);
    }

    StatementCommand compileSetDatabaseProperty() {
        this.read();
        this.checkDatabaseUpdateAuthorisation();
        switch (this.token.tokenType) {
            case 561: {
                this.read();
                this.readThis(117);
                Routine routine = this.readCreateDatabaseAuthenticationFunction();
                Object[] args = new Object[]{routine};
                return new StatementCommand(1036, args, null, null);
            }
            case 358: {
                Boolean padSpace = null;
                this.read();
                this.checkIsSimpleName();
                String name = this.token.tokenString;
                this.read();
                if (this.readIfThis(180)) {
                    this.readThis(463);
                    padSpace = Boolean.FALSE;
                } else if (this.readIfThis(463)) {
                    this.readThis(514);
                    padSpace = Boolean.TRUE;
                }
                if (padSpace == null) {
                    padSpace = this.session.isProcessingScript() && this.database.getProperties().isVersion18() ? Boolean.FALSE : Boolean.TRUE;
                }
                Object[] args = new Object[]{name, padSpace};
                return new StatementCommand(1047, args, null, null);
            }
            case 78: {
                return this.compileSetDefault();
            }
            case 587: {
                this.read();
                this.readThis(703);
                boolean sqlLog = this.readIfThis(261);
                this.readThis(432);
                Integer value = this.readIntegerObject();
                Object[] args = new Object[]{value, sqlLog};
                return new StatementCommand(1016, args, null, null);
            }
            case 593: {
                this.read();
                Integer size = this.readIntegerObject();
                Object[] args = new Object[]{size};
                return new StatementCommand(1037, args, null, null);
            }
            case 616: {
                this.read();
                switch (this.token.tokenType) {
                    case 37: {
                        this.read();
                        this.readThis(117);
                        Routine routine = this.readCreatePasswordCheckFunction();
                        Object[] args = new Object[]{routine};
                        return new StatementCommand(1040, args, null, null);
                    }
                    case 586: {
                        this.read();
                        String name = this.readQuotedString();
                        Object[] args = new Object[]{name};
                        return new StatementCommand(1056, args, null, null);
                    }
                }
                throw this.unexpectedToken();
            }
            case 622: {
                this.read();
                this.readThis(597);
                boolean mode = this.processTrueOrFalse();
                Object[] args = new Object[]{mode};
                return new StatementCommand(1049, args, null, null);
            }
            case 261: {
                this.read();
                int type = 1050;
                Boolean flag = Boolean.TRUE;
                Integer value = 0;
                String property = null;
                switch (this.token.tokenType) {
                    case 446: {
                        this.read();
                        property = "sql.enforce_names";
                        flag = this.processTrueOrFalseObject();
                        break;
                    }
                    case 623: {
                        this.read();
                        this.readThis(446);
                        property = "sql.regular_names";
                        flag = this.processTrueOrFalseObject();
                        break;
                    }
                    case 222: {
                        this.read();
                        flag = this.processTrueOrFalseObject();
                        property = "sql.enforce_refs";
                        break;
                    }
                    case 512: {
                        this.read();
                        flag = this.processTrueOrFalseObject();
                        property = "sql.enforce_size";
                        break;
                    }
                    case 635: {
                        this.read();
                        flag = this.processTrueOrFalseObject();
                        property = "sql.enforce_types";
                        break;
                    }
                    case 631: {
                        this.read();
                        if (this.readIfThis(79)) {
                            property = "sql.enforce_tdc_delete";
                        } else {
                            this.readThis(303);
                            property = "sql.enforce_tdc_update";
                        }
                        flag = this.processTrueOrFalseObject();
                        break;
                    }
                    case 287: {
                        this.read();
                        this.readThis(634);
                        this.readThis(635);
                        flag = this.processTrueOrFalseObject();
                        property = "jdbc.translate_tti_types";
                        break;
                    }
                    case 656: {
                        this.read();
                        this.readThis(451);
                        flag = this.processTrueOrFalseObject();
                        property = "sql.concat_nulls";
                        break;
                    }
                    case 451: {
                        this.read();
                        if (this.readIfThis(401)) {
                            property = "sql.nulls_first";
                        } else {
                            this.readThis(198);
                            property = "sql.nulls_order";
                        }
                        flag = this.processTrueOrFalseObject();
                        break;
                    }
                    case 299: {
                        this.read();
                        this.readThis(451);
                        flag = this.processTrueOrFalseObject();
                        property = "sql.unique_nulls";
                        break;
                    }
                    case 49: {
                        this.read();
                        this.readThis(295);
                        flag = this.processTrueOrFalseObject();
                        property = "sql.convert_trunc";
                        break;
                    }
                    case 16: {
                        this.read();
                        this.readThis(496);
                        value = this.readIntegerObject();
                        property = "sql.avg_scale";
                        break;
                    }
                    case 87: {
                        this.read();
                        this.readThis(611);
                        flag = this.processTrueOrFalseObject();
                        property = "sql.double_nan";
                        break;
                    }
                    case 605: {
                        this.read();
                        this.readThis(142);
                        this.readThis(702);
                        flag = this.processTrueOrFalseObject();
                        property = "sql.longvar_is_lob";
                        break;
                    }
                    case 595: {
                        this.read();
                        flag = this.processTrueOrFalseObject();
                        property = "sql.ignore_case";
                        break;
                    }
                    case 630: {
                        this.read();
                        if (this.token.tokenString.equals("DB2")) {
                            this.read();
                            property = "sql.syntax_db2";
                        } else if (this.token.tokenString.equals("MSS")) {
                            this.read();
                            property = "sql.syntax_mss";
                        } else if (this.token.tokenString.equals("MYS")) {
                            this.read();
                            property = "sql.syntax_mys";
                        } else if (this.token.tokenString.equals("ORA")) {
                            this.read();
                            property = "sql.syntax_ora";
                        } else if (this.token.tokenString.equals("PGS")) {
                            this.read();
                            property = "sql.syntax_pgs";
                        } else {
                            throw this.unexpectedToken();
                        }
                        flag = this.processTrueOrFalseObject();
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                Object[] args = new Object[]{property, flag, value};
                return new StatementCommand(type, args, null, null);
            }
            case 633: {
                this.read();
                this.readThis(278);
                this.readThis(381);
                String source = this.readQuotedString();
                Object[] args = new Object[]{source};
                return new StatementCommand(1051, args, null, null);
            }
            case 526: {
                this.read();
                if (this.readIfThis(241)) {
                    this.readThis(194);
                    if (!this.readIfThis(583)) {
                        this.readThis(579);
                    }
                    Boolean mode = this.processTrueOrFalseObject();
                    StatementCommand cs = new StatementCommand(1054, new Object[]{mode}, null, null);
                    return cs;
                }
                this.readThis(580);
                int mode = 0;
                switch (this.token.tokenType) {
                    case 711: {
                        this.read();
                        mode = 2;
                        break;
                    }
                    case 712: {
                        this.read();
                        mode = 1;
                        break;
                    }
                    case 603: {
                        this.read();
                        mode = 0;
                    }
                }
                HsqlNameManager.HsqlName[] names = this.database.schemaManager.getCatalogAndBaseTableNames();
                Object[] args = new Object[]{ValuePool.getInt(mode)};
                StatementCommand cs = new StatementCommand(1052, args, null, names);
                return cs;
            }
            case 299: {
                this.read();
                this.readThis(445);
                this.isUndelimitedSimpleName();
                String name = this.token.tokenString;
                this.read();
                if (name.length() != 16) {
                    throw Error.error(5555);
                }
                if (!Charset.isInSet(name, Charset.unquotedIdentifier) || !Charset.startsWith(name, Charset.uppercaseLetters)) {
                    throw Error.error(5501);
                }
                Object[] args = new Object[]{name};
                return new StatementCommand(1055, args, null, null);
            }
        }
        throw this.unexpectedToken();
    }

    StatementCommand compileSetFilesProperty() {
        this.read();
        int type = 0;
        Boolean flag = null;
        Integer value = null;
        Boolean mode = null;
        HsqlNameManager.HsqlName[] names = this.database.schemaManager.getCatalogNameArray();
        this.checkDatabaseUpdateAuthorisation();
        switch (this.token.tokenType) {
            case 37: {
                this.read();
                long longValue = this.readBigint();
                type = 1014;
                names = this.database.schemaManager.getCatalogNameArray();
                if (this.readIfThis(804)) {
                    this.readBigint();
                }
                Object[] args = new Object[]{longValue, 0L};
                return new StatementCommand(type, args, null, names);
            }
            case 569: {
                this.read();
                if (this.readIfThis(512)) {
                    value = this.readIntegerObject();
                    type = 1013;
                } else {
                    this.readThis(245);
                    value = this.readIntegerObject();
                    type = 1012;
                }
                if (!this.readIfThis(180)) break;
                this.readThis(37);
                mode = Boolean.TRUE;
                break;
            }
            case 496: {
                this.read();
                value = this.readIntegerObject();
                type = 1025;
                names = this.database.schemaManager.getCatalogAndBaseTableNames();
                break;
            }
            case 514: {
                this.read();
                if (this.token.tokenType == 294) {
                    flag = Boolean.TRUE;
                    this.read();
                } else if (this.token.tokenType == 106) {
                    flag = Boolean.FALSE;
                    this.read();
                } else {
                    value = this.readIntegerObject();
                }
                type = 1031;
                names = this.database.schemaManager.getCatalogAndBaseTableNames();
                break;
            }
            case 702: {
                this.read();
                if (this.readIfThis(496)) {
                    value = this.readIntegerObject();
                    type = 1017;
                } else {
                    this.readThis(578);
                    type = 1018;
                    flag = this.processTrueOrFalseObject();
                }
                names = this.database.schemaManager.getCatalogAndBaseTableNames();
                break;
            }
            case 584: {
                this.read();
                type = 1015;
                value = this.readIntegerObject();
                break;
            }
            case 715: {
                this.read();
                if (this.readIfThis(512)) {
                    value = this.readIntegerObject();
                } else {
                    flag = this.processTrueOrFalseObject();
                }
                type = 1022;
                break;
            }
            case 562: {
                this.read();
                type = 1011;
                this.readThis(417);
                flag = this.processTrueOrFalseObject();
                break;
            }
            case 703: {
                this.read();
                if (this.readIfThis(512)) {
                    type = 1021;
                    value = this.readIntegerObject();
                    break;
                }
                type = 1020;
                flag = this.processTrueOrFalseObject();
                break;
            }
            case 632: {
                this.read();
                this.readThis(472);
                type = 1032;
                value = this.readIntegerObject();
                break;
            }
            case 547: {
                this.read();
                this.readThis(585);
                type = 1033;
                int delay = 0;
                if (this.token.tokenType == 294) {
                    delay = this.database.getProperties().getDefaultWriteDelay();
                    this.read();
                } else if (this.token.tokenType == 106) {
                    delay = 0;
                    this.read();
                } else {
                    delay = this.readInteger();
                    if (delay < 0) {
                        delay = 0;
                    }
                    if (this.token.tokenType == 609) {
                        this.read();
                    } else {
                        delay *= 1000;
                    }
                }
                value = new Integer(delay);
                break;
            }
            case 627: {
                this.read();
                this.readThis(592);
                if (this.token.tokenType == 633) {
                    this.read();
                    value = new Integer(0);
                } else {
                    this.readThis(578);
                    value = new Integer(3);
                }
                type = 1026;
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        Object[] args = new Object[]{flag == null ? (Constable)value : (Constable)flag, mode};
        return new StatementCommand(type, args, null, names);
    }

    Object[] processTransactionCharacteristics() {
        int level = 0;
        boolean readonly = false;
        Object[] args = new Object[2];
        block10: while (true) {
            switch (this.token.tokenType) {
                case 480: {
                    if (args[0] != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.token.tokenType == 195) {
                        this.read();
                        readonly = true;
                    } else {
                        this.readThis(547);
                        readonly = false;
                    }
                    args[0] = readonly;
                    continue block10;
                }
                case 424: {
                    if (args[1] != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(432);
                    switch (this.token.tokenType) {
                        case 506: {
                            this.read();
                            level = 8;
                            break;
                        }
                        case 480: {
                            this.read();
                            if (this.token.tokenType == 365) {
                                this.read();
                                level = 2;
                                break;
                            }
                            if (this.token.tokenType == 537) {
                                this.read();
                                level = 1;
                                break;
                            }
                            throw this.unexpectedToken();
                        }
                        case 482: {
                            this.read();
                            this.readThis(480);
                            level = 4;
                            break;
                        }
                        default: {
                            throw this.unexpectedToken();
                        }
                    }
                    args[1] = new Integer(level);
                    continue block10;
                }
                case 804: {
                    if (args[0] == null && args[1] == null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    continue block10;
                }
            }
            break;
        }
        if (!readonly && level == 1) {
            throw this.unexpectedToken("WRITE");
        }
        return args;
    }

    private Statement compileCommit() {
        boolean chain = false;
        this.read();
        this.readIfThis(546);
        if (this.token.tokenType == 5) {
            this.read();
            if (this.token.tokenType == 180) {
                this.read();
            } else {
                chain = true;
            }
            this.readThis(350);
        }
        String sql = chain ? StatementSession.commitAndChainStatement.sql : StatementSession.commitNoChainStatement.sql;
        StatementSession st = new StatementSession(11, new Object[]{chain});
        st.setSQL(sql);
        return st;
    }

    private Statement compileStartTransaction() {
        this.read();
        this.readThis(526);
        Object[] args = this.processTransactionCharacteristics();
        StatementSession cs = new StatementSession(111, args);
        return cs;
    }

    private Statement compileLock() {
        this.read();
        if (this.readIfThis(348)) {
            return this.compileLockCatalog();
        }
        this.readThis(278);
        return this.compileLockTable();
    }

    private Statement compileLockCatalog() {
        boolean isLock = this.processTrueOrFalse();
        int statementType = isLock ? 1111 : 1112;
        HsqlNameManager.HsqlName[] writeTableNames = isLock ? this.database.schemaManager.getCatalogAndBaseTableNames() : null;
        StatementSession cs = new StatementSession(statementType, null, writeTableNames);
        return cs;
    }

    private Statement compileLockTable() {
        OrderedHashSet readSet = new OrderedHashSet();
        OrderedHashSet writeSet = new OrderedHashSet();
        while (true) {
            Table table = this.readTableName();
            switch (this.token.tokenType) {
                case 480: {
                    this.read();
                    readSet.add(table.getName());
                    break;
                }
                case 547: {
                    this.read();
                    writeSet.add(table.getName());
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
            if (this.token.tokenType != 804) break;
            this.read();
        }
        Object[] writeTableNames = new HsqlNameManager.HsqlName[writeSet.size()];
        writeSet.toArray(writeTableNames);
        readSet.removeAll(writeTableNames);
        Object[] readTableNames = new HsqlNameManager.HsqlName[readSet.size()];
        readSet.toArray(readTableNames);
        StatementSession cs = new StatementSession(1113, (HsqlNameManager.HsqlName[])readTableNames, (HsqlNameManager.HsqlName[])writeTableNames);
        return cs;
    }

    private Statement compileRollback() {
        boolean chain = false;
        String savepoint = null;
        this.read();
        if (this.token.tokenType == 546) {
            this.read();
        }
        if (this.token.tokenType == 285) {
            this.read();
            this.readThis(246);
            this.checkIsSimpleName();
            savepoint = this.token.tokenString;
            this.read();
            String sql = this.getLastPart();
            Object[] args = new Object[]{savepoint};
            StatementSession cs = new StatementSession(1118, args);
            return cs;
        }
        if (this.token.tokenType == 5) {
            this.read();
            if (this.token.tokenType == 180) {
                this.read();
            } else {
                chain = true;
            }
            this.readThis(350);
        }
        String sql = chain ? StatementSession.rollbackAndChainStatement.sql : StatementSession.rollbackNoChainStatement.sql;
        StatementSession st = new StatementSession(62, new Object[]{chain});
        st.setSQL(sql);
        return st;
    }

    private Statement compileSavepoint() {
        this.read();
        this.checkIsSimpleName();
        String name = this.token.tokenString;
        this.read();
        String sql = this.getLastPart();
        Object[] args = new Object[]{name};
        return new StatementSession(63, args);
    }

    private Statement compileReleaseSavepoint() {
        this.read();
        this.readThis(246);
        String name = this.token.tokenString;
        this.read();
        String sql = this.getLastPart();
        Object[] args = new Object[]{name};
        return new StatementSession(57, args);
    }

    private Statement compileSessionSettings() {
        switch (this.token.tokenType) {
            case 354: {
                this.read();
                this.readThis(10);
                this.readThis(526);
                Object[] args = this.processTransactionCharacteristics();
                return new StatementSession(109, args);
            }
            case 15: {
                this.read();
                Expression e = this.XreadValueSpecificationOrNull();
                if (e == null) {
                    throw Error.error(5584);
                }
                e.resolveTypes(this.session, null);
                if (e.isUnresolvedParam()) {
                    e.dataType = Type.SQL_VARCHAR;
                }
                if (e.dataType == null || !e.dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                Expression[] args = new Expression[]{e, null};
                return new StatementSession(76, args);
            }
            case 236: {
                this.read();
                this.readThis(608);
                this.readThis(245);
                Integer size = this.readIntegerObject();
                Object[] args = new Object[]{size};
                return new StatementSession(1117, args);
            }
            case 589: {
                this.read();
                String feature = this.parseSQLFeatureValue();
                Boolean value = this.processTrueOrFalseObject();
                Object[] args = new Object[]{feature, value};
                return new StatementSession(1115, args);
            }
        }
        throw this.unexpectedToken();
    }

    private Statement compileSetRole() {
        Expression e;
        if (this.token.tokenType == 181) {
            this.read();
            e = new ExpressionValue(null, Type.SQL_VARCHAR);
        } else {
            e = this.XreadValueSpecificationOrNull();
            if (e == null) {
                throw Error.error(4100);
            }
            if (!e.getDataType().isCharacterType()) {
                throw Error.error(2200);
            }
            if (!(e.getType() == 1 || e.getType() == 28 && ((FunctionSQL)e).isValueFunction())) {
                throw Error.error(2200);
            }
        }
        String sql = this.getLastPart();
        return new StatementSession(73, new Expression[]{e});
    }

    private Statement compileSetTimeZone() {
        Expression e;
        this.readThis(549);
        if (this.token.tokenType == 157) {
            this.read();
            e = new ExpressionValue(null, Type.SQL_INTERVAL_HOUR_TO_MINUTE);
        } else {
            e = this.XreadIntervalValueExpression();
            HsqlList unresolved = e.resolveColumnReferences(this.session, RangeGroup.emptyGroup, RangeGroup.emptyArray, null);
            ExpressionColumn.checkColumnsResolved(unresolved);
            e.resolveTypes(this.session, null);
            if (e.dataType == null) {
                throw Error.error(5563);
            }
            if (e.dataType.typeCode != 111) {
                throw Error.error(5563);
            }
        }
        String sql = this.getLastPart();
        return new StatementSession(71, new Expression[]{e});
    }

    private Statement compileShutdown() {
        this.session.checkAdmin();
        int closemode = 2;
        this.read();
        switch (this.token.tokenType) {
            case 596: {
                closemode = 1;
                this.read();
                break;
            }
            case 577: {
                closemode = 3;
                this.read();
                break;
            }
            case 627: {
                closemode = 4;
                this.read();
            }
        }
        if (this.token.tokenType == 821) {
            this.read();
        }
        if (this.token.tokenType != 872) {
            throw this.unexpectedToken();
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{new Integer(closemode)};
        StatementCommand cs = new StatementCommand(1003, args, null, null);
        return cs;
    }

    private Statement compileBackup() {
        Boolean blockingMode = null;
        Boolean scriptMode = null;
        Boolean compression = null;
        Boolean files = null;
        this.read();
        this.readThis(582);
        this.readThis(285);
        String path = this.readQuotedString();
        path = path.trim();
        if (path.length() == 0) {
            throw this.unexpectedToken(path);
        }
        block7: while (true) {
            switch (this.token.tokenType) {
                case 566: {
                    if (blockingMode != null) {
                        throw this.unexpectedToken();
                    }
                    blockingMode = Boolean.TRUE;
                    this.read();
                    continue block7;
                }
                case 627: {
                    if (scriptMode != null) {
                        throw this.unexpectedToken();
                    }
                    scriptMode = Boolean.TRUE;
                    this.read();
                    continue block7;
                }
                case 578: {
                    if (compression != null) {
                        throw this.unexpectedToken();
                    }
                    compression = Boolean.TRUE;
                    this.read();
                    continue block7;
                }
                case 183: {
                    this.read();
                    if (this.token.tokenType == 578) {
                        if (compression != null) {
                            throw this.unexpectedToken();
                        }
                        compression = Boolean.FALSE;
                        this.read();
                        continue block7;
                    }
                    if (this.token.tokenType == 566) {
                        if (blockingMode != null) {
                            throw this.unexpectedToken();
                        }
                        blockingMode = Boolean.FALSE;
                        this.read();
                        continue block7;
                    }
                    throw this.unexpectedToken();
                }
                case 10: {
                    if (files != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(591);
                    files = Boolean.TRUE;
                    continue block7;
                }
            }
            break;
        }
        if (scriptMode == null) {
            scriptMode = Boolean.FALSE;
        }
        if (blockingMode == null) {
            blockingMode = Boolean.TRUE;
        }
        if (compression == null) {
            compression = Boolean.TRUE;
        }
        if (files == null) {
            files = Boolean.FALSE;
        }
        if (scriptMode.booleanValue() && !blockingMode.booleanValue()) {
            throw this.unexpectedToken("NOT");
        }
        HsqlNameManager.HsqlName[] names = blockingMode != false ? this.database.schemaManager.getCatalogAndBaseTableNames() : HsqlNameManager.HsqlName.emptyArray;
        Object[] args = new Object[]{path, blockingMode, scriptMode, compression, files};
        StatementCommand cs = new StatementCommand(1001, args, null, names);
        return cs;
    }

    private Statement compileCheckpoint() {
        boolean defrag = false;
        this.read();
        if (this.token.tokenType == 584) {
            defrag = true;
            this.read();
        } else if (this.token.tokenType == 821) {
            this.read();
        }
        if (this.token.tokenType != 872) {
            throw this.unexpectedToken();
        }
        HsqlNameManager.HsqlName[] names = this.database.schemaManager.getCatalogAndBaseTableNames();
        Object[] args = new Object[]{defrag};
        StatementCommand cs = new StatementCommand(1002, args, null, names);
        return cs;
    }

    public static Statement getAutoCheckpointStatement(Database database) {
        HsqlNameManager.HsqlName[] names = database.schemaManager.getCatalogAndBaseTableNames();
        Object[] args = new Object[]{Boolean.FALSE};
        StatementCommand cs = new StatementCommand(1002, args, null, names);
        cs.setCompileTimestamp(database.txManager.getGlobalChangeTimestamp());
        cs.setSQL("CHECKPOINT");
        return cs;
    }

    private Statement compileDisconnect() {
        this.read();
        String sql = "DISCONNECT";
        StatementSession cs = new StatementSession(22, (Object[])null);
        return cs;
    }

    private Statement compileExplainPlan() {
        this.read();
        this.readThis(617);
        this.readThis(112);
        Statement cs = this.compilePart(0);
        cs.setDescribe();
        return new StatementCommand(1151, new Object[]{cs});
    }

    private StatementCommand compileTableSource(Table t) {
        String source;
        String sql;
        boolean isSourceHeader = false;
        boolean isDesc = false;
        Object[] args = new Object[5];
        args[0] = t.getName();
        if (!t.isText()) {
            HsqlException e = Error.error(321);
        }
        if (this.token.tokenType == 194) {
            this.read();
            sql = this.getLastPart();
            args[1] = Boolean.TRUE;
            return new StatementCommand(1155, args, null, new HsqlNameManager.HsqlName[]{t.getName()});
        }
        if (this.token.tokenType == 615) {
            this.read();
            sql = this.getLastPart();
            args[1] = Boolean.FALSE;
            return new StatementCommand(1155, args, null, new HsqlNameManager.HsqlName[]{t.getName()});
        }
        if (this.token.tokenType == 594) {
            this.read();
            isSourceHeader = true;
        }
        if (this.token.tokenType == 871) {
            source = this.token.tokenString;
            this.read();
        } else {
            source = this.readQuotedString();
        }
        if (!isSourceHeader && this.token.tokenType == 389) {
            isDesc = true;
            this.read();
        }
        sql = this.getLastPart();
        args[2] = source;
        args[3] = isDesc;
        args[4] = isSourceHeader;
        int type = isSourceHeader ? 1156 : 1155;
        return new StatementCommand(type, args, null, new HsqlNameManager.HsqlName[]{t.getName()});
    }
}

