/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.RangeVariableResolver;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Scanner;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.Statement;
import org.hsqldb.StatementCommand;
import org.hsqldb.StatementDML;
import org.hsqldb.StatementDMQL;
import org.hsqldb.StatementInsert;
import org.hsqldb.StatementProcedure;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.Token;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.map.ValuePool;
import org.hsqldb.types.Type;

public class ParserDML
extends ParserDQL {
    ParserDML(Session session, Scanner scanner) {
        super(session, scanner, null);
    }

    StatementDMQL compileInsertStatement(RangeGroup[] rangeGroups) {
        boolean[] updateColumnCheckList = null;
        int[] updateColumnMap = ValuePool.emptyIntArray;
        boolean overridingUser = false;
        boolean overridingSystem = false;
        boolean assignsToIdentity = false;
        boolean hasColumnList = false;
        int isSpecial = 0;
        Expression[] updateExpressions = Expression.emptyArray;
        Object[] targets = null;
        if (this.database.sqlSyntaxMys) {
            if (this.readIfThis(729)) {
                isSpecial = 2;
            }
            if (isSpecial == 0) {
                this.readThis(135);
                if (this.readIfThis(413)) {
                    isSpecial = 1;
                }
            }
            this.readIfThis(141);
        } else {
            this.readThis(135);
            this.readThis(141);
        }
        Token tableToken = this.getRecordedToken();
        RangeVariable range = this.readRangeVariableForDataChange(50);
        range.resolveRangeTableTypes(this.session, RangeVariable.emptyArray);
        Table table = range.getTable();
        boolean[] insertColumnCheckList = null;
        int[] insertColumnMap = table.getColumnMap();
        int colCount = table.getColumnCount();
        int position = this.getPosition();
        Table baseTable = table.isTriggerInsertable() ? table : table.getBaseTable();
        switch (this.token.tokenType) {
            case 78: {
                this.read();
                this.readThis(308);
                Expression insertExpressions = new Expression(25, new Expression[0]);
                insertExpressions = new Expression(26, new Expression[]{insertExpressions});
                insertColumnCheckList = table.getNewColumnCheckList();
                StatementInsert cs = new StatementInsert(this.session, table, insertColumnMap, insertExpressions, insertColumnCheckList, updateExpressions, updateColumnCheckList, updateColumnMap, null, isSpecial, this.compileContext);
                return cs;
            }
            case 816: {
                int brackets = this.readOpenBrackets();
                if (brackets == 1) {
                    boolean isQuery = false;
                    switch (this.token.tokenType) {
                        case 251: 
                        case 278: 
                        case 319: {
                            this.rewind(position);
                            isQuery = true;
                            break;
                        }
                    }
                    if (isQuery) break;
                    OrderedHashSet columnNames = new OrderedHashSet();
                    boolean withPrefix = this.database.sqlSyntaxOra;
                    this.readSimpleColumnNames(columnNames, range, withPrefix);
                    this.readThis(802);
                    colCount = columnNames.size();
                    insertColumnMap = table.getColumnIndexes(columnNames);
                    hasColumnList = true;
                    if (this.token.tokenType != 308 && this.token.tokenType != 461) {
                        break;
                    }
                } else {
                    this.rewind(position);
                    break;
                }
            }
            case 461: {
                if (this.token.tokenType == 461) {
                    this.read();
                    if (this.token.tokenType == 305) {
                        this.read();
                        overridingUser = true;
                    } else if (this.token.tokenType == 276) {
                        this.read();
                        overridingSystem = true;
                    } else {
                        throw this.unexpectedToken();
                    }
                    this.readThis(307);
                    if (this.token.tokenType != 308) break;
                }
            }
            case 308: {
                this.read();
                insertColumnCheckList = table.getColumnCheckList(insertColumnMap);
                Expression insertExpressions = this.XreadContextuallyTypedTable(colCount);
                HsqlList unresolved = insertExpressions.resolveColumnReferences(this.session, RangeGroup.emptyGroup, rangeGroups, null);
                ExpressionColumn.checkColumnsResolved(unresolved);
                insertExpressions.resolveTypes(this.session, null);
                ParserDML.setParameterTypes(insertExpressions, table, insertColumnMap);
                if (table != baseTable) {
                    int[] baseColumnMap = table.getBaseTableColumnMap();
                    int[] newColumnMap = new int[insertColumnMap.length];
                    ArrayUtil.projectRow(baseColumnMap, insertColumnMap, newColumnMap);
                    insertColumnMap = newColumnMap;
                }
                Expression[] rowList = insertExpressions.nodes;
                for (int j = 0; j < rowList.length; ++j) {
                    Expression[] rowArgs = rowList[j].nodes;
                    for (int i = 0; i < rowArgs.length; ++i) {
                        Expression e = rowArgs[i];
                        ColumnSchema column = baseTable.getColumn(insertColumnMap[i]);
                        if (column.isIdentity()) {
                            assignsToIdentity = true;
                            if (e.getType() != 4) {
                                if (baseTable.identitySequence.isAlways() && !overridingUser && !overridingSystem) {
                                    throw Error.error(5543);
                                }
                                if (overridingUser) {
                                    rowArgs[i] = new ExpressionColumn(4);
                                }
                            }
                        } else if (!column.hasDefault() && column.isGenerated() && e.getType() != 4) {
                            throw Error.error(5541);
                        }
                        if (!e.isUnresolvedParam()) continue;
                        e.setAttributesAsColumn(column, true);
                    }
                }
                if (!assignsToIdentity && (overridingUser || overridingSystem)) {
                    throw this.unexpectedTokenRequire("OVERRIDING");
                }
                if (!hasColumnList) {
                    tableToken.setWithColumnList();
                }
                if (this.database.sqlSyntaxMys && isSpecial == 0 && this.readIfThis(194)) {
                    this.readThis(798);
                    this.readThis(427);
                    this.readThis(303);
                    OrderedHashSet targetSet = new OrderedHashSet();
                    LongDeque colIndexList = new LongDeque();
                    HsqlArrayList exprList = new HsqlArrayList();
                    RangeVariable[] rangeVariables = new RangeVariable[]{range};
                    RangeGroup.RangeGroupSimple rangeGroup = new RangeGroup.RangeGroupSimple(rangeVariables, false);
                    isSpecial = 3;
                    this.readSetClauseList(rangeVariables, targetSet, colIndexList, exprList);
                    updateColumnMap = new int[colIndexList.size()];
                    colIndexList.toArray(updateColumnMap);
                    targets = new Expression[targetSet.size()];
                    targetSet.toArray(targets);
                    for (int i = 0; i < targets.length; ++i) {
                        this.resolveOuterReferencesAndTypes(rangeGroups, (Expression)targets[i]);
                    }
                    updateColumnCheckList = table.getColumnCheckList(updateColumnMap);
                    updateExpressions = new Expression[exprList.size()];
                    exprList.toArray(updateExpressions);
                    this.resolveUpdateExpressions(table, rangeGroup, updateColumnMap, updateExpressions, rangeGroups);
                }
                StatementInsert cs = new StatementInsert(this.session, table, insertColumnMap, insertExpressions, insertColumnCheckList, updateExpressions, updateColumnCheckList, updateColumnMap, (Expression[])targets, isSpecial, this.compileContext);
                return cs;
            }
            case 251: 
            case 278: 
            case 319: {
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        insertColumnCheckList = table.getColumnCheckList(insertColumnMap);
        if (table != baseTable) {
            int[] baseColumnMap = table.getBaseTableColumnMap();
            int[] newColumnMap = new int[insertColumnMap.length];
            ArrayUtil.projectRow(baseColumnMap, insertColumnMap, newColumnMap);
            insertColumnMap = newColumnMap;
        }
        int enforcedDefaultIndex = baseTable.getIdentityColumnIndex();
        int overrideIndex = -1;
        if (enforcedDefaultIndex != -1 && ArrayUtil.find(insertColumnMap, enforcedDefaultIndex) > -1) {
            if (baseTable.identitySequence.isAlways() && !overridingUser && !overridingSystem) {
                throw Error.error(5543);
            }
            if (overridingUser) {
                overrideIndex = enforcedDefaultIndex;
            }
        } else if (overridingUser || overridingSystem) {
            throw this.unexpectedTokenRequire("OVERRIDING");
        }
        Object[] types = new Type[insertColumnMap.length];
        ArrayUtil.projectRow(baseTable.getColumnTypes(), insertColumnMap, types);
        this.compileContext.setOuterRanges(rangeGroups);
        QueryExpression queryExpression = this.XreadQueryExpression();
        queryExpression.setReturningResult();
        queryExpression.resolve(this.session, rangeGroups, (Type[])types);
        if (colCount != queryExpression.getColumnCount()) {
            throw Error.error(5546);
        }
        if (!hasColumnList) {
            tableToken.setWithColumnList();
        }
        StatementInsert cs = new StatementInsert(this.session, table, insertColumnMap, insertColumnCheckList, queryExpression, isSpecial, overrideIndex, this.compileContext);
        return cs;
    }

    private static void setParameterTypes(Expression tableExpression, Table table, int[] columnMap) {
        for (int i = 0; i < tableExpression.nodes.length; ++i) {
            Expression[] list = tableExpression.nodes[i].nodes;
            for (int j = 0; j < list.length; ++j) {
                if (!list[j].isUnresolvedParam()) continue;
                list[j].setAttributesAsColumn(table.getColumn(columnMap[j]), true);
            }
        }
    }

    Statement compileTruncateStatement() {
        boolean isTable = false;
        boolean withCommit = false;
        boolean noCheck = false;
        boolean restartIdentity = false;
        HsqlNameManager.HsqlName objectName = null;
        RangeVariable[] rangeVariables = null;
        Table table = null;
        HsqlNameManager.HsqlName[] writeTableNames = null;
        RangeVariable targetRange = null;
        this.readThis(295);
        if (this.token.tokenType == 278) {
            this.readThis(278);
            targetRange = this.readRangeVariableForDataChange(1215);
            rangeVariables = new RangeVariable[]{targetRange};
            table = rangeVariables[0].getTable();
            objectName = table.getName();
            isTable = true;
        } else {
            this.readThis(497);
            objectName = this.readSchemaName();
        }
        switch (this.token.tokenType) {
            case 376: {
                this.read();
                this.readThis(128);
                break;
            }
            case 484: {
                this.read();
                this.readThis(128);
                restartIdentity = true;
            }
        }
        if (!isTable) {
            this.checkIsThis(5);
        }
        if (this.readIfThis(5)) {
            this.readThis(44);
            withCommit = true;
            if (this.readIfThis(180)) {
                this.readThis(37);
                noCheck = true;
            }
        }
        writeTableNames = isTable ? new HsqlNameManager.HsqlName[]{table.getName()} : this.session.database.schemaManager.getCatalogAndBaseTableNames();
        if (withCommit) {
            Object[] args = new Object[]{objectName, restartIdentity, noCheck};
            return new StatementCommand(1215, args, null, writeTableNames);
        }
        StatementDML cs = new StatementDML(this.session, table, targetRange, rangeVariables, this.compileContext, restartIdentity, 1215, null);
        return cs;
    }

    Statement compileDeleteStatement(RangeGroup[] rangeGroups) {
        Table baseTable;
        Expression condition = null;
        boolean restartIdentity = false;
        this.readThis(79);
        this.readThis(115);
        RangeVariable targetRange = this.readRangeVariableForDataChange(19);
        RangeVariable[] rangeVariables = new RangeVariable[]{targetRange};
        RangeGroup.RangeGroupSimple rangeGroup = new RangeGroup.RangeGroupSimple(rangeVariables, false);
        Table table = rangeVariables[0].getTable();
        this.compileContext.setOuterRanges(rangeGroups);
        if (this.token.tokenType == 316) {
            this.read();
            condition = this.XreadAndResolveBooleanValueExpression(rangeGroups, rangeGroup);
        }
        SortAndSlice sortAndSlice = null;
        if (this.token.tokenType == 601) {
            sortAndSlice = this.XreadOrderByExpression();
        }
        Table table2 = baseTable = table.isTriggerDeletable() ? table : table.getBaseTable();
        if (table != baseTable) {
            QuerySpecification baseSelect = table.getQueryExpression().getMainSelect();
            if (condition != null) {
                condition = condition.replaceColumnReferences(rangeVariables[0], baseSelect.exprColumns);
            }
            condition = ExpressionLogical.andExpressions(baseSelect.queryCondition, condition);
            rangeVariables = baseSelect.rangeVariables;
            ArrayUtil.fillArray(rangeVariables[0].usedColumns, true);
        }
        if (condition != null) {
            rangeVariables[0].addJoinCondition(condition);
            RangeVariableResolver resolver = new RangeVariableResolver(this.session, rangeVariables, null, this.compileContext, false);
            resolver.processConditions();
            rangeVariables = resolver.rangeVariables;
        }
        for (int i = 0; i < rangeVariables.length; ++i) {
            rangeVariables[i].resolveRangeTableTypes(this.session, RangeVariable.emptyArray);
        }
        StatementDML cs = new StatementDML(this.session, table, targetRange, rangeVariables, this.compileContext, restartIdentity, 19, sortAndSlice);
        return cs;
    }

    StatementDMQL compileUpdateStatement(RangeGroup[] rangeGroups) {
        this.read();
        OrderedHashSet targetSet = new OrderedHashSet();
        LongDeque colIndexList = new LongDeque();
        HsqlArrayList exprList = new HsqlArrayList();
        RangeVariable targetRange = this.readRangeVariableForDataChange(82);
        RangeVariable[] rangeVariables = new RangeVariable[]{targetRange};
        RangeGroup.RangeGroupSimple rangeGroup = new RangeGroup.RangeGroupSimple(rangeVariables, false);
        Table table = rangeVariables[0].rangeTable;
        Table baseTable = table.isTriggerUpdatable() ? table : table.getBaseTable();
        this.readThis(254);
        this.readSetClauseList(rangeVariables, targetSet, colIndexList, exprList);
        int[] columnMap = new int[colIndexList.size()];
        colIndexList.toArray(columnMap);
        Object[] targets = new Expression[targetSet.size()];
        targetSet.toArray(targets);
        for (int i = 0; i < targets.length; ++i) {
            this.resolveOuterReferencesAndTypes(rangeGroups, (Expression)targets[i]);
        }
        boolean[] columnCheckList = table.getColumnCheckList(columnMap);
        Expression[] updateExpressions = new Expression[exprList.size()];
        exprList.toArray(updateExpressions);
        Expression condition = null;
        if (this.token.tokenType == 316) {
            this.read();
            condition = this.XreadAndResolveBooleanValueExpression(rangeGroups, rangeGroup);
        }
        SortAndSlice sortAndSlice = null;
        if (this.token.tokenType == 601) {
            sortAndSlice = this.XreadOrderByExpression();
        }
        this.resolveUpdateExpressions(table, rangeGroup, columnMap, updateExpressions, rangeGroups);
        if (table != baseTable) {
            QuerySpecification baseSelect = ((TableDerived)table).getQueryExpression().getMainSelect();
            if (condition != null) {
                condition = condition.replaceColumnReferences(rangeVariables[0], baseSelect.exprColumns);
            }
            for (int i = 0; i < updateExpressions.length; ++i) {
                updateExpressions[i] = updateExpressions[i].replaceColumnReferences(rangeVariables[0], baseSelect.exprColumns);
            }
            condition = ExpressionLogical.andExpressions(baseSelect.queryCondition, condition);
            rangeVariables = baseSelect.rangeVariables;
            ArrayUtil.fillArray(rangeVariables[0].usedColumns, true);
        }
        if (condition != null) {
            rangeVariables[0].addJoinCondition(condition);
            RangeVariableResolver resolver = new RangeVariableResolver(this.session, rangeVariables, null, this.compileContext, false);
            resolver.processConditions();
            rangeVariables = resolver.rangeVariables;
        }
        for (int i = 0; i < rangeVariables.length; ++i) {
            rangeVariables[i].resolveRangeTableTypes(this.session, RangeVariable.emptyArray);
        }
        if (table != baseTable) {
            int[] baseColumnMap = table.getBaseTableColumnMap();
            int[] newColumnMap = new int[columnMap.length];
            ArrayUtil.projectRow(baseColumnMap, columnMap, newColumnMap);
            columnMap = newColumnMap;
            for (int i = 0; i < columnMap.length; ++i) {
                if (!baseTable.colGenerated[columnMap[i]]) continue;
                throw Error.error(5513);
            }
        }
        StatementDML cs = new StatementDML(this.session, (Expression[])targets, table, targetRange, rangeVariables, columnMap, updateExpressions, columnCheckList, this.compileContext, sortAndSlice);
        return cs;
    }

    Expression XreadAndResolveBooleanValueExpression(RangeGroup[] rangeGroups, RangeGroup rangeGroup) {
        Expression condition = this.XreadBooleanValueExpression();
        HsqlList unresolved = condition.resolveColumnReferences(this.session, rangeGroup, rangeGroups, null);
        ExpressionColumn.checkColumnsResolved(unresolved);
        condition.resolveTypes(this.session, null);
        if (condition.isUnresolvedParam()) {
            condition.dataType = Type.SQL_BOOLEAN;
        }
        if (condition.getDataType() != Type.SQL_BOOLEAN) {
            throw Error.error(5568);
        }
        return condition;
    }

    void resolveUpdateExpressions(Table targetTable, RangeGroup rangeGroup, int[] columnMap, Expression[] colExpressions, RangeGroup[] rangeGroups) {
        HsqlList unresolved = null;
        int enforcedDefaultIndex = -1;
        if (targetTable.hasIdentityColumn() && targetTable.identitySequence.isAlways()) {
            enforcedDefaultIndex = targetTable.getIdentityColumnIndex();
        }
        int i = 0;
        int ix = 0;
        while (i < columnMap.length) {
            Expression e;
            int j;
            Expression expr = colExpressions[ix];
            if (targetTable.colGenerated[columnMap[i]]) {
                throw Error.error(5513);
            }
            if (expr.getType() == 25) {
                Expression[] elements = expr.nodes;
                j = 0;
                while (j < elements.length) {
                    e = elements[j];
                    if (enforcedDefaultIndex == columnMap[i] && e.getType() != 4) {
                        throw Error.error(5541);
                    }
                    if (e.isUnresolvedParam()) {
                        e.setAttributesAsColumn(targetTable.getColumn(columnMap[i]), true);
                    } else if (e.getType() != 4) {
                        unresolved = expr.resolveColumnReferences(this.session, rangeGroup, rangeGroups, null);
                        ExpressionColumn.checkColumnsResolved(unresolved);
                        unresolved = null;
                        e.resolveTypes(this.session, null);
                    }
                    ++j;
                    ++i;
                }
            } else if (expr.getType() == 22) {
                unresolved = expr.resolveColumnReferences(this.session, rangeGroup, rangeGroups, null);
                ExpressionColumn.checkColumnsResolved(unresolved);
                expr.resolveTypes(this.session, null);
                int count = expr.table.queryExpression.getColumnCount();
                j = 0;
                while (j < count) {
                    if (enforcedDefaultIndex == columnMap[i]) {
                        throw Error.error(5541);
                    }
                    ++j;
                    ++i;
                }
            } else {
                e = expr;
                if (enforcedDefaultIndex == columnMap[i] && e.getType() != 4) {
                    throw Error.error(5541);
                }
                if (e.isUnresolvedParam()) {
                    e.setAttributesAsColumn(targetTable.getColumn(columnMap[i]), true);
                } else if (e.getType() != 4) {
                    unresolved = expr.resolveColumnReferences(this.session, rangeGroup, rangeGroups, null);
                    ExpressionColumn.checkColumnsResolved(unresolved);
                    e.resolveTypes(this.session, null);
                }
                ++i;
            }
            ++ix;
        }
    }

    void readSetClauseList(RangeVariable[] rangeVars, OrderedHashSet targets, LongDeque colIndexList, HsqlArrayList expressions) {
        while (true) {
            Expression e;
            int degree;
            if (this.token.tokenType == 816) {
                this.read();
                int oldCount = targets.size();
                this.readTargetSpecificationList(targets, rangeVars, colIndexList);
                degree = targets.size() - oldCount;
                this.readThis(802);
            } else {
                Expression target = this.XreadTargetSpecification(rangeVars, colIndexList);
                if (!targets.add(target)) {
                    ColumnSchema col = target.getColumn();
                    throw Error.error(5579, col.getName().name);
                }
                degree = 1;
            }
            this.readThis(396);
            int position = this.getPosition();
            int brackets = this.readOpenBrackets();
            if (this.token.tokenType == 251) {
                this.rewind(position);
                TableDerived td = this.XreadSubqueryTableBody(22);
                QueryExpression qe = td.getQueryExpression();
                qe.setReturningResult();
                if (degree != qe.getColumnCount()) {
                    throw Error.error(5546);
                }
                Expression e2 = new Expression(22, td);
                expressions.add(e2);
                if (this.token.tokenType != 804) break;
                this.read();
                continue;
            }
            if (brackets > 0) {
                this.rewind(position);
            }
            if (degree > 1) {
                int rowDegree;
                this.readThis(816);
                e = this.readRow();
                this.readThis(802);
                int n = rowDegree = e.getType() == 25 ? e.nodes.length : 1;
                if (degree != rowDegree) {
                    throw Error.error(5546);
                }
                expressions.add(e);
            } else {
                e = this.XreadValueExpressionWithContext();
                expressions.add(e);
            }
            if (this.token.tokenType != 804) break;
            this.read();
        }
    }

    void readGetClauseList(RangeVariable[] rangeVars, OrderedHashSet targets, LongDeque colIndexList, HsqlArrayList expressions) {
        while (true) {
            Expression target;
            if (!targets.add(target = this.XreadTargetSpecification(rangeVars, colIndexList))) {
                ColumnSchema col = target.getColumn();
                throw Error.error(5579, col.getName().name);
            }
            this.readThis(396);
            switch (this.token.tokenType) {
                case 443: 
                case 495: {
                    int columnIndex = ExpressionColumn.diagnosticsList.getIndex(this.token.tokenString);
                    ExpressionColumn e = new ExpressionColumn(10, columnIndex);
                    expressions.add(e);
                    this.read();
                }
            }
            if (this.token.tokenType != 804) break;
            this.read();
        }
    }

    StatementDMQL compileMergeStatement(RangeGroup[] rangeGroups) {
        int[] insertColumnMap = null;
        int[] updateColumnMap = null;
        Object[] targets = null;
        HsqlArrayList updateList = new HsqlArrayList();
        Expression[] updateExpressions = Expression.emptyArray;
        HsqlArrayList insertList = new HsqlArrayList();
        Expression insertExpression = null;
        this.read();
        this.readThis(141);
        RangeVariable targetRange = this.readRangeVariableForDataChange(128);
        Table table = targetRange.rangeTable;
        this.readThis(306);
        this.compileContext.setOuterRanges(rangeGroups);
        RangeVariable sourceRange = this.readTableOrSubquery();
        RangeVariable[] targetRanges = new RangeVariable[]{targetRange};
        sourceRange.resolveRangeTable(this.session, new RangeGroup.RangeGroupSimple(targetRanges, false), rangeGroups);
        sourceRange.resolveRangeTableTypes(this.session, targetRanges);
        this.compileContext.setOuterRanges(RangeGroup.emptyArray);
        RangeVariable[] fullRangeVars = new RangeVariable[]{sourceRange, targetRange};
        RangeVariable[] sourceRangeVars = new RangeVariable[]{sourceRange};
        RangeVariable[] targetRangeVars = new RangeVariable[]{targetRange};
        RangeGroup.RangeGroupSimple fullRangeGroup = new RangeGroup.RangeGroupSimple(fullRangeVars, false);
        RangeGroup.RangeGroupSimple sourceRangeGroup = new RangeGroup.RangeGroupSimple(sourceRangeVars, false);
        this.readThis(194);
        Expression mergeCondition = this.XreadAndResolveBooleanValueExpression(rangeGroups, fullRangeGroup);
        insertColumnMap = table.getColumnMap();
        boolean[] insertColumnCheckList = table.getNewColumnCheckList();
        OrderedHashSet updateTargetSet = new OrderedHashSet();
        OrderedHashSet insertColNames = new OrderedHashSet();
        LongDeque updateColIndexList = new LongDeque();
        Expression[] conditions = new Expression[3];
        boolean deleteFirst = false;
        this.readMergeWhen(rangeGroups, fullRangeGroup, updateColIndexList, insertColNames, updateTargetSet, insertList, updateList, targetRangeVars, sourceRange, conditions);
        if (conditions[2] != null) {
            deleteFirst = true;
        }
        if (this.token.tokenType == 314) {
            this.readMergeWhen(rangeGroups, fullRangeGroup, updateColIndexList, insertColNames, updateTargetSet, insertList, updateList, targetRangeVars, sourceRange, conditions);
        }
        if (conditions[1] == null && conditions[2] != null) {
            deleteFirst = true;
        }
        if (this.token.tokenType == 314) {
            this.readMergeWhen(rangeGroups, fullRangeGroup, updateColIndexList, insertColNames, updateTargetSet, insertList, updateList, targetRangeVars, sourceRange, conditions);
        }
        if (conditions[1] == null && conditions[2] != null) {
            deleteFirst = true;
        }
        if (insertList.size() > 0) {
            int colCount = insertColNames.size();
            if (colCount != 0) {
                insertColumnMap = table.getColumnIndexes(insertColNames);
                insertColumnCheckList = table.getColumnCheckList(insertColumnMap);
            }
            insertExpression = (Expression)insertList.get(0);
            ParserDML.setParameterTypes(insertExpression, table, insertColumnMap);
            if (conditions[0] == null) {
                conditions[0] = Expression.EXPR_TRUE;
            }
        }
        if (updateList.size() > 0) {
            targets = new Expression[updateTargetSet.size()];
            updateTargetSet.toArray(targets);
            for (int i = 0; i < targets.length; ++i) {
                this.resolveOuterReferencesAndTypes(rangeGroups, (Expression)targets[i]);
            }
            updateExpressions = new Expression[updateList.size()];
            updateList.toArray(updateExpressions);
            updateColumnMap = new int[updateColIndexList.size()];
            updateColIndexList.toArray(updateColumnMap);
            if (conditions[1] == null) {
                conditions[1] = Expression.EXPR_TRUE;
            }
        }
        if (updateExpressions.length != 0) {
            Table baseTable = table.isTriggerUpdatable() ? table : table.getBaseTable();
            int[] baseUpdateColumnMap = updateColumnMap;
            if (table != baseTable) {
                baseUpdateColumnMap = new int[updateColumnMap.length];
                ArrayUtil.projectRow(table.getBaseTableColumnMap(), updateColumnMap, baseUpdateColumnMap);
            }
            this.resolveUpdateExpressions(table, fullRangeGroup, updateColumnMap, updateExpressions, rangeGroups);
        }
        HsqlList unresolved = null;
        unresolved = mergeCondition.resolveColumnReferences(this.session, fullRangeGroup, rangeGroups, null);
        ExpressionColumn.checkColumnsResolved(unresolved);
        mergeCondition.resolveTypes(this.session, null);
        if (mergeCondition.isUnresolvedParam()) {
            mergeCondition.dataType = Type.SQL_BOOLEAN;
        }
        if (mergeCondition.getDataType() != Type.SQL_BOOLEAN) {
            throw Error.error(5568);
        }
        fullRangeVars[1].addJoinCondition(mergeCondition);
        RangeVariableResolver resolver = new RangeVariableResolver(this.session, fullRangeVars, null, this.compileContext, false);
        resolver.processConditions();
        fullRangeVars = resolver.rangeVariables;
        for (int i = 0; i < fullRangeVars.length; ++i) {
            fullRangeVars[i].resolveRangeTableTypes(this.session, RangeVariable.emptyArray);
        }
        if (insertExpression != null) {
            unresolved = insertExpression.resolveColumnReferences(this.session, sourceRangeGroup, RangeGroup.emptyArray, null);
            unresolved = Expression.resolveColumnSet(this.session, RangeVariable.emptyArray, rangeGroups, unresolved);
            ExpressionColumn.checkColumnsResolved(unresolved);
            insertExpression.resolveTypes(this.session, null);
        }
        StatementDML cs = new StatementDML(this.session, (Expression[])targets, sourceRange, targetRange, fullRangeVars, insertColumnMap, updateColumnMap, insertColumnCheckList, mergeCondition, insertExpression, updateExpressions, deleteFirst, conditions[0], conditions[1], conditions[2], this.compileContext);
        return cs;
    }

    private void readMergeWhen(RangeGroup[] rangeGroups, RangeGroup rangeGroup, LongDeque updateColIndexList, OrderedHashSet insertColumnNames, OrderedHashSet updateTargetSet, HsqlArrayList insertExpressions, HsqlArrayList updateExpressions, RangeVariable[] targetRangeVars, RangeVariable sourceRangeVar, Expression[] conditions) {
        Table table = targetRangeVars[0].rangeTable;
        int columnCount = table.getColumnCount();
        Expression condition = null;
        this.readThis(314);
        if (this.token.tokenType == 437) {
            this.read();
            if (this.readIfThis(5)) {
                condition = this.XreadAndResolveBooleanValueExpression(rangeGroups, rangeGroup);
            }
            this.readThis(280);
            if (this.readIfThis(303)) {
                if (updateExpressions.size() != 0) {
                    throw Error.error(5547);
                }
                conditions[1] = condition;
                this.readThis(254);
                this.readSetClauseList(targetRangeVars, updateTargetSet, updateColIndexList, updateExpressions);
            } else {
                if (conditions[2] != null) {
                    throw Error.error(5547);
                }
                if (condition == null) {
                    condition = Expression.EXPR_TRUE;
                }
                conditions[2] = condition;
                this.readThis(79);
            }
        } else if (this.token.tokenType == 183) {
            if (insertExpressions.size() != 0) {
                throw Error.error(5548);
            }
            this.read();
            this.readThis(437);
            if (this.readIfThis(5)) {
                condition = this.XreadAndResolveBooleanValueExpression(rangeGroups, rangeGroup);
            }
            conditions[0] = condition;
            this.readThis(280);
            this.readThis(135);
            int brackets = this.readOpenBrackets();
            if (brackets == 1) {
                boolean withPrefix = this.database.sqlSyntaxOra;
                this.readSimpleColumnNames(insertColumnNames, targetRangeVars[0], withPrefix);
                columnCount = insertColumnNames.size();
                this.readThis(802);
                brackets = 0;
            }
            this.readThis(308);
            Expression e = this.XreadContextuallyTypedTable(columnCount);
            if (e.nodes.length != 1) {
                throw Error.error(3201);
            }
            insertExpressions.add(e);
        } else {
            throw this.unexpectedToken();
        }
    }

    StatementDMQL compileCallStatement(RangeGroup[] rangeGroups, boolean isStrictlyProcedure) {
        RoutineSchema routineSchema;
        this.read();
        if (this.isIdentifier() && (routineSchema = (RoutineSchema)this.database.schemaManager.findSchemaObject(this.session, this.token.tokenString, this.token.namePrefix, this.token.namePrePrefix, 17)) != null) {
            this.read();
            return this.compileProcedureCall(rangeGroups, routineSchema);
        }
        if (isStrictlyProcedure) {
            throw Error.error(5501, this.token.tokenString);
        }
        Expression expression = this.XreadValueExpression();
        HsqlList unresolved = expression.resolveColumnReferences(this.session, RangeGroup.emptyGroup, rangeGroups, null);
        ExpressionColumn.checkColumnsResolved(unresolved);
        expression.resolveTypes(this.session, null);
        StatementProcedure cs = new StatementProcedure(this.session, expression, this.compileContext);
        return cs;
    }

    StatementDMQL compileProcedureCall(RangeGroup[] rangeGroups, RoutineSchema routineSchema) {
        int i;
        HsqlArrayList list = new HsqlArrayList();
        boolean bracket = true;
        if (this.database.sqlSyntaxOra) {
            bracket = this.readIfThis(816);
        } else {
            this.readThis(816);
        }
        if (bracket) {
            if (this.token.tokenType == 802) {
                this.read();
            } else {
                while (true) {
                    Expression e = this.XreadValueExpression();
                    list.add(e);
                    if (this.token.tokenType != 804) break;
                    this.read();
                }
                this.readThis(802);
            }
        }
        Expression[] arguments = new Expression[list.size()];
        list.toArray(arguments);
        Routine routine = routineSchema.getSpecificRoutine(arguments.length);
        this.compileContext.addProcedureCall(routine);
        HsqlList unresolved = null;
        for (i = 0; i < arguments.length; ++i) {
            Expression e = arguments[i];
            if (e.isUnresolvedParam()) {
                e.setAttributesAsColumn(routine.getParameter(i), routine.getParameter(i).isWriteable());
                continue;
            }
            byte paramMode = routine.getParameter(i).getParameterMode();
            unresolved = arguments[i].resolveColumnReferences(this.session, RangeGroup.emptyGroup, rangeGroups, unresolved);
            if (paramMode == 1 || e.getType() == 6) continue;
            throw Error.error(5603);
        }
        ExpressionColumn.checkColumnsResolved(unresolved);
        for (i = 0; i < arguments.length; ++i) {
            arguments[i].resolveTypes(this.session, null);
            if (routine.getParameter(i).getDataType().canBeAssignedFrom(arguments[i].getDataType())) continue;
            throw Error.error(5561);
        }
        StatementProcedure cs = new StatementProcedure(this.session, routine, arguments, this.compileContext);
        return cs;
    }

    void resolveOuterReferencesAndTypes(RangeGroup[] rangeGroups, Expression e) {
        HsqlList unresolved = e.resolveColumnReferences(this.session, RangeGroup.emptyGroup, 0, rangeGroups, null, false);
        ExpressionColumn.checkColumnsResolved(unresolved);
        e.resolveTypes(this.session, null);
    }
}

