/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionSQL;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserDML;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeGroup;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.StatementQuery;
import org.hsqldb.StatementSchema;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.TableUtil;
import org.hsqldb.TableWorks;
import org.hsqldb.TextTable;
import org.hsqldb.Token;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.Type;

public class ParserTable
extends ParserDML {
    ParserTable(Session session, Scanner scanner) {
        super(session, scanner);
    }

    StatementSchema compileCreateTable(int type) {
        Table table;
        boolean ifNot = false;
        if (this.token.tokenType == 412) {
            int position = this.getPosition();
            this.read();
            if (this.token.tokenType == 183) {
                this.read();
                this.readThis(101);
                ifNot = true;
            } else {
                this.rewind(position);
            }
        }
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(3, false);
        name.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        switch (type) {
            case 6: 
            case 7: {
                table = new TextTable(this.database, name, type);
                break;
            }
            default: {
                table = new Table(this.database, name, type);
            }
        }
        if (this.token.tokenType == 10) {
            return this.compileCreateTableAsSubqueryDefinition(table);
        }
        return this.compileCreateTableBody(table, ifNot);
    }

    StatementSchema compileCreateTableBody(Table table, boolean ifNot) {
        HsqlArrayList tempConstraints = new HsqlArrayList();
        HsqlArrayList tempIndexes = new HsqlArrayList();
        boolean isTable = this.readTableContentsSource(table, tempConstraints, tempIndexes);
        if (!isTable) {
            return this.compileCreateTableAsSubqueryDefinition(table);
        }
        this.readTableOnCommitClause(table);
        if (this.database.sqlSyntaxMys && this.readIfThis(576)) {
            String comment;
            this.readIfThis(396);
            table.getName().comment = comment = this.readQuotedString();
        }
        OrderedHashSet names = new OrderedHashSet();
        names.add(this.database.getCatalogName());
        for (int i = 0; i < tempConstraints.size(); ++i) {
            Table t;
            Constraint c = (Constraint)tempConstraints.get(i);
            HsqlNameManager.HsqlName name = c.getMainTableName();
            if (name == null || (t = this.database.schemaManager.findUserTable(null, name.name, name.schema.name)) == null || t.isTemp()) continue;
            names.add(table.getName());
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{table, tempConstraints, tempIndexes, null, ifNot};
        Object[] writeLockNames = new HsqlNameManager.HsqlName[names.size()];
        names.toArray(writeLockNames);
        return new StatementSchema(sql, 77, args, null, (HsqlNameManager.HsqlName[])writeLockNames);
    }

    boolean readTableContentsSource(Table table, HsqlArrayList tempConstraints, HsqlArrayList tempIndexes) {
        int position = this.getPosition();
        this.readThis(816);
        Constraint c = new Constraint(null, null, 5);
        tempConstraints.add(c);
        boolean start = true;
        boolean startPart = true;
        boolean end = false;
        block7: while (!end) {
            switch (this.token.tokenType) {
                case 154: {
                    ColumnSchema[] likeColumns = this.readLikeTable(table);
                    for (int i = 0; i < likeColumns.length; ++i) {
                        table.addColumn(likeColumns[i]);
                    }
                    start = false;
                    startPart = false;
                    continue block7;
                }
                case 37: 
                case 48: 
                case 113: 
                case 214: 
                case 299: {
                    if (!startPart) {
                        throw this.unexpectedToken();
                    }
                    this.readConstraint(table, tempConstraints);
                    start = false;
                    startPart = false;
                    continue block7;
                }
                case 804: {
                    if (startPart) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    startPart = true;
                    continue block7;
                }
                case 802: {
                    this.read();
                    end = true;
                    continue block7;
                }
                case 427: 
                case 598: {
                    if (!this.database.sqlSyntaxMys) break;
                    this.readIndex(table, tempIndexes);
                    start = false;
                    startPart = false;
                    continue block7;
                }
            }
            if (!startPart) {
                throw this.unexpectedToken();
            }
            this.checkIsSchemaObjectName();
            HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newColumnHsqlName(table.getName(), this.token.tokenString, this.isDelimitedIdentifier());
            this.read();
            ColumnSchema newcolumn = this.readColumnDefinitionOrNull(table, hsqlName, tempConstraints);
            if (newcolumn == null) {
                if (start) {
                    this.rewind(position);
                    return false;
                }
                throw Error.error(5000);
            }
            table.addColumn(newcolumn);
            start = false;
            startPart = false;
        }
        if (table.getColumnCount() == 0) {
            throw Error.error(5591);
        }
        return true;
    }

    void readTableOnCommitClause(Table table) {
        if (this.token.tokenType == 194) {
            if (!table.isTemp()) {
                throw this.unexpectedToken();
            }
            this.read();
            this.readThis(44);
            if (this.token.tokenType != 79 && this.token.tokenType == 476) {
                table.persistenceScope = 23;
            }
            this.read();
            this.readThis(245);
        }
    }

    private ColumnSchema[] readLikeTable(Table table) {
        this.read();
        boolean generated = false;
        boolean identity = false;
        boolean defaults = false;
        Table likeTable = this.readTableName();
        OrderedIntHashSet set = new OrderedIntHashSet();
        while (true) {
            boolean including;
            boolean bl = including = this.token.tokenType == 416;
            if (!including && this.token.tokenType != 399) break;
            this.read();
            switch (this.token.tokenType) {
                case 407: {
                    if (!set.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    generated = including;
                    break;
                }
                case 128: {
                    if (!set.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    identity = including;
                    break;
                }
                case 381: {
                    if (!set.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    defaults = including;
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
            this.read();
        }
        ColumnSchema[] columnList = new ColumnSchema[likeTable.getColumnCount()];
        for (int i = 0; i < columnList.length; ++i) {
            ColumnSchema column = likeTable.getColumn(i).duplicate();
            HsqlNameManager.HsqlName name = this.database.nameManager.newColumnSchemaHsqlName(table.getName(), column.getName());
            column.setName(name);
            column.setPrimaryKey(false);
            if (identity) {
                if (column.isIdentity()) {
                    column.setIdentity(column.getIdentitySequence().duplicate());
                }
            } else {
                column.setIdentity(null);
            }
            if (!defaults) {
                column.setDefaultExpression(null);
            }
            if (!generated) {
                column.setGeneratingExpression(null);
            }
            columnList[i] = column;
        }
        return columnList;
    }

    StatementSchema compileCreateTableAsSubqueryDefinition(Table table) {
        HsqlNameManager.HsqlName[] readName = null;
        boolean withData = true;
        HsqlNameManager.HsqlName[] columnNames = null;
        StatementQuery statement = null;
        if (this.token.tokenType == 816) {
            columnNames = this.readColumnNames(table.getName());
        }
        this.readThis(10);
        this.readThis(816);
        QueryExpression queryExpression = this.XreadQueryExpression();
        queryExpression.setReturningResult();
        queryExpression.resolve(this.session);
        this.readThis(802);
        this.readThis(319);
        if (this.token.tokenType == 180) {
            this.read();
            withData = false;
        } else if (table.getTableType() == 7) {
            throw this.unexpectedTokenRequire("NO");
        }
        this.readThis(378);
        if (this.token.tokenType == 194) {
            if (!table.isTemp()) {
                throw this.unexpectedToken();
            }
            this.read();
            this.readThis(44);
            if (this.token.tokenType != 79 && this.token.tokenType == 476) {
                table.persistenceScope = 23;
            }
            this.read();
            this.readThis(245);
        }
        if (columnNames == null) {
            columnNames = queryExpression.getResultColumnNames();
        } else if (columnNames.length != queryExpression.getColumnCount()) {
            throw Error.error(5593);
        }
        TableUtil.setColumnsInSchemaTable(table, columnNames, queryExpression.getColumnTypes());
        table.createPrimaryKey();
        if (table.isTemp() && table.hasLobColumn()) {
            throw Error.error(5534);
        }
        if (withData) {
            statement = new StatementQuery(this.session, queryExpression, this.compileContext);
            readName = statement.getTableNamesForRead();
        }
        Object[] args = new Object[]{table, new HsqlArrayList(), null, statement, Boolean.FALSE};
        String sql = this.getLastPart();
        HsqlNameManager.HsqlName[] writeLockNames = this.database.schemaManager.catalogNameArray;
        StatementSchema st = new StatementSchema(sql, 77, args, readName, writeLockNames);
        return st;
    }

    static Table addTableConstraintDefinitions(Session session, Table table, HsqlArrayList tempConstraints, HsqlArrayList constraintList, boolean addToSchema) {
        Constraint c = (Constraint)tempConstraints.get(0);
        String namePart = c.getName() == null ? null : c.getName().name;
        HsqlNameManager.HsqlName indexName = session.database.nameManager.newAutoName("IDX", namePart, table.getSchemaName(), table.getName(), 20);
        c.setColumnsIndexes(table);
        table.createPrimaryKey(indexName, c.core.mainCols, true);
        if (c.core.mainCols != null) {
            Constraint newconstraint = new Constraint(c.getName(), table, table.getPrimaryIndex(), 4);
            table.addConstraint(newconstraint);
            if (addToSchema) {
                session.database.schemaManager.addSchemaObject(newconstraint);
            }
        }
        block7: for (int i = 1; i < tempConstraints.size(); ++i) {
            c = (Constraint)tempConstraints.get(i);
            switch (c.getConstraintType()) {
                case 2: {
                    c.setColumnsIndexes(table);
                    if (table.getUniqueConstraintForColumns(c.core.mainCols) != null) {
                        throw Error.error(5522);
                    }
                    indexName = session.database.nameManager.newAutoName("IDX", c.getName().name, table.getSchemaName(), table.getName(), 20);
                    Index index = table.createAndAddIndexStructure(session, indexName, c.core.mainCols, null, null, true, true, false);
                    Constraint newconstraint = new Constraint(c.getName(), table, index, 2);
                    table.addConstraint(newconstraint);
                    if (!addToSchema) continue block7;
                    session.database.schemaManager.addSchemaObject(newconstraint);
                    continue block7;
                }
                case 0: {
                    ParserTable.addForeignKey(session, table, c, constraintList);
                    continue block7;
                }
                case 3: {
                    try {
                        c.prepareCheckConstraint(session, table);
                    }
                    catch (HsqlException e) {
                        if (session.isProcessingScript()) continue block7;
                        throw e;
                    }
                    table.addConstraint(c);
                    if (c.isNotNull()) {
                        ColumnSchema column = table.getColumn(c.notNullColumnIndex);
                        column.setNullable(false);
                        table.setColumnTypeVars(c.notNullColumnIndex);
                    }
                    if (!addToSchema) continue block7;
                    session.database.schemaManager.addSchemaObject(c);
                }
            }
        }
        return table;
    }

    static void addForeignKey(Session session, Table table, Constraint c, HsqlArrayList constraintList) {
        HsqlNameManager.HsqlName mainTableName = c.getMainTableName();
        if (mainTableName == table.getName()) {
            c.core.mainTable = table;
        } else {
            Table mainTable = session.database.schemaManager.findUserTable(session, mainTableName.name, mainTableName.schema.name);
            if (mainTable == null) {
                if (constraintList == null) {
                    throw Error.error(5501, mainTableName.name);
                }
                constraintList.add(c);
                return;
            }
            c.core.mainTable = mainTable;
        }
        c.setColumnsIndexes(table);
        TableWorks tableWorks = new TableWorks(session, table);
        tableWorks.checkCreateForeignKey(c);
        Constraint uniqueConstraint = c.core.mainTable.getUniqueConstraintForColumns(c.core.mainCols);
        if (uniqueConstraint == null) {
            throw Error.error(5523);
        }
        Index mainIndex = uniqueConstraint.getMainIndex();
        boolean isForward = c.core.mainTable.getSchemaName() != table.getSchemaName();
        int offset = session.database.schemaManager.getTableIndex(table);
        if (offset != -1 && offset < session.database.schemaManager.getTableIndex(c.core.mainTable)) {
            isForward = true;
        }
        HsqlNameManager.HsqlName refIndexName = session.database.nameManager.newAutoName("IDX", table.getSchemaName(), table.getName(), 20);
        Index index = table.createAndAddIndexStructure(session, refIndexName, c.core.refCols, null, null, false, true, isForward);
        HsqlNameManager.HsqlName mainName = session.database.nameManager.newAutoName("REF", c.getName().name, table.getSchemaName(), table.getName(), 20);
        c.core.uniqueName = uniqueConstraint.getName();
        c.core.mainName = mainName;
        c.core.mainIndex = mainIndex;
        c.core.refTable = table;
        c.core.refName = c.getName();
        c.core.refIndex = index;
        c.isForward = isForward;
        table.addConstraint(c);
        c.core.mainTable.addConstraint(new Constraint(mainName, c));
        session.database.schemaManager.addSchemaObject(c);
    }

    Constraint readFKReferences(Table refTable, HsqlNameManager.HsqlName constraintName, OrderedHashSet refColSet) {
        HsqlNameManager.HsqlName mainTableName;
        OrderedHashSet mainColSet = null;
        this.readThis(222);
        HsqlNameManager.HsqlName schema = this.token.namePrefix == null ? refTable.getSchemaName() : this.database.schemaManager.getSchemaHsqlName(this.token.namePrefix);
        if (refTable.getSchemaName() == schema && refTable.getName().name.equals(this.token.tokenString)) {
            mainTableName = refTable.getName();
            this.read();
        } else {
            mainTableName = this.readFKTableName(schema);
        }
        if (this.token.tokenType == 816) {
            mainColSet = this.readColumnNames(false);
        }
        int matchType = 59;
        if (this.token.tokenType == 162) {
            this.read();
            switch (this.token.tokenType) {
                case 511: {
                    this.read();
                    break;
                }
                case 470: {
                    throw super.unsupportedFeature();
                }
                case 116: {
                    this.read();
                    matchType = 61;
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
        }
        int deleteAction = 3;
        int updateAction = 3;
        OrderedIntHashSet set = new OrderedIntHashSet();
        block13: while (this.token.tokenType == 194) {
            this.read();
            if (!set.add(this.token.tokenType)) {
                throw this.unexpectedToken();
            }
            if (this.token.tokenType == 79) {
                this.read();
                if (this.token.tokenType == 254) {
                    this.read();
                    switch (this.token.tokenType) {
                        case 78: {
                            this.read();
                            deleteAction = 4;
                            continue block13;
                        }
                        case 186: {
                            this.read();
                            deleteAction = 2;
                            continue block13;
                        }
                    }
                    throw this.unexpectedToken();
                }
                if (this.token.tokenType == 347) {
                    this.read();
                    deleteAction = 0;
                    continue;
                }
                if (this.token.tokenType == 485) {
                    this.read();
                    continue;
                }
                this.readThis(180);
                this.readThis(332);
                continue;
            }
            if (this.token.tokenType == 303) {
                this.read();
                if (this.token.tokenType == 254) {
                    this.read();
                    switch (this.token.tokenType) {
                        case 78: {
                            this.read();
                            updateAction = 4;
                            continue block13;
                        }
                        case 186: {
                            this.read();
                            updateAction = 2;
                            continue block13;
                        }
                    }
                    throw this.unexpectedToken();
                }
                if (this.token.tokenType == 347) {
                    this.read();
                    updateAction = 0;
                    continue;
                }
                if (this.token.tokenType == 485) {
                    this.read();
                    continue;
                }
                this.readThis(180);
                this.readThis(332);
                continue;
            }
            throw this.unexpectedToken();
        }
        if (constraintName == null) {
            constraintName = this.database.nameManager.newAutoName("FK", refTable.getSchemaName(), refTable.getName(), 5);
        }
        return new Constraint(constraintName, refTable.getName(), refColSet, mainTableName, mainColSet, 0, deleteAction, updateAction, matchType);
    }

    HsqlNameManager.HsqlName readFKTableName(HsqlNameManager.HsqlName schema) {
        this.checkIsSchemaObjectName();
        Table table = this.database.schemaManager.findUserTable(this.session, this.token.tokenString, schema.name);
        HsqlNameManager.HsqlName name = table == null ? this.database.nameManager.newHsqlName(schema, this.token.tokenString, this.isDelimitedIdentifier(), 3) : table.getName();
        this.read();
        return name;
    }

    ColumnSchema readColumnDefinitionOrNull(Table table, HsqlNameManager.HsqlName hsqlName, HsqlArrayList constraintList) {
        boolean isGenerated = false;
        boolean isIdentity = false;
        boolean isPKIdentity = false;
        boolean generatedAlways = false;
        Expression generateExpr = null;
        boolean isNullable = true;
        Expression defaultExpr = null;
        Type typeObject = null;
        NumberSequence sequence = null;
        switch (this.token.tokenType) {
            case 407: {
                this.read();
                this.readThis(337);
                isGenerated = true;
                generatedAlways = true;
                throw this.unexpectedToken("GENERATED");
            }
            case 128: {
                this.read();
                isIdentity = true;
                isPKIdentity = true;
                typeObject = Type.SQL_INTEGER;
                sequence = new NumberSequence(null, 0L, 1L, typeObject);
                break;
            }
            case 804: {
                return null;
            }
            case 802: {
                return null;
            }
            default: {
                if (this.token.isUndelimitedIdentifier) {
                    if ("SERIAL".equals(this.token.tokenString)) {
                        if (this.database.sqlSyntaxMys) {
                            this.read();
                            isIdentity = true;
                            isPKIdentity = true;
                            typeObject = Type.SQL_BIGINT;
                            sequence = new NumberSequence(null, 1L, 1L, typeObject);
                            break;
                        }
                        if (this.database.sqlSyntaxPgs) {
                            this.read();
                            isIdentity = true;
                            typeObject = Type.SQL_INTEGER;
                            sequence = new NumberSequence(null, 1L, 1L, typeObject);
                            break;
                        }
                    } else if ("BIGSERIAL".equals(this.token.tokenString) && this.database.sqlSyntaxPgs) {
                        this.read();
                        isIdentity = true;
                        isPKIdentity = true;
                        typeObject = Type.SQL_BIGINT;
                        sequence = new NumberSequence(null, 1L, 1L, typeObject);
                        break;
                    }
                }
                typeObject = this.readTypeDefinition(true, true);
            }
        }
        if (!isGenerated && !isIdentity) {
            if (this.database.sqlSyntaxMys) {
                switch (this.token.tokenType) {
                    case 186: {
                        this.read();
                        break;
                    }
                    case 183: {
                        this.read();
                        this.readThis(186);
                        isNullable = false;
                        break;
                    }
                }
            }
            switch (this.token.tokenType) {
                case 319: {
                    if (this.database.sqlSyntaxDb2) {
                        this.read();
                    } else {
                        throw this.unexpectedToken();
                    }
                }
                case 78: {
                    this.read();
                    defaultExpr = this.readDefaultClause(typeObject);
                    if (defaultExpr.opType != 12 || !this.database.sqlSyntaxPgs) break;
                    sequence = ((ExpressionColumn)defaultExpr).sequence;
                    defaultExpr = null;
                    isIdentity = true;
                    break;
                }
                case 407: {
                    this.read();
                    if (this.token.tokenType == 24) {
                        this.read();
                        this.readThis(78);
                    } else {
                        this.readThis(337);
                        generatedAlways = true;
                    }
                    this.readThis(10);
                    if (this.token.tokenType == 128) {
                        this.read();
                        sequence = new NumberSequence(null, typeObject);
                        sequence.setAlways(generatedAlways);
                        if (this.token.tokenType == 816) {
                            this.read();
                            this.readSequenceOptions(sequence, false, false, true);
                            this.readThis(802);
                        }
                        isIdentity = true;
                        break;
                    }
                    if (this.token.tokenType == 816) {
                        if (!generatedAlways) {
                            throw super.unexpectedTokenRequire("IDENTITY");
                        }
                        isGenerated = true;
                        break;
                    }
                    if (this.token.tokenType != 505) break;
                    if (generatedAlways) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.token.namePrefix != null && !this.token.namePrefix.equals(table.getSchemaName().name)) {
                        throw super.unexpectedToken(this.token.namePrefix);
                    }
                    sequence = this.database.schemaManager.getSequence(this.token.tokenString, table.getSchemaName().name, true);
                    isIdentity = true;
                    this.read();
                    break;
                }
                case 128: {
                    this.read();
                    isIdentity = true;
                    isPKIdentity = true;
                    sequence = new NumberSequence(null, 0L, 1L, typeObject);
                }
            }
        }
        if (isGenerated) {
            this.readThis(816);
            generateExpr = this.XreadValueExpression();
            this.readThis(802);
        }
        if (!isGenerated && !isIdentity && this.database.sqlSyntaxMys && this.token.isUndelimitedIdentifier && "AUTO_INCREMENT".equals(this.token.tokenString)) {
            this.read();
            isIdentity = true;
            sequence = new NumberSequence(null, 1L, 1L, typeObject);
        }
        ColumnSchema column = new ColumnSchema(hsqlName, typeObject, isNullable, false, defaultExpr);
        column.setGeneratingExpression(generateExpr);
        this.readColumnConstraints(table, column, constraintList);
        if (this.token.tokenType == 128 && !isIdentity) {
            this.read();
            isIdentity = true;
            isPKIdentity = true;
            sequence = new NumberSequence(null, 0L, 1L, typeObject);
        }
        if (this.token.tokenType == 407 && !isIdentity && !isGenerated) {
            this.read();
            if (this.token.tokenType == 24) {
                this.read();
                this.readThis(78);
            } else {
                this.readThis(337);
                generatedAlways = true;
            }
            this.readThis(10);
            this.readThis(128);
            sequence = new NumberSequence(null, typeObject);
            sequence.setAlways(generatedAlways);
            if (this.token.tokenType == 816) {
                this.read();
                this.readSequenceOptions(sequence, false, false, true);
                this.readThis(802);
            }
            isIdentity = true;
        }
        if (isIdentity) {
            column.setIdentity(sequence);
        }
        if (isPKIdentity && !column.isPrimaryKey()) {
            OrderedHashSet set = new OrderedHashSet();
            set.add(column.getName().name);
            HsqlNameManager.HsqlName constName = this.database.nameManager.newAutoName("PK", table.getSchemaName(), table.getName(), 5);
            Constraint c = new Constraint(constName, set, 4);
            constraintList.set(0, c);
            column.setPrimaryKey(true);
        }
        if (this.database.sqlSyntaxPgs && this.token.tokenType == 78 && column.getDefaultExpression() == null && column.getIdentitySequence() == null) {
            this.read();
            defaultExpr = this.readDefaultClause(typeObject);
            if (defaultExpr.opType == 12) {
                sequence = ((ExpressionColumn)defaultExpr).sequence;
                defaultExpr = null;
            }
            column.setDefaultExpression(defaultExpr);
            column.setIdentity(sequence);
        }
        return column;
    }

    void readConstraint(SchemaObject schemaObject, HsqlArrayList constraintList) {
        HsqlNameManager.HsqlName constName = null;
        if (this.token.tokenType == 48) {
            this.read();
            constName = this.readNewDependentSchemaObjectName(schemaObject.getName(), 5);
        }
        switch (this.token.tokenType) {
            case 214: {
                if (schemaObject.getName().type != 3) {
                    throw this.unexpectedTokenRequire("CHECK");
                }
                this.read();
                this.readThis(427);
                Constraint mainConst = (Constraint)constraintList.get(0);
                if (mainConst.getConstraintType() == 4) {
                    throw Error.error(5532);
                }
                if (constName == null) {
                    constName = this.database.nameManager.newAutoName("PK", schemaObject.getSchemaName(), schemaObject.getName(), 5);
                }
                OrderedHashSet set = this.readColumnNames(false);
                Constraint c = new Constraint(constName, set, 4);
                constraintList.set(0, c);
                break;
            }
            case 299: {
                if (schemaObject.getName().type != 3) {
                    throw this.unexpectedTokenRequire("CHECK");
                }
                this.read();
                if (this.database.sqlSyntaxMys && !this.readIfThis(598)) {
                    this.readIfThis(427);
                }
                OrderedHashSet set = this.readColumnNames(false);
                if (constName == null) {
                    constName = this.database.nameManager.newAutoName("CT", schemaObject.getSchemaName(), schemaObject.getName(), 5);
                }
                Constraint c = new Constraint(constName, set, 2);
                constraintList.add(c);
                break;
            }
            case 113: {
                if (schemaObject.getName().type != 3) {
                    throw this.unexpectedTokenRequire("CHECK");
                }
                this.read();
                this.readThis(427);
                OrderedHashSet set = this.readColumnNames(false);
                Constraint c = this.readFKReferences((Table)schemaObject, constName, set);
                constraintList.add(c);
                break;
            }
            case 37: {
                this.read();
                if (constName == null) {
                    constName = this.database.nameManager.newAutoName("CT", schemaObject.getSchemaName(), schemaObject.getName(), 5);
                }
                Constraint c = new Constraint(constName, null, 3);
                this.readCheckConstraintCondition(c);
                constraintList.add(c);
                break;
            }
            default: {
                if (constName == null) break;
                throw this.unexpectedToken();
            }
        }
    }

    void readColumnConstraints(Table table, ColumnSchema column, HsqlArrayList constraintList) {
        boolean end = false;
        boolean hasNotNullConstraint = false;
        boolean hasNullNoiseWord = false;
        boolean hasPrimaryKey = false;
        do {
            HsqlNameManager.HsqlName constName = null;
            if (this.token.tokenType == 48) {
                this.read();
                constName = this.readNewDependentSchemaObjectName(table.getName(), 5);
            }
            switch (this.token.tokenType) {
                case 214: {
                    if (hasNullNoiseWord || hasPrimaryKey) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(427);
                    Constraint existingConst = (Constraint)constraintList.get(0);
                    if (existingConst.getConstraintType() == 4) {
                        throw Error.error(5532);
                    }
                    OrderedHashSet set = new OrderedHashSet();
                    set.add(column.getName().name);
                    if (constName == null) {
                        constName = this.database.nameManager.newAutoName("PK", table.getSchemaName(), table.getName(), 5);
                    }
                    Constraint c = new Constraint(constName, set, 4);
                    constraintList.set(0, c);
                    column.setPrimaryKey(true);
                    hasPrimaryKey = true;
                    break;
                }
                case 299: {
                    this.read();
                    OrderedHashSet set = new OrderedHashSet();
                    set.add(column.getName().name);
                    if (constName == null) {
                        constName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
                    }
                    Constraint c = new Constraint(constName, set, 2);
                    constraintList.add(c);
                    break;
                }
                case 113: {
                    this.read();
                    this.readThis(427);
                }
                case 222: {
                    OrderedHashSet set = new OrderedHashSet();
                    set.add(column.getName().name);
                    Constraint c = this.readFKReferences(table, constName, set);
                    constraintList.add(c);
                    break;
                }
                case 37: {
                    this.read();
                    if (constName == null) {
                        constName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
                    }
                    Constraint c = new Constraint(constName, null, 3);
                    this.readCheckConstraintCondition(c);
                    OrderedHashSet set = c.getCheckColumnExpressions();
                    for (int i = 0; i < set.size(); ++i) {
                        ExpressionColumn e = (ExpressionColumn)set.get(i);
                        if (column.getName().name.equals(e.getColumnName())) {
                            if (e.getSchemaName() == null || e.getSchemaName().equals(table.getSchemaName().name)) continue;
                            throw Error.error(5505);
                        }
                        throw Error.error(5501);
                    }
                    constraintList.add(c);
                    break;
                }
                case 183: {
                    if (hasNotNullConstraint || hasNullNoiseWord) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(186);
                    if (constName == null) {
                        constName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
                    }
                    Constraint c = new Constraint(constName, null, 3);
                    c.check = new ExpressionLogical(column);
                    constraintList.add(c);
                    hasNotNullConstraint = true;
                    break;
                }
                case 186: {
                    if (hasNotNullConstraint || hasNullNoiseWord || hasPrimaryKey) {
                        throw this.unexpectedToken();
                    }
                    if (constName != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    hasNullNoiseWord = true;
                    break;
                }
                default: {
                    end = true;
                }
            }
        } while (!end);
    }

    void readCheckConstraintCondition(Constraint c) {
        this.readThis(816);
        this.startRecording();
        this.isCheckOrTriggerCondition = true;
        Expression condition = this.XreadBooleanValueExpression();
        this.isCheckOrTriggerCondition = false;
        Token[] tokens = this.getRecordedStatement();
        this.readThis(802);
        c.check = condition;
    }

    Expression readDefaultClause(Type dataType) {
        Expression e = null;
        boolean minus = false;
        if (this.token.tokenType == 186) {
            this.read();
            return new ExpressionValue(null, dataType);
        }
        if (dataType.isDateTimeType() || dataType.isIntervalType()) {
            switch (this.token.tokenType) {
                case 72: 
                case 140: 
                case 281: 
                case 282: {
                    e = this.readDateTimeIntervalLiteral(this.session);
                    if (e.dataType.typeCode != dataType.typeCode) {
                        throw this.unexpectedToken();
                    }
                    Object defaultValue = e.getValue(this.session, dataType);
                    return new ExpressionValue(defaultValue, dataType);
                }
                case 869: {
                    break;
                }
                default: {
                    e = this.XreadDateTimeValueFunctionOrNull();
                    if (e == null) break;
                    e = this.XreadModifier(e);
                    break;
                }
            }
        } else if (dataType.isNumberType()) {
            if (this.token.tokenType == 814) {
                this.read();
                minus = true;
            } else if (this.database.sqlSyntaxPgs && this.token.tokenType == 612) {
                return this.readNextvalFunction();
            }
        } else if (dataType.isCharacterType()) {
            switch (this.token.tokenType) {
                case 60: 
                case 63: 
                case 64: 
                case 65: 
                case 69: 
                case 253: 
                case 277: 
                case 305: {
                    FunctionSQL function = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                    e = this.readSQLFunction(function);
                    break;
                }
            }
        } else if (dataType.isBooleanType()) {
            switch (this.token.tokenType) {
                case 294: {
                    this.read();
                    return Expression.EXPR_TRUE;
                }
                case 106: {
                    this.read();
                    return Expression.EXPR_FALSE;
                }
            }
        } else if (dataType.isBitType()) {
            switch (this.token.tokenType) {
                case 294: {
                    this.read();
                    return new ExpressionValue(BinaryData.singleBitOne, dataType);
                }
                case 106: {
                    this.read();
                    return new ExpressionValue(BinaryData.singleBitZero, dataType);
                }
            }
        } else if (dataType.isArrayType()) {
            e = this.readCollection(19);
            if (e.nodes.length > 0) {
                throw Error.parseError(5562, null, this.scanner.getLineNumber());
            }
            e.dataType = dataType;
            return e;
        }
        if (e != null) {
            e.resolveTypes(this.session, null);
            if (!dataType.canBeAssignedFrom(e.getDataType())) {
                throw Error.parseError(5562, null, this.scanner.getLineNumber());
            }
            return e;
        }
        boolean inParens = false;
        if ((this.database.sqlSyntaxMss || this.database.sqlSyntaxPgs) && this.token.tokenType == 816) {
            this.read();
            inParens = true;
        }
        if (this.token.tokenType == 869) {
            Object value = this.token.tokenValue;
            Type valueType = this.token.dataType;
            Type convertType = dataType;
            if (dataType.typeCode == 40) {
                convertType = Type.getType(12, null, this.database.collation, dataType.precision, 0);
            } else if (dataType.typeCode == 30) {
                convertType = Type.getType(61, null, null, dataType.precision, 0);
            }
            value = convertType.convertToType(this.session, value, valueType);
            this.read();
            if (minus) {
                value = dataType.negate(value);
            }
            if (inParens) {
                this.readThis(802);
            }
            return new ExpressionValue(value, convertType);
        }
        if ((this.database.sqlSyntaxOra || this.database.sqlSyntaxPgs) && (e = this.XreadValueExpressionOrNull()) != null) {
            QuerySpecification qs;
            TableDerived t;
            if (e.getType() == 22) {
                t = (TableDerived)e.getTable();
                qs = (QuerySpecification)t.getQueryExpression();
                qs.setReturningResult();
            }
            e.resolveColumnReferences(this.session, RangeGroup.emptyGroup, 0, RangeGroup.emptyArray, null, true);
            e.resolveTypes(this.session, null);
            if (e.getType() == 22) {
                t = (TableDerived)e.getTable();
                qs = (QuerySpecification)t.getQueryExpression();
                Table d = qs.getRangeVariables()[0].getTable();
                if (d != this.session.database.schemaManager.dualTable || qs.exprColumns.length != 1) {
                    throw Error.error(5565);
                }
                e = qs.exprColumns[0];
            }
            if (inParens) {
                this.readThis(802);
            }
            return e;
        }
        if (this.database.sqlSyntaxDb2) {
            Object value = null;
            switch (dataType.typeComparisonGroup) {
                case 12: {
                    value = "";
                    break;
                }
                case 61: {
                    value = BinaryData.zeroLengthBinary;
                    break;
                }
                case 2: {
                    value = 0;
                    break;
                }
                case 16: {
                    value = Boolean.FALSE;
                    break;
                }
                case 40: {
                    value = "";
                    return new ExpressionValue(value, Type.SQL_VARCHAR_DEFAULT);
                }
                case 30: {
                    value = BinaryData.zeroLengthBinary;
                    return new ExpressionValue(value, Type.SQL_VARBINARY_DEFAULT);
                }
                case 92: {
                    FunctionSQL function = FunctionSQL.newSQLFunction("CURRENT_TIME", this.compileContext);
                    function.resolveTypes(this.session, null);
                    return function;
                }
                case 91: {
                    FunctionSQL function = FunctionSQL.newSQLFunction("CURRENT_DATE", this.compileContext);
                    function.resolveTypes(this.session, null);
                    return function;
                }
                case 93: {
                    FunctionSQL function = FunctionSQL.newSQLFunction("CURRENT_TIMESTAMP", this.compileContext);
                    function.resolveTypes(this.session, null);
                    return function;
                }
            }
            value = dataType.convertToDefaultType(this.session, value);
            return new ExpressionValue(value, dataType);
        }
        if (inParens) {
            this.readThis(802);
        }
        throw this.unexpectedToken();
    }

    void readSequenceOptions(NumberSequence sequence, boolean withType, boolean isAlter, boolean allowComma) {
        boolean end;
        OrderedIntHashSet set = new OrderedIntHashSet();
        block10: do {
            end = false;
            if (set.contains(this.token.tokenType)) {
                throw this.unexpectedToken();
            }
            switch (this.token.tokenType) {
                case 10: {
                    if (withType) {
                        set.add(this.token.tokenType);
                        this.read();
                        Type type = this.readTypeDefinition(false, true);
                        sequence.setDefaults(sequence.getName(), type);
                        break;
                    }
                    throw this.unexpectedToken();
                }
                case 267: {
                    set.add(this.token.tokenType);
                    this.read();
                    this.readThis(319);
                    long value = this.readBigint();
                    sequence.setStartValueNoCheck(value);
                    if (!allowComma) continue block10;
                    this.readIfThis(804);
                    break;
                }
                case 484: {
                    if (!isAlter) {
                        end = true;
                        break;
                    }
                    set.add(this.token.tokenType);
                    this.read();
                    if (this.readIfThis(319)) {
                        long value = this.readBigint();
                        sequence.setCurrentValueNoCheck(value);
                        break;
                    }
                    sequence.setStartValueDefault();
                    break;
                }
                case 417: {
                    set.add(this.token.tokenType);
                    this.read();
                    this.readThis(24);
                    long value = this.readBigint();
                    sequence.setIncrement(value);
                    break;
                }
                case 180: {
                    this.read();
                    if (set.contains(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    if (this.token.tokenType == 438) {
                        sequence.setDefaultMaxValue();
                    } else if (this.token.tokenType == 442) {
                        sequence.setDefaultMinValue();
                    } else if (this.token.tokenType == 71) {
                        sequence.setCycle(false);
                    } else {
                        throw this.unexpectedToken();
                    }
                    set.add(this.token.tokenType);
                    this.read();
                    break;
                }
                case 438: {
                    set.add(this.token.tokenType);
                    this.read();
                    long value = this.readBigint();
                    sequence.setMaxValueNoCheck(value);
                    break;
                }
                case 442: {
                    set.add(this.token.tokenType);
                    this.read();
                    long value = this.readBigint();
                    sequence.setMinValueNoCheck(value);
                    break;
                }
                case 71: {
                    set.add(this.token.tokenType);
                    this.read();
                    sequence.setCycle(true);
                    break;
                }
                default: {
                    if ((this.database.sqlSyntaxOra || this.database.sqlSyntaxDb2) && this.isSimpleName()) {
                        if (this.token.tokenString.equals("NOCACHE") || this.token.tokenString.equals("NOCYCLE") || this.token.tokenString.equals("NOMAXVALUE") || this.token.tokenString.equals("NOMINVALUE") || this.token.tokenString.equals("NOORDER") || this.token.tokenString.equals("ORDER")) {
                            this.read();
                            break;
                        }
                        if (this.token.tokenString.equals("CACHE")) {
                            this.read();
                            this.readBigint();
                            break;
                        }
                    }
                    end = true;
                }
            }
        } while (!end);
        sequence.checkValues();
    }

    private void readIndex(Table table, HsqlArrayList indexList) {
        HsqlNameManager.HsqlName tableSchema;
        this.read();
        HsqlNameManager.HsqlName indexHsqlName = this.readNewSchemaObjectName(20, true);
        indexHsqlName.schema = tableSchema = table.getSchemaName();
        indexHsqlName.parent = table.getName();
        indexHsqlName.schema = table.getSchemaName();
        int[] indexColumns = this.readColumnList(table, true);
        Constraint c = new Constraint(indexHsqlName, table, indexColumns, 20);
        indexList.add(c);
    }
}

