/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ParserDQL;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.MultiValueHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.persist.PersistentStore;

public class RangeVariableResolver {
    Session session;
    QuerySpecification select;
    RangeVariable[] rangeVariables;
    Expression conditions;
    OrderedHashSet rangeVarSet = new OrderedHashSet();
    ParserDQL.CompileContext compileContext;
    SortAndSlice sortAndSlice = SortAndSlice.noSort;
    boolean reorder;
    HsqlArrayList[] tempJoinExpressions;
    HsqlArrayList[] joinExpressions;
    HsqlArrayList[] whereExpressions;
    HsqlArrayList queryConditions = new HsqlArrayList();
    Expression[] inExpressions;
    boolean[] inInJoin;
    int inExpressionCount = 0;
    boolean expandInExpression = true;
    int firstLeftJoinIndex;
    int firstRightJoinIndex;
    int lastRightJoinIndex;
    int firstLateralJoinIndex;
    int firstOuterJoinIndex;
    int lastOuterJoinIndex;
    OrderedIntHashSet colIndexSetEqual = new OrderedIntHashSet();
    IntKeyIntValueHashMap colIndexSetOther = new IntKeyIntValueHashMap();
    OrderedHashSet tempSet = new OrderedHashSet();
    HashMap tempMap = new HashMap();
    MultiValueHashMap tempMultiMap = new MultiValueHashMap();

    RangeVariableResolver(Session session, QuerySpecification select) {
        this.session = session;
        this.select = select;
        this.rangeVariables = select.rangeVariables;
        this.conditions = select.queryCondition;
        this.compileContext = select.compileContext;
        this.sortAndSlice = select.sortAndSlice;
        this.reorder = true;
        this.initialise();
    }

    RangeVariableResolver(Session session, RangeVariable[] rangeVariables, Expression conditions, ParserDQL.CompileContext compileContext, boolean reorder) {
        this.session = session;
        this.rangeVariables = rangeVariables;
        this.conditions = conditions;
        this.compileContext = compileContext;
        this.reorder = reorder;
        this.initialise();
    }

    private void initialise() {
        int i;
        this.firstLeftJoinIndex = this.rangeVariables.length;
        this.firstRightJoinIndex = this.rangeVariables.length;
        this.firstLateralJoinIndex = this.rangeVariables.length;
        this.firstOuterJoinIndex = this.rangeVariables.length;
        this.inExpressions = new Expression[this.rangeVariables.length];
        this.inInJoin = new boolean[this.rangeVariables.length];
        this.tempJoinExpressions = new HsqlArrayList[this.rangeVariables.length];
        for (i = 0; i < this.rangeVariables.length; ++i) {
            this.tempJoinExpressions[i] = new HsqlArrayList();
        }
        this.joinExpressions = new HsqlArrayList[this.rangeVariables.length];
        for (i = 0; i < this.rangeVariables.length; ++i) {
            this.joinExpressions[i] = new HsqlArrayList();
        }
        this.whereExpressions = new HsqlArrayList[this.rangeVariables.length];
        for (i = 0; i < this.rangeVariables.length; ++i) {
            this.whereExpressions[i] = new HsqlArrayList();
        }
        this.queryConditions.clear();
    }

    void processConditions() {
        int i;
        if (this.session.sessionOptimization < 8) {
            this.reorder = false;
        }
        RangeVariableResolver.decomposeAndConditions(this.session, this.conditions, this.queryConditions);
        for (i = 0; i < this.rangeVariables.length; ++i) {
            this.rangeVarSet.add(this.rangeVariables[i]);
            if (this.rangeVariables[i].joinCondition == null) continue;
            RangeVariableResolver.decomposeAndConditions(this.session, this.rangeVariables[i].joinCondition, this.tempJoinExpressions[i]);
        }
        for (int j = 0; j < this.queryConditions.size(); ++j) {
            int index;
            Expression e = (Expression)this.queryConditions.get(j);
            if (e.isTrue() || !e.isSingleColumnEqual && !e.isColumnCondition) continue;
            RangeVariable range = e.getLeftNode().getRangeVariable();
            if (e.getLeftNode().opType == 2 && range != null && (index = this.rangeVarSet.getIndex(range)) > 0) {
                this.rangeVariables[index].isLeftJoin = false;
                this.rangeVariables[index - 1].isRightJoin = false;
            }
            range = e.getRightNode().getRangeVariable();
            if (e.getRightNode().opType != 2 || range == null || (index = this.rangeVarSet.getIndex(range)) <= 0) continue;
            this.rangeVariables[index].isLeftJoin = false;
            this.rangeVariables[index - 1].isRightJoin = false;
        }
        for (i = 0; i < this.rangeVariables.length; ++i) {
            RangeVariable range = this.rangeVariables[i];
            boolean isOuter = false;
            if (range.isLeftJoin) {
                if (this.firstLeftJoinIndex == this.rangeVariables.length) {
                    this.firstLeftJoinIndex = i;
                }
                isOuter = true;
            }
            if (range.isRightJoin) {
                if (this.firstRightJoinIndex == this.rangeVariables.length) {
                    this.firstRightJoinIndex = i;
                }
                this.lastRightJoinIndex = i;
                isOuter = true;
            }
            if (range.isLateral) {
                if (this.firstLateralJoinIndex == this.rangeVariables.length) {
                    this.firstLateralJoinIndex = i;
                }
                isOuter = true;
            }
            if (!isOuter) continue;
            if (this.firstOuterJoinIndex == this.rangeVariables.length) {
                this.firstOuterJoinIndex = i;
            }
            this.lastOuterJoinIndex = i;
        }
        this.expandConditions();
        this.conditions = null;
        this.reorder();
        this.assignToLists();
        this.assignToRangeVariables();
        if (this.select != null) {
            this.select.startInnerRange = 0;
            this.select.endInnerRange = this.rangeVariables.length;
            if (this.firstRightJoinIndex < this.rangeVariables.length) {
                this.select.startInnerRange = this.firstRightJoinIndex;
            }
            if (this.firstLeftJoinIndex < this.rangeVariables.length) {
                this.select.endInnerRange = this.firstLeftJoinIndex;
            }
        }
        for (i = 0; i < this.rangeVariables.length; ++i) {
            this.rangeVariables[i].rangePositionInJoin = i;
        }
        if (this.expandInExpression && this.inExpressionCount != 0) {
            this.setInConditionsAsTables();
        }
    }

    static Expression decomposeAndConditions(Session session, Expression e, HsqlList conditions) {
        if (e == null) {
            return Expression.EXPR_TRUE;
        }
        Expression arg1 = e.getLeftNode();
        Expression arg2 = e.getRightNode();
        int type = e.getType();
        if (type == 49) {
            arg1 = RangeVariableResolver.decomposeAndConditions(session, arg1, conditions);
            arg2 = RangeVariableResolver.decomposeAndConditions(session, arg2, conditions);
            if (arg1.isTrue()) {
                return arg2;
            }
            if (arg2.isTrue()) {
                return arg1;
            }
            e.setLeftNode(arg1);
            e.setRightNode(arg2);
            return e;
        }
        if (type == 40 && arg1.getType() == 25 && arg2.getType() == 25) {
            for (int i = 0; i < arg1.nodes.length; ++i) {
                ExpressionLogical part = new ExpressionLogical(arg1.nodes[i], arg2.nodes[i]);
                ((Expression)part).resolveTypes(session, null);
                conditions.add(part);
            }
            return Expression.EXPR_TRUE;
        }
        if (!e.isTrue()) {
            conditions.add(e);
        }
        return Expression.EXPR_TRUE;
    }

    static Expression decomposeOrConditions(Expression e, HsqlList conditions) {
        if (e == null) {
            return Expression.EXPR_FALSE;
        }
        Expression arg1 = e.getLeftNode();
        Expression arg2 = e.getRightNode();
        int type = e.getType();
        if (type == 50) {
            arg1 = RangeVariableResolver.decomposeOrConditions(arg1, conditions);
            arg2 = RangeVariableResolver.decomposeOrConditions(arg2, conditions);
            if (arg1.isFalse()) {
                return arg2;
            }
            if (arg2.isFalse()) {
                return arg1;
            }
            e = new ExpressionLogical(50, arg1, arg2);
            return e;
        }
        if (!e.isFalse()) {
            conditions.add(e);
        }
        return Expression.EXPR_FALSE;
    }

    void expandConditions() {
        int i;
        HsqlList[] array = this.tempJoinExpressions;
        if (this.firstRightJoinIndex == this.rangeVariables.length) {
            this.moveConditions(this.tempJoinExpressions, 0, this.firstOuterJoinIndex, this.queryConditions, -1);
        }
        if (this.firstOuterJoinIndex < 2) {
            return;
        }
        for (i = 0; i < this.firstOuterJoinIndex; ++i) {
            this.moveConditions(this.tempJoinExpressions, 0, this.firstOuterJoinIndex, this.tempJoinExpressions[i], i);
        }
        if (this.firstOuterJoinIndex < 3) {
            return;
        }
        for (i = 0; i < this.firstOuterJoinIndex; ++i) {
            Object key;
            HsqlArrayList list = array[i];
            this.tempMultiMap.clear();
            this.tempSet.clear();
            this.tempMap.clear();
            boolean hasValEqual = false;
            boolean hasColEqual = false;
            boolean hasChain = false;
            for (int j = 0; j < list.size(); ++j) {
                ColumnSchema column;
                Expression e = (Expression)list.get(j);
                if (e.isTrue()) continue;
                if (e.isSingleColumnEqual) {
                    hasValEqual = true;
                    if (e.getLeftNode().opType == 2) {
                        this.tempMap.put(e.getLeftNode().getColumn(), e.getRightNode());
                        continue;
                    }
                    if (e.getRightNode().opType != 2) continue;
                    this.tempMap.put(e.getRightNode().getColumn(), e.getLeftNode());
                    continue;
                }
                if (!e.isColumnEqual || e.getLeftNode().getRangeVariable() == e.getRightNode().getRangeVariable() || e.getLeftNode().getRangeVariable() == null || e.getRightNode().getRangeVariable() == null) continue;
                int idx = this.rangeVarSet.getIndex(e.getLeftNode().getRangeVariable());
                if (idx < 0) {
                    e.isSingleColumnEqual = true;
                    e.isSingleColumnCondition = true;
                    this.tempMap.put(e.getRightNode().getColumn(), e.getLeftNode());
                    continue;
                }
                if (idx >= this.firstOuterJoinIndex) continue;
                idx = this.rangeVarSet.getIndex(e.getRightNode().getRangeVariable());
                if (idx < 0) {
                    e.isSingleColumnEqual = true;
                    e.isSingleColumnCondition = true;
                    this.tempMap.put(e.getRightNode().getColumn(), e.getLeftNode());
                    continue;
                }
                if (idx >= this.firstOuterJoinIndex) continue;
                hasColEqual = true;
                if (e.getLeftNode().getRangeVariable() == this.rangeVariables[i]) {
                    column = e.getLeftNode().getColumn();
                    this.tempMultiMap.put(column, e.getRightNode());
                    if (this.tempMultiMap.valueCount(column) <= 1) continue;
                    hasChain = true;
                    continue;
                }
                if (e.getRightNode().getRangeVariable() != this.rangeVariables[i]) continue;
                column = e.getRightNode().getColumn();
                this.tempMultiMap.put(column, e.getLeftNode());
                if (this.tempMultiMap.valueCount(column) <= 1) continue;
                hasChain = true;
            }
            if (hasChain) {
                Iterator keyIt = this.tempMultiMap.keySet().iterator();
                while (keyIt.hasNext()) {
                    key = keyIt.next();
                    Iterator it = this.tempMultiMap.get(key);
                    this.tempSet.clear();
                    while (it.hasNext()) {
                        this.tempSet.add(it.next());
                    }
                    while (this.tempSet.size() > 1) {
                        Expression e1 = (Expression)this.tempSet.remove(this.tempSet.size() - 1);
                        for (int j = 0; j < this.tempSet.size(); ++j) {
                            Expression e2 = (Expression)this.tempSet.get(j);
                            this.closeJoinChain(array, e1, e2);
                        }
                    }
                }
            }
            if (!hasColEqual || !hasValEqual) continue;
            Iterator keyIt = this.tempMultiMap.keySet().iterator();
            while (keyIt.hasNext()) {
                key = keyIt.next();
                Expression e1 = (Expression)this.tempMap.get(key);
                if (e1 == null) continue;
                Iterator it = this.tempMultiMap.get(key);
                while (it.hasNext()) {
                    Expression e2 = (Expression)it.next();
                    ExpressionLogical e = new ExpressionLogical(e1, e2);
                    int index = this.rangeVarSet.getIndex(e2.getRangeVariable());
                    array[index].add(e);
                }
            }
        }
    }

    void moveConditions(HsqlList[] lists, int rangeStart, int rangeLimit, HsqlList list, int listIndex) {
        for (int j = 0; j < list.size(); ++j) {
            Expression e = (Expression)list.get(j);
            this.tempSet.clear();
            e.collectRangeVariables(this.rangeVariables, this.tempSet);
            int index = this.rangeVarSet.getSmallestIndex(this.tempSet);
            if (index < rangeStart || (index = this.rangeVarSet.getLargestIndex(this.tempSet)) >= rangeLimit || index == listIndex) continue;
            list.remove(j);
            lists[index].add(e);
            --j;
        }
    }

    void closeJoinChain(HsqlList[] array, Expression e1, Expression e2) {
        int idx2;
        int index;
        int idx1 = this.rangeVarSet.getIndex(e1.getRangeVariable());
        int n = index = idx1 > (idx2 = this.rangeVarSet.getIndex(e2.getRangeVariable())) ? idx1 : idx2;
        if (idx1 == -1 || idx2 == -1) {
            return;
        }
        ExpressionLogical e = new ExpressionLogical(e1, e2);
        for (int i = 0; i < array[index].size(); ++i) {
            if (!e.equals(array[index].get(i))) continue;
            return;
        }
        array[index].add(e);
    }

    void reorder() {
        if (!this.reorder) {
            return;
        }
        if (this.rangeVariables.length == 1 || this.firstRightJoinIndex != this.rangeVariables.length) {
            return;
        }
        if (this.firstLeftJoinIndex == 1) {
            return;
        }
        if (this.firstLateralJoinIndex != this.rangeVariables.length) {
            return;
        }
        if (this.sortAndSlice.usingIndex && this.sortAndSlice.primaryTableIndex != null) {
            return;
        }
        HsqlArrayList joins = new HsqlArrayList();
        HsqlArrayList starts = new HsqlArrayList();
        for (int i = 0; i < this.firstLeftJoinIndex; ++i) {
            HsqlArrayList tempJoins = this.tempJoinExpressions[i];
            for (int j = 0; j < tempJoins.size(); ++j) {
                Expression e = (Expression)tempJoins.get(j);
                if (e.isColumnEqual) {
                    joins.add(e);
                    continue;
                }
                if (!e.isSingleColumnCondition) continue;
                starts.add(e);
            }
        }
        this.reorderRanges(starts, joins);
    }

    void reorderRanges(HsqlArrayList starts, HsqlArrayList joins) {
        int i;
        if (starts.size() == 0) {
            return;
        }
        int position = -1;
        RangeVariable range = null;
        double cost = 1024.0;
        for (int i2 = 0; i2 < this.firstLeftJoinIndex; ++i2) {
            Table table = this.rangeVariables[i2].rangeTable;
            if (table instanceof TableDerived) continue;
            this.collectIndexableColumns(this.rangeVariables[i2], starts);
            Index.IndexUse[] indexes = table.getIndexForColumns(this.session, this.colIndexSetEqual, 40, false);
            Index index = null;
            for (int j = 0; j < indexes.length; ++j) {
                index = indexes[j].index;
                double currentCost = this.searchCost(this.session, table, index, indexes[j].columnCount, 40);
                if (!(currentCost < cost)) continue;
                cost = currentCost;
                position = i2;
            }
            if (index == null) {
                Iterator it = this.colIndexSetOther.keySet().iterator();
                while (it.hasNext()) {
                    int colIndex = it.nextInt();
                    index = table.getIndexForColumn(this.session, colIndex);
                    if (index == null) continue;
                    cost = (double)table.getRowStore(this.session).elementCount() / 2.0;
                    if (this.colIndexSetOther.get(colIndex, 0) <= 1) break;
                    cost /= 2.0;
                    break;
                }
            }
            if (index == null || i2 != 0) continue;
            position = 0;
            break;
        }
        if (position < 0) {
            return;
        }
        if (position == 0 && this.firstLeftJoinIndex == 2) {
            return;
        }
        RangeVariable[] newRanges = new RangeVariable[this.rangeVariables.length];
        ArrayUtil.copyArray(this.rangeVariables, newRanges, this.rangeVariables.length);
        range = newRanges[position];
        newRanges[position] = newRanges[0];
        newRanges[0] = range;
        for (position = 1; position < this.firstLeftJoinIndex; ++position) {
            int i3;
            boolean found = false;
            for (i3 = 0; i3 < joins.size(); ++i3) {
                int newPosition;
                Expression e = (Expression)joins.get(i3);
                if (e == null || (newPosition = this.getJoinedRangePosition(e, position, newRanges)) < position) continue;
                range = newRanges[position];
                newRanges[position] = newRanges[newPosition];
                newRanges[newPosition] = range;
                joins.set(i3, null);
                found = true;
                break;
            }
            if (found) continue;
            for (i3 = 0; i3 < starts.size(); ++i3) {
                Table table = newRanges[i3].rangeTable;
                this.collectIndexableColumns(newRanges[i3], starts);
                Index.IndexUse[] indexes = table.getIndexForColumns(this.session, this.colIndexSetEqual, 40, false);
                if (indexes.length <= 0) continue;
                found = true;
                break;
            }
            if (!found) break;
        }
        if (position != this.firstLeftJoinIndex) {
            return;
        }
        ArrayUtil.copyArray(newRanges, this.rangeVariables, this.rangeVariables.length);
        joins.clear();
        for (i = 0; i < this.firstLeftJoinIndex; ++i) {
            HsqlArrayList tempJoins = this.tempJoinExpressions[i];
            joins.addAll(tempJoins);
            tempJoins.clear();
        }
        this.tempJoinExpressions[this.firstLeftJoinIndex - 1].addAll(joins);
        this.rangeVarSet.clear();
        for (i = 0; i < this.rangeVariables.length; ++i) {
            this.rangeVarSet.add(this.rangeVariables[i]);
        }
    }

    int getJoinedRangePosition(Expression e, int position, RangeVariable[] currentRanges) {
        int found = -1;
        this.tempSet.clear();
        e.getJoinRangeVariables(currentRanges, this.tempSet);
        for (int i = 0; i < this.tempSet.size(); ++i) {
            for (int j = 0; j < currentRanges.length; ++j) {
                if (this.tempSet.get(i) != currentRanges[j] || j < position) continue;
                if (found > 0) {
                    return -1;
                }
                found = j;
            }
        }
        return found;
    }

    void assignToLists() {
        int i;
        int lastOuterIndex = -1;
        for (i = 0; i < this.rangeVariables.length; ++i) {
            if (this.rangeVariables[i].isLeftJoin) {
                lastOuterIndex = i;
            }
            if (this.rangeVariables[i].isRightJoin) {
                lastOuterIndex = i;
            }
            if (lastOuterIndex == i) {
                this.joinExpressions[i].addAll(this.tempJoinExpressions[i]);
                continue;
            }
            int start = lastOuterIndex + 1;
            for (int j = 0; j < this.tempJoinExpressions[i].size(); ++j) {
                Expression e = (Expression)this.tempJoinExpressions[i].get(j);
                this.assignToJoinLists(e, this.joinExpressions, start);
            }
        }
        for (i = 0; i < this.queryConditions.size(); ++i) {
            this.assignToJoinLists((Expression)this.queryConditions.get(i), this.whereExpressions, this.lastRightJoinIndex);
        }
    }

    void assignToJoinLists(Expression e, HsqlList[] expressionLists, int first) {
        if (e == null) {
            return;
        }
        this.tempSet.clear();
        e.collectRangeVariables(this.rangeVariables, this.tempSet);
        int index = this.rangeVarSet.getLargestIndex(this.tempSet);
        if (index == -1) {
            index = 0;
        }
        if (index < first) {
            index = first;
        }
        if (e instanceof ExpressionLogical && ((ExpressionLogical)e).isTerminal) {
            index = expressionLists.length - 1;
        }
        expressionLists[index].add(e);
    }

    void assignToRangeVariables() {
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            RangeVariable.RangeVariableConditions conditions;
            boolean hasIndex = false;
            if (i < this.firstLeftJoinIndex && this.firstRightJoinIndex == this.rangeVariables.length) {
                conditions = this.rangeVariables[i].joinConditions[0];
                this.joinExpressions[i].addAll(this.whereExpressions[i]);
                this.assignToRangeVariable(this.rangeVariables[i], conditions, i, this.joinExpressions[i]);
                this.assignToRangeVariable(conditions, this.joinExpressions[i]);
                continue;
            }
            conditions = this.rangeVariables[i].joinConditions[0];
            this.assignToRangeVariable(this.rangeVariables[i], conditions, i, this.joinExpressions[i]);
            conditions = this.rangeVariables[i].joinConditions[0];
            if (conditions.hasIndex()) {
                hasIndex = true;
            }
            this.assignToRangeVariable(conditions, this.joinExpressions[i]);
            conditions = this.rangeVariables[i].whereConditions[0];
            for (int j = i + 1; j < this.rangeVariables.length; ++j) {
                if (!this.rangeVariables[j].isRightJoin) continue;
                this.assignToRangeVariable(this.rangeVariables[j].whereConditions[0], this.whereExpressions[i]);
            }
            if (!hasIndex) {
                this.assignToRangeVariable(this.rangeVariables[i], conditions, i, this.whereExpressions[i]);
            }
            this.assignToRangeVariable(conditions, this.whereExpressions[i]);
        }
    }

    void assignToRangeVariable(RangeVariable.RangeVariableConditions conditions, HsqlList exprList) {
        int size = exprList.size();
        for (int j = 0; j < size; ++j) {
            Expression e = (Expression)exprList.get(j);
            conditions.addCondition(e);
        }
    }

    private void collectIndexableColumns(RangeVariable range, HsqlList exprList) {
        this.colIndexSetEqual.clear();
        this.colIndexSetOther.clear();
        int size = exprList.size();
        for (int j = 0; j < size; ++j) {
            int idx;
            Expression e = (Expression)exprList.get(j);
            if (!e.isSingleColumnCondition) continue;
            if (e.getLeftNode().getRangeVariable() == range) {
                idx = e.getLeftNode().getColumnIndex();
            } else {
                if (e.getRightNode().getRangeVariable() != range) continue;
                idx = e.getRightNode().getColumnIndex();
            }
            if (e.isSingleColumnEqual) {
                this.colIndexSetEqual.add(idx);
                continue;
            }
            int count = this.colIndexSetOther.get(idx, 0);
            this.colIndexSetOther.put(idx, count + 1);
        }
    }

    void assignToRangeVariable(RangeVariable rangeVar, RangeVariable.RangeVariableConditions conditions, int rangeVarIndex, HsqlList exprList) {
        if (exprList.isEmpty()) {
            return;
        }
        this.setIndexConditions(conditions, exprList, rangeVarIndex, true);
    }

    private void setIndexConditions(RangeVariable.RangeVariableConditions conditions, HsqlList exprList, int rangeVarIndex, boolean includeOr) {
        this.colIndexSetEqual.clear();
        this.colIndexSetOther.clear();
        int size = exprList.size();
        block8: for (int j = 0; j < size; ++j) {
            Expression e = (Expression)exprList.get(j);
            if (e == null || !e.isIndexable(conditions.rangeVar)) continue;
            int type = e.getType();
            switch (type) {
                case 50: {
                    continue block8;
                }
                case 2: {
                    continue block8;
                }
                case 40: {
                    if (e.exprSubType == 52 || e.exprSubType == 51 || e.getLeftNode().getRangeVariable() != conditions.rangeVar) continue block8;
                    int colIndex = e.getLeftNode().getColumnIndex();
                    this.colIndexSetEqual.add(colIndex);
                    continue block8;
                }
                case 47: {
                    if (e.getLeftNode().getRangeVariable() != conditions.rangeVar || conditions.rangeVar.isLeftJoin) continue block8;
                    int colIndex = e.getLeftNode().getColumnIndex();
                    this.colIndexSetEqual.add(colIndex);
                    continue block8;
                }
                case 48: {
                    if (e.getLeftNode().getLeftNode().getRangeVariable() != conditions.rangeVar || conditions.rangeVar.isLeftJoin) continue block8;
                    int colIndex = e.getLeftNode().getLeftNode().getColumnIndex();
                    int count = this.colIndexSetOther.get(colIndex, 0);
                    this.colIndexSetOther.put(colIndex, count + 1);
                    continue block8;
                }
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    if (e.getLeftNode().getRangeVariable() != conditions.rangeVar) continue block8;
                    int colIndex = e.getLeftNode().getColumnIndex();
                    int count = this.colIndexSetOther.get(colIndex, 0);
                    this.colIndexSetOther.put(colIndex, count + 1);
                    continue block8;
                }
                default: {
                    throw Error.runtimeError(201, "RangeVariableResolver");
                }
            }
        }
        this.setEqualityConditions(conditions, exprList, rangeVarIndex);
        boolean hasIndex = conditions.hasIndex();
        if (!hasIndex) {
            this.setNonEqualityConditions(conditions, exprList, rangeVarIndex);
            hasIndex = conditions.hasIndex();
        }
        if (rangeVarIndex == 0 && this.sortAndSlice.usingIndex) {
            hasIndex = true;
        }
        boolean isOR = false;
        if (!hasIndex && includeOr) {
            int size2 = exprList.size();
            for (int j = 0; j < size2; ++j) {
                Expression e = (Expression)exprList.get(j);
                if (e == null) continue;
                if (e.getType() == 50) {
                    hasIndex = this.setOrConditions(conditions, (ExpressionLogical)e, rangeVarIndex);
                    if (!hasIndex) continue;
                    exprList.set(j, null);
                    isOR = true;
                    break;
                }
                if (e.getType() != 40 || e.exprSubType != 52 || rangeVarIndex >= this.firstLeftJoinIndex || this.firstRightJoinIndex != this.rangeVariables.length || e.getRightNode().isCorrelated()) continue;
                OrderedIntHashSet set = new OrderedIntHashSet();
                ((ExpressionLogical)e).addLeftColumnsForAllAny(conditions.rangeVar, set);
                Index.IndexUse[] indexes = conditions.rangeVar.rangeTable.getIndexForColumns(this.session, set, 40, false);
                if (indexes.length == 0 || this.inExpressions[rangeVarIndex] != null) continue;
                this.inExpressions[rangeVarIndex] = e;
                this.inInJoin[rangeVarIndex] = conditions.isJoin;
                ++this.inExpressionCount;
                exprList.set(j, null);
                break;
            }
        }
        int size3 = exprList.size();
        for (int i = 0; i < size3; ++i) {
            Expression e = (Expression)exprList.get(i);
            if (e == null) continue;
            if (isOR) {
                for (int j = 0; j < conditions.rangeVar.joinConditions.length; ++j) {
                    if (conditions.isJoin) {
                        conditions.rangeVar.joinConditions[j].nonIndexCondition = ExpressionLogical.andExpressions(e, conditions.rangeVar.joinConditions[j].nonIndexCondition);
                        continue;
                    }
                    conditions.rangeVar.whereConditions[j].nonIndexCondition = ExpressionLogical.andExpressions(e, conditions.rangeVar.whereConditions[j].nonIndexCondition);
                }
                continue;
            }
            conditions.addCondition(e);
        }
    }

    private boolean setOrConditions(RangeVariable.RangeVariableConditions conditions, ExpressionLogical orExpression, int rangeVarIndex) {
        HsqlArrayList orExprList = new HsqlArrayList();
        RangeVariableResolver.decomposeOrConditions(orExpression, orExprList);
        Object[] conditionsArray = new RangeVariable.RangeVariableConditions[orExprList.size()];
        for (int i = 0; i < orExprList.size(); ++i) {
            HsqlArrayList exprList = new HsqlArrayList();
            Expression e = (Expression)orExprList.get(i);
            RangeVariableResolver.decomposeAndConditions(this.session, e, exprList);
            RangeVariable.RangeVariableConditions c = new RangeVariable.RangeVariableConditions(conditions);
            this.setIndexConditions(c, exprList, rangeVarIndex, false);
            conditionsArray[i] = c;
            if (c.hasIndex()) continue;
            return false;
        }
        Expression exclude = null;
        for (int i = 0; i < conditionsArray.length; ++i) {
            RangeVariable.RangeVariableConditions c = conditionsArray[i];
            conditionsArray[i].excludeConditions = exclude;
            if (i == conditionsArray.length - 1) break;
            Expression e = null;
            if (c.indexCond != null) {
                for (int k = 0; k < c.indexedColumnCount; ++k) {
                    e = ExpressionLogical.andExpressions(e, c.indexCond[k]);
                }
            }
            e = ExpressionLogical.andExpressions(e, c.indexEndCondition);
            e = ExpressionLogical.andExpressions(e, c.nonIndexCondition);
            exclude = ExpressionLogical.orExpressions(e, exclude);
        }
        if (exclude != null) {
            // empty if block
        }
        if (conditions.isJoin) {
            conditions.rangeVar.joinConditions = conditionsArray;
            conditionsArray = new RangeVariable.RangeVariableConditions[orExprList.size()];
            ArrayUtil.fillArray(conditionsArray, conditions.rangeVar.whereConditions[0]);
            conditions.rangeVar.whereConditions = conditionsArray;
        } else {
            conditions.rangeVar.whereConditions = conditionsArray;
            conditionsArray = new RangeVariable.RangeVariableConditions[orExprList.size()];
            ArrayUtil.fillArray(conditionsArray, conditions.rangeVar.joinConditions[0]);
            conditions.rangeVar.joinConditions = conditionsArray;
        }
        return true;
    }

    private void setEqualityConditions(RangeVariable.RangeVariableConditions conditions, HsqlList exprList, int rangeVarIndex) {
        Index index = null;
        if (rangeVarIndex == 0 && this.sortAndSlice.usingIndex && (index = this.sortAndSlice.primaryTableIndex) != null) {
            conditions.rangeIndex = index;
        }
        if (index == null) {
            Index.IndexUse[] indexes = conditions.rangeVar.rangeTable.getIndexForColumns(this.session, this.colIndexSetEqual, 40, false);
            if (indexes.length == 0) {
                return;
            }
            index = indexes[0].index;
            double cost = Double.MAX_VALUE;
            if (indexes.length > 1) {
                for (int i = 0; i < indexes.length; ++i) {
                    PersistentStore store = conditions.rangeVar.rangeTable.getRowStore(this.session);
                    double currentCost = store.searchCost(this.session, indexes[i].index, indexes[i].columnCount, 40);
                    if (!(currentCost < cost)) continue;
                    cost = currentCost;
                    index = indexes[i].index;
                }
            }
        }
        int[] cols = index.getColumns();
        int colCount = cols.length;
        Expression[] firstRowExpressions = new Expression[cols.length];
        for (int j = 0; j < exprList.size(); ++j) {
            int offset;
            int type;
            Expression e = (Expression)exprList.get(j);
            if (e == null || (type = e.getType()) != 40 && type != 47 || e.getLeftNode().getRangeVariable() != conditions.rangeVar || !e.isIndexable(conditions.rangeVar) || (offset = ArrayUtil.find(cols, e.getLeftNode().getColumnIndex())) == -1 || firstRowExpressions[offset] != null) continue;
            firstRowExpressions[offset] = e;
            exprList.set(j, null);
        }
        boolean hasNull = false;
        for (int i = 0; i < firstRowExpressions.length; ++i) {
            Expression e = firstRowExpressions[i];
            if (e == null) {
                if (colCount == cols.length) {
                    colCount = i;
                }
                hasNull = true;
                continue;
            }
            if (!hasNull) continue;
            exprList.add(e);
            firstRowExpressions[i] = null;
        }
        if (colCount > 0) {
            conditions.addIndexCondition(firstRowExpressions, index, colCount);
        }
    }

    private void setNonEqualityConditions(RangeVariable.RangeVariableConditions conditions, HsqlList exprList, int rangeVarIndex) {
        if (this.colIndexSetOther.isEmpty()) {
            return;
        }
        int currentCount = 0;
        Index index = null;
        if (rangeVarIndex == 0 && this.sortAndSlice.usingIndex) {
            index = this.sortAndSlice.primaryTableIndex;
        }
        if (index == null) {
            Iterator it = this.colIndexSetOther.keySet().iterator();
            while (it.hasNext()) {
                Index currentIndex;
                int colIndex = it.nextInt();
                int colCount = this.colIndexSetOther.get(colIndex, 0);
                if (colCount <= currentCount || (currentIndex = conditions.rangeVar.rangeTable.getIndexForColumn(this.session, colIndex)) == null) continue;
                index = currentIndex;
                currentCount = colCount;
            }
        }
        if (index == null) {
            return;
        }
        int[] cols = index.getColumns();
        for (int j = 0; j < exprList.size(); ++j) {
            Expression e = (Expression)exprList.get(j);
            if (e == null) continue;
            boolean isIndexed = false;
            switch (e.getType()) {
                case 48: {
                    if (e.getLeftNode().getType() != 47 || cols[0] != e.getLeftNode().getLeftNode().getColumnIndex()) break;
                    isIndexed = true;
                    break;
                }
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    if (cols[0] != e.getLeftNode().getColumnIndex() || e.getRightNode() == null || e.getRightNode().isCorrelated()) break;
                    isIndexed = true;
                }
            }
            if (!isIndexed) continue;
            Expression[] firstRowExpressions = new Expression[index.getColumnCount()];
            firstRowExpressions[0] = e;
            conditions.addIndexCondition(firstRowExpressions, index, 1);
            exprList.set(j, null);
            break;
        }
    }

    void setInConditionsAsTables() {
        for (int i = this.rangeVariables.length - 1; i >= 0; --i) {
            RangeVariable rangeVar = this.rangeVariables[i];
            ExpressionLogical in = (ExpressionLogical)this.inExpressions[i];
            if (in == null) continue;
            OrderedIntHashSet set = new OrderedIntHashSet();
            in.addLeftColumnsForAllAny(rangeVar, set);
            Index.IndexUse[] indexes = rangeVar.rangeTable.getIndexForColumns(this.session, set, 40, false);
            Index index = indexes[0].index;
            int indexedColCount = 0;
            for (int j = 0; j < index.getColumnCount() && set.contains(index.getColumns()[j]); ++j) {
                ++indexedColCount;
            }
            RangeVariable newRangeVar = new RangeVariable(in.getRightNode().getTable(), null, null, null, this.compileContext);
            newRangeVar.isGenerated = true;
            RangeVariable[] newList = new RangeVariable[this.rangeVariables.length + 1];
            ArrayUtil.copyAdjustArray(this.rangeVariables, newList, newRangeVar, i, 1);
            this.rangeVariables = newList;
            Expression[] exprList = new Expression[index.getColumnCount()];
            for (int j = 0; j < indexedColCount; ++j) {
                int leftIndex = index.getColumns()[j];
                int rightIndex = set.getIndex(leftIndex);
                ExpressionLogical e = new ExpressionLogical(rangeVar, leftIndex, newRangeVar, rightIndex);
                exprList[j] = e;
            }
            boolean isOuter = this.rangeVariables[i].isLeftJoin || this.rangeVariables[i].isRightJoin;
            RangeVariable.RangeVariableConditions conditions = !this.inInJoin[i] && isOuter ? rangeVar.whereConditions[0] : rangeVar.joinConditions[0];
            conditions.addIndexCondition(exprList, index, indexedColCount);
            int j = 0;
            while (j < set.size()) {
                int leftIndex = set.get(j);
                int rightIndex = j++;
                ExpressionLogical e = new ExpressionLogical(rangeVar, leftIndex, newRangeVar, rightIndex);
                conditions.addCondition(e);
            }
        }
    }

    private double searchCost(Session session, Table table, Index index, int count, int opType) {
        if (table instanceof TableDerived) {
            return 1000.0;
        }
        return table.getRowStore(session).searchCost(session, index, count, opType);
    }
}

