/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Row;
import org.hsqldb.Schema;
import org.hsqldb.SchemaObject;
import org.hsqldb.SchemaObjectSet;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.TableUtil;
import org.hsqldb.TableWorks;
import org.hsqldb.TriggerDef;
import org.hsqldb.TypeInvariants;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.MultiValueHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.WrapperIterator;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Collation;
import org.hsqldb.types.Type;

public class SchemaManager {
    Database database;
    HsqlNameManager.HsqlName defaultSchemaHsqlName;
    HashMappedList schemaMap = new HashMappedList();
    MultiValueHashMap referenceMap = new MultiValueHashMap();
    int defaultTableType = 4;
    long schemaChangeTimestamp;
    HsqlNameManager.HsqlName[] catalogNameArray;
    ReadWriteLock lock = new ReentrantReadWriteLock();
    Lock readLock = this.lock.readLock();
    Lock writeLock = this.lock.writeLock();
    Table dualTable;
    public Table dataChangeTable;
    long[][] tempIndexRoots;

    public SchemaManager(Database database) {
        this.database = database;
        this.defaultSchemaHsqlName = SqlInvariants.INFORMATION_SCHEMA_HSQLNAME;
        this.catalogNameArray = new HsqlNameManager.HsqlName[]{database.getCatalogName()};
        Schema schema = new Schema(SqlInvariants.INFORMATION_SCHEMA_HSQLNAME, SqlInvariants.INFORMATION_SCHEMA_HSQLNAME.owner);
        this.schemaMap.put(schema.getName().name, schema);
        try {
            schema.charsetLookup.add(Charset.SQL_TEXT, false);
            schema.charsetLookup.add(Charset.SQL_IDENTIFIER_CHARSET, false);
            schema.charsetLookup.add(Charset.SQL_CHARACTER, false);
            schema.collationLookup.add(Collation.getDefaultInstance(), false);
            schema.collationLookup.add(Collation.getDefaultIgnoreCaseInstance(), false);
            schema.typeLookup.add(TypeInvariants.CARDINAL_NUMBER, false);
            schema.typeLookup.add(TypeInvariants.YES_OR_NO, false);
            schema.typeLookup.add(TypeInvariants.CHARACTER_DATA, false);
            schema.typeLookup.add(TypeInvariants.SQL_IDENTIFIER, false);
            schema.typeLookup.add(TypeInvariants.TIME_STAMP, false);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    public void setSchemaChangeTimestamp() {
        this.schemaChangeTimestamp = this.database.txManager.getGlobalChangeTimestamp();
    }

    public long getSchemaChangeTimestamp() {
        return this.schemaChangeTimestamp;
    }

    public HsqlNameManager.HsqlName getSQLJSchemaHsqlName() {
        return SqlInvariants.SQLJ_SCHEMA_HSQLNAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPublicSchema() {
        this.writeLock.lock();
        try {
            HsqlNameManager.HsqlName name = this.database.nameManager.newHsqlName(null, "PUBLIC", 2);
            Schema schema = new Schema(name, this.database.getGranteeManager().getDBARole());
            this.defaultSchemaHsqlName = schema.getName();
            this.schemaMap.put(schema.getName().name, schema);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema(HsqlNameManager.HsqlName name, Grantee owner) {
        this.writeLock.lock();
        try {
            SqlInvariants.checkSchemaNameNotSystem(name.name);
            Schema schema = new Schema(name, owner);
            this.schemaMap.add(name.name, schema);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropSchema(Session session, String name, boolean cascade) {
        this.writeLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(name);
            if (schema == null) {
                throw Error.error(5501, name);
            }
            if (SqlInvariants.isLobsSchemaName(name)) {
                throw Error.error(5503, name);
            }
            if (!cascade && !schema.isEmpty()) {
                throw Error.error(4200);
            }
            OrderedHashSet externalReferences = new OrderedHashSet();
            this.getCascadingReferencesToSchema(schema.getName(), externalReferences);
            this.removeSchemaObjects(externalReferences);
            Iterator tableIterator = schema.schemaObjectIterator(3);
            while (tableIterator.hasNext()) {
                Table table = (Table)tableIterator.next();
                Constraint[] list = table.getFKConstraints();
                for (int i = 0; i < list.length; ++i) {
                    Constraint constraint = list[i];
                    if (constraint.getMain().getSchemaName() == schema.getName()) continue;
                    constraint.getMain().removeConstraint(constraint.getMainName().name);
                    this.removeReferencesFrom(constraint);
                }
                this.removeTable(session, table);
            }
            Iterator sequenceIterator = schema.schemaObjectIterator(7);
            while (sequenceIterator.hasNext()) {
                NumberSequence sequence = (NumberSequence)sequenceIterator.next();
                this.database.getGranteeManager().removeDbObject(sequence.getName());
            }
            schema.release();
            this.schemaMap.remove(name);
            if (this.defaultSchemaHsqlName.name.equals(name)) {
                HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(name, false, 2);
                schema = new Schema(hsqlName, this.database.getGranteeManager().getDBARole());
                this.defaultSchemaHsqlName = schema.getName();
                this.schemaMap.put(schema.getName().name, schema);
            }
            this.database.getUserManager().removeSchemaReference(name);
            this.database.getSessionManager().removeSchemaReference(schema);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameSchema(HsqlNameManager.HsqlName name, HsqlNameManager.HsqlName newName) {
        this.writeLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(name.name);
            Schema exists = (Schema)this.schemaMap.get(newName.name);
            if (schema == null) {
                throw Error.error(5501, name.name);
            }
            if (exists != null) {
                throw Error.error(5504, newName.name);
            }
            SqlInvariants.checkSchemaNameNotSystem(name.name);
            SqlInvariants.checkSchemaNameNotSystem(newName.name);
            int index = this.schemaMap.getIndex(name.name);
            schema.getName().rename(newName);
            this.schemaMap.set(index, newName.name, schema);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.writeLock.lock();
        try {
            Iterator it = this.schemaMap.values().iterator();
            while (it.hasNext()) {
                Schema schema = (Schema)it.next();
                schema.release();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSchemaNamesArray() {
        this.readLock.lock();
        try {
            Object[] array = new String[this.schemaMap.size()];
            this.schemaMap.toKeysArray(array);
            Object[] objectArray = array;
            return objectArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema[] getAllSchemas() {
        this.readLock.lock();
        try {
            Object[] objects = new Schema[this.schemaMap.size()];
            this.schemaMap.toValuesArray(objects);
            Object[] objectArray = objects;
            return objectArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlNameManager.HsqlName getUserSchemaHsqlName(String name) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(name);
            if (schema == null) {
                throw Error.error(4850, name);
            }
            if (schema.getName() == SqlInvariants.INFORMATION_SCHEMA_HSQLNAME) {
                throw Error.error(4850, name);
            }
            HsqlNameManager.HsqlName hsqlName = schema.getName();
            return hsqlName;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Grantee toSchemaOwner(String name) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(name);
            Grantee grantee = schema == null ? null : schema.getOwner();
            return grantee;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public HsqlNameManager.HsqlName getDefaultSchemaHsqlName() {
        return this.defaultSchemaHsqlName;
    }

    public void setDefaultSchemaHsqlName(HsqlNameManager.HsqlName name) {
        this.defaultSchemaHsqlName = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean schemaExists(String name) {
        this.readLock.lock();
        try {
            boolean bl = this.schemaMap.containsKey(name);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlNameManager.HsqlName findSchemaHsqlName(String name) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(name);
            if (schema == null) {
                HsqlNameManager.HsqlName hsqlName = null;
                return hsqlName;
            }
            HsqlNameManager.HsqlName hsqlName = schema.getName();
            return hsqlName;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlNameManager.HsqlName getSchemaHsqlName(String name) {
        if (name == null) {
            return this.defaultSchemaHsqlName;
        }
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(name);
            if (schema == null) {
                throw Error.error(4850, name);
            }
            HsqlNameManager.HsqlName hsqlName = schema.getName();
            return hsqlName;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getSchemaName(String name) {
        return this.getSchemaHsqlName((String)name).name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema findSchema(String name) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(name);
            return schema;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropSchemas(Session session, Grantee grantee, boolean cascade) {
        this.writeLock.lock();
        try {
            HsqlArrayList list = this.getSchemas(grantee);
            Iterator it = list.iterator();
            while (it.hasNext()) {
                Schema schema = (Schema)it.next();
                this.dropSchema(session, schema.getName().name, cascade);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlArrayList getSchemas(Grantee grantee) {
        this.readLock.lock();
        try {
            HsqlArrayList list = new HsqlArrayList();
            Iterator it = this.schemaMap.values().iterator();
            while (it.hasNext()) {
                Schema schema = (Schema)it.next();
                if (!grantee.equals(schema.getOwner())) continue;
                list.add(schema);
            }
            HsqlArrayList hsqlArrayList = list;
            return hsqlArrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSchemas(Grantee grantee) {
        this.readLock.lock();
        try {
            Iterator it = this.schemaMap.values().iterator();
            while (it.hasNext()) {
                Schema schema = (Schema)it.next();
                if (!grantee.equals(schema.getOwner())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlArrayList getAllTables(boolean withLobTables) {
        this.readLock.lock();
        try {
            HsqlArrayList alltables = new HsqlArrayList();
            String[] schemas = this.getSchemaNamesArray();
            for (int i = 0; i < schemas.length; ++i) {
                String name = schemas[i];
                if (!withLobTables && SqlInvariants.isLobsSchemaName(name) || SqlInvariants.isSystemSchemaName(name)) continue;
                HashMappedList current = this.getTables(name);
                alltables.addAll(current.values());
            }
            HsqlArrayList hsqlArrayList = alltables;
            return hsqlArrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMappedList getTables(String schema) {
        this.readLock.lock();
        try {
            Schema temp = (Schema)this.schemaMap.get(schema);
            HashMappedList hashMappedList = temp.tableList;
            return hashMappedList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public HsqlNameManager.HsqlName[] getCatalogNameArray() {
        return this.catalogNameArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlNameManager.HsqlName[] getCatalogAndBaseTableNames() {
        this.readLock.lock();
        try {
            OrderedHashSet names = new OrderedHashSet();
            HsqlArrayList tables = this.getAllTables(false);
            for (int i = 0; i < tables.size(); ++i) {
                Table table = (Table)tables.get(i);
                if (table.isTemp()) continue;
                names.add(table.getName());
            }
            names.add(this.database.getCatalogName());
            Object[] array = new HsqlNameManager.HsqlName[names.size()];
            names.toArray(array);
            Object[] objectArray = array;
            return objectArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlNameManager.HsqlName[] getCatalogAndBaseTableNames(HsqlNameManager.HsqlName name) {
        if (name == null) {
            return this.catalogNameArray;
        }
        this.readLock.lock();
        try {
            SchemaObject parentObject;
            switch (name.type) {
                case 2: {
                    if (this.findSchemaHsqlName(name.name) == null) {
                        HsqlNameManager.HsqlName[] hsqlNameArray = this.catalogNameArray;
                        return hsqlNameArray;
                    }
                    OrderedHashSet names = new OrderedHashSet();
                    names.add(this.database.getCatalogName());
                    HashMappedList list = this.getTables(name.name);
                    for (int i = 0; i < list.size(); ++i) {
                        names.add(((SchemaObject)list.get(i)).getName());
                    }
                    Object[] array = new HsqlNameManager.HsqlName[names.size()];
                    names.toArray(array);
                    Object[] objectArray = array;
                    return objectArray;
                }
                case 11: {
                    HsqlNameManager.HsqlName[] names = this.catalogNameArray;
                    return names;
                }
                case 5: 
                case 20: {
                    this.findSchemaObject(name.name, name.schema.name, name.type);
                }
            }
            SchemaObject object = this.findSchemaObject(name.name, name.schema.name, name.type);
            if (object == null) {
                HsqlNameManager.HsqlName[] list = this.catalogNameArray;
                return list;
            }
            HsqlNameManager.HsqlName parent = object.getName().parent;
            OrderedHashSet references = this.getReferencesTo(object.getName());
            OrderedHashSet names = new OrderedHashSet();
            names.add(this.database.getCatalogName());
            if (parent != null && (parentObject = this.findSchemaObject(parent.name, parent.schema.name, parent.type)) != null && parentObject.getName().type == 3) {
                names.add(parentObject.getName());
            }
            if (object.getName().type == 3) {
                names.add(object.getName());
            }
            for (int i = 0; i < references.size(); ++i) {
                Table table;
                HsqlNameManager.HsqlName reference = (HsqlNameManager.HsqlName)references.get(i);
                if (reference.type != 3 || (table = this.findUserTable(null, reference.name, reference.schema.name)) == null || table.isTemp()) continue;
                names.add(reference);
            }
            Object[] array = new HsqlNameManager.HsqlName[names.size()];
            names.toArray(array);
            Object[] objectArray = array;
            return objectArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private SchemaObjectSet getSchemaObjectSet(Schema schema, int type) {
        SchemaObjectSet set = null;
        switch (type) {
            case 7: {
                set = schema.sequenceLookup;
                break;
            }
            case 3: 
            case 4: {
                set = schema.tableLookup;
                break;
            }
            case 14: {
                set = schema.charsetLookup;
                break;
            }
            case 15: {
                set = schema.collationLookup;
                break;
            }
            case 17: {
                set = schema.procedureLookup;
                break;
            }
            case 16: {
                set = schema.functionLookup;
                break;
            }
            case 12: 
            case 13: {
                set = schema.typeLookup;
                break;
            }
            case 20: {
                set = schema.indexLookup;
                break;
            }
            case 5: {
                set = schema.constraintLookup;
                break;
            }
            case 8: {
                set = schema.triggerLookup;
                break;
            }
            case 24: {
                set = schema.specificRoutineLookup;
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSchemaObjectNotExists(HsqlNameManager.HsqlName name) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(name.schema.name);
            SchemaObjectSet set = this.getSchemaObjectSet(schema, name.type);
            set.checkAdd(name);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Table getUserTable(Session session, HsqlNameManager.HsqlName name) {
        return this.getUserTable(session, name.name, name.schema.name);
    }

    public Table getUserTable(Session session, String name, String schema) {
        Table t = this.findUserTable(session, name, schema);
        if (t == null) {
            String longName = schema == null ? name : schema + '.' + name;
            throw Error.error(5501, longName);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table findUserTable(Session session, String name, String schemaName) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(schemaName);
            if (schema == null) {
                Table table = null;
                return table;
            }
            int i = schema.tableList.getIndex(name);
            if (i == -1) {
                Table table = null;
                return table;
            }
            Table table = (Table)schema.tableList.get(i);
            return table;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Table findSessionTable(Session session, String name) {
        return session.sessionContext.findSessionTable(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTableOrView(Session session, Table table, boolean cascade) {
        this.writeLock.lock();
        try {
            if (table.isView()) {
                this.dropView(table, cascade);
            } else {
                this.dropTable(session, table, cascade);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void dropView(Table table, boolean cascade) {
        Schema schema = (Schema)this.schemaMap.get(table.getSchemaName().name);
        this.removeSchemaObject(table.getName(), cascade);
        schema.triggerLookup.removeParent(table.getName());
    }

    private void dropTable(Session session, Table table, boolean cascade) {
        Schema schema = (Schema)this.schemaMap.get(table.getSchemaName().name);
        int dropIndex = schema.tableList.getIndex(table.getName().name);
        OrderedHashSet externalConstraints = table.getDependentExternalConstraints();
        OrderedHashSet externalReferences = new OrderedHashSet();
        this.getCascadingReferencesTo(table.getName(), externalReferences);
        if (!cascade) {
            int i;
            for (i = 0; i < externalConstraints.size(); ++i) {
                Constraint c = (Constraint)externalConstraints.get(i);
                HsqlNameManager.HsqlName refname = c.getRefName();
                if (c.getConstraintType() != 1) continue;
                throw Error.error(5533, refname.getSchemaQualifiedStatementName());
            }
            if (!externalReferences.isEmpty()) {
                for (i = 0; i < externalReferences.size(); ++i) {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)externalReferences.get(i);
                    if (name.parent == table.getName()) continue;
                    throw Error.error(5502, name.getSchemaQualifiedStatementName());
                }
            }
        }
        OrderedHashSet tableSet = new OrderedHashSet();
        OrderedHashSet constraintNameSet = new OrderedHashSet();
        OrderedHashSet indexNameSet = new OrderedHashSet();
        for (int i = 0; i < externalConstraints.size(); ++i) {
            Constraint c = (Constraint)externalConstraints.get(i);
            Table t = c.getMain();
            if (t != table) {
                tableSet.add(t);
            }
            if ((t = c.getRef()) != table) {
                tableSet.add(t);
            }
            constraintNameSet.add(c.getMainName());
            constraintNameSet.add(c.getRefName());
            indexNameSet.add(c.getRefIndex().getName());
        }
        OrderedHashSet uniqueConstraintNames = table.getUniquePKConstraintNames();
        TableWorks tw = new TableWorks(session, table);
        tableSet = tw.dropConstraintsAndIndexes(tableSet, constraintNameSet, indexNameSet);
        tw.setNewTablesInSchema(tableSet);
        tw.updateConstraints(tableSet, constraintNameSet);
        this.removeSchemaObjects(externalReferences);
        this.removeTableDependentReferences(table);
        this.removeReferencesTo(uniqueConstraintNames);
        this.removeReferencesTo(table.getName());
        this.removeReferencesFrom(table);
        schema.tableList.remove(dropIndex);
        schema.indexLookup.removeParent(table.getName());
        schema.constraintLookup.removeParent(table.getName());
        schema.triggerLookup.removeParent(table.getName());
        this.removeTable(session, table);
        this.recompileDependentObjects(tableSet);
    }

    private void removeTable(Session session, Table table) {
        this.database.getGranteeManager().removeDbObject(table.getName());
        table.releaseTriggers();
        if (!table.isView() && table.hasLobColumn()) {
            RowIterator it = table.rowIterator(session);
            while (it.hasNext()) {
                Row row = it.getNextRow();
                Object[] data = row.getData();
                session.sessionData.adjustLobUsageCount(table, data, -1);
            }
        }
        if (table.tableType == 3) {
            Session[] sessions = this.database.sessionManager.getAllSessions();
            for (int i = 0; i < sessions.length; ++i) {
                sessions[i].sessionData.persistentStoreCollection.removeStore(table);
            }
        } else {
            this.database.persistentStoreCollection.removeStore(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTable(int index, Table table) {
        this.writeLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(table.getSchemaName().name);
            schema.tableList.set(index, table.getName().name, table);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTableIndex(Table table) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(table.getSchemaName().name);
            if (schema == null) {
                int n = -1;
                return n;
            }
            HsqlNameManager.HsqlName name = table.getName();
            int n = schema.tableList.getIndex(name.name);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recompileDependentObjects(OrderedHashSet tableSet) {
        this.writeLock.lock();
        try {
            OrderedHashSet set = new OrderedHashSet();
            for (int i = 0; i < tableSet.size(); ++i) {
                Table table = (Table)tableSet.get(i);
                set.addAll(this.getReferencesTo(table.getName()));
            }
            Session session = this.database.sessionManager.getSysSession();
            for (int i = 0; i < set.size(); ++i) {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)set.get(i);
                switch (name.type) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 24: {
                        SchemaObject object = this.getSchemaObject(name);
                        object.compile(session, null);
                    }
                }
            }
            if (Error.TRACE) {
                HsqlArrayList list = this.getAllTables(false);
                for (int i = 0; i < list.size(); ++i) {
                    Table t = (Table)list.get(i);
                    t.verifyConstraintsIntegrity();
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recompileDependentObjects(Table table) {
        this.writeLock.lock();
        try {
            OrderedHashSet set = new OrderedHashSet();
            this.getCascadingReferencesTo(table.getName(), set);
            Session session = this.database.sessionManager.getSysSession();
            for (int i = 0; i < set.size(); ++i) {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)set.get(i);
                switch (name.type) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 24: {
                        SchemaObject object = this.getSchemaObject(name);
                        object.compile(session, null);
                    }
                }
            }
            if (Error.TRACE) {
                HsqlArrayList list = this.getAllTables(false);
                for (int i = 0; i < list.size(); ++i) {
                    Table t = (Table)list.get(i);
                    t.verifyConstraintsIntegrity();
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Collation getCollation(Session session, String name, String schemaName) {
        Collation collation = null;
        if (schemaName == null || "INFORMATION_SCHEMA".equals(schemaName)) {
            try {
                collation = Collation.getCollation(name);
            }
            catch (HsqlException e) {
                // empty catch block
            }
        }
        if (collation == null) {
            schemaName = session.getSchemaName(schemaName);
            collation = (Collation)this.getSchemaObject(name, schemaName, 15);
        }
        return collation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NumberSequence getSequence(String name, String schemaName, boolean raise) {
        this.readLock.lock();
        try {
            NumberSequence object;
            Schema schema = (Schema)this.schemaMap.get(schemaName);
            if (schema != null && (object = (NumberSequence)schema.sequenceList.get(name)) != null) {
                NumberSequence numberSequence = object;
                return numberSequence;
            }
            if (raise) {
                throw Error.error(5501, name);
            }
            NumberSequence numberSequence = null;
            return numberSequence;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getUserDefinedType(String name, String schemaName, boolean raise) {
        this.readLock.lock();
        try {
            SchemaObject object;
            Schema schema = (Schema)this.schemaMap.get(schemaName);
            if (schema != null && (object = schema.typeLookup.getObject(name)) != null) {
                Type type = (Type)object;
                return type;
            }
            if (raise) {
                throw Error.error(5501, name);
            }
            Type type = null;
            return type;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type findDomainOrUDT(Session session, String name, String prefix, String prePrefix, String prePrePrefix) {
        this.readLock.lock();
        try {
            Type type;
            Type type2 = type = (Type)this.findSchemaObject(session, name, prefix, prePrefix, 12);
            return type2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getDomain(String name, String schemaName, boolean raise) {
        this.readLock.lock();
        try {
            SchemaObject object;
            Schema schema = (Schema)this.schemaMap.get(schemaName);
            if (schema != null && (object = schema.typeLookup.getObject(name)) != null && ((Type)object).isDomainType()) {
                Type type = (Type)object;
                return type;
            }
            if (raise) {
                throw Error.error(5501, name);
            }
            Type type = null;
            return type;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type getDistinctType(String name, String schemaName, boolean raise) {
        this.readLock.lock();
        try {
            SchemaObject object;
            Schema schema = (Schema)this.schemaMap.get(schemaName);
            if (schema != null && (object = schema.typeLookup.getObject(name)) != null && ((Type)object).isDistinctType()) {
                Type type = (Type)object;
                return type;
            }
            if (raise) {
                throw Error.error(5501, name);
            }
            Type type = null;
            return type;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaObject getSchemaObject(String name, String schemaName, int type) {
        this.readLock.lock();
        try {
            SchemaObject object = this.findSchemaObject(name, schemaName, type);
            if (object == null) {
                throw Error.error(SchemaObjectSet.getGetErrorCode(type), name);
            }
            SchemaObject schemaObject = object;
            return schemaObject;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public SchemaObject getCharacterSet(Session session, String name, String schemaName) {
        if (schemaName == null || "INFORMATION_SCHEMA".equals(schemaName)) {
            if (name.equals("SQL_IDENTIFIER")) {
                return Charset.SQL_IDENTIFIER_CHARSET;
            }
            if (name.equals("SQL_TEXT")) {
                return Charset.SQL_TEXT;
            }
            if (name.equals("LATIN1")) {
                return Charset.LATIN1;
            }
            if (name.equals("ASCII_GRAPHIC")) {
                return Charset.ASCII_GRAPHIC;
            }
        }
        if (schemaName == null) {
            schemaName = session.getSchemaName(null);
        }
        return this.getSchemaObject(name, schemaName, 14);
    }

    public Table findTable(Session session, String name, String prefix, String prePrefix) {
        Table t;
        if (prefix == null && (t = this.findSessionTable(session, name)) != null) {
            return t;
        }
        if (prePrefix == null && ("SESSION".equals(prefix) ? (t = this.findSessionTable(session, name)) != null : "INFORMATION_SCHEMA".equals(prefix) && this.database.dbInfo != null && (t = this.database.dbInfo.getSystemTable(session, name)) != null)) {
            return t;
        }
        t = (Table)this.findSchemaObject(session, name, prefix, prePrefix, 3);
        return t;
    }

    public SchemaObject findSchemaObject(Session session, String name, String prefix, String prePrefix, int type) {
        Table t;
        switch (type) {
            case 3: 
            case 12: 
            case 16: 
            case 17: 
            case 18: {
                if (prefix == null) {
                    if ((session.database.sqlSyntaxOra || session.database.sqlSyntaxDb2 || session.isProcessingScript()) && type == 3 && "DUAL".equals(name)) {
                        return this.dualTable;
                    }
                    if (type != 3 || (t = this.findSessionTable(session, name)) == null) break;
                    return t;
                }
                if (prePrefix != null) break;
                if (type == 3 && "MODULE".equals(prefix) && (t = this.findSessionTable(session, name)) != null) {
                    return t;
                }
                if (type != 3 || !"SESSION".equals(prefix) || (t = this.findSessionTable(session, name)) == null) break;
                return t;
            }
        }
        if (prefix == null) {
            prefix = session.getSchemaName(null);
        }
        if (prePrefix != null && !prePrefix.equals(this.database.getCatalogName().name)) {
            return null;
        }
        if (type == 3 && "INFORMATION_SCHEMA".equals(prefix) && this.database.dbInfo != null && (t = this.database.dbInfo.getSystemTable(session, name)) != null) {
            return t;
        }
        return this.findSchemaObject(name, prefix, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaObject findSchemaObject(String name, String schemaName, int type) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(schemaName);
            if (schema == null) {
                SchemaObject schemaObject = null;
                return schemaObject;
            }
            SchemaObject schemaObject = schema.findSchemaObject(name, type);
            return schemaObject;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Table findUserTableForIndex(Session session, String name, String schemaName) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(schemaName);
            HsqlNameManager.HsqlName indexName = schema.indexLookup.getName(name);
            if (indexName == null) {
                Table table = null;
                return table;
            }
            Table table = this.findUserTable(session, indexName.parent.name, schemaName);
            return table;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropIndex(Session session, HsqlNameManager.HsqlName name) {
        this.writeLock.lock();
        try {
            Table t = this.getUserTable(session, name.parent.name, name.parent.schema.name);
            TableWorks tw = new TableWorks(session, t);
            tw.dropIndex(name.name);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropConstraint(Session session, HsqlNameManager.HsqlName name, boolean cascade) {
        this.writeLock.lock();
        try {
            Table t = this.getUserTable(session, name.parent.name, name.parent.schema.name);
            TableWorks tw = new TableWorks(session, t);
            tw.dropConstraint(name.name, cascade);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDependentObjects(HsqlNameManager.HsqlName name) {
        this.writeLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(name.schema.name);
            schema.indexLookup.removeParent(name);
            schema.constraintLookup.removeParent(name);
            schema.triggerLookup.removeParent(name);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeExportedKeys(Table toDrop) {
        this.writeLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(toDrop.getSchemaName().name);
            for (int i = 0; i < schema.tableList.size(); ++i) {
                Table table = (Table)schema.tableList.get(i);
                Constraint[] constraints = table.getConstraints();
                for (int j = constraints.length - 1; j >= 0; --j) {
                    Table refTable = constraints[j].getRef();
                    if (toDrop != refTable) continue;
                    table.removeConstraint(j);
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator databaseObjectIterator(String schemaName, int type) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(schemaName);
            Iterator iterator = schema.schemaObjectIterator(type);
            return iterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator databaseObjectIterator(int type) {
        this.readLock.lock();
        try {
            Iterator it = this.schemaMap.values().iterator();
            WrapperIterator objects = new WrapperIterator();
            while (it.hasNext()) {
                Object[] values;
                int targetType = type;
                if (type == 18) {
                    targetType = 16;
                }
                Schema temp = (Schema)it.next();
                SchemaObjectSet set = temp.getObjectSet(targetType);
                if (set.map.size() != 0) {
                    values = new Object[set.map.size()];
                    set.map.valuesToArray(values);
                    objects = new WrapperIterator(objects, new WrapperIterator(values));
                }
                if (type != 18) continue;
                set = temp.getObjectSet(17);
                if (set.map.size() == 0) continue;
                values = new Object[set.map.size()];
                set.map.valuesToArray(values);
                objects = new WrapperIterator(objects, new WrapperIterator(values));
            }
            WrapperIterator wrapperIterator = objects;
            return wrapperIterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void addReferencesFrom(SchemaObject object) {
        OrderedHashSet set = object.getReferences();
        HsqlNameManager.HsqlName name = object.getName();
        if (set == null) {
            return;
        }
        for (int i = 0; i < set.size(); ++i) {
            HsqlNameManager.HsqlName referenced = (HsqlNameManager.HsqlName)set.get(i);
            if (object instanceof Routine) {
                name = ((Routine)object).getSpecificName();
            }
            this.referenceMap.put(referenced, name);
        }
    }

    private void removeReferencesTo(OrderedHashSet set) {
        for (int i = 0; i < set.size(); ++i) {
            HsqlNameManager.HsqlName referenced = (HsqlNameManager.HsqlName)set.get(i);
            this.referenceMap.remove(referenced);
        }
    }

    private void removeReferencesTo(HsqlNameManager.HsqlName referenced) {
        this.referenceMap.remove(referenced);
    }

    private void removeReferencesFrom(SchemaObject object) {
        HsqlNameManager.HsqlName name = object.getName();
        OrderedHashSet set = object.getReferences();
        if (set == null) {
            return;
        }
        for (int i = 0; i < set.size(); ++i) {
            HsqlNameManager.HsqlName referenced = (HsqlNameManager.HsqlName)set.get(i);
            if (object instanceof Routine) {
                name = ((Routine)object).getSpecificName();
            }
            this.referenceMap.remove(referenced, name);
        }
    }

    private void removeTableDependentReferences(Table table) {
        OrderedHashSet mainSet = table.getReferencesForDependents();
        block5: for (int i = 0; i < mainSet.size(); ++i) {
            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)mainSet.get(i);
            SchemaObject object = null;
            switch (name.type) {
                case 5: {
                    object = table.getConstraint(name.name);
                    break;
                }
                case 8: {
                    object = table.getTrigger(name.name);
                    break;
                }
                case 9: {
                    object = table.getColumn(table.getColumnIndex(name.name));
                    break;
                }
                default: {
                    continue block5;
                }
            }
            this.removeReferencesFrom(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderedHashSet getReferencesTo(HsqlNameManager.HsqlName object) {
        this.readLock.lock();
        try {
            OrderedHashSet set = new OrderedHashSet();
            Iterator it = this.referenceMap.get(object);
            while (it.hasNext()) {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)it.next();
                set.add(name);
            }
            OrderedHashSet orderedHashSet = set;
            return orderedHashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderedHashSet getReferencesTo(HsqlNameManager.HsqlName table, HsqlNameManager.HsqlName column) {
        this.readLock.lock();
        try {
            HsqlNameManager.HsqlName name;
            OrderedHashSet set = new OrderedHashSet();
            Iterator it = this.referenceMap.get(table);
            while (it.hasNext()) {
                name = (HsqlNameManager.HsqlName)it.next();
                SchemaObject object = this.getSchemaObject(name);
                OrderedHashSet references = object.getReferences();
                if (!references.contains(column)) continue;
                set.add(name);
            }
            it = this.referenceMap.get(column);
            while (it.hasNext()) {
                name = (HsqlNameManager.HsqlName)it.next();
                set.add(name);
            }
            OrderedHashSet orderedHashSet = set;
            return orderedHashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReferenced(HsqlNameManager.HsqlName object) {
        this.writeLock.lock();
        try {
            boolean bl = this.referenceMap.containsKey(object);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getCascadingReferencesTo(HsqlNameManager.HsqlName object, OrderedHashSet set) {
        this.readLock.lock();
        try {
            OrderedHashSet newSet = new OrderedHashSet();
            Iterator it = this.referenceMap.get(object);
            while (it.hasNext()) {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)it.next();
                boolean added = set.add(name);
                if (!added) continue;
                newSet.add(name);
            }
            for (int i = 0; i < newSet.size(); ++i) {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)newSet.get(i);
                this.getCascadingReferencesTo(name, set);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void getCascadingReferencesToSchema(HsqlNameManager.HsqlName schema, OrderedHashSet set) {
        Iterator mainIterator = this.referenceMap.keySet().iterator();
        while (mainIterator.hasNext()) {
            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)mainIterator.next();
            if (name.schema != schema) continue;
            this.getCascadingReferencesTo(name, set);
        }
        for (int i = set.size() - 1; i >= 0; --i) {
            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)set.get(i);
            if (name.schema != schema) continue;
            set.remove(i);
        }
    }

    public MultiValueHashMap getReferencesToSchema(String schemaName) {
        MultiValueHashMap map = new MultiValueHashMap();
        Iterator mainIterator = this.referenceMap.keySet().iterator();
        while (mainIterator.hasNext()) {
            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)mainIterator.next();
            if (!name.schema.name.equals(schemaName)) continue;
            Iterator it = this.referenceMap.get(name);
            while (it.hasNext()) {
                map.put(name, it.next());
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HsqlNameManager.HsqlName getSchemaObjectName(HsqlNameManager.HsqlName schemaName, String name, int type, boolean raise) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(schemaName.name);
            SchemaObjectSet set = null;
            if (schema == null) {
                if (raise) {
                    throw Error.error(SchemaObjectSet.getGetErrorCode(type));
                }
                HsqlNameManager.HsqlName hsqlName = null;
                return hsqlName;
            }
            if (type == 18) {
                set = schema.functionLookup;
                SchemaObject object = schema.functionLookup.getObject(name);
                if (object == null) {
                    set = schema.procedureLookup;
                    object = schema.procedureLookup.getObject(name);
                }
            } else {
                set = this.getSchemaObjectSet(schema, type);
            }
            if (raise) {
                set.checkExists(name);
            }
            HsqlNameManager.HsqlName hsqlName = set.getName(name);
            return hsqlName;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaObject getSchemaObject(HsqlNameManager.HsqlName name) {
        this.readLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(name.schema.name);
            if (schema == null) {
                SchemaObject schemaObject = null;
                return schemaObject;
            }
            switch (name.type) {
                case 7: {
                    SchemaObject schemaObject = (SchemaObject)schema.sequenceList.get(name.name);
                    return schemaObject;
                }
                case 3: 
                case 4: {
                    SchemaObject schemaObject = (SchemaObject)schema.tableList.get(name.name);
                    return schemaObject;
                }
                case 14: {
                    SchemaObject schemaObject = schema.charsetLookup.getObject(name.name);
                    return schemaObject;
                }
                case 15: {
                    SchemaObject schemaObject = schema.collationLookup.getObject(name.name);
                    return schemaObject;
                }
                case 17: {
                    SchemaObject schemaObject = schema.procedureLookup.getObject(name.name);
                    return schemaObject;
                }
                case 16: {
                    SchemaObject schemaObject = schema.functionLookup.getObject(name.name);
                    return schemaObject;
                }
                case 24: {
                    SchemaObject schemaObject = schema.specificRoutineLookup.getObject(name.name);
                    return schemaObject;
                }
                case 18: {
                    SchemaObject object = schema.functionLookup.getObject(name.name);
                    if (object == null) {
                        object = schema.procedureLookup.getObject(name.name);
                    }
                    SchemaObject schemaObject = object;
                    return schemaObject;
                }
                case 12: 
                case 13: {
                    SchemaObject schemaObject = schema.typeLookup.getObject(name.name);
                    return schemaObject;
                }
                case 8: {
                    name = schema.triggerLookup.getName(name.name);
                    if (name == null) {
                        SchemaObject schemaObject = null;
                        return schemaObject;
                    }
                    HsqlNameManager.HsqlName tableName = name.parent;
                    Table table = (Table)schema.tableList.get(tableName.name);
                    TriggerDef triggerDef = table.getTrigger(name.name);
                    return triggerDef;
                }
                case 5: {
                    name = schema.constraintLookup.getName(name.name);
                    if (name == null) {
                        SchemaObject tableName = null;
                        return tableName;
                    }
                    HsqlNameManager.HsqlName tableName = name.parent;
                    Table table = (Table)schema.tableList.get(tableName.name);
                    Constraint constraint = table.getConstraint(name.name);
                    return constraint;
                }
                case 6: {
                    SchemaObject tableName = null;
                    return tableName;
                }
                case 20: {
                    name = schema.indexLookup.getName(name.name);
                    if (name == null) {
                        SchemaObject tableName = null;
                        return tableName;
                    }
                    HsqlNameManager.HsqlName tableName = name.parent;
                    Table table = (Table)schema.tableList.get(tableName.name);
                    Index index = table.getIndex(name.name);
                    return index;
                }
            }
            SchemaObject schemaObject = null;
            return schemaObject;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void checkColumnIsReferenced(HsqlNameManager.HsqlName tableName, HsqlNameManager.HsqlName name) {
        OrderedHashSet set = this.getReferencesTo(tableName, name);
        if (!set.isEmpty()) {
            HsqlNameManager.HsqlName objectName = (HsqlNameManager.HsqlName)set.get(0);
            throw Error.error(5502, objectName.getSchemaQualifiedStatementName());
        }
    }

    public void checkObjectIsReferenced(HsqlNameManager.HsqlName name) {
        OrderedHashSet set = this.getReferencesTo(name);
        HsqlNameManager.HsqlName refName = null;
        for (int i = 0; i < set.size(); ++i) {
            refName = (HsqlNameManager.HsqlName)set.get(i);
            if (refName.parent != name) break;
            refName = null;
        }
        if (refName == null) {
            return;
        }
        if (name.type == 5) {
            return;
        }
        int errorCode = 5502;
        if (refName.type == 0) {
            errorCode = 5533;
        }
        throw Error.error(errorCode, refName.getSchemaQualifiedStatementName());
    }

    public void checkSchemaNameCanChange(HsqlNameManager.HsqlName name) {
        this.readLock.lock();
        try {
            Iterator it = this.referenceMap.values().iterator();
            HsqlNameManager.HsqlName refName = null;
            block7: while (it.hasNext()) {
                refName = (HsqlNameManager.HsqlName)it.next();
                switch (refName.type) {
                    case 4: 
                    case 8: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 24: {
                        if (refName.schema == name) break block7;
                    }
                    default: {
                        refName = null;
                        continue block7;
                    }
                }
            }
            if (refName == null) {
                return;
            }
            throw Error.error(5502, refName.getSchemaQualifiedStatementName());
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSchemaObject(SchemaObject object) {
        this.writeLock.lock();
        try {
            HsqlNameManager.HsqlName name = object.getName();
            Schema schema = (Schema)this.schemaMap.get(name.schema.name);
            switch (name.type) {
                case 3: {
                    OrderedHashSet refs = ((Table)object).getReferencesForDependents();
                    block12: for (int i = 0; i < refs.size(); ++i) {
                        HsqlNameManager.HsqlName ref = (HsqlNameManager.HsqlName)refs.get(i);
                        switch (ref.type) {
                            case 9: {
                                int index = ((Table)object).findColumn(ref.name);
                                ColumnSchema column = ((Table)object).getColumn(index);
                                this.addSchemaObject(column);
                                continue block12;
                            }
                        }
                    }
                    break;
                }
                case 9: {
                    OrderedHashSet refs = object.getReferences();
                    if (refs == null || refs.isEmpty()) {
                        return;
                    }
                    this.addReferencesFrom(object);
                    return;
                }
            }
            schema.addSchemaObject(this.database.nameManager, object, false);
            this.addReferencesFrom(object);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSchemaObject(HsqlNameManager.HsqlName name, boolean cascade) {
        this.writeLock.lock();
        try {
            OrderedHashSet objectSet = new OrderedHashSet();
            switch (name.type) {
                case 16: 
                case 17: 
                case 18: {
                    RoutineSchema routine = (RoutineSchema)this.getSchemaObject(name);
                    if (routine == null) break;
                    Routine[] specifics = routine.getSpecificRoutines();
                    for (int i = 0; i < specifics.length; ++i) {
                        this.getCascadingReferencesTo(specifics[i].getSpecificName(), objectSet);
                    }
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 12: 
                case 14: 
                case 15: 
                case 24: {
                    this.getCascadingReferencesTo(name, objectSet);
                    break;
                }
                case 13: {
                    OrderedHashSet set = this.getReferencesTo(name);
                    Iterator it = set.iterator();
                    while (it.hasNext()) {
                        HsqlNameManager.HsqlName ref = (HsqlNameManager.HsqlName)it.next();
                        if (ref.type != 9) continue;
                        it.remove();
                    }
                    if (set.isEmpty()) break;
                    HsqlNameManager.HsqlName objectName = (HsqlNameManager.HsqlName)set.get(0);
                    throw Error.error(5502, objectName.getSchemaQualifiedStatementName());
                }
            }
            if (objectSet.isEmpty()) {
                this.removeSchemaObject(name);
                return;
            }
            if (!cascade) {
                HsqlNameManager.HsqlName objectName = (HsqlNameManager.HsqlName)objectSet.get(0);
                throw Error.error(5502, objectName.getSchemaQualifiedStatementName());
            }
            objectSet.add(name);
            this.removeSchemaObjects(objectSet);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSchemaObjects(OrderedHashSet set) {
        this.writeLock.lock();
        try {
            for (int i = 0; i < set.size(); ++i) {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)set.get(i);
                this.removeSchemaObject(name);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSchemaObject(HsqlNameManager.HsqlName name) {
        this.writeLock.lock();
        try {
            Schema schema = (Schema)this.schemaMap.get(name.schema.name);
            SchemaObject object = null;
            SchemaObjectSet set = null;
            switch (name.type) {
                case 7: {
                    set = schema.sequenceLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 3: 
                case 4: {
                    set = schema.tableLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 9: {
                    Table table = (Table)this.getSchemaObject(name.parent);
                    if (table == null) break;
                    object = table.getColumn(table.getColumnIndex(name.name));
                    break;
                }
                case 14: {
                    set = schema.charsetLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 15: {
                    set = schema.collationLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 17: {
                    set = schema.procedureLookup;
                    RoutineSchema routine = (RoutineSchema)set.getObject(name.name);
                    object = routine;
                    Routine[] specifics = routine.getSpecificRoutines();
                    for (int i = 0; i < specifics.length; ++i) {
                        this.removeSchemaObject(specifics[i].getSpecificName());
                    }
                    break;
                }
                case 16: {
                    set = schema.functionLookup;
                    RoutineSchema routine = (RoutineSchema)set.getObject(name.name);
                    object = routine;
                    Routine[] specifics = routine.getSpecificRoutines();
                    for (int i = 0; i < specifics.length; ++i) {
                        this.removeSchemaObject(specifics[i].getSpecificName());
                    }
                    break;
                }
                case 24: {
                    set = schema.specificRoutineLookup;
                    Routine routine = (Routine)set.getObject(name.name);
                    object = routine;
                    routine.routineSchema.removeSpecificRoutine(routine);
                    if (routine.routineSchema.getSpecificRoutines().length != 0) break;
                    this.removeSchemaObject(routine.getName());
                    break;
                }
                case 12: 
                case 13: {
                    set = schema.typeLookup;
                    object = set.getObject(name.name);
                    break;
                }
                case 20: {
                    set = schema.indexLookup;
                    break;
                }
                case 5: {
                    set = schema.constraintLookup;
                    if (name.parent.type == 3) {
                        Table table = (Table)schema.tableList.get(name.parent.name);
                        object = table.getConstraint(name.name);
                        table.removeConstraint(name.name);
                        break;
                    }
                    if (name.parent.type != 13) break;
                    Type type = (Type)schema.typeLookup.getObject(name.parent.name);
                    object = type.userTypeModifier.getConstraint(name.name);
                    type.userTypeModifier.removeConstraint(name.name);
                    break;
                }
                case 8: {
                    set = schema.triggerLookup;
                    Table table = (Table)schema.tableList.get(name.parent.name);
                    object = table.getTrigger(name.name);
                    if (object == null) break;
                    table.removeTrigger((TriggerDef)object);
                    break;
                }
                default: {
                    throw Error.runtimeError(201, "SchemaManager");
                }
            }
            if (object != null) {
                this.database.getGranteeManager().removeDbObject(name);
                this.removeReferencesFrom(object);
            }
            if (set != null) {
                set.remove(name.name);
            }
            this.removeReferencesTo(name);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameSchemaObject(HsqlNameManager.HsqlName name, HsqlNameManager.HsqlName newName) {
        this.writeLock.lock();
        try {
            if (name.schema != newName.schema) {
                throw Error.error(5505, newName.schema.name);
            }
            this.checkObjectIsReferenced(name);
            Schema schema = (Schema)this.schemaMap.get(name.schema.name);
            SchemaObjectSet set = this.getSchemaObjectSet(schema, name.type);
            set.rename(name, newName);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceReferences(SchemaObject oldObject, SchemaObject newObject) {
        this.writeLock.lock();
        try {
            this.removeReferencesFrom(oldObject);
            this.addReferencesFrom(newObject);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSQLArray() {
        this.readLock.lock();
        try {
            Schema schema;
            SchemaObject object;
            OrderedHashSet newResolved;
            Iterator it;
            Schema schema2;
            OrderedHashSet resolved = new OrderedHashSet();
            OrderedHashSet unresolved = new OrderedHashSet();
            HsqlArrayList list = new HsqlArrayList();
            Iterator schemas = this.schemaMap.values().iterator();
            schemas = this.schemaMap.values().iterator();
            while (schemas.hasNext()) {
                schema2 = (Schema)schemas.next();
                if (SqlInvariants.isSystemSchemaName(schema2.getName().name) || SqlInvariants.isLobsSchemaName(schema2.getName().name)) continue;
                list.add(schema2.getSQL());
                schema2.addSimpleObjects(unresolved);
            }
            while ((it = unresolved.iterator()).hasNext()) {
                newResolved = new OrderedHashSet();
                SchemaObjectSet.addAllSQL(resolved, unresolved, list, it, newResolved);
                unresolved.removeAll(newResolved);
                if (newResolved.size() != 0) continue;
                break;
            }
            schemas = this.schemaMap.values().iterator();
            while (schemas.hasNext()) {
                schema2 = (Schema)schemas.next();
                if (SqlInvariants.isLobsSchemaName(schema2.getName().name) || SqlInvariants.isSystemSchemaName(schema2.getName().name)) continue;
                list.addAll(schema2.getSQLArray(resolved, unresolved));
            }
            while ((it = unresolved.iterator()).hasNext()) {
                newResolved = new OrderedHashSet();
                SchemaObjectSet.addAllSQL(resolved, unresolved, list, it, newResolved);
                unresolved.removeAll(newResolved);
                if (newResolved.size() != 0) continue;
                break;
            }
            it = unresolved.iterator();
            while (it.hasNext()) {
                object = (SchemaObject)it.next();
                if (!(object instanceof Routine)) continue;
                list.add(((Routine)object).getSQLDeclaration());
            }
            it = unresolved.iterator();
            while (it.hasNext()) {
                object = (SchemaObject)it.next();
                if (object instanceof Routine) {
                    list.add(((Routine)object).getSQLAlter());
                    continue;
                }
                list.add(object.getSQL());
            }
            schemas = this.schemaMap.values().iterator();
            while (schemas.hasNext()) {
                Object[] t;
                schema = (Schema)schemas.next();
                if (SqlInvariants.isLobsSchemaName(schema.getName().name) || SqlInvariants.isSystemSchemaName(schema.getName().name) || (t = schema.getTriggerSQL()).length <= 0) continue;
                list.add(Schema.getSetSchemaSQL(schema.getName()));
                list.addAll(t);
            }
            schemas = this.schemaMap.values().iterator();
            while (schemas.hasNext()) {
                schema = (Schema)schemas.next();
                list.addAll(schema.getSequenceRestartSQL());
            }
            if (this.defaultSchemaHsqlName != null) {
                StringBuffer sb = new StringBuffer();
                sb.append("SET").append(' ').append("DATABASE");
                sb.append(' ').append("DEFAULT").append(' ');
                sb.append("INITIAL").append(' ').append("SCHEMA");
                sb.append(' ').append(this.defaultSchemaHsqlName.statementName);
                list.add(sb.toString());
            }
            String[] array = new String[list.size()];
            list.toArray(array);
            String[] stringArray = array;
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTablePropsSQL(boolean withHeader) {
        this.readLock.lock();
        try {
            HsqlArrayList tableList = this.getAllTables(false);
            HsqlArrayList list = new HsqlArrayList();
            for (int i = 0; i < tableList.size(); ++i) {
                Object ddl;
                Table t = (Table)tableList.get(i);
                if (t.isText()) {
                    ddl = t.getSQLForTextSource(withHeader);
                    list.addAll((Object[])ddl);
                }
                if ((ddl = t.getSQLForReadOnly()) != null) {
                    list.add(ddl);
                }
                if (!t.isCached() || (ddl = t.getSQLForClustered()) == null) continue;
                list.add(ddl);
            }
            String[] array = new String[list.size()];
            list.toArray(array);
            String[] stringArray = array;
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTableSpaceSQL() {
        this.readLock.lock();
        try {
            HsqlArrayList tableList = this.getAllTables(false);
            HsqlArrayList list = new HsqlArrayList();
            for (int i = 0; i < tableList.size(); ++i) {
                String ddl;
                Table t = (Table)tableList.get(i);
                if (!t.isCached() || (ddl = t.getSQLForTableSpace()) == null) continue;
                list.add(ddl);
            }
            String[] array = new String[list.size()];
            list.toArray(array);
            String[] stringArray = array;
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getIndexRootsSQL() {
        this.readLock.lock();
        try {
            Session sysSession = this.database.sessionManager.getSysSession();
            long[][] rootsArray = this.getIndexRoots(sysSession);
            HsqlArrayList tableList = this.getAllTables(true);
            HsqlArrayList list = new HsqlArrayList();
            for (int i = 0; i < rootsArray.length; ++i) {
                Table table = (Table)tableList.get(i);
                if (rootsArray[i] == null || rootsArray[i].length <= 0 || rootsArray[i][0] == -1L) continue;
                String ddl = table.getIndexRootsSQL(rootsArray[i]);
                list.add(ddl);
            }
            String[] array = new String[list.size()];
            list.toArray(array);
            String[] stringArray = array;
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCommentsArray() {
        this.readLock.lock();
        try {
            HsqlArrayList tableList = this.getAllTables(false);
            HsqlArrayList list = new HsqlArrayList();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < tableList.size(); ++i) {
                Table table = (Table)tableList.get(i);
                if (table.getTableType() == 1) continue;
                int colCount = table.getColumnCount();
                for (int j = 0; j < colCount; ++j) {
                    ColumnSchema column = table.getColumn(j);
                    if (column.getName().comment == null) continue;
                    sb.setLength(0);
                    sb.append("COMMENT").append(' ').append("ON");
                    sb.append(' ').append("COLUMN").append(' ');
                    sb.append(table.getName().getSchemaQualifiedStatementName());
                    sb.append('.').append(column.getName().statementName);
                    sb.append(' ').append("IS").append(' ');
                    sb.append(StringConverter.toQuotedString(column.getName().comment, '\'', true));
                    list.add(sb.toString());
                }
                if (table.getName().comment == null) continue;
                sb.setLength(0);
                sb.append("COMMENT").append(' ').append("ON");
                sb.append(' ').append("TABLE").append(' ');
                sb.append(table.getName().getSchemaQualifiedStatementName());
                sb.append(' ').append("IS").append(' ');
                sb.append(StringConverter.toQuotedString(table.getName().comment, '\'', true));
                list.add(sb.toString());
            }
            Iterator it = this.databaseObjectIterator(18);
            while (it.hasNext()) {
                SchemaObject object = (SchemaObject)it.next();
                if (object.getName().comment == null) continue;
                sb.setLength(0);
                sb.append("COMMENT").append(' ').append("ON");
                sb.append(' ').append("ROUTINE").append(' ');
                sb.append(object.getName().getSchemaQualifiedStatementName());
                sb.append(' ').append("IS").append(' ');
                sb.append(StringConverter.toQuotedString(object.getName().comment, '\'', true));
                list.add(sb.toString());
            }
            String[] array = new String[list.size()];
            list.toArray(array);
            String[] stringArray = array;
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setTempIndexRoots(long[][] roots) {
        this.tempIndexRoots = roots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[][] getIndexRoots(Session session) {
        this.readLock.lock();
        try {
            if (this.tempIndexRoots != null) {
                long[][] roots = this.tempIndexRoots;
                this.tempIndexRoots = null;
                long[][] lArray = roots;
                return lArray;
            }
            HsqlArrayList allTables = this.getAllTables(true);
            HsqlArrayList list = new HsqlArrayList();
            int size = allTables.size();
            for (int i = 0; i < size; ++i) {
                Table t = (Table)allTables.get(i);
                if (t.getTableType() == 5) {
                    long[] roots = t.getIndexRootsArray();
                    list.add(roots);
                    continue;
                }
                list.add(null);
            }
            long[][] array = new long[list.size()][];
            list.toArray(array);
            long[][] lArrayArray = array;
            return lArrayArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndexRoots(long[][] roots) {
        this.readLock.lock();
        try {
            HsqlArrayList allTables = this.database.schemaManager.getAllTables(true);
            int size = allTables.size();
            for (int i = 0; i < size; ++i) {
                long[] rootsArray;
                Table t = (Table)allTables.get(i);
                if (t.getTableType() != 5 || (rootsArray = roots[i]) == null) continue;
                t.setIndexRoots(rootsArray);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setDefaultTableType(int type) {
        this.defaultTableType = type;
    }

    public int getDefaultTableType() {
        return this.defaultTableType;
    }

    public void createSystemTables() {
        this.dualTable = TableUtil.newSingleColumnTable(this.database, SqlInvariants.DUAL_TABLE_HSQLNAME, 12, SqlInvariants.DUAL_COLUMN_HSQLNAME, Type.SQL_VARCHAR);
        this.dualTable.insertSys(this.database.sessionManager.getSysSession(), this.dualTable.getRowStore(null), new Object[]{"X"});
        this.dualTable.setDataReadOnly(true);
        Type[] columnTypes = new Type[]{Type.SQL_BIGINT, Type.SQL_BIGINT, Type.SQL_BIGINT, TypeInvariants.SQL_IDENTIFIER, TypeInvariants.SQL_IDENTIFIER, Type.SQL_BOOLEAN};
        HsqlNameManager.HsqlName tableName = this.database.nameManager.getSubqueryTableName();
        HashMappedList columnList = new HashMappedList();
        for (int i = 0; i < columnTypes.length; ++i) {
            HsqlNameManager cfr_ignored_0 = this.database.nameManager;
            HsqlNameManager.HsqlName name = HsqlNameManager.getAutoColumnName(i + 1);
            ColumnSchema column = new ColumnSchema(name, columnTypes[i], true, false, null);
            columnList.add(name.name, column);
        }
        this.dataChangeTable = new TableDerived(this.database, tableName, 13, columnTypes, columnList, new int[]{0});
        this.dataChangeTable.createIndexForColumns(null, new int[]{1});
    }
}

