/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.error.Error;

public class SqlInvariants {
    public static final String SYSTEM_AUTHORIZATION_NAME = "_SYSTEM";
    public static final String DBA_ADMIN_ROLE_NAME = "DBA";
    public static final String SCHEMA_CREATE_ROLE_NAME = "CREATE_SCHEMA";
    public static final String CHANGE_AUTH_ROLE_NAME = "CHANGE_AUTHORIZATION";
    public static final String SYSTEM_SUBQUERY = "SYSTEM_SUBQUERY";
    public static final String PUBLIC_ROLE_NAME = "PUBLIC";
    public static final String DEFAULT_CATALOG_NAME = "PUBLIC";
    public static final String SYSTEM_SCHEMA = "SYSTEM_SCHEMA";
    public static final String LOBS_SCHEMA = "SYSTEM_LOBS";
    public static final String DEFINITION_SCHEMA = "DEFINITION_SCHEMA";
    public static final String INFORMATION_SCHEMA = "INFORMATION_SCHEMA";
    public static final String SQLJ_SCHEMA = "SQLJ";
    public static final String PUBLIC_SCHEMA = "PUBLIC";
    public static final String CLASSPATH_NAME = "CLASSPATH";
    public static final String MODULE = "MODULE";
    public static final String DUAL = "DUAL";
    public static final String DUMMY = "DUMMY";
    public static final String IDX = "IDX";
    public static final HsqlNameManager.HsqlName INFORMATION_SCHEMA_HSQLNAME = HsqlNameManager.newSystemObjectName("INFORMATION_SCHEMA", 2);
    public static final HsqlNameManager.HsqlName SYSTEM_SCHEMA_HSQLNAME = HsqlNameManager.newSystemObjectName("SYSTEM_SCHEMA", 2);
    public static final HsqlNameManager.HsqlName LOBS_SCHEMA_HSQLNAME = HsqlNameManager.newSystemObjectName("SYSTEM_LOBS", 2);
    public static final HsqlNameManager.HsqlName SQLJ_SCHEMA_HSQLNAME = HsqlNameManager.newSystemObjectName("SQLJ", 2);
    public static final HsqlNameManager.HsqlName SYSTEM_SUBQUERY_HSQLNAME = HsqlNameManager.newSystemObjectName("SYSTEM_SUBQUERY", 3);
    public static final HsqlNameManager.HsqlName MODULE_HSQLNAME = HsqlNameManager.newSystemObjectName("MODULE", 2);
    public static final HsqlNameManager.HsqlName DUAL_TABLE_HSQLNAME = HsqlNameManager.newSystemObjectName("DUAL", 3);
    public static final HsqlNameManager.HsqlName DUAL_COLUMN_HSQLNAME;
    public static final HsqlNameManager.HsqlName SYSTEM_INDEX_HSQLNAME;

    public static final void checkSchemaNameNotSystem(String name) {
        if (SqlInvariants.isSystemSchemaName(name)) {
            throw Error.error(5503, name);
        }
    }

    public static final boolean isSystemSchemaName(String name) {
        return DEFINITION_SCHEMA.equals(name) || INFORMATION_SCHEMA.equals(name) || SYSTEM_SCHEMA.equals(name) || SQLJ_SCHEMA.equals(name);
    }

    public static final boolean isLobsSchemaName(String name) {
        return LOBS_SCHEMA.equals(name);
    }

    public static final boolean isSchemaNameSystem(HsqlNameManager.HsqlName name) {
        if (name.schema != null) {
            name = name.schema;
        }
        return INFORMATION_SCHEMA_HSQLNAME.equals(name) || SYSTEM_SCHEMA_HSQLNAME.equals(name) || SQLJ_SCHEMA_HSQLNAME.equals(name);
    }

    static {
        SqlInvariants.DUAL_TABLE_HSQLNAME.schema = SYSTEM_SCHEMA_HSQLNAME;
        DUAL_COLUMN_HSQLNAME = HsqlNameManager.newSystemObjectName(DUMMY, 9);
        SqlInvariants.DUAL_COLUMN_HSQLNAME.parent = DUAL_TABLE_HSQLNAME;
        SYSTEM_INDEX_HSQLNAME = HsqlNameManager.newSystemObjectName(IDX, 20);
        SYSTEM_SUBQUERY_HSQLNAME.setSchemaIfNull(SYSTEM_SCHEMA_HSQLNAME);
    }
}

