/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Routine;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.StatementSchema;
import org.hsqldb.Table;
import org.hsqldb.TableWorks;
import org.hsqldb.TextTable;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.DataSpaceManager;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.TableSpaceManager;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.rights.User;
import org.hsqldb.scriptio.ScriptWriterText;

public class StatementCommand
extends Statement {
    Object[] parameters;

    StatementCommand(int type, Object[] args) {
        this(type, args, null, null);
    }

    StatementCommand(int type, Object[] args, HsqlNameManager.HsqlName[] readNames, HsqlNameManager.HsqlName[] writeNames) {
        super(type);
        this.isTransactionStatement = true;
        this.parameters = args;
        if (readNames != null) {
            this.readTableNames = readNames;
        }
        if (writeNames != null) {
            this.writeTableNames = writeNames;
        }
        switch (type) {
            case 1215: {
                this.group = 2014;
                break;
            }
            case 1151: {
                this.group = 2009;
                this.statementReturnType = 2;
                this.isTransactionStatement = false;
                this.isLogged = false;
                break;
            }
            case 1002: {
                this.group = 2014;
                this.isLogged = false;
                break;
            }
            case 1004: {
                String name = (String)this.parameters[0];
                if (name == null) {
                    this.statementReturnType = 2;
                }
                this.group = 2014;
                this.isLogged = false;
                break;
            }
            case 1001: {
                this.group = 2014;
                if (writeNames.length == 0) {
                    this.group = 2015;
                }
                this.isLogged = false;
                break;
            }
            case 1016: 
            case 1032: 
            case 1033: 
            case 1055: {
                this.isTransactionStatement = false;
                this.group = 2013;
                break;
            }
            case 1011: 
            case 1012: 
            case 1013: 
            case 1015: 
            case 1017: 
            case 1018: 
            case 1020: 
            case 1021: 
            case 1022: 
            case 1025: 
            case 1026: 
            case 1031: 
            case 1034: 
            case 1035: 
            case 1036: 
            case 1037: 
            case 1039: 
            case 1040: 
            case 1046: 
            case 1047: 
            case 1049: 
            case 1050: 
            case 1051: 
            case 1052: 
            case 1053: 
            case 1054: 
            case 1056: {
                this.group = 2013;
                break;
            }
            case 1014: {
                this.group = 2013;
                this.isLogged = false;
                break;
            }
            case 1158: 
            case 1159: 
            case 1160: {
                this.group = 2012;
                break;
            }
            case 1156: {
                this.group = 2012;
                this.isLogged = false;
                break;
            }
            case 1155: {
                this.group = 2012;
                break;
            }
            case 1154: {
                this.group = 2012;
                break;
            }
            case 1003: {
                this.group = 2014;
                this.isTransactionStatement = false;
                this.isLogged = false;
                break;
            }
            case 1157: {
                this.group = 2012;
                break;
            }
            case 1153: {
                this.group = 2013;
                this.isTransactionStatement = false;
                this.isLogged = false;
                break;
            }
            case 1091: 
            case 1092: 
            case 1093: {
                this.group = 2013;
                this.isTransactionStatement = false;
                break;
            }
            case 1005: {
                this.group = 2011;
                this.isTransactionStatement = false;
                this.isLogged = false;
                break;
            }
            default: {
                throw Error.runtimeError(201, "StatementCommand");
            }
        }
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable t) {
            result = Result.newErrorResult(t, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
            return result;
        }
        try {
            if (this.isLogged) {
                session.database.logger.writeOtherStatement(session, this.sql);
            }
        }
        catch (Throwable e) {
            return Result.newErrorResult(e, this.sql);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Result getResult(Session session) {
        if (this.isExplain) {
            return Result.newSingleColumnStringResult("OPERATION", this.describe(session));
        }
        switch (this.type) {
            case 1215: {
                return this.getTruncateResult(session);
            }
            case 1151: {
                Statement statement = (Statement)this.parameters[0];
                return Result.newSingleColumnStringResult("OPERATION", statement.describe(session));
            }
            case 1001: {
                String path = (String)this.parameters[0];
                boolean blocking = (Boolean)this.parameters[1];
                boolean script = (Boolean)this.parameters[2];
                boolean compressed = (Boolean)this.parameters[3];
                boolean files = (Boolean)this.parameters[4];
                try {
                    session.checkAdmin();
                    if (!session.database.getType().equals("file:")) {
                        throw Error.error(459);
                    }
                    if (session.database.isFilesReadOnly()) {
                        throw Error.error(455);
                    }
                    if (session.database.logger.isStoredFileAccess()) {
                        throw Error.error(457);
                    }
                    session.database.logger.backup(path, script, blocking, compressed, files);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1002: {
                boolean defrag = (Boolean)this.parameters[0];
                session.database.lobManager.lock();
                try {
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.checkpoint(defrag);
                    Result blocking = Result.updateZeroResult;
                    return blocking;
                }
                catch (HsqlException e) {
                    Result script = Result.newErrorResult(e, this.sql);
                    return script;
                }
                finally {
                    session.database.lobManager.unlock();
                }
            }
            case 1011: {
                try {
                    boolean mode = (Boolean)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setIncrementBackup(mode);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1012: {
                try {
                    int value = (Integer)this.parameters[0];
                    boolean check = this.parameters[1] == null;
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (check && !session.database.getProperties().validateProperty("hsqldb.cache_rows", value)) {
                        throw Error.error(5556);
                    }
                    session.database.logger.setCacheMaxRows(value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1013: {
                try {
                    int value = (Integer)this.parameters[0];
                    boolean check = this.parameters[1] == null;
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (check && !session.database.getProperties().validateProperty("hsqldb.cache_size", value)) {
                        throw Error.error(5556);
                    }
                    session.database.logger.setCacheSize(value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1014: {
                try {
                    long value1 = (Long)this.parameters[0];
                    long value2 = (Long)this.parameters[1];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (session.isProcessingScript()) {
                        session.database.logger.setFilesTimestamp(value1);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1017: {
                try {
                    int value = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (session.isProcessingScript()) {
                        session.database.logger.setLobFileScaleNoCheck(value);
                    } else {
                        session.database.logger.setLobFileScale(value);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1018: {
                try {
                    boolean mode = (Boolean)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (session.isProcessingScript()) {
                        session.database.logger.setLobFileCompressedNoCheck(mode);
                    } else {
                        session.database.logger.setLobFileCompressed(mode);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1025: {
                try {
                    int value = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (session.isProcessingScript()) {
                        session.database.logger.setDataFileScaleNoCheck(value);
                    } else {
                        session.database.logger.setDataFileScale(value);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1031: {
                try {
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (session.database.getType().equals("res:")) {
                        return Result.updateZeroResult;
                    }
                    if (session.database.isFilesReadOnly()) {
                        return Result.updateZeroResult;
                    }
                    if (this.parameters[0] instanceof Boolean) {
                        boolean value = (Boolean)this.parameters[0];
                        session.database.logger.setDataFileSpaces(value);
                    } else {
                        int value = (Integer)this.parameters[0];
                        session.database.logger.setDataFileSpaces(value);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1015: {
                try {
                    int value = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (!session.database.getProperties().validateProperty("hsqldb.defrag_limit", value)) {
                        throw Error.error(5556);
                    }
                    session.database.logger.setDefagLimit(value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1016: {
                try {
                    int value = (Integer)this.parameters[0];
                    boolean isSql = (Boolean)this.parameters[1];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setEventLogLevel(value, isSql);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1022: {
                try {
                    session.checkAdmin();
                    session.checkDDLWrite();
                    Object v = this.parameters[0];
                    if (v instanceof Boolean) {
                        boolean value = (Boolean)this.parameters[0];
                        session.database.logger.setNioDataFile(value);
                    } else {
                        int value = (Integer)this.parameters[0];
                        session.database.logger.setNioMaxSize(value);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1020: {
                try {
                    boolean value = (Boolean)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setLogData(value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1021: {
                try {
                    int value = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setLogSize(value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1032: {
                try {
                    String value = (String)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1026: {
                try {
                    int value = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setScriptType(value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1033: {
                try {
                    int value = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setWriteDelay(value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1036: {
                try {
                    Routine routine = (Routine)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.userManager.setExtAuthenticationFunction(routine);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1040: {
                try {
                    Routine routine = (Routine)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.userManager.setPasswordCheckFunction(routine);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1056: {
                try {
                    String algo = (String)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (!session.isProcessingScript()) {
                        return Result.updateZeroResult;
                    }
                    session.database.granteeManager.setDigestAlgo(algo);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1047: {
                try {
                    String name = (String)this.parameters[0];
                    boolean padSpaces = (Boolean)this.parameters[1];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.collation.setCollation(name, padSpaces);
                    session.database.schemaManager.setSchemaChangeTimestamp();
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1049: {
                boolean mode = (Boolean)this.parameters[0];
                session.checkAdmin();
                session.checkDDLWrite();
                session.database.setReferentialIntegrity(mode);
                return Result.updateZeroResult;
            }
            case 1050: {
                String property = (String)this.parameters[0];
                boolean mode = (Boolean)this.parameters[1];
                int value = ((Number)this.parameters[2]).intValue();
                session.checkAdmin();
                session.checkDDLWrite();
                if (property == "sql.enforce_names") {
                    session.database.setStrictNames(mode);
                } else if (property == "sql.regular_names") {
                    session.database.setRegularNames(mode);
                } else if (property == "sql.enforce_size") {
                    session.database.setStrictColumnSize(mode);
                } else if (property == "sql.enforce_types") {
                    session.database.setStrictTypes(mode);
                } else if (property == "sql.enforce_refs") {
                    session.database.setStrictReferences(mode);
                } else if (property == "sql.enforce_tdc_delete") {
                    session.database.setStrictTDCD(mode);
                } else if (property == "sql.enforce_tdc_update") {
                    session.database.setStrictTDCU(mode);
                } else if (property == "jdbc.translate_tti_types") {
                    session.database.setTranslateTTI(mode);
                } else if (property == "sql.concat_nulls") {
                    session.database.setConcatNulls(mode);
                } else if (property == "sql.nulls_first") {
                    session.database.setNullsFirst(mode);
                } else if (property == "sql.nulls_order") {
                    session.database.setNullsOrder(mode);
                } else if (property == "sql.unique_nulls") {
                    session.database.setUniqueNulls(mode);
                } else if (property == "sql.convert_trunc") {
                    session.database.setConvertTrunc(mode);
                } else if (property == "sql.avg_scale") {
                    session.database.setAvgScale(value);
                } else if (property == "sql.double_nan") {
                    session.database.setDoubleNaN(mode);
                } else if (property == "sql.longvar_is_lob") {
                    session.database.setLongVarIsLob(mode);
                } else if (property == "sql.ignore_case") {
                    session.database.setIgnoreCase(mode);
                    session.setIgnoreCase(mode);
                } else if (property == "sql.syntax_db2") {
                    session.database.setSyntaxDb2(mode);
                } else if (property == "sql.syntax_mss") {
                    session.database.setSyntaxMss(mode);
                } else if (property == "sql.syntax_mys") {
                    session.database.setSyntaxMys(mode);
                } else if (property == "sql.syntax_ora") {
                    session.database.setSyntaxOra(mode);
                } else if (property == "sql.syntax_pgs") {
                    session.database.setSyntaxPgs(mode);
                }
                return Result.updateZeroResult;
            }
            case 1034: {
                HsqlNameManager.HsqlName schema = (HsqlNameManager.HsqlName)this.parameters[0];
                session.checkAdmin();
                session.checkDDLWrite();
                session.database.schemaManager.setDefaultSchemaHsqlName(schema);
                session.database.schemaManager.setSchemaChangeTimestamp();
                return Result.updateZeroResult;
            }
            case 1035: {
                Integer type = (Integer)this.parameters[0];
                session.checkAdmin();
                session.checkDDLWrite();
                session.database.schemaManager.setDefaultTableType(type);
                return Result.updateZeroResult;
            }
            case 1052: {
                try {
                    int mode = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.database.txManager.setTransactionControl(session, mode);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1053: {
                try {
                    int mode = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.database.defaultIsolationLevel = mode;
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1054: {
                try {
                    boolean mode = (Boolean)this.parameters[0];
                    session.checkAdmin();
                    session.database.txConflictRollback = mode;
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1037: {
                try {
                    int count = (Integer)this.parameters[0];
                    session.checkAdmin();
                    JavaSystem.gcFrequency = count;
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1039: {
                try {
                    String property = (String)this.parameters[0];
                    Object value = this.parameters[1];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1046: {
                int size = (Integer)this.parameters[0];
                session.checkAdmin();
                session.database.setResultMaxMemoryRows(size);
                return Result.updateZeroResult;
            }
            case 1051: {
                try {
                    String source = (String)this.parameters[0];
                    HsqlProperties props = null;
                    session.checkAdmin();
                    if (source.length() > 0) {
                        props = HsqlProperties.delimitedArgPairsToProps(source, "=", ";", null);
                        if (props.getErrorKeys().length > 0) {
                            throw Error.error(482, props.getErrorKeys()[0]);
                        }
                        session.database.logger.setDefaultTextTableProperties(source, props);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1055: {
                try {
                    String name = (String)this.parameters[0];
                    session.checkAdmin();
                    session.database.setUniqueName(name);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1004: {
                ScriptWriterText dsw = null;
                String name = (String)this.parameters[0];
                try {
                    session.checkAdmin();
                    if (name == null) {
                        return session.database.getScript(false);
                    }
                    dsw = new ScriptWriterText(session.database, name, true, true, true);
                    dsw.writeAll();
                    dsw.close();
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1003: {
                try {
                    int mode = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.database.close(mode);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1159: {
                try {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.parameters[0];
                    Table table = session.database.schemaManager.getUserTable(session, name.name, name.schema.name);
                    session.checkAdmin();
                    session.checkDDLWrite();
                    if (!session.database.logger.isFileDatabase()) {
                        return Result.updateZeroResult;
                    }
                    if (session.database.logger.getDataFileSpaces() == 0) {
                        throw Error.error(457);
                    }
                    if (table.getSpaceID() != 7) {
                        return Result.updateZeroResult;
                    }
                    DataFileCache cache = session.database.logger.getCache();
                    if (cache == null) {
                        return Result.updateZeroResult;
                    }
                    DataSpaceManager dataSpace = cache.spaceManager;
                    int tableSpaceID = dataSpace.getNewTableSpaceID();
                    table.setSpaceID(tableSpaceID);
                    if (!table.isCached()) {
                        return Result.updateZeroResult;
                    }
                    TableSpaceManager tableSpace = dataSpace.getTableSpace(tableSpaceID);
                    PersistentStore store = table.getRowStore(session);
                    store.setSpaceManager(tableSpace);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1160: {
                try {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.parameters[0];
                    int spaceid = (Integer)this.parameters[1];
                    Table table = session.database.schemaManager.getUserTable(session, name.name, name.schema.name);
                    if (!session.isProcessingScript()) {
                        return Result.updateZeroResult;
                    }
                    if (table.getTableType() != 5) {
                        return Result.updateZeroResult;
                    }
                    if (table.getSpaceID() != 7) {
                        return Result.updateZeroResult;
                    }
                    table.setSpaceID(spaceid);
                    if (table.store == null) {
                        return Result.updateZeroResult;
                    }
                    DataFileCache cache = session.database.logger.getCache();
                    if (cache == null) {
                        return Result.updateZeroResult;
                    }
                    DataSpaceManager dataSpace = cache.spaceManager;
                    TableSpaceManager tableSpace = dataSpace.getTableSpace(table.getSpaceID());
                    table.store.setSpaceManager(tableSpace);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1158: {
                try {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.parameters[0];
                    int[] colIndex = (int[])this.parameters[1];
                    Table table = session.database.schemaManager.getUserTable(session, name.name, name.schema.name);
                    StatementSchema.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    if (!table.isCached() && !table.isText()) {
                        throw Error.error(457);
                    }
                    Index index = table.getIndexForColumns(session, colIndex);
                    if (index != null) {
                        Index[] indexes = table.getIndexList();
                        for (int i = 0; i < indexes.length; ++i) {
                            indexes[i].setClustered(false);
                        }
                        index.setClustered(true);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1153: {
                try {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.parameters[0];
                    String value = (String)this.parameters[1];
                    Table table = session.database.schemaManager.getUserTable(session, name.name, name.schema.name);
                    if (session.isProcessingScript()) {
                        table.setIndexRoots(session, value);
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1154: {
                try {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.parameters[0];
                    Table table = session.database.schemaManager.getUserTable(session, name.name, name.schema.name);
                    boolean mode = (Boolean)this.parameters[1];
                    StatementSchema.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    table.setDataReadOnly(mode);
                    session.database.schemaManager.setSchemaChangeTimestamp();
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1155: 
            case 1156: {
                try {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.parameters[0];
                    Table table = session.database.schemaManager.getUserTable(session, name.name, name.schema.name);
                    StatementSchema.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    if (!table.isText()) {
                        HsqlException e = Error.error(321);
                        return Result.newErrorResult(e, this.sql);
                    }
                    if (this.parameters[1] != null) {
                        boolean mode = (Boolean)this.parameters[1];
                        if (mode) {
                            ((TextTable)table).connect(session);
                        } else {
                            ((TextTable)table).disconnect();
                        }
                        session.database.schemaManager.setSchemaChangeTimestamp();
                        return Result.updateZeroResult;
                    }
                    String source = (String)this.parameters[2];
                    boolean isDesc = (Boolean)this.parameters[3];
                    boolean isHeader = (Boolean)this.parameters[4];
                    if (isHeader) {
                        ((TextTable)table).setHeader(source);
                    } else {
                        ((TextTable)table).setDataSource(session, source, isDesc, false);
                    }
                    return Result.updateZeroResult;
                }
                catch (Throwable e2) {
                    HsqlException e2;
                    if (!(e2 instanceof HsqlException)) {
                        e2 = Error.error(467, e2.toString());
                    }
                    if (session.isProcessingLog() || session.isProcessingScript()) {
                        session.addWarning(e2);
                        session.database.logger.logWarningEvent("Problem processing SET TABLE SOURCE", e2);
                        return Result.updateZeroResult;
                    }
                    return Result.newErrorResult(e2, this.sql);
                }
            }
            case 1157: {
                try {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.parameters[0];
                    int type = (Integer)this.parameters[1];
                    Table table = session.database.schemaManager.getUserTable(session, name.name, name.schema.name);
                    if (table.getTableType() == type) {
                        return Result.updateZeroResult;
                    }
                    StatementSchema.checkSchemaUpdateAuthorisation(session, table.getSchemaName());
                    TableWorks tw = new TableWorks(session, table);
                    boolean result = tw.setTableType(session, type);
                    if (!result) {
                        throw Error.error(467);
                    }
                    session.database.schemaManager.setSchemaChangeTimestamp();
                    if (name.schema == SqlInvariants.LOBS_SCHEMA_HSQLNAME) {
                        session.database.lobManager.compileStatements();
                    }
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1091: {
                User user = (User)this.parameters[0];
                boolean mode = (Boolean)this.parameters[1];
                session.checkAdmin();
                session.checkDDLWrite();
                user.isLocalOnly = mode;
                session.database.schemaManager.setSchemaChangeTimestamp();
                return Result.updateZeroResult;
            }
            case 1092: {
                try {
                    User user = (User)this.parameters[0];
                    HsqlNameManager.HsqlName schema = (HsqlNameManager.HsqlName)this.parameters[1];
                    session.checkDDLWrite();
                    if (user == null) {
                        user = session.getUser();
                    } else {
                        session.checkAdmin();
                        session.checkDDLWrite();
                        user = session.database.userManager.get(user.getName().getNameString());
                    }
                    if (schema != null) {
                        schema = session.database.schemaManager.getSchemaHsqlName(schema.name);
                    }
                    user.setInitialSchema(schema);
                    session.database.schemaManager.setSchemaChangeTimestamp();
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1093: {
                try {
                    User user = this.parameters[0] == null ? session.getUser() : (User)this.parameters[0];
                    String password = (String)this.parameters[1];
                    boolean isDigest = (Boolean)this.parameters[2];
                    session.checkDDLWrite();
                    session.database.userManager.setPassword(session, user, password, isDigest);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1005: {
                try {
                    long sessionID = ((Number)this.parameters[0]).longValue();
                    int action = ((Number)this.parameters[1]).intValue();
                    Session targetSession = session.database.sessionManager.getSession(sessionID);
                    if (targetSession == null) {
                        throw Error.error(4500);
                    }
                    switch (action) {
                        case 2: {
                            session.database.txManager.resetSession(session, targetSession, 3);
                            break;
                        }
                        case 278: {
                            session.database.txManager.resetSession(session, targetSession, 2);
                            break;
                        }
                        case 236: {
                            session.database.txManager.resetSession(session, targetSession, 1);
                            break;
                        }
                        case 39: {
                            session.database.txManager.resetSession(session, targetSession, 5);
                            break;
                        }
                        case 233: {
                            session.database.txManager.resetSession(session, targetSession, 4);
                        }
                    }
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
                return Result.updateZeroResult;
            }
        }
        throw Error.runtimeError(201, "StatemntCommand");
    }

    Result getTruncateResult(Session session) {
        try {
            Object[] tables;
            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.parameters[0];
            boolean restartIdentity = (Boolean)this.parameters[1];
            boolean noCheck = (Boolean)this.parameters[2];
            if (name.type == 3) {
                Table table = session.database.schemaManager.getUserTable(session, name);
                tables = new Table[]{table};
                session.getGrantee().checkDelete(table);
                if (!noCheck) {
                    for (int i = 0; i < table.fkMainConstraints.length; ++i) {
                        HsqlNameManager.HsqlName tableName;
                        Table refTable;
                        if (table.fkMainConstraints[i].getRef() == table || (refTable = session.database.schemaManager.getUserTable(session, tableName = table.fkMainConstraints[i].getRef().getName())).isEmpty(session)) continue;
                        throw Error.error(8, refTable.getName().name);
                    }
                }
            } else {
                session.database.schemaManager.getSchemaHsqlName(name.name);
                HashMappedList list = session.database.schemaManager.getTables(name.name);
                tables = new Table[list.size()];
                list.toValuesArray(tables);
                StatementSchema.checkSchemaUpdateAuthorisation(session, name);
                if (!noCheck) {
                    OrderedHashSet set = new OrderedHashSet();
                    session.database.schemaManager.getCascadingReferencesToSchema(name, set);
                    for (int i = 0; i < set.size(); ++i) {
                        Table refTable;
                        HsqlNameManager.HsqlName objectName = (HsqlNameManager.HsqlName)set.get(i);
                        if (objectName.type != 5 || objectName.parent.type != 3 || (refTable = session.database.schemaManager.getUserTable(session, objectName.parent)).isEmpty(session)) continue;
                        throw Error.error(8, refTable.getName().name);
                    }
                }
                if (restartIdentity) {
                    Iterator it = session.database.schemaManager.databaseObjectIterator(name.name, 7);
                    while (it.hasNext()) {
                        NumberSequence sequence = (NumberSequence)it.next();
                        sequence.reset();
                    }
                }
            }
            for (int i = 0; i < tables.length; ++i) {
                Object table = tables[i];
                PersistentStore store = ((Table)table).getRowStore(session);
                store.removeAll();
                if (!restartIdentity || ((Table)table).identitySequence == null) continue;
                ((Table)table).identitySequence.reset();
            }
            return Result.updateZeroResult;
        }
        catch (HsqlException e) {
            return Result.newErrorResult(e, this.sql);
        }
    }

    @Override
    public ResultMetaData getResultMetaData() {
        switch (this.type) {
            case 1151: {
                return ResultMetaData.newSingleColumnMetaData("OPERATION");
            }
            case 1004: {
                if (this.statementReturnType != 2) break;
                return ResultMetaData.newSingleColumnMetaData("COMMANDS");
            }
        }
        return super.getResultMetaData();
    }

    @Override
    public boolean isAutoCommitStatement() {
        return this.isTransactionStatement;
    }

    @Override
    public String describe(Session session) {
        return this.sql;
    }
}

