/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementDML;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.lib.LongKeyIntValueHashMap;
import org.hsqldb.lib.LongValueHashMap;
import org.hsqldb.result.Result;

public final class StatementManager {
    private Database database;
    private IntKeyHashMap schemaMap;
    private LongKeyHashMap csidMap;
    private LongKeyIntValueHashMap useMap;
    private long next_cs_id;

    StatementManager(Database database) {
        this.database = database;
        this.schemaMap = new IntKeyHashMap();
        this.csidMap = new LongKeyHashMap();
        this.useMap = new LongKeyIntValueHashMap();
        this.next_cs_id = 0L;
    }

    synchronized void reset() {
        this.schemaMap.clear();
        this.csidMap.clear();
        this.useMap.clear();
        this.next_cs_id = 0L;
    }

    private long nextID() {
        ++this.next_cs_id;
        return this.next_cs_id;
    }

    private long getStatementID(HsqlNameManager.HsqlName schema, String sql) {
        LongValueHashMap sqlMap = (LongValueHashMap)this.schemaMap.get(schema.hashCode());
        if (sqlMap == null) {
            return -1L;
        }
        return sqlMap.get((Object)sql, -1);
    }

    public synchronized Statement getStatement(Session session, long csid) {
        Statement cs = (Statement)this.csidMap.get(csid);
        if (cs == null) {
            return null;
        }
        if (cs.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp()) {
            if ((cs = this.recompileStatement(session, cs)) == null) {
                this.freeStatement(csid);
                return null;
            }
            this.csidMap.put(csid, cs);
        }
        return cs;
    }

    public synchronized Statement getStatement(Session session, Statement statement) {
        long csid = statement.getID();
        Statement cs = (Statement)this.csidMap.get(csid);
        if (cs != null) {
            return this.getStatement(session, csid);
        }
        if (statement.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp() && (cs = this.recompileStatement(session, statement)) == null) {
            this.freeStatement(csid);
            return null;
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement recompileStatement(Session session, Statement cs) {
        Statement newStatement;
        HsqlNameManager.HsqlName oldSchema = session.getCurrentSchemaHsqlName();
        try {
            HsqlNameManager.HsqlName schema = cs.getSchemaName();
            int props = cs.getCursorPropertiesRequest();
            if (schema != null) {
                session.setSchema(schema.name);
            }
            boolean setGenerated = cs.generatedResultMetaData() != null;
            newStatement = session.compileStatement(cs.getSQL(), props);
            newStatement.setCursorPropertiesRequest(props);
            if (!cs.getResultMetaData().areTypesCompatible(newStatement.getResultMetaData())) {
                Statement statement = null;
                return statement;
            }
            if (!cs.getParametersMetaData().areTypesCompatible(newStatement.getParametersMetaData())) {
                Statement statement = null;
                return statement;
            }
            newStatement.setCompileTimestamp(this.database.txManager.getGlobalChangeTimestamp());
            if (setGenerated) {
                StatementDML si = (StatementDML)cs;
                newStatement.setGeneratedColumnInfo(si.generatedType, si.generatedInputMetaData);
            }
        }
        catch (Throwable t) {
            Statement statement = null;
            return statement;
        }
        finally {
            session.setCurrentSchemaHsqlName(oldSchema);
        }
        return newStatement;
    }

    private long registerStatement(long csid, Statement cs) {
        if (csid < 0L) {
            csid = this.nextID();
            int schemaid = cs.getSchemaName().hashCode();
            LongValueHashMap sqlMap = (LongValueHashMap)this.schemaMap.get(schemaid);
            if (sqlMap == null) {
                sqlMap = new LongValueHashMap();
                this.schemaMap.put(schemaid, sqlMap);
            }
            sqlMap.put(cs.getSQL(), csid);
        }
        cs.setID(csid);
        cs.setCompileTimestamp(this.database.txManager.getGlobalChangeTimestamp());
        this.csidMap.put(csid, cs);
        return csid;
    }

    synchronized void freeStatement(long csid) {
        if (csid == -1L) {
            return;
        }
        int useCount = this.useMap.get(csid, 1);
        if (useCount > 1) {
            this.useMap.put(csid, useCount - 1);
            return;
        }
        Statement cs = (Statement)this.csidMap.remove(csid);
        if (cs != null) {
            int schemaid = cs.getSchemaName().hashCode();
            LongValueHashMap sqlMap = (LongValueHashMap)this.schemaMap.get(schemaid);
            String sql = cs.getSQL();
            sqlMap.remove(sql);
        }
        this.useMap.remove(csid);
    }

    synchronized Statement compile(Session session, Result cmd) throws Throwable {
        int props = cmd.getExecuteProperties();
        Statement cs = null;
        String sql = cmd.getMainString();
        long csid = this.getStatementID(session.currentSchema, sql);
        if (csid >= 0L && (cs = (Statement)this.csidMap.get(csid)) != null && cs.getCursorPropertiesRequest() != props) {
            cs = null;
            csid = -1L;
        }
        if (cs == null || !cs.isValid() || cs.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp()) {
            cs = session.compileStatement(sql, props);
            cs.setCursorPropertiesRequest(props);
            csid = this.registerStatement(csid, cs);
        }
        int useCount = this.useMap.get(csid, 0) + 1;
        this.useMap.put(csid, useCount);
        cs.setGeneratedColumnInfo(cmd.getGeneratedResultType(), cmd.getGeneratedResultMetaData());
        return cs;
    }
}

