/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.QueryExpression;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.StatementDML;
import org.hsqldb.StatementQuery;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.navigator.RowSetNavigatorDataChange;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.types.Type;

public class StatementResultUpdate
extends StatementDML {
    int actionType;
    Type[] types;
    Result result;

    StatementResultUpdate() {
        this.writeTableNames = new HsqlNameManager.HsqlName[1];
        this.setCompileTimestamp(Long.MAX_VALUE);
    }

    @Override
    public String describe(Session session) {
        return "";
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
            this.clearStructures(session);
        }
        catch (Throwable t) {
            this.clearStructures(session);
            result = Result.newErrorResult(t, null);
        }
        return result;
    }

    @Override
    Result getResult(Session session) {
        this.checkAccessRights(session);
        Object[] args = session.sessionContext.dynamicArguments;
        PersistentStore store = this.baseTable.getRowStore(session);
        switch (this.actionType) {
            case 81: {
                Row row = this.getRow(session, args);
                if (row == null || row.isDeleted(session, store)) {
                    throw Error.error(3621);
                }
                RowSetNavigatorDataChange list = session.sessionContext.getRowSetDataChange();
                Object[] data = (Object[])ArrayUtil.duplicateArray(row.getData());
                boolean[] columnCheck = this.baseTable.getNewColumnCheckList();
                for (int i = 0; i < this.baseColumnMap.length; ++i) {
                    if (this.types[i] == Type.SQL_ALL_TYPES) continue;
                    data[this.baseColumnMap[i]] = args[i];
                    columnCheck[this.baseColumnMap[i]] = true;
                }
                int[] colMap = ArrayUtil.booleanArrayToIntIndexes(columnCheck);
                list.addRow(session, row, data, this.baseTable.getColumnTypes(), colMap);
                list.endMainDataSet();
                this.update(session, this.baseTable, list, null);
                break;
            }
            case 18: {
                Row row = this.getRow(session, args);
                if (row == null || row.isDeleted(session, store)) {
                    throw Error.error(3621);
                }
                RowSetNavigatorDataChange list = session.sessionContext.getRowSetDataChange();
                list.addRow(row);
                list.endMainDataSet();
                this.delete(session, this.baseTable, list);
                break;
            }
            case 50: {
                Object[] data = this.baseTable.getNewRowData(session);
                for (int i = 0; i < this.baseColumnMap.length; ++i) {
                    data[this.baseColumnMap[i]] = args[i];
                }
                return this.insertSingleRow(session, store, data);
            }
        }
        return Result.updateOneResult;
    }

    Row getRow(Session session, Object[] args) {
        int rowIdIndex = this.result.metaData.getColumnCount();
        Long rowId = (Long)args[rowIdIndex];
        PersistentStore store = this.baseTable.getRowStore(session);
        Row row = null;
        if (rowIdIndex + 2 == this.result.metaData.getExtendedColumnCount()) {
            Object[] data = ((RowSetNavigatorData)this.result.getNavigator()).getData(rowId);
            if (data != null) {
                row = (Row)data[rowIdIndex + 1];
            }
        } else {
            int id = (int)rowId.longValue();
            row = (Row)store.get(id, false);
        }
        this.result = null;
        return row;
    }

    void setRowActionProperties(Result result, int action, StatementQuery statement, Type[] types) {
        QueryExpression qe = statement.queryExpression;
        this.result = result;
        this.actionType = action;
        this.baseTable = qe.getBaseTable();
        this.types = types;
        this.baseColumnMap = qe.getBaseTableColumnMap();
        this.writeTableNames[0] = this.baseTable.getName();
        this.sql = statement.getSQL();
        this.parameterMetaData = qe.getMetaData();
    }

    @Override
    void checkAccessRights(Session session) {
        switch (this.type) {
            case 7: {
                break;
            }
            case 50: {
                session.getGrantee().checkInsert(this.targetTable, this.insertCheckColumns);
                break;
            }
            case 85: {
                break;
            }
            case 19: {
                session.getGrantee().checkDelete(this.targetTable);
                break;
            }
            case 82: {
                session.getGrantee().checkUpdate(this.targetTable, this.updateCheckColumns);
                break;
            }
            case 128: {
                session.getGrantee().checkInsert(this.targetTable, this.insertCheckColumns);
                session.getGrantee().checkUpdate(this.targetTable, this.updateCheckColumns);
            }
        }
    }
}

