/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.RangeVariable;
import org.hsqldb.Row;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.TableBase;
import org.hsqldb.TextTable;
import org.hsqldb.TriggerDef;
import org.hsqldb.TriggerDefSQL;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.map.ValuePool;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorDataChange;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.Collation;
import org.hsqldb.types.Type;

public class Table
extends TableBase
implements SchemaObject {
    public static final Table[] emptyArray = new Table[0];
    protected HsqlNameManager.HsqlName tableName;
    protected long changeTimestamp;
    public HashMappedList columnList;
    int identityColumn;
    NumberSequence identitySequence;
    Constraint[] constraintList;
    Constraint[] fkConstraints;
    Constraint[] fkMainConstraints;
    Constraint[] checkConstraints;
    TriggerDef[] triggerList;
    TriggerDef[][] triggerLists;
    Expression[] colDefaults;
    private boolean hasDefaultValues;
    boolean[] colGenerated;
    private boolean hasGeneratedValues;
    boolean[] colRefFK;
    boolean[] colMainFK;
    int referentialActions;
    int cascadingDeletes;
    boolean isDropped;
    private boolean hasDomainColumns;
    private boolean hasNotNullColumns;
    protected int[] defaultColumnMap;
    RangeVariable[] defaultRanges;

    public Table(Database database, HsqlNameManager.HsqlName name, int type) {
        this.database = database;
        this.tableName = name;
        this.persistenceId = database.persistentStoreCollection.getNextId();
        switch (type) {
            case 13: {
                this.persistenceScope = 21;
                this.isSessionBased = true;
                break;
            }
            case 2: {
                this.persistenceScope = 21;
                this.isSessionBased = true;
                break;
            }
            case 1: {
                this.persistenceScope = 22;
                this.isSessionBased = true;
                break;
            }
            case 12: {
                this.persistenceScope = 24;
                this.isSchemaBased = true;
                break;
            }
            case 5: {
                if (database.logger.isFileDatabase()) {
                    this.persistenceScope = 24;
                    this.isSchemaBased = true;
                    this.isCached = true;
                    this.isLogged = !database.isFilesReadOnly();
                    break;
                }
                type = 4;
            }
            case 4: {
                this.persistenceScope = 24;
                this.isSchemaBased = true;
                this.isLogged = !database.isFilesReadOnly();
                break;
            }
            case 3: {
                this.persistenceScope = 22;
                this.isTemp = true;
                this.isSchemaBased = true;
                this.isSessionBased = true;
                break;
            }
            case 6: {
                this.persistenceScope = 23;
                if (!database.logger.isFileDatabase()) {
                    throw Error.error(459);
                }
                this.isSchemaBased = true;
                this.isSessionBased = true;
                this.isTemp = true;
                this.isText = true;
                this.isReadOnly = true;
                break;
            }
            case 7: {
                this.persistenceScope = 24;
                if (!database.logger.isFileDatabase()) {
                    if (!database.logger.isAllowedFullPath()) {
                        throw Error.error(459);
                    }
                    this.isReadOnly = true;
                }
                this.isSchemaBased = true;
                this.isText = true;
                break;
            }
            case 8: {
                this.persistenceScope = 21;
                this.isSchemaBased = true;
                this.isSessionBased = true;
                this.isView = true;
                break;
            }
            case 9: {
                this.persistenceScope = 23;
                this.isSessionBased = true;
                break;
            }
            case 11: {
                this.persistenceScope = 21;
                this.isSessionBased = true;
                break;
            }
            default: {
                throw Error.runtimeError(201, "Table");
            }
        }
        this.tableType = type;
        this.identityColumn = -1;
        this.columnList = new HashMappedList();
        this.indexList = Index.emptyArray;
        this.constraintList = Constraint.emptyArray;
        this.fkConstraints = Constraint.emptyArray;
        this.fkMainConstraints = Constraint.emptyArray;
        this.checkConstraints = Constraint.emptyArray;
        this.triggerList = TriggerDef.emptyArray;
        this.triggerLists = new TriggerDef[9][];
        for (int i = 0; i < 9; ++i) {
            this.triggerLists[i] = TriggerDef.emptyArray;
        }
        if (database.isFilesReadOnly() && this.isFileBased()) {
            this.isReadOnly = true;
        }
    }

    public Table(Table table, HsqlNameManager.HsqlName name) {
        this.persistenceScope = 21;
        name.schema = SqlInvariants.SYSTEM_SCHEMA_HSQLNAME;
        this.tableName = name;
        this.database = table.database;
        this.tableType = 9;
        this.columnList = table.columnList;
        this.columnCount = table.columnCount;
        this.indexList = Index.emptyArray;
        this.constraintList = Constraint.emptyArray;
        this.createPrimaryKey();
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public final HsqlNameManager.HsqlName getName() {
        return this.tableName;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.database.getCatalogName();
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return this.tableName.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.tableName.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet set = new OrderedHashSet();
        if (this.identitySequence != null && this.identitySequence.getName() != null) {
            set.add(this.identitySequence.getName());
        }
        return set;
    }

    public RangeVariable[] getDefaultRanges() {
        if (this.defaultRanges == null) {
            this.defaultRanges = new RangeVariable[]{new RangeVariable(this, 0)};
        }
        return this.defaultRanges;
    }

    public OrderedHashSet getReferencesForDependents() {
        int i;
        OrderedHashSet set = new OrderedHashSet();
        for (i = 0; i < this.colTypes.length; ++i) {
            ColumnSchema column = this.getColumn(i);
            OrderedHashSet refs = column.getReferences();
            if (refs == null || refs.isEmpty()) continue;
            set.add(column.getName());
        }
        for (i = 0; i < this.fkConstraints.length; ++i) {
            if (this.fkConstraints[i].getMainTableName() == this.getName()) continue;
            set.add(this.fkConstraints[i].getName());
        }
        for (i = 0; i < this.triggerList.length; ++i) {
            set.add(this.triggerList[i].getName());
        }
        return set;
    }

    @Override
    public OrderedHashSet getComponents() {
        OrderedHashSet set = new OrderedHashSet();
        set.addAll(this.constraintList);
        set.addAll(this.triggerList);
        for (int i = 0; i < this.indexList.length; ++i) {
            if (this.indexList[i].isConstraint()) continue;
            set.add(this.indexList[i]);
        }
        return set;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        for (int i = 0; i < this.columnCount; ++i) {
            ColumnSchema column = this.getColumn(i);
            column.compile(session, this);
        }
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE").append(' ');
        if (this.isTemp()) {
            sb.append("GLOBAL").append(' ');
            sb.append("TEMPORARY").append(' ');
        } else if (this.isText()) {
            sb.append("TEXT").append(' ');
        } else if (this.isCached()) {
            sb.append("CACHED").append(' ');
        } else {
            sb.append("MEMORY").append(' ');
        }
        sb.append("TABLE").append(' ');
        sb.append(this.getName().getSchemaQualifiedStatementName());
        sb.append('(');
        int[] pk = this.getPrimaryKey();
        Constraint pkConst = this.getPrimaryConstraint();
        for (int j = 0; j < this.columnCount; ++j) {
            String defaultString;
            Collation collation;
            ColumnSchema column = this.getColumn(j);
            String colname = column.getName().statementName;
            Type type = column.getDataType();
            if (j > 0) {
                sb.append(',');
            }
            sb.append(colname);
            sb.append(' ');
            sb.append(type.getTypeDefinition());
            if (!type.isDistinctType() && !type.isDomainType() && type.isCharacterType() && (collation = ((CharacterType)type).getCollation()).isObjectCollation()) {
                sb.append(' ').append(collation.getCollateSQL());
            }
            if ((defaultString = column.getDefaultSQL()) != null) {
                sb.append(' ').append("DEFAULT").append(' ');
                sb.append(defaultString);
            }
            if (column.isIdentity()) {
                sb.append(' ').append(column.getIdentitySequence().getSQLColumnDefinition());
            }
            if (column.isGenerated()) {
                sb.append(' ').append("GENERATED").append(' ');
                sb.append("ALWAYS").append(' ').append("AS").append("(");
                sb.append(column.getGeneratingExpression().getSQL());
                sb.append(")");
            }
            if (!column.isNullable()) {
                Constraint c = this.getNotNullConstraintForColumn(j);
                if (c != null && !c.getName().isReservedName()) {
                    sb.append(' ').append("CONSTRAINT").append(' ').append(c.getName().statementName);
                }
                sb.append(' ').append("NOT").append(' ').append("NULL");
            }
            if (pk.length != 1 || j != pk[0] || !pkConst.getName().isReservedName()) continue;
            sb.append(' ').append("PRIMARY").append(' ').append("KEY");
        }
        for (Constraint c : this.getConstraints()) {
            String d;
            if (c.isForward || (d = c.getSQL()).length() <= 0) continue;
            sb.append(',');
            sb.append(d);
        }
        sb.append(')');
        if (this.onCommitPreserve()) {
            sb.append(' ').append("ON").append(' ');
            sb.append("COMMIT").append(' ').append("PRESERVE");
            sb.append(' ').append("ROWS");
        }
        return sb.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return this.changeTimestamp;
    }

    public final void setName(HsqlNameManager.HsqlName name) {
        this.tableName = name;
    }

    String[] getSQL(OrderedHashSet resolved, OrderedHashSet unresolved) {
        for (int i = 0; i < this.constraintList.length; ++i) {
            Constraint c = this.constraintList[i];
            if (c.isForward) {
                unresolved.add(c);
                continue;
            }
            if (c.getConstraintType() != 2 && c.getConstraintType() != 4) continue;
            resolved.add(c.getName());
        }
        HsqlArrayList list = new HsqlArrayList();
        list.add(this.getSQL());
        if (!this.isTemp && !this.isText && this.identitySequence != null && this.identitySequence.getName() == null) {
            list.add(NumberSequence.getRestartSQL(this));
        }
        for (int i = 0; i < this.indexList.length; ++i) {
            if (this.indexList[i].isConstraint() || this.indexList[i].getColumnCount() <= 0) continue;
            list.add(this.indexList[i].getSQL());
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    public String getSQLForReadOnly() {
        if (this.isReadOnly) {
            StringBuffer sb = new StringBuffer(64);
            sb.append("SET").append(' ').append("TABLE").append(' ');
            sb.append(this.getName().getSchemaQualifiedStatementName());
            sb.append(' ').append("READ").append(' ');
            sb.append("ONLY");
            return sb.toString();
        }
        return null;
    }

    public String[] getSQLForTextSource(boolean withHeader) {
        if (this.isText()) {
            String dataSource;
            HsqlArrayList list = new HsqlArrayList();
            if (this.isReadOnly) {
                list.add(this.getSQLForReadOnly());
            }
            if ((dataSource = ((TextTable)this).getDataSourceDDL()) != null) {
                list.add(dataSource);
            }
            String header = ((TextTable)this).getDataSourceHeader();
            if (withHeader && header != null && !this.isReadOnly) {
                list.add(header);
            }
            String[] array = new String[list.size()];
            list.toArray(array);
            return array;
        }
        return null;
    }

    public String getSQLForClustered() {
        if (!this.isCached() && !this.isText()) {
            return null;
        }
        Index index = this.getClusteredIndex();
        if (index == null) {
            return null;
        }
        String colList = this.getColumnListSQL(index.getColumns(), index.getColumnCount());
        StringBuffer sb = new StringBuffer(64);
        sb.append("SET").append(' ').append("TABLE").append(' ');
        sb.append(this.getName().getSchemaQualifiedStatementName());
        sb.append(' ').append("CLUSTERED").append(' ');
        sb.append("ON").append(' ').append(colList);
        return sb.toString();
    }

    public String getSQLForTableSpace() {
        if (!this.isCached() || this.tableSpace == 7) {
            return null;
        }
        StringBuffer sb = new StringBuffer(64);
        sb.append("SET").append(' ').append("TABLE").append(' ');
        sb.append(this.getName().getSchemaQualifiedStatementName());
        sb.append(' ').append("SPACE").append(' ').append(this.tableSpace);
        return sb.toString();
    }

    public String[] getTriggerSQL() {
        HsqlArrayList list = new HsqlArrayList();
        for (int i = 0; i < this.triggerList.length; ++i) {
            if (this.triggerList[i].isSystem()) continue;
            list.add(this.triggerList[i].getSQL());
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    public String getIndexRootsSQL(long[] roots) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("SET").append(' ').append("TABLE").append(' ');
        sb.append(this.getName().getSchemaQualifiedStatementName());
        sb.append(' ').append("INDEX").append(' ').append('\'');
        sb.append(StringUtil.getList(roots, " ", ""));
        sb.append(' ');
        sb.append(StringUtil.getList(new long[this.indexList.length], " ", ""));
        sb.append(' ').append(this.store.elementCount());
        sb.append('\'');
        return sb.toString();
    }

    public String getColumnListSQL(int[] col, int len) {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        for (int i = 0; i < len; ++i) {
            sb.append(this.getColumn((int)col[i]).getName().statementName);
            if (i >= len - 1) continue;
            sb.append(',');
        }
        sb.append(')');
        return sb.toString();
    }

    public String getColumnListWithTypeSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        for (int j = 0; j < this.columnCount; ++j) {
            ColumnSchema column = this.getColumn(j);
            String colname = column.getName().statementName;
            Type type = column.getDataType();
            if (j > 0) {
                sb.append(',');
            }
            sb.append(colname);
            sb.append(' ');
            sb.append(type.getTypeDefinition());
        }
        sb.append(')');
        return sb.toString();
    }

    public boolean isConnected() {
        return true;
    }

    public static int compareRows(Session session, Object[] a, Object[] b, int[] cols, Type[] coltypes) {
        int fieldcount = cols.length;
        for (int j = 0; j < fieldcount; ++j) {
            int i = coltypes[cols[j]].compare(session, a[cols[j]], b[cols[j]]);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    @Override
    public int getId() {
        return this.tableName.hashCode();
    }

    public final boolean isSchemaBaseTable() {
        switch (this.tableType) {
            case 4: 
            case 5: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public final boolean isWithDataSource() {
        return this.isWithDataSource;
    }

    public final boolean isText() {
        return this.isText;
    }

    public final boolean isTemp() {
        return this.isTemp;
    }

    public final boolean isReadOnly() {
        return this.isReadOnly;
    }

    public final boolean isView() {
        return this.isView;
    }

    public boolean isQueryBased() {
        return false;
    }

    public boolean isCached() {
        return this.isCached;
    }

    public boolean isDataReadOnly() {
        return this.isReadOnly;
    }

    public boolean isDropped() {
        return this.isDropped;
    }

    final boolean isIndexingMutable() {
        return !this.isCached;
    }

    public void checkDataReadOnly() {
        if (this.isDataReadOnly()) {
            throw Error.error(456);
        }
    }

    public void setDataReadOnly(boolean value) {
        if (!value) {
            if (this.database.isFilesReadOnly() && this.isFileBased()) {
                throw Error.error(456);
            }
            if (this.database.getType() == "mem:" && this.isText) {
                throw Error.error(456);
            }
        }
        this.isReadOnly = value;
    }

    public boolean isFileBased() {
        return this.isCached || this.isText;
    }

    public void addConstraint(Constraint c) {
        int index = c.getConstraintType() == 4 ? 0 : this.constraintList.length;
        this.constraintList = (Constraint[])ArrayUtil.toAdjustedArray(this.constraintList, c, index, 1);
        this.updateConstraintLists();
    }

    void updateConstraintLists() {
        int i;
        int fkCount = 0;
        int mainCount = 0;
        int checkCount = 0;
        this.referentialActions = 0;
        this.cascadingDeletes = 0;
        block10: for (i = 0; i < this.constraintList.length; ++i) {
            switch (this.constraintList[i].getConstraintType()) {
                case 0: {
                    ++fkCount;
                    continue block10;
                }
                case 1: {
                    ++mainCount;
                    continue block10;
                }
                case 3: {
                    if (this.constraintList[i].isNotNull()) continue block10;
                    ++checkCount;
                }
            }
        }
        this.fkConstraints = fkCount == 0 ? Constraint.emptyArray : new Constraint[fkCount];
        fkCount = 0;
        this.fkMainConstraints = mainCount == 0 ? Constraint.emptyArray : new Constraint[mainCount];
        mainCount = 0;
        this.checkConstraints = checkCount == 0 ? Constraint.emptyArray : new Constraint[checkCount];
        checkCount = 0;
        this.colRefFK = new boolean[this.columnCount];
        this.colMainFK = new boolean[this.columnCount];
        block11: for (i = 0; i < this.constraintList.length; ++i) {
            switch (this.constraintList[i].getConstraintType()) {
                case 0: {
                    this.fkConstraints[fkCount] = this.constraintList[i];
                    ArrayUtil.intIndexesToBooleanArray(this.constraintList[i].getRefColumns(), this.colRefFK);
                    ++fkCount;
                    continue block11;
                }
                case 1: {
                    this.fkMainConstraints[mainCount] = this.constraintList[i];
                    ArrayUtil.intIndexesToBooleanArray(this.constraintList[i].getMainColumns(), this.colMainFK);
                    if (this.constraintList[i].hasCoreTriggeredAction()) {
                        ++this.referentialActions;
                        if (this.constraintList[i].getDeleteAction() == 0) {
                            ++this.cascadingDeletes;
                        }
                    }
                    ++mainCount;
                    continue block11;
                }
                case 3: {
                    if (this.constraintList[i].isNotNull()) continue block11;
                    this.checkConstraints[checkCount] = this.constraintList[i];
                    ++checkCount;
                }
            }
        }
    }

    void verifyConstraintsIntegrity() {
        for (int i = 0; i < this.constraintList.length; ++i) {
            Constraint c = this.constraintList[i];
            if (c.getConstraintType() != 0 && c.getConstraintType() != 1) continue;
            if (c.getMain() != this.database.schemaManager.findUserTable(null, c.getMain().getName().name, c.getMain().getName().schema.name)) {
                throw Error.runtimeError(201, "FK mismatch : " + c.getName().name);
            }
            if (c.getRef() == this.database.schemaManager.findUserTable(null, c.getRef().getName().name, c.getRef().getName().schema.name)) continue;
            throw Error.runtimeError(201, "FK mismatch : " + c.getName().name);
        }
    }

    public Constraint[] getConstraints() {
        return this.constraintList;
    }

    public Constraint[] getFKConstraints() {
        return this.fkConstraints;
    }

    public Constraint getPrimaryConstraint() {
        return this.hasPrimaryKey() ? this.constraintList[0] : null;
    }

    void collectFKReadLocks(int[] columnMap, OrderedHashSet set) {
        for (int i = 0; i < this.fkMainConstraints.length; ++i) {
            Constraint constraint = this.fkMainConstraints[i];
            Table ref = constraint.getRef();
            int[] mainColumns = constraint.getMainColumns();
            if (ref == this) continue;
            if (columnMap == null) {
                int[] cols;
                if (!constraint.core.hasDeleteAction) continue;
                int[] nArray = cols = constraint.getDeleteAction() == 0 ? null : constraint.getRefColumns();
                if (!set.add(ref.getName())) continue;
                ref.collectFKReadLocks(cols, set);
                continue;
            }
            if (!ArrayUtil.haveCommonElement(columnMap, mainColumns) || !set.add(ref.getName())) continue;
            ref.collectFKReadLocks(constraint.getRefColumns(), set);
        }
    }

    void collectFKWriteLocks(int[] columnMap, OrderedHashSet set) {
        for (int i = 0; i < this.fkMainConstraints.length; ++i) {
            Constraint constraint = this.fkMainConstraints[i];
            Table ref = constraint.getRef();
            int[] mainColumns = constraint.getMainColumns();
            if (ref == this) continue;
            if (columnMap == null) {
                int[] cols;
                if (!constraint.core.hasDeleteAction) continue;
                int[] nArray = cols = constraint.getDeleteAction() == 0 ? null : constraint.getRefColumns();
                if (!set.add(ref.getName())) continue;
                ref.collectFKWriteLocks(cols, set);
                continue;
            }
            if (!ArrayUtil.haveCommonElement(columnMap, mainColumns) || !constraint.core.hasUpdateAction || !set.add(ref.getName())) continue;
            ref.collectFKWriteLocks(constraint.getRefColumns(), set);
        }
    }

    Constraint getNotNullConstraintForColumn(int colIndex) {
        for (Constraint c : this.constraintList) {
            if (!c.isNotNull() || c.notNullColumnIndex != colIndex) continue;
            return c;
        }
        return null;
    }

    Constraint getUniqueConstraintForColumns(int[] cols) {
        for (Constraint c : this.constraintList) {
            if (!c.isUniqueWithColumns(cols)) continue;
            return c;
        }
        return null;
    }

    Constraint getFKConstraintForColumns(Table tableMain, int[] mainCols, int[] refCols) {
        for (Constraint c : this.constraintList) {
            if (!c.isEquivalent(tableMain, mainCols, this, refCols)) continue;
            return c;
        }
        return null;
    }

    public Constraint getUniqueOrPKConstraintForIndex(Index index) {
        for (Constraint c : this.constraintList) {
            if (c.getMainIndex() != index || c.getConstraintType() != 2 && c.getConstraintType() != 4) continue;
            return c;
        }
        return null;
    }

    int getNextConstraintIndex(int from, int type) {
        int size = this.constraintList.length;
        for (int i = from; i < size; ++i) {
            Constraint c = this.constraintList[i];
            if (c.getConstraintType() != type) continue;
            return i;
        }
        return -1;
    }

    public void addColumn(ColumnSchema column) {
        String name = column.getName().name;
        if (this.findColumn(name) >= 0) {
            throw Error.error(5504, name);
        }
        if (column.isIdentity()) {
            if (this.identityColumn != -1) {
                throw Error.error(5525, name);
            }
            this.identityColumn = this.columnCount;
            this.identitySequence = column.getIdentitySequence();
        }
        this.addColumnNoCheck(column);
    }

    public void addColumnNoCheck(ColumnSchema column) {
        this.columnList.add(column.getName().name, column);
        ++this.columnCount;
    }

    public boolean hasGeneratedColumn() {
        return this.hasGeneratedValues;
    }

    public boolean hasLobColumn() {
        return this.hasLobColumn;
    }

    public boolean hasIdentityColumn() {
        return this.identityColumn != -1;
    }

    public long getNextIdentity() {
        return this.identitySequence.peek();
    }

    void checkReferentialColumnsMatch(int[] col, Table other, int[] othercol) {
        for (int i = 0; i < col.length; ++i) {
            Type type = this.colTypes[col[i]];
            Type otherType = other.colTypes[othercol[i]];
            if (type.canCompareDirect(otherType)) continue;
            throw Error.error(5562);
        }
    }

    Table moveDefinition(Session session, int newType, ColumnSchema column, Constraint constraint, Index index, int colIndex, int adjust, OrderedHashSet dropConstraints, OrderedHashSet dropIndexes) {
        int i;
        Table tn;
        boolean newPK = false;
        if (constraint != null && constraint.getConstraintType() == 4) {
            newPK = true;
        }
        if (this.isText) {
            tn = new TextTable(this.database, this.tableName, newType);
            ((TextTable)tn).dataSource = ((TextTable)this).dataSource;
            ((TextTable)tn).isReversed = ((TextTable)this).isReversed;
            ((TextTable)tn).isConnected = ((TextTable)this).isConnected;
        } else {
            tn = new Table(this.database, this.tableName, newType);
        }
        if (this.tableType == 3) {
            tn.persistenceScope = this.persistenceScope;
        }
        tn.tableSpace = this.tableSpace;
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            ColumnSchema col = (ColumnSchema)this.columnList.get(i2);
            if (i2 == colIndex) {
                if (column != null) {
                    tn.addColumn(column);
                }
                if (adjust <= 0) continue;
            }
            col = col.duplicate();
            col.setPrimaryKey(false);
            tn.addColumn(col);
        }
        if (this.columnCount == colIndex) {
            tn.addColumn(column);
        }
        int[] pkCols = null;
        if (this.hasPrimaryKey() && !dropConstraints.contains(this.getPrimaryConstraint().getName())) {
            pkCols = this.getPrimaryKey();
            pkCols = ArrayUtil.toAdjustedColumnArray(pkCols, colIndex, adjust);
        } else if (newPK) {
            pkCols = constraint.getMainColumns();
        }
        tn.createPrimaryKey(this.getIndex(0).getName(), pkCols, false);
        for (int i3 = 1; i3 < this.indexList.length; ++i3) {
            Index idx = this.indexList[i3];
            if (dropIndexes.contains(idx.getName())) continue;
            int[] colarr = ArrayUtil.toAdjustedColumnArray(idx.getColumns(), colIndex, adjust);
            Index newIdx = tn.createIndexStructure(idx.getName(), colarr, idx.getColumnDesc(), null, idx.isUnique(), idx.isConstraint(), idx.isForward());
            newIdx.setClustered(idx.isClustered());
            tn.addIndexStructure(newIdx);
        }
        if (index != null) {
            tn.addIndexStructure(index);
        }
        HsqlArrayList newList = new HsqlArrayList();
        if (newPK) {
            constraint.core.mainIndex = tn.indexList[0];
            constraint.core.mainTable = tn;
            constraint.core.mainTableName = tn.tableName;
            newList.add(constraint);
        }
        for (i = 0; i < this.constraintList.length; ++i) {
            Constraint c = this.constraintList[i];
            if (dropConstraints.contains(c.getName())) continue;
            c = c.duplicate();
            c.updateTable(session, this, tn, colIndex, adjust);
            newList.add(c);
        }
        if (!newPK && constraint != null) {
            constraint.updateTable(session, this, tn, -1, 0);
            newList.add(constraint);
        }
        tn.constraintList = new Constraint[newList.size()];
        newList.toArray(tn.constraintList);
        tn.updateConstraintLists();
        tn.setBestRowIdentifiers();
        tn.triggerList = this.triggerList;
        tn.triggerLists = this.triggerLists;
        for (i = 0; i < tn.constraintList.length; ++i) {
            tn.constraintList[i].compile(session, tn);
        }
        for (i = 0; i < tn.columnCount; ++i) {
            tn.getColumn(i).compile(session, tn);
        }
        return tn;
    }

    void checkColumnInCheckConstraint(int colIndex) {
        for (Constraint c : this.constraintList) {
            if (c.getConstraintType() != 3 || c.isNotNull() || !c.hasColumn(colIndex)) continue;
            HsqlNameManager.HsqlName name = c.getName();
            throw Error.error(5502, name.getSchemaQualifiedStatementName());
        }
    }

    void checkColumnInFKConstraint(int colIndex) {
        for (Constraint c : this.constraintList) {
            if (!c.hasColumn(colIndex) || c.getConstraintType() != 1 && c.getConstraintType() != 0) continue;
            HsqlNameManager.HsqlName name = c.getName();
            throw Error.error(5533, name.getSchemaQualifiedStatementName());
        }
    }

    OrderedHashSet getDependentConstraints(int colIndex) {
        OrderedHashSet set = new OrderedHashSet();
        for (Constraint c : this.constraintList) {
            if (!c.hasColumnOnly(colIndex)) continue;
            set.add(c);
        }
        return set;
    }

    OrderedHashSet getContainingConstraints(int colIndex) {
        OrderedHashSet set = new OrderedHashSet();
        for (Constraint c : this.constraintList) {
            if (!c.hasColumnPlus(colIndex)) continue;
            set.add(c);
        }
        return set;
    }

    OrderedHashSet getContainingIndexNames(int colIndex) {
        OrderedHashSet set = new OrderedHashSet();
        for (Index index : this.indexList) {
            if (ArrayUtil.find(index.getColumns(), colIndex) == -1) continue;
            set.add(index.getName());
        }
        return set;
    }

    OrderedHashSet getDependentConstraints(Constraint constraint) {
        OrderedHashSet set = new OrderedHashSet();
        for (Constraint c : this.fkMainConstraints) {
            if (c.core.uniqueName != constraint.getName()) continue;
            set.add(c);
        }
        return set;
    }

    public OrderedHashSet getDependentExternalConstraints() {
        OrderedHashSet set = new OrderedHashSet();
        for (Constraint c : this.constraintList) {
            if (c.getConstraintType() != 1 && c.getConstraintType() != 0 || c.core.mainTable == c.core.refTable) continue;
            set.add(c);
        }
        return set;
    }

    public OrderedHashSet getUniquePKConstraintNames() {
        OrderedHashSet set = new OrderedHashSet();
        for (Constraint c : this.constraintList) {
            if (c.getConstraintType() != 2 && c.getConstraintType() != 4) continue;
            set.add(c.getName());
        }
        return set;
    }

    void checkColumnInFKConstraint(int colIndex, int actionType) {
        for (Constraint c : this.constraintList) {
            if (c.getConstraintType() != 0 || !c.hasColumn(colIndex) || actionType != c.getUpdateAction() && actionType != c.getDeleteAction()) continue;
            HsqlNameManager.HsqlName name = c.getName();
            throw Error.error(5533, name.getSchemaQualifiedStatementName());
        }
    }

    int getIdentityColumnIndex() {
        return this.identityColumn;
    }

    public int getColumnIndex(String name) {
        int i = this.findColumn(name);
        if (i == -1) {
            throw Error.error(5501, name);
        }
        return i;
    }

    public int findColumn(String name) {
        int index = this.columnList.getIndex(name);
        return index;
    }

    void resetDefaultsFlag() {
        this.hasDefaultValues = false;
        this.hasGeneratedValues = false;
        this.hasNotNullColumns = false;
        this.hasDomainColumns = false;
        this.hasLobColumn = false;
        for (int i = 0; i < this.columnCount; ++i) {
            this.hasDefaultValues |= this.colDefaults[i] != null;
            this.hasGeneratedValues |= this.colGenerated[i];
            this.hasNotNullColumns |= this.colNotNull[i];
            if (this.colTypes[i].isDomainType()) {
                this.hasDomainColumns = true;
            }
            if (!this.colTypes[i].isLobType()) continue;
            this.hasLobColumn = true;
        }
    }

    public int[] getBestRowIdentifiers() {
        return this.bestRowIdentifierCols;
    }

    public boolean isBestRowIdentifiersStrict() {
        return this.bestRowIdentifierStrict;
    }

    public Index getClusteredIndex() {
        for (int i = 0; i < this.indexList.length; ++i) {
            if (!this.indexList[i].isClustered()) continue;
            return this.indexList[i];
        }
        return null;
    }

    synchronized Index getIndexForColumn(Session session, int col) {
        int i = this.bestIndexForColumn[col];
        if (i > -1) {
            return this.indexList[i];
        }
        switch (this.tableType) {
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 11: {
                Index index = this.createIndexForColumns(session, new int[]{col});
                return index;
            }
        }
        return null;
    }

    boolean isIndexed(int colIndex) {
        return this.bestIndexForColumn[colIndex] != -1;
    }

    int[] getUniqueNotNullColumnGroup(boolean[] usedColumns) {
        for (Constraint constraint : this.constraintList) {
            int[] indexCols;
            if (!(constraint.getConstraintType() == 2 ? ArrayUtil.areAllIntIndexesInBooleanArray(indexCols = constraint.getMainColumns(), this.colNotNull) && ArrayUtil.areAllIntIndexesInBooleanArray(indexCols, usedColumns) : constraint.getConstraintType() == 4 && ArrayUtil.areAllIntIndexesInBooleanArray(indexCols = constraint.getMainColumns(), usedColumns))) continue;
            return indexCols;
        }
        return null;
    }

    boolean areColumnsNotNull(int[] indexes) {
        return ArrayUtil.areAllIntIndexesInBooleanArray(indexes, this.colNotNull);
    }

    public void createPrimaryKey() {
        this.createPrimaryKey(null, ValuePool.emptyIntArray, false);
    }

    public void createPrimaryKey(HsqlNameManager.HsqlName indexName, int[] columns, boolean columnsNotNull) {
        if (columns == null) {
            columns = ValuePool.emptyIntArray;
        }
        for (int i = 0; i < columns.length; ++i) {
            this.getColumn(columns[i]).setPrimaryKey(true);
        }
        this.setColumnStructures();
        Object[] primaryKeyTypes = new Type[columns.length];
        ArrayUtil.projectRow(this.colTypes, columns, primaryKeyTypes);
        HsqlNameManager.HsqlName name = indexName;
        if (name == null) {
            name = this.database.nameManager.newAutoName("IDX", this.getSchemaName(), this.getName(), 20);
        }
        this.createPrimaryIndex(columns, (Type[])primaryKeyTypes, name);
        this.setBestRowIdentifiers();
    }

    public void createPrimaryKeyConstraint(HsqlNameManager.HsqlName indexName, int[] columns, boolean columnsNotNull) {
        this.createPrimaryKey(indexName, columns, columnsNotNull);
        Constraint c = new Constraint(indexName, this, this.getPrimaryIndex(), 4);
        this.addConstraint(c);
    }

    void setColumnStructures() {
        if (this.colTypes == null) {
            this.colTypes = new Type[this.columnCount];
        }
        this.colDefaults = new Expression[this.columnCount];
        this.colNotNull = new boolean[this.columnCount];
        this.colGenerated = new boolean[this.columnCount];
        this.defaultColumnMap = new int[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            this.setSingleColumnTypeVars(i);
        }
        this.resetDefaultsFlag();
    }

    void setColumnTypeVars(int i) {
        this.setSingleColumnTypeVars(i);
        this.resetDefaultsFlag();
    }

    private void setSingleColumnTypeVars(int i) {
        Type dataType;
        ColumnSchema column = this.getColumn(i);
        this.colTypes[i] = dataType = column.getDataType();
        this.colNotNull[i] = column.isPrimaryKey() || !column.isNullable();
        this.defaultColumnMap[i] = i;
        if (column.isIdentity()) {
            this.identitySequence = column.getIdentitySequence();
            this.identityColumn = i;
        } else if (this.identityColumn == i) {
            this.identitySequence = null;
            this.identityColumn = -1;
        }
        this.colDefaults[i] = column.getDefaultExpression();
        this.colGenerated[i] = column.isGenerated();
    }

    int[] getColumnMap() {
        return this.defaultColumnMap;
    }

    int[] getNewColumnMap() {
        return new int[this.columnCount];
    }

    boolean[] getColumnCheckList(int[] columnIndexes) {
        boolean[] columnCheckList = new boolean[this.columnCount];
        for (int i = 0; i < columnIndexes.length; ++i) {
            int index = columnIndexes[i];
            if (index <= -1) continue;
            columnCheckList[index] = true;
        }
        return columnCheckList;
    }

    int[] getColumnIndexes(String[] list) {
        int[] cols = new int[list.length];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = this.getColumnIndex(list[i]);
        }
        return cols;
    }

    int[] getColumnIndexes(OrderedHashSet set) {
        int[] cols = new int[set.size()];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = this.getColumnIndex((String)set.get(i));
            if (cols[i] != -1) continue;
            throw Error.error(5501, (String)set.get(i));
        }
        return cols;
    }

    int[] getColumnIndexes(HashMappedList list) {
        int[] cols = new int[list.size()];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = (Integer)list.get(i);
        }
        return cols;
    }

    public ColumnSchema getColumn(int i) {
        return (ColumnSchema)this.columnList.get(i);
    }

    public OrderedHashSet getColumnNameSet(int[] columnIndexes) {
        OrderedHashSet set = new OrderedHashSet();
        for (int i = 0; i < columnIndexes.length; ++i) {
            set.add(((ColumnSchema)this.columnList.get(i)).getName());
        }
        return set;
    }

    public OrderedHashSet getColumnNameSet(boolean[] columnCheckList) {
        OrderedHashSet set = new OrderedHashSet();
        for (int i = 0; i < columnCheckList.length; ++i) {
            if (!columnCheckList[i]) continue;
            set.add(this.columnList.get(i));
        }
        return set;
    }

    public void getColumnNames(boolean[] columnCheckList, Set set) {
        for (int i = 0; i < columnCheckList.length; ++i) {
            if (!columnCheckList[i]) continue;
            set.add(((ColumnSchema)this.columnList.get(i)).getName());
        }
    }

    public OrderedHashSet getColumnNameSet() {
        OrderedHashSet set = new OrderedHashSet();
        for (int i = 0; i < this.columnCount; ++i) {
            set.add(((ColumnSchema)this.columnList.get(i)).getName());
        }
        return set;
    }

    Object[] getNewRowData(Session session) {
        Object[] data = new Object[this.columnCount];
        if (this.hasDefaultValues) {
            for (int i = 0; i < this.columnCount; ++i) {
                Expression def = this.colDefaults[i];
                if (def == null) continue;
                data[i] = def.getValue(session, this.colTypes[i]);
            }
        }
        return data;
    }

    boolean hasTrigger(int trigVecIndex) {
        return this.triggerLists[trigVecIndex].length != 0;
    }

    void addTrigger(TriggerDef td, HsqlNameManager.HsqlName otherName) {
        int pos;
        int index = this.triggerList.length;
        if (otherName != null && (pos = this.getTriggerIndex(otherName.name)) != -1) {
            index = pos + 1;
        }
        this.triggerList = (TriggerDef[])ArrayUtil.toAdjustedArray(this.triggerList, td, index, 1);
        TriggerDef[] list = this.triggerLists[td.triggerType];
        index = list.length;
        if (otherName != null) {
            for (int i = 0; i < list.length; ++i) {
                TriggerDef trigger = list[i];
                if (!trigger.getName().name.equals(otherName.name)) continue;
                index = i + 1;
                break;
            }
        }
        list = (TriggerDef[])ArrayUtil.toAdjustedArray(list, td, index, 1);
        this.triggerLists[td.triggerType] = list;
    }

    TriggerDef getTrigger(String name) {
        for (int i = this.triggerList.length - 1; i >= 0; --i) {
            if (!this.triggerList[i].getName().name.equals(name)) continue;
            return this.triggerList[i];
        }
        return null;
    }

    public int getTriggerIndex(String name) {
        for (int i = 0; i < this.triggerList.length; ++i) {
            if (!this.triggerList[i].getName().name.equals(name)) continue;
            return i;
        }
        return -1;
    }

    void removeTrigger(TriggerDef trigger) {
        TriggerDef td = null;
        for (int i = 0; i < this.triggerList.length; ++i) {
            td = this.triggerList[i];
            if (!td.getName().name.equals(trigger.getName().name)) continue;
            td.terminate();
            this.triggerList = (TriggerDef[])ArrayUtil.toAdjustedArray(this.triggerList, null, i, -1);
            break;
        }
        if (td == null) {
            return;
        }
        int index = td.triggerType;
        for (int j = 0; j < this.triggerLists[index].length; ++j) {
            td = this.triggerLists[index][j];
            if (!td.getName().name.equals(trigger.getName().name)) continue;
            this.triggerLists[index] = (TriggerDef[])ArrayUtil.toAdjustedArray(this.triggerLists[index], null, j, -1);
            break;
        }
    }

    void releaseTriggers() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < this.triggerLists[i].length; ++j) {
                this.triggerLists[i][j].terminate();
            }
            this.triggerLists[i] = TriggerDef.emptyArray;
        }
        this.triggerList = TriggerDef.emptyArray;
    }

    void terminateTriggers() {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < this.triggerLists[i].length; ++j) {
                this.triggerLists[i][j].terminate();
            }
        }
    }

    int getIndexIndex(String indexName) {
        Index[] indexes = this.indexList;
        for (int i = 0; i < indexes.length; ++i) {
            if (!indexName.equals(indexes[i].getName().name)) continue;
            return i;
        }
        return -1;
    }

    Index getIndex(String indexName) {
        Index[] indexes = this.indexList;
        int i = this.getIndexIndex(indexName);
        return i == -1 ? null : indexes[i];
    }

    int getConstraintIndex(String constraintName) {
        int size = this.constraintList.length;
        for (int i = 0; i < size; ++i) {
            if (!this.constraintList[i].getName().name.equals(constraintName)) continue;
            return i;
        }
        return -1;
    }

    public Constraint getConstraint(String constraintName) {
        int i = this.getConstraintIndex(constraintName);
        return i < 0 ? null : this.constraintList[i];
    }

    public Constraint getUniqueConstraintForIndex(Index index) {
        for (Constraint c : this.constraintList) {
            if (c.getMainIndex() != index || c.getConstraintType() != 4 && c.getConstraintType() != 2) continue;
            return c;
        }
        return null;
    }

    void removeConstraint(String name) {
        int index = this.getConstraintIndex(name);
        if (index != -1) {
            this.removeConstraint(index);
        }
    }

    void removeConstraint(int index) {
        this.constraintList = (Constraint[])ArrayUtil.toAdjustedArray(this.constraintList, null, index, -1);
        this.updateConstraintLists();
    }

    void renameColumn(ColumnSchema column, String newName, boolean isquoted) {
        String oldname = column.getName().name;
        int i = this.getColumnIndex(oldname);
        this.columnList.setKey(i, newName);
        column.getName().rename(newName, isquoted);
    }

    void renameColumn(ColumnSchema column, HsqlNameManager.HsqlName newName) {
        String oldname = column.getName().name;
        int i = this.getColumnIndex(oldname);
        if (this.findColumn(newName.name) != -1) {
            throw Error.error(5504);
        }
        this.columnList.setKey(i, newName.name);
        column.getName().rename(newName);
    }

    public TriggerDef[] getTriggers() {
        return this.triggerList;
    }

    public boolean isWritable() {
        return !this.isReadOnly && !this.database.databaseReadOnly && (!this.database.isFilesReadOnly() || !this.isCached && !this.isText);
    }

    public boolean isInsertable() {
        return this.isWritable();
    }

    public boolean isUpdatable() {
        return this.isWritable();
    }

    public boolean isTriggerInsertable() {
        return false;
    }

    public boolean isTriggerUpdatable() {
        return false;
    }

    public boolean isTriggerDeletable() {
        return false;
    }

    public int[] getUpdatableColumns() {
        return this.defaultColumnMap;
    }

    public Table getBaseTable() {
        return this;
    }

    public int[] getBaseTableColumnMap() {
        return this.defaultColumnMap;
    }

    Index createIndexForColumns(Session session, int[] columns) {
        Index index = null;
        HsqlNameManager.HsqlName indexName = this.database.nameManager.newAutoName("IDX_T", this.getSchemaName(), this.getName(), 20);
        try {
            index = this.createAndAddIndexStructure(session, indexName, columns, null, null, false, false, false);
        }
        catch (Throwable t) {
            return null;
        }
        return index;
    }

    void fireTriggers(Session session, int trigVecIndex, RowSetNavigatorDataChange rowSet) {
        if (!this.database.isReferentialIntegrity()) {
            return;
        }
        for (TriggerDef td : this.triggerLists[trigVecIndex]) {
            boolean sqlTrigger = td instanceof TriggerDefSQL;
            if (td.hasOldTable()) {
                // empty if block
            }
            td.pushPair(session, null, null);
        }
    }

    void fireTriggers(Session session, int trigVecIndex, RowSetNavigator rowSet) {
        if (!this.database.isReferentialIntegrity()) {
            return;
        }
        for (TriggerDef td : this.triggerLists[trigVecIndex]) {
            boolean sqlTrigger = td instanceof TriggerDefSQL;
            if (td.hasOldTable()) {
                // empty if block
            }
            td.pushPair(session, null, null);
        }
    }

    void fireTriggers(Session session, int trigVecIndex, Object[] oldData, Object[] newData, int[] cols) {
        if (!this.database.isReferentialIntegrity()) {
            return;
        }
        for (TriggerDef td : this.triggerLists[trigVecIndex]) {
            boolean sqlTrigger = td instanceof TriggerDefSQL;
            if (cols != null && td.getUpdateColumnIndexes() != null && !ArrayUtil.haveCommonElement(td.getUpdateColumnIndexes(), cols)) continue;
            if (td.isForEachRow()) {
                switch (td.triggerType) {
                    case 6: {
                        break;
                    }
                    case 3: {
                        if (sqlTrigger) break;
                        newData = (Object[])ArrayUtil.duplicateArray(newData);
                        break;
                    }
                    case 5: {
                        if (sqlTrigger) break;
                        oldData = (Object[])ArrayUtil.duplicateArray(oldData);
                        newData = (Object[])ArrayUtil.duplicateArray(newData);
                        break;
                    }
                    case 4: 
                    case 7: 
                    case 8: {
                        if (sqlTrigger) break;
                        oldData = (Object[])ArrayUtil.duplicateArray(oldData);
                    }
                }
                td.pushPair(session, oldData, newData);
                continue;
            }
            td.pushPair(session, null, null);
        }
    }

    public void enforceRowConstraints(Session session, Object[] data) {
        for (int i = 0; i < this.columnCount; ++i) {
            ColumnSchema column;
            Type type = this.colTypes[i];
            if (this.hasDomainColumns && type.isDomainType()) {
                Constraint[] constraints = type.userTypeModifier.getConstraints();
                column = this.getColumn(i);
                for (int j = 0; j < constraints.length; ++j) {
                    constraints[j].checkCheckConstraint(session, this, column, data[i]);
                }
            }
            if (!this.colNotNull[i] || data[i] != null) continue;
            Constraint c = this.getNotNullConstraintForColumn(i);
            if (c == null && ArrayUtil.find(this.getPrimaryKey(), i) > -1) {
                c = this.getPrimaryConstraint();
            }
            String constraintName = c == null ? "" : c.getName().name;
            column = this.getColumn(i);
            Object[] info = new String[]{constraintName, this.tableName.statementName, column.getName().statementName};
            throw Error.error(null, 10, 3, info);
        }
    }

    public void enforceTypeLimits(Session session, Object[] data) {
        int i;
        try {
            for (i = 0; i < this.columnCount; ++i) {
                data[i] = this.colTypes[i].convertToTypeLimits(session, data[i]);
            }
        }
        catch (HsqlException e) {
            int code = e.getErrorCode();
            if (code == -3401 || code == -3403 || code == -3408) {
                ColumnSchema column = this.getColumn(i);
                Object[] info = new String[]{"", this.tableName.statementName, column.getName().statementName};
                throw Error.error(e, code, 3, info);
            }
            throw e;
        }
    }

    int indexTypeForColumn(Session session, int col) {
        int i = this.bestIndexForColumn[col];
        if (i > -1) {
            return this.indexList[i].isUnique() && this.indexList[i].getColumnCount() == 1 ? 2 : 1;
        }
        switch (this.tableType) {
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 11: {
                return 1;
            }
        }
        return 0;
    }

    synchronized Index getIndexForColumns(Session session, int[] cols) {
        int i = this.bestIndexForColumn[cols[0]];
        if (i > -1) {
            return this.indexList[i];
        }
        switch (this.tableType) {
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 11: {
                Index index = this.createIndexForColumns(session, cols);
                return index;
            }
        }
        return null;
    }

    Index getFullIndexForColumns(int[] cols) {
        for (int i = 0; i < this.indexList.length; ++i) {
            if (!ArrayUtil.haveEqualArrays(this.indexList[i].getColumns(), cols, cols.length)) continue;
            return this.indexList[i];
        }
        return null;
    }

    Index getIndexForColumns(int[] cols) {
        for (int i = 0; i < this.indexList.length; ++i) {
            if (!ArrayUtil.haveEqualSets(this.indexList[i].getColumns(), cols, cols.length)) continue;
            return this.indexList[i];
        }
        return null;
    }

    synchronized Index.IndexUse[] getIndexForColumns(Session session, OrderedIntHashSet set, int opType, boolean ordered) {
        if (set.isEmpty()) {
            return Index.emptyUseArray;
        }
        Index.IndexUse[] indexUse = this.findIndexForColumns(session, set, opType, ordered);
        if (indexUse.length == 0) {
            switch (this.tableType) {
                case 1: 
                case 2: 
                case 3: 
                case 8: 
                case 11: {
                    Index selected = this.createIndexForColumns(session, set.toArray());
                    if (selected == null) break;
                    indexUse = selected.asArray();
                }
            }
        }
        return indexUse;
    }

    Index.IndexUse[] findIndexForColumns(Session session, OrderedIntHashSet set, int opType, boolean ordered) {
        Index.IndexUse[] indexUse = Index.emptyUseArray;
        if (set.isEmpty()) {
            return Index.emptyUseArray;
        }
        int count = this.indexList.length;
        for (int i = 0; i < count; ++i) {
            int matchCount;
            Index currentIndex = this.getIndex(i);
            int[] indexcols = currentIndex.getColumns();
            int n = matchCount = ordered ? set.getOrderedStartMatchCount(indexcols) : set.getStartMatchCount(indexcols);
            if (matchCount == 0) continue;
            if (matchCount == set.size()) {
                return currentIndex.asArray();
            }
            if (matchCount == currentIndex.getColumnCount() && currentIndex.isUnique()) {
                return currentIndex.asArray();
            }
            if (indexUse.length == 0 && matchCount == currentIndex.getColumnCount()) {
                indexUse = currentIndex.asArray();
                continue;
            }
            Index.IndexUse[] newList = new Index.IndexUse[indexUse.length + 1];
            ArrayUtil.copyArray(indexUse, newList, indexUse.length);
            newList[newList.length - 1] = new Index.IndexUse(currentIndex, matchCount);
            indexUse = newList;
        }
        return indexUse;
    }

    public Index getFullIndex(Session session) {
        if (this.fullIndex == null) {
            this.fullIndex = this.getFullIndexForColumns(this.defaultColumnMap);
            if (this.fullIndex == null) {
                this.fullIndex = this.createIndexForColumns(session, this.defaultColumnMap);
            }
        }
        return this.fullIndex;
    }

    public final long[] getIndexRootsArray() {
        PersistentStore store = this.database.persistentStoreCollection.getStore(this);
        long[] roots = new long[this.indexList.length];
        for (int index = 0; index < this.indexList.length; ++index) {
            CachedObject accessor = store.getAccessor(this.indexList[index]);
            roots[index] = accessor == null ? -1L : accessor.getPos();
        }
        return roots;
    }

    public void setIndexRoots(long[] roots, long[] uniqueSize, long cardinality) {
        int index;
        if (!this.isCached) {
            throw Error.error(5501, this.tableName.name);
        }
        PersistentStore store = this.database.persistentStoreCollection.getStore(this);
        for (index = 0; index < this.indexList.length; ++index) {
            store.setAccessor(this.indexList[index], roots[index]);
        }
        for (index = 0; index < this.indexList.length; ++index) {
            store.setElementCount(this.indexList[index], cardinality, uniqueSize[index]);
        }
    }

    public void setIndexRoots(long[] roots) {
        if (!this.isCached) {
            throw Error.error(5501, this.tableName.name);
        }
        PersistentStore store = this.database.persistentStoreCollection.getStore(this);
        for (int index = 0; index < this.indexList.length; ++index) {
            store.setAccessor(this.indexList[index], roots[index]);
        }
    }

    void setIndexRoots(Session session, String s) {
        long v;
        int index;
        if (!this.isCached) {
            throw Error.error(5501, this.tableName.name);
        }
        int indexCount = this.getIndexCount();
        ParserDQL p = new ParserDQL(session, new Scanner(s), null);
        long[] roots = new long[indexCount];
        long[] uniqueSize = new long[indexCount];
        long cardinality = -1L;
        p.read();
        for (index = 0; index < indexCount; ++index) {
            roots[index] = v = p.readBigint();
        }
        try {
            for (index = 0; index < indexCount; ++index) {
                uniqueSize[index] = v = p.readBigint();
            }
            cardinality = p.readBigint();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setIndexRoots(roots, uniqueSize, cardinality);
    }

    Row insertSingleRow(Session session, PersistentStore store, Object[] data, int[] changedCols) {
        if (this.hasGeneratedValues) {
            this.setGeneratedColumns(session, data);
        }
        this.enforceTypeLimits(session, data);
        if (this.hasDomainColumns || this.hasNotNullColumns) {
            this.enforceRowConstraints(session, data);
        }
        if (this.isView) {
            return null;
        }
        Row row = (Row)store.getNewCachedObject(session, data, true);
        session.addInsertAction(this, store, row, changedCols);
        return row;
    }

    void insertIntoTable(Session session, Result result) {
        PersistentStore store = this.getRowStore(session);
        RowSetNavigator nav = result.initialiseNavigator();
        while (nav.hasNext()) {
            Object[] data = nav.getNext();
            Object[] newData = (Object[])ArrayUtil.resizeArrayIfDifferent(data, this.columnCount);
            this.insertData(session, store, newData);
        }
    }

    public void insertNoCheckFromLog(Session session, Object[] data) {
        this.systemUpdateIdentityValue(data);
        PersistentStore store = this.getRowStore(session);
        Row row = (Row)store.getNewCachedObject(session, data, true);
        session.addInsertAction(this, store, row, null);
    }

    public int insertSys(Session session, PersistentStore store, Result ins) {
        RowSetNavigator nav = ins.getNavigator();
        int count = 0;
        while (nav.hasNext()) {
            this.insertSys(session, store, nav.getNext());
            ++count;
        }
        return count;
    }

    void insertResult(Session session, PersistentStore store, Result ins) {
        RowSetNavigator nav = ins.initialiseNavigator();
        while (nav.hasNext()) {
            Object[] data = nav.getNext();
            Object[] newData = (Object[])ArrayUtil.resizeArrayIfDifferent(data, this.columnCount);
            this.insertData(session, store, newData);
        }
    }

    public void insertFromScript(Session session, PersistentStore store, Object[] data) {
        this.systemUpdateIdentityValue(data);
        if (session.database.getProperties().isVersion18()) {
            for (int i = 0; i < this.columnCount; ++i) {
                int length;
                if (data[i] == null || !this.colTypes[i].isCharacterType() && !this.colTypes[i].isBinaryType()) continue;
                if (data[i] instanceof String) {
                    length = ((String)data[i]).length();
                } else if (data[i] instanceof BinaryData) {
                    length = (int)((BinaryData)data[i]).length(session);
                } else {
                    throw Error.runtimeError(1200, "Table");
                }
                if ((long)length <= this.colTypes[i].precision) continue;
                length = (length / 10 + 1) * 10;
                this.colTypes[i] = Type.getType(this.colTypes[i].typeCode, this.colTypes[i].getCharacterSet(), this.colTypes[i].getCollation(), length, 0);
                ColumnSchema column = this.getColumn(i);
                column.setType(this.colTypes[i]);
            }
        }
        this.insertData(session, store, data);
    }

    public void insertData(Session session, PersistentStore store, Object[] data) {
        Row row = (Row)store.getNewCachedObject(session, data, false);
        store.indexRow(session, row);
    }

    public void insertSys(Session session, PersistentStore store, Object[] data) {
        Row row = (Row)store.getNewCachedObject(session, data, false);
        store.indexRow(session, row);
    }

    protected void setIdentityColumn(Session session, Object[] data) {
        if (this.identityColumn != -1) {
            Number id = (Number)data[this.identityColumn];
            if (this.identitySequence.getName() == null) {
                if (id == null) {
                    id = (Number)this.identitySequence.getValueObject();
                    data[this.identityColumn] = id;
                } else {
                    this.identitySequence.userUpdate(id.longValue());
                }
            } else if (id == null) {
                id = (Number)session.sessionData.getSequenceValue(this.identitySequence);
                data[this.identityColumn] = id;
            }
            if (session != null) {
                session.setLastIdentity(id);
            }
        }
    }

    public void setGeneratedColumns(Session session, Object[] data) {
        if (this.hasGeneratedValues) {
            for (int i = 0; i < this.colGenerated.length; ++i) {
                if (!this.colGenerated[i]) continue;
                Expression e = this.getColumn(i).getGeneratingExpression();
                RangeVariable.RangeIteratorBase range = session.sessionContext.getCheckIterator(this.getDefaultRanges()[0]);
                range.setCurrent(data);
                data[i] = e.getValue(session, this.colTypes[i]);
            }
        }
    }

    public void systemSetIdentityColumn(Session session, Object[] data) {
        if (this.identityColumn != -1) {
            Number id = (Number)data[this.identityColumn];
            if (id == null) {
                id = (Number)this.identitySequence.getValueObject();
                data[this.identityColumn] = id;
            } else {
                this.identitySequence.userUpdate(id.longValue());
            }
        }
    }

    protected void systemUpdateIdentityValue(Object[] data) {
        Number id;
        if (this.identityColumn != -1 && (id = (Number)data[this.identityColumn]) != null) {
            this.identitySequence.systemUpdate(id.longValue());
        }
    }

    public Row getDeleteRowFromLog(Session session, Object[] data) {
        Row row = null;
        PersistentStore store = this.getRowStore(session);
        if (this.hasPrimaryKey()) {
            Index index = this.getPrimaryIndex();
            int[] colsSequence = index.getDefaultColumnMap();
            RowIterator it = index.findFirstRow(session, store, data, colsSequence);
            row = it.getNextRow();
            it.release();
        } else if (this.bestIndex == null) {
            RowIterator it = this.rowIterator(session);
            while ((row = it.getNextRow()) != null && Table.compareRows(session, row.getData(), data, this.defaultColumnMap, this.colTypes) != 0) {
            }
            it.release();
        } else {
            RowIterator it = this.bestIndex.findFirstRow(session, store, data);
            while ((row = it.getNextRow()) != null) {
                Object[] rowdata = row.getData();
                if (this.bestIndex.compareRowNonUnique(session, rowdata, data, this.bestIndex.getColumns()) != 0) {
                    row = null;
                    break;
                }
                if (Table.compareRows(session, rowdata, data, this.defaultColumnMap, this.colTypes) != 0) continue;
                break;
            }
            it.release();
        }
        return row;
    }

    public RowIterator rowIteratorClustered(Session session) {
        PersistentStore store = this.getRowStore(session);
        Index index = this.getClusteredIndex();
        if (index == null) {
            index = this.getPrimaryIndex();
        }
        return index.firstRow(session, store, 0, null);
    }

    public RowIterator rowIteratorClustered(PersistentStore store) {
        Index index = this.getClusteredIndex();
        if (index == null) {
            index = this.getPrimaryIndex();
        }
        return index.firstRow(store);
    }

    @Override
    public void clearAllData(Session session) {
        super.clearAllData(session);
        if (this.identitySequence != null) {
            this.identitySequence.reset();
        }
    }

    @Override
    public void clearAllData(PersistentStore store) {
        super.clearAllData(store);
        if (this.identitySequence != null) {
            this.identitySequence.reset();
        }
    }

    @Override
    public PersistentStore getRowStore(Session session) {
        if (this.store != null) {
            return this.store;
        }
        if (this.isSessionBased) {
            return session.sessionData.persistentStoreCollection.getStore(this);
        }
        return this.database.persistentStoreCollection.getStore(this);
    }

    public QueryExpression getQueryExpression() {
        return null;
    }

    public Expression getDataExpression() {
        return null;
    }

    public void prepareTable(Session session) {
    }

    public void materialise(Session session) {
    }

    public void materialiseCorrelated(Session session) {
    }
}

