/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.TableUtil;
import org.hsqldb.TriggerDef;
import org.hsqldb.error.Error;
import org.hsqldb.lib.OrderedHashSet;

public class View
extends TableDerived {
    private String statement;
    private HsqlNameManager.HsqlName[] columnNames;
    private OrderedHashSet schemaObjectNames;
    private int checkOption;
    private Table baseTable;
    boolean isTriggerInsertable;
    boolean isTriggerUpdatable;
    boolean isTriggerDeletable;

    View(Database db, HsqlNameManager.HsqlName name, HsqlNameManager.HsqlName[] columnNames, int check) {
        super(db, name, 8);
        this.columnNames = columnNames;
        this.checkOption = check;
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public OrderedHashSet getReferences() {
        return this.schemaObjectNames;
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
        ParserDQL p = new ParserDQL(session, new Scanner(this.statement), null);
        p.read();
        TableDerived viewSubQueryTable = p.XreadViewSubqueryTable(this, true);
        this.queryExpression = viewSubQueryTable.queryExpression;
        if (this.getColumnCount() == 0) {
            if (this.columnNames == null) {
                this.columnNames = viewSubQueryTable.queryExpression.getResultColumnNames();
            }
            if (this.columnNames.length != viewSubQueryTable.queryExpression.getColumnCount()) {
                throw Error.error(5593, this.getName().statementName);
            }
            TableUtil.setColumnsInSchemaTable(this, this.columnNames, this.queryExpression.getColumnTypes());
        }
        this.schemaObjectNames = p.compileContext.getSchemaObjectNames();
        this.canRecompile = true;
        this.baseTable = this.queryExpression.getBaseTable();
        if (this.baseTable == null) {
            return;
        }
        switch (this.checkOption) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "View");
            }
        }
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("CREATE").append(' ').append("VIEW");
        sb.append(' ');
        sb.append(this.getName().getSchemaQualifiedStatementName()).append(' ');
        sb.append('(');
        int count = this.getColumnCount();
        for (int j = 0; j < count; ++j) {
            sb.append(this.getColumn((int)j).getName().statementName);
            if (j >= count - 1) continue;
            sb.append(',');
        }
        sb.append(')').append(' ').append("AS").append(' ');
        sb.append(this.getStatement());
        return sb.toString();
    }

    @Override
    public int[] getUpdatableColumns() {
        return this.queryExpression.getBaseTableColumnMap();
    }

    @Override
    public boolean isTriggerInsertable() {
        return this.isTriggerInsertable;
    }

    @Override
    public boolean isTriggerUpdatable() {
        return this.isTriggerUpdatable;
    }

    @Override
    public boolean isTriggerDeletable() {
        return this.isTriggerDeletable;
    }

    @Override
    public boolean isInsertable() {
        return this.isTriggerInsertable ? false : super.isInsertable();
    }

    @Override
    public boolean isUpdatable() {
        return this.isTriggerUpdatable ? false : super.isUpdatable();
    }

    @Override
    void addTrigger(TriggerDef td, HsqlNameManager.HsqlName otherName) {
        switch (td.operationType) {
            case 50: {
                if (this.isTriggerInsertable) {
                    throw Error.error(5538);
                }
                this.isTriggerInsertable = true;
                break;
            }
            case 19: {
                if (this.isTriggerDeletable) {
                    throw Error.error(5538);
                }
                this.isTriggerDeletable = true;
                break;
            }
            case 82: {
                if (this.isTriggerUpdatable) {
                    throw Error.error(5538);
                }
                this.isTriggerUpdatable = true;
                break;
            }
            default: {
                throw Error.runtimeError(201, "View");
            }
        }
        super.addTrigger(td, otherName);
    }

    @Override
    void removeTrigger(TriggerDef td) {
        switch (td.operationType) {
            case 50: {
                this.isTriggerInsertable = false;
                break;
            }
            case 19: {
                this.isTriggerDeletable = false;
                break;
            }
            case 82: {
                this.isTriggerUpdatable = false;
                break;
            }
            default: {
                throw Error.runtimeError(201, "View");
            }
        }
        super.removeTrigger(td);
    }

    @Override
    public void setDataReadOnly(boolean value) {
        throw Error.error(4000);
    }

    public int getCheckOption() {
        return this.checkOption;
    }

    public String getStatement() {
        return this.statement;
    }

    public void setStatement(String sql) {
        this.statement = sql;
    }

    @Override
    public TableDerived newDerivedTable(Session session) {
        ParserDQL p = new ParserDQL(session, new Scanner(), session.parser.compileContext);
        p.reset(this.statement);
        p.read();
        TableDerived td = p.XreadViewSubqueryTable(this, false);
        return td;
    }
}

