/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.hsqldb.lib.BasicTextJdkLogFormatter;

public class FrameworkLogger {
    private static Map loggerInstances = new HashMap();
    private static Map jdkToLog4jLevels = new HashMap();
    private static Method log4jGetLogger;
    private static Method log4jLogMethod;
    private static boolean callerFqcnAvailable;
    private Object log4jLogger;
    private Logger jdkLogger;
    private static boolean noopMode;

    public static synchronized String report() {
        return loggerInstances.size() + " logger instances:  " + loggerInstances.keySet();
    }

    public static synchronized void clearLoggers(String prefixToZap) {
        HashSet<String> targetKeys = new HashSet<String>();
        Iterator it = loggerInstances.keySet().iterator();
        String dottedPrefix = prefixToZap + '.';
        while (it.hasNext()) {
            String k = (String)it.next();
            if (!k.equals(prefixToZap) && !k.startsWith(dottedPrefix)) continue;
            targetKeys.add(k);
        }
        loggerInstances.keySet().removeAll(targetKeys);
    }

    private static synchronized void populateJdkToLog4jLevels(String classString) throws ClassNotFoundException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Method log4jToLevel = Class.forName(classString).getMethod("toLevel", String.class);
        jdkToLog4jLevels.put(Level.ALL, log4jToLevel.invoke(null, "ALL"));
        jdkToLog4jLevels.put(Level.FINER, log4jToLevel.invoke(null, "DEBUG"));
        jdkToLog4jLevels.put(Level.WARNING, log4jToLevel.invoke(null, "ERROR"));
        jdkToLog4jLevels.put(Level.SEVERE, log4jToLevel.invoke(null, "FATAL"));
        jdkToLog4jLevels.put(Level.INFO, log4jToLevel.invoke(null, "INFO"));
        jdkToLog4jLevels.put(Level.OFF, log4jToLevel.invoke(null, "OFF"));
        jdkToLog4jLevels.put(Level.FINEST, log4jToLevel.invoke(null, "TRACE"));
        jdkToLog4jLevels.put(Level.WARNING, log4jToLevel.invoke(null, "WARN"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reconfigure() {
        noopMode = false;
        Class<?> log4jLoggerClass = null;
        Class<?> log4jManagerClass = null;
        loggerInstances.clear();
        jdkToLog4jLevels.clear();
        log4jGetLogger = null;
        log4jLogMethod = null;
        callerFqcnAvailable = false;
        try {
            log4jLoggerClass = Class.forName("org.apache.logging.log4j.Logger");
            log4jManagerClass = Class.forName("org.apache.logging.log4j.LogManager");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (log4jLoggerClass != null) {
            try {
                FrameworkLogger.populateJdkToLog4jLevels("org.apache.logging.log4j.Level");
                log4jLogMethod = log4jLoggerClass.getMethod("log", Class.forName("org.apache.logging.log4j.Level"), Object.class, Throwable.class);
                log4jGetLogger = log4jManagerClass.getMethod("getLogger", String.class);
                return;
            }
            catch (Exception e) {
                try {
                    System.err.println("<clinit> failure instantiating configured Log4j v2 system: " + e);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        log4jLoggerClass = null;
        log4jManagerClass = null;
        log4jLogMethod = null;
        log4jGetLogger = null;
        jdkToLog4jLevels.clear();
        try {
            log4jLoggerClass = Class.forName("org.apache.log4j.Logger");
            log4jManagerClass = log4jLoggerClass;
        }
        catch (Exception e) {
            // empty catch block
        }
        if (log4jLoggerClass != null) {
            try {
                FrameworkLogger.populateJdkToLog4jLevels("org.apache.log4j.Level");
                log4jLogMethod = log4jLoggerClass.getMethod("log", String.class, Class.forName("org.apache.log4j.Priority"), Object.class, Throwable.class);
                log4jGetLogger = log4jManagerClass.getMethod("getLogger", String.class);
                callerFqcnAvailable = true;
                return;
            }
            catch (Exception e) {
                try {
                    System.err.println("<clinit> failure instantiating configured Log4j v1 system: " + e);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        log4jLoggerClass = null;
        log4jManagerClass = null;
        log4jLogMethod = null;
        log4jGetLogger = null;
        callerFqcnAvailable = false;
        jdkToLog4jLevels.clear();
        String propVal = System.getProperty("hsqldb.reconfig_logging");
        if (propVal != null && propVal.equalsIgnoreCase("false")) {
            return;
        }
        InputStream istream = null;
        try {
            LogManager lm = LogManager.getLogManager();
            String path = "/org/hsqldb/resources/jdklogging-default.properties";
            if (FrameworkLogger.isDefaultJdkConfig()) {
                lm.reset();
                ConsoleHandler consoleHandler = new ConsoleHandler();
                consoleHandler.setFormatter(new BasicTextJdkLogFormatter(false));
                consoleHandler.setLevel(Level.INFO);
                istream = FrameworkLogger.class.getResourceAsStream(path);
                lm.readConfiguration(istream);
                Logger cmdlineLogger = Logger.getLogger("org.hsqldb.cmdline");
                cmdlineLogger.addHandler(consoleHandler);
                cmdlineLogger.setUseParentHandlers(false);
            } else {
                lm.readConfiguration();
            }
        }
        catch (Exception e) {
            noopMode = true;
            System.err.println("<clinit> failure initializing JDK logging system.  Continuing without Application logging.");
            e.printStackTrace();
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException ioe) {
                    System.err.println("Failed to close logging input stream: " + ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FrameworkLogger(String s) {
        if (!noopMode) {
            if (log4jGetLogger == null) {
                this.jdkLogger = Logger.getLogger(s);
            } else {
                try {
                    this.log4jLogger = log4jGetLogger.invoke(null, s);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to instantiate Log4j Logger", e);
                }
            }
        }
        Class<FrameworkLogger> clazz = FrameworkLogger.class;
        synchronized (FrameworkLogger.class) {
            loggerInstances.put(s, this);
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }

    public static FrameworkLogger getLog(Class c) {
        return FrameworkLogger.getLog(c.getName());
    }

    public static FrameworkLogger getLog(Class c, String contextId) {
        return contextId == null ? FrameworkLogger.getLog(c) : FrameworkLogger.getLog(contextId + '.' + c.getName());
    }

    public static FrameworkLogger getLog(String baseId, String contextId) {
        return contextId == null ? FrameworkLogger.getLog(baseId) : FrameworkLogger.getLog(contextId + '.' + baseId);
    }

    public static synchronized FrameworkLogger getLog(String s) {
        if (loggerInstances.containsKey(s)) {
            return (FrameworkLogger)loggerInstances.get(s);
        }
        return new FrameworkLogger(s);
    }

    public void log(Level level, String message, Throwable t) {
        this.privlog(level, message, t, 2, FrameworkLogger.class);
    }

    public void privlog(Level level, String message, Throwable t, int revertMethods, Class skipClass) {
        if (noopMode) {
            return;
        }
        if (this.log4jLogger == null) {
            StackTraceElement[] elements = new Throwable().getStackTrace();
            String c = "";
            String m = "";
            if (elements.length > revertMethods) {
                c = elements[revertMethods].getClassName();
                m = elements[revertMethods].getMethodName();
            }
            if (t == null) {
                this.jdkLogger.logp(level, c, m, message);
            } else {
                this.jdkLogger.logp(level, c, m, message, t);
            }
        } else {
            try {
                Object[] objectArray;
                if (callerFqcnAvailable) {
                    Object[] objectArray2 = new Object[4];
                    objectArray2[0] = skipClass.getName();
                    objectArray2[1] = jdkToLog4jLevels.get(level);
                    objectArray2[2] = message;
                    objectArray = objectArray2;
                    objectArray2[3] = t;
                } else {
                    Object[] objectArray3 = new Object[3];
                    objectArray3[0] = jdkToLog4jLevels.get(level);
                    objectArray3[1] = message;
                    objectArray = objectArray3;
                    objectArray3[2] = t;
                }
                log4jLogMethod.invoke(this.log4jLogger, objectArray);
            }
            catch (Exception e) {
                throw new RuntimeException("Logging failed when attempting to log: " + message, e);
            }
        }
    }

    public void enduserlog(Level level, String message) {
        if (noopMode) {
            return;
        }
        if (this.log4jLogger == null) {
            String c = FrameworkLogger.class.getName();
            String m = "\\l";
            this.jdkLogger.logp(level, c, m, message);
        } else {
            try {
                Object[] objectArray;
                if (callerFqcnAvailable) {
                    Object[] objectArray2 = new Object[4];
                    objectArray2[0] = FrameworkLogger.class.getName();
                    objectArray2[1] = jdkToLog4jLevels.get(level);
                    objectArray2[2] = message;
                    objectArray = objectArray2;
                    objectArray2[3] = null;
                } else {
                    Object[] objectArray3 = new Object[3];
                    objectArray3[0] = jdkToLog4jLevels.get(level);
                    objectArray3[1] = message;
                    objectArray = objectArray3;
                    objectArray3[2] = null;
                }
                log4jLogMethod.invoke(this.log4jLogger, objectArray);
            }
            catch (Exception e) {
                throw new RuntimeException("Logging failed when attempting to log: " + message, e);
            }
        }
    }

    public void log(Level level, String message) {
        this.privlog(level, message, null, 2, FrameworkLogger.class);
    }

    public void finer(String message) {
        this.privlog(Level.FINER, message, null, 2, FrameworkLogger.class);
    }

    public void warning(String message) {
        this.privlog(Level.WARNING, message, null, 2, FrameworkLogger.class);
    }

    public void severe(String message) {
        this.privlog(Level.SEVERE, message, null, 2, FrameworkLogger.class);
    }

    public void info(String message) {
        this.privlog(Level.INFO, message, null, 2, FrameworkLogger.class);
    }

    public void finest(String message) {
        this.privlog(Level.FINEST, message, null, 2, FrameworkLogger.class);
    }

    public void error(String message) {
        this.privlog(Level.WARNING, message, null, 2, FrameworkLogger.class);
    }

    public void finer(String message, Throwable t) {
        this.privlog(Level.FINER, message, t, 2, FrameworkLogger.class);
    }

    public void warning(String message, Throwable t) {
        this.privlog(Level.WARNING, message, t, 2, FrameworkLogger.class);
    }

    public void severe(String message, Throwable t) {
        this.privlog(Level.SEVERE, message, t, 2, FrameworkLogger.class);
    }

    public void info(String message, Throwable t) {
        this.privlog(Level.INFO, message, t, 2, FrameworkLogger.class);
    }

    public void finest(String message, Throwable t) {
        this.privlog(Level.FINEST, message, t, 2, FrameworkLogger.class);
    }

    public void error(String message, Throwable t) {
        this.privlog(Level.WARNING, message, t, 2, FrameworkLogger.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDefaultJdkConfig() {
        File globalCfgFile = new File(System.getProperty("java.home"), "lib/logging.properties");
        if (!globalCfgFile.isFile()) {
            return false;
        }
        FileInputStream fis = null;
        LogManager lm = LogManager.getLogManager();
        try {
            fis = new FileInputStream(globalCfgFile);
            Properties defaultProps = new Properties();
            defaultProps.load(fis);
            Enumeration<?> names = defaultProps.propertyNames();
            int i = 0;
            while (names.hasMoreElements()) {
                ++i;
                String name = (String)names.nextElement();
                String liveVal = lm.getProperty(name);
                if (liveVal == null) {
                    boolean bl = false;
                    return bl;
                }
                if (lm.getProperty(name).equals(liveVal)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    static {
        callerFqcnAvailable = false;
        try {
            FrameworkLogger.reconfigure();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

