/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class HashMap
extends BaseHashMap {
    Set keySet;
    Collection values;

    public HashMap() {
        this(8);
    }

    public HashMap(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity, 3, 3, false);
    }

    public Object get(Object key) {
        int hash = key.hashCode();
        int lookup = this.getLookup(key, hash);
        if (lookup != -1) {
            return this.objectValueTable[lookup];
        }
        return null;
    }

    public Object put(Object key, Object value) {
        return super.addOrRemove(0L, 0L, key, value, false);
    }

    public Object remove(Object key) {
        return super.removeObject(key, false);
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    public void putAll(HashMap t) {
        Iterator it = t.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            this.put(key, t.get(key));
        }
    }

    public void valuesToArray(Object[] array) {
        Iterator it = this.values().iterator();
        int i = 0;
        while (it.hasNext()) {
            array[i] = it.next();
            ++i;
        }
    }

    public void keysToArray(Object[] array) {
        Iterator it = this.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            array[i] = it.next();
            ++i;
        }
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    class Values
    implements Collection {
        Values() {
        }

        @Override
        public Iterator iterator() {
            HashMap hashMap = HashMap.this;
            hashMap.getClass();
            return new BaseHashMap.BaseHashIterator(hashMap, false);
        }

        @Override
        public int size() {
            return HashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void clear() {
            HashMap.this.clear();
        }
    }

    class KeySet
    implements Set {
        KeySet() {
        }

        @Override
        public Iterator iterator() {
            HashMap hashMap = HashMap.this;
            hashMap.getClass();
            return new BaseHashMap.BaseHashIterator(hashMap, true);
        }

        @Override
        public int size() {
            return HashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return HashMap.this.containsKey(o);
        }

        @Override
        public Object get(Object key) {
            int lookup = HashMap.this.getLookup(key, key.hashCode());
            if (lookup < 0) {
                return null;
            }
            return HashMap.this.objectKeyTable[lookup];
        }

        @Override
        public boolean add(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            int oldSize = this.size();
            HashMap.this.remove(o);
            return this.size() != oldSize;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void clear() {
            HashMap.this.clear();
        }
    }
}

