/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import org.hsqldb.lib.StringConverter;

public class HsqlByteArrayOutputStream
extends OutputStream
implements DataOutput {
    protected byte[] buffer;
    protected int count;

    public HsqlByteArrayOutputStream() {
        this(128);
    }

    public HsqlByteArrayOutputStream(int size) {
        if (size < 128) {
            size = 128;
        }
        this.buffer = new byte[size];
    }

    public HsqlByteArrayOutputStream(byte[] buffer) {
        this.buffer = buffer;
    }

    public HsqlByteArrayOutputStream(InputStream input, int length) throws IOException {
        this.buffer = new byte[length];
        int used = this.write(input, length);
        if (used != length) {
            throw new EOFException();
        }
    }

    public HsqlByteArrayOutputStream(InputStream input) throws IOException {
        int read;
        this.buffer = new byte[128];
        while ((read = input.read(this.buffer, this.count, this.buffer.length - this.count)) != -1) {
            this.count += read;
            if (this.count != this.buffer.length) continue;
            this.ensureRoom(128);
        }
    }

    @Override
    public void writeShort(int v) {
        this.ensureRoom(2);
        this.buffer[this.count++] = (byte)(v >>> 8);
        this.buffer[this.count++] = (byte)v;
    }

    @Override
    public void writeInt(int v) {
        if (this.count + 4 > this.buffer.length) {
            this.ensureRoom(4);
        }
        this.buffer[this.count++] = (byte)(v >>> 24);
        this.buffer[this.count++] = (byte)(v >>> 16);
        this.buffer[this.count++] = (byte)(v >>> 8);
        this.buffer[this.count++] = (byte)v;
    }

    @Override
    public void writeLong(long v) {
        this.writeInt((int)(v >>> 32));
        this.writeInt((int)v);
    }

    @Override
    public final void writeBytes(String s) {
        int len = s.length();
        this.ensureRoom(len);
        for (int i = 0; i < len; ++i) {
            this.buffer[this.count++] = (byte)s.charAt(i);
        }
    }

    @Override
    public final void writeFloat(float v) {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public final void writeDouble(double v) {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeBoolean(boolean v) {
        this.ensureRoom(1);
        this.buffer[this.count++] = (byte)(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) {
        this.ensureRoom(1);
        this.buffer[this.count++] = (byte)v;
    }

    @Override
    public void writeChar(int v) {
        this.ensureRoom(2);
        this.buffer[this.count++] = (byte)(v >>> 8);
        this.buffer[this.count++] = (byte)v;
    }

    @Override
    public void writeChars(String s) {
        int len = s.length();
        this.ensureRoom(len * 2);
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this.buffer[this.count++] = (byte)(v >>> 8);
            this.buffer[this.count++] = (byte)v;
        }
    }

    @Override
    public void writeUTF(String str) throws IOException {
        int len = str.length();
        if (len > 65535) {
            throw new UTFDataFormatException();
        }
        this.ensureRoom(len * 3 + 2);
        int initpos = this.count;
        this.count += 2;
        StringConverter.stringToUTFBytes(str, this);
        int bytecount = this.count - initpos - 2;
        if (bytecount > 65535) {
            this.count = initpos;
            throw new UTFDataFormatException();
        }
        this.buffer[initpos++] = (byte)(bytecount >>> 8);
        this.buffer[initpos] = (byte)bytecount;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void write(int b) {
        this.ensureRoom(1);
        this.buffer[this.count++] = (byte)b;
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.ensureRoom(len);
        System.arraycopy(b, off, this.buffer, this.count, len);
        this.count += len;
    }

    public String toString() {
        return new String(this.buffer, 0, this.count);
    }

    @Override
    public void close() throws IOException {
    }

    public void writeNoCheck(int b) {
        this.buffer[this.count++] = (byte)b;
    }

    public void writeChars(char[] charArray) {
        int len = charArray.length;
        this.ensureRoom(len * 2);
        for (int i = 0; i < len; ++i) {
            char v = charArray[i];
            this.buffer[this.count++] = (byte)(v >>> 8);
            this.buffer[this.count++] = (byte)v;
        }
    }

    public int write(InputStream input, int countLimit) throws IOException {
        int read;
        int left = countLimit;
        this.ensureRoom(countLimit);
        while (left > 0 && (read = input.read(this.buffer, this.count, left)) != -1) {
            left -= read;
            this.count += read;
        }
        return countLimit - left;
    }

    public int write(Reader input, int countLimit) throws IOException {
        int c;
        int left;
        this.ensureRoom(countLimit * 2);
        for (left = countLimit; left > 0 && (c = input.read()) != -1; --left) {
            this.writeChar(c);
        }
        return countLimit - left;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buffer, 0, this.count);
    }

    public void reset() {
        this.count = 0;
    }

    public byte[] toByteArray() {
        byte[] newbuf = new byte[this.count];
        System.arraycopy(this.buffer, 0, newbuf, 0, this.count);
        return newbuf;
    }

    public int size() {
        return this.count;
    }

    public void setPosition(int newPos) {
        if (newPos > this.buffer.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.count = newPos;
    }

    public String toString(String enc) throws UnsupportedEncodingException {
        return new String(this.buffer, 0, this.count, enc);
    }

    public void write(char[] c, int off, int len) {
        this.ensureRoom(len * 2);
        for (int i = off; i < len; ++i) {
            char v = c[i];
            this.buffer[this.count++] = (byte)(v >>> 8);
            this.buffer[this.count++] = (byte)v;
        }
    }

    public void fill(int b, int len) {
        this.ensureRoom(len);
        for (int i = 0; i < len; ++i) {
            this.buffer[this.count++] = (byte)b;
        }
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public void ensureRoom(int extra) {
        long newsize;
        long newcount = this.count + extra;
        if (newcount > Integer.MAX_VALUE) {
            throw new OutOfMemoryError("2GB maximum buffer length exceeded");
        }
        if (newcount > newsize) {
            for (newsize = (long)this.buffer.length; newcount > newsize; newsize *= 2L) {
            }
            if (newsize > Integer.MAX_VALUE) {
                newsize = Integer.MAX_VALUE;
            }
            byte[] newbuf = new byte[(int)newsize];
            System.arraycopy(this.buffer, 0, newbuf, 0, this.count);
            this.buffer = newbuf;
        }
    }

    public void reset(int newSize) {
        this.count = 0;
        if (newSize > this.buffer.length) {
            this.buffer = new byte[newSize];
        }
    }

    public void reset(byte[] buffer) {
        this.count = 0;
        this.buffer = buffer;
    }

    public void setSize(int size) {
        if (size > this.buffer.length) {
            this.reset(size);
        }
        this.count = size;
    }
}

