/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.DoubleIntIndex;

public class IntIndex {
    private int count = 0;
    private int capacity;
    private boolean sorted = true;
    private boolean sortOnValues = true;
    private boolean hasChanged;
    private final boolean fixedSize;
    private int[] keys;
    private int[] values;
    private int targetSearchValue;

    public IntIndex(int capacity, boolean fixedSize) {
        this.capacity = capacity;
        this.keys = new int[capacity];
        this.fixedSize = fixedSize;
        this.hasChanged = true;
    }

    public synchronized int getKey(int i) {
        if (i < 0 || i >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return this.keys[i];
    }

    public synchronized void setKey(int i, int key) {
        if (i < 0 || i >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.sortOnValues) {
            this.sorted = false;
        }
        this.keys[i] = key;
    }

    public synchronized int size() {
        return this.count;
    }

    public synchronized int capacity() {
        return this.capacity;
    }

    public int[] getKeys() {
        return this.keys;
    }

    public long getTotalValues() {
        long total = 0L;
        for (int i = 0; i < this.count; ++i) {
            total += (long)this.keys[i];
        }
        return total;
    }

    public void setSize(int newSize) {
        this.count = newSize;
    }

    public synchronized boolean addUnsorted(int key) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (this.sorted && this.count != 0 && key < this.keys[this.count - 1]) {
            this.sorted = false;
        }
        this.hasChanged = true;
        this.keys[this.count] = key;
        ++this.count;
        return true;
    }

    public synchronized boolean addSorted(int key) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (this.count != 0 && key < this.keys[this.count - 1]) {
            return false;
        }
        this.hasChanged = true;
        this.keys[this.count] = key;
        ++this.count;
        return true;
    }

    public synchronized boolean addUnique(int key) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = key;
        int i = this.binaryEmptySlotSearch();
        if (i == -1) {
            return false;
        }
        this.hasChanged = true;
        if (this.count != i) {
            this.moveRows(i, i + 1, this.count - i);
        }
        this.keys[i] = key;
        ++this.count;
        return true;
    }

    public synchronized int add(int key) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return -1;
            }
            this.doubleCapacity();
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = key;
        int i = this.binarySlotSearch();
        if (i == -1) {
            return i;
        }
        this.hasChanged = true;
        if (this.count != i) {
            this.moveRows(i, i + 1, this.count - i);
        }
        this.keys[i] = key;
        ++this.count;
        return i;
    }

    public void clear() {
        this.removeAll();
    }

    public synchronized int findFirstGreaterEqualKeyIndex(int value) {
        int index = this.findFirstGreaterEqualSlotIndex(value);
        return index == this.count ? -1 : index;
    }

    public synchronized int findFirstEqualKeyIndex(int value) {
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = value;
        return this.binaryFirstSearch();
    }

    public synchronized int findFirstConsecutiveKeys(int number) {
        int baseIndex = -1;
        if (this.count == 0) {
            return -1;
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        if (number == 1) {
            return 0;
        }
        for (int i = 1; i < this.count; ++i) {
            if (this.keys[i - 1] == this.keys[i] - 1) {
                if (baseIndex == -1) {
                    baseIndex = i - 1;
                }
                if (i - baseIndex + 1 != this.count) continue;
                return baseIndex;
            }
            baseIndex = -1;
        }
        return baseIndex;
    }

    public synchronized int removeFirstConsecutiveKeys(int number, int def) {
        int baseIndex = this.findFirstConsecutiveKeys(number);
        if (baseIndex == -1) {
            return def;
        }
        int result = this.keys[baseIndex];
        this.removeRange(baseIndex, baseIndex + number);
        return result;
    }

    public synchronized int findFirstGreaterEqualSlotIndex(int value) {
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = value;
        return this.binarySlotSearch();
    }

    private int binaryFirstSearch() {
        int low = 0;
        int high = this.count;
        int mid = 0;
        int compare = 0;
        int found = this.count;
        while (low < high) {
            mid = low + high >>> 1;
            compare = this.compare(mid);
            if (compare < 0) {
                high = mid;
                continue;
            }
            if (compare > 0) {
                low = mid + 1;
                continue;
            }
            high = mid;
            found = mid;
        }
        return found == this.count ? -1 : found;
    }

    private int binarySlotSearch() {
        int low = 0;
        int high = this.count;
        int mid = 0;
        int compare = 0;
        while (low < high) {
            mid = low + high >>> 1;
            compare = this.compare(mid);
            if (compare <= 0) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return low;
    }

    private int binaryEmptySlotSearch() {
        int low = 0;
        int high = this.count;
        int mid = 0;
        int compare = 0;
        while (low < high) {
            mid = low + high >>> 1;
            compare = this.compare(mid);
            if (compare < 0) {
                high = mid;
                continue;
            }
            if (compare > 0) {
                low = mid + 1;
                continue;
            }
            return -1;
        }
        return low;
    }

    public synchronized void sort() {
        this.fastQuickSort();
    }

    private synchronized void fastQuickSort() {
        DoubleIntIndex indices = new DoubleIntIndex(32, false);
        int threshold = 16;
        indices.push(0, this.count - 1);
        while (indices.size() > 0) {
            int start = indices.peekKey();
            int end = indices.peekValue();
            indices.pop();
            if (end - start >= threshold) {
                int pivot = this.partition(start, end, start + (end - start >>> 1));
                indices.push(start, pivot - 1);
                indices.push(pivot + 1, end);
                continue;
            }
            this.insertionSort(start, end);
        }
        this.sorted = true;
    }

    private int partition(int start, int end, int pivot) {
        int store = start;
        this.swap(pivot, end);
        for (int i = start; i <= end - 1; ++i) {
            if (!this.lessThan(i, end)) continue;
            this.swap(i, store);
            ++store;
        }
        this.swap(store, end);
        return store;
    }

    private synchronized void fastQuickSortRecursive() {
        this.quickSort(0, this.count - 1);
        this.insertionSort(0, this.count - 1);
        this.sorted = true;
    }

    private void quickSort(int l, int r) {
        int M = 16;
        if (r - l > M) {
            int i = r + l >>> 1;
            if (this.lessThan(i, l)) {
                this.swap(l, i);
            }
            if (this.lessThan(r, l)) {
                this.swap(l, r);
            }
            if (this.lessThan(r, i)) {
                this.swap(i, r);
            }
            int j = r - 1;
            this.swap(i, j);
            i = l;
            int v = j;
            while (true) {
                if (this.lessThan(++i, v)) {
                    continue;
                }
                while (this.lessThan(v, --j)) {
                }
                if (j < i) break;
                this.swap(i, j);
            }
            this.swap(i, r - 1);
            this.quickSort(l, j);
            this.quickSort(i + 1, r);
        }
    }

    private void insertionSort(int lo0, int hi0) {
        for (int i = lo0 + 1; i <= hi0; ++i) {
            int j;
            for (j = i; j > lo0 && this.lessThan(i, j - 1); --j) {
            }
            if (i == j) continue;
            this.moveAndInsertRow(i, j);
        }
    }

    protected void moveAndInsertRow(int i, int j) {
        int col1 = this.keys[i];
        this.moveRows(j, j + 1, i - j);
        this.keys[j] = col1;
    }

    protected void swap(int i1, int i2) {
        int col1 = this.keys[i1];
        this.keys[i1] = this.keys[i2];
        this.keys[i2] = col1;
    }

    protected int compare(int i) {
        if (this.targetSearchValue > this.keys[i]) {
            return 1;
        }
        if (this.targetSearchValue < this.keys[i]) {
            return -1;
        }
        return 0;
    }

    protected boolean lessThan(int i, int j) {
        return this.keys[i] < this.keys[j];
    }

    protected void moveRows(int fromIndex, int toIndex, int rows) {
        System.arraycopy(this.keys, fromIndex, this.keys, toIndex, rows);
    }

    protected void doubleCapacity() {
        this.keys = (int[])ArrayUtil.resizeArray(this.keys, this.capacity * 2);
        this.capacity *= 2;
    }

    public void removeRange(int start, int limit) {
        ArrayUtil.adjustArray(73, this.keys, this.count, start, start - limit);
        this.count -= limit - start;
    }

    public void removeAll() {
        this.hasChanged = true;
        ArrayUtil.clearArray(73, this.keys, 0, this.count);
        this.count = 0;
    }

    public void copyTo(IntIndex other) {
        System.arraycopy(this.keys, 0, other.keys, 0, this.count);
        other.setSize(this.count);
    }

    public final synchronized void remove(int position) {
        this.hasChanged = true;
        this.moveRows(position + 1, position, this.count - position - 1);
        --this.count;
        this.keys[this.count] = 0;
        this.values[this.count] = 0;
    }

    private int peek() {
        return this.getKey(this.count - 1);
    }

    private boolean pop() {
        if (this.count > 0) {
            --this.count;
            return true;
        }
        return false;
    }

    private boolean push(int key) {
        return this.addUnsorted(key);
    }
}

