/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.Set;

public class OrderedHashSet
extends HashSet
implements HsqlList,
Set {
    public OrderedHashSet() {
        super(8);
        this.isList = true;
    }

    @Override
    public boolean remove(Object key) {
        return super.removeObject(key, true) != null;
    }

    @Override
    public Object remove(int index) throws IndexOutOfBoundsException {
        this.checkRange(index);
        return super.removeObject(this.objectKeyTable[index], true);
    }

    public boolean insert(int index, Object key) throws IndexOutOfBoundsException {
        int i;
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.contains(key)) {
            return false;
        }
        if (index == this.size()) {
            return this.add(key);
        }
        Object[] array = new Object[this.size()];
        this.toArray(array);
        super.clear();
        for (i = 0; i < index; ++i) {
            this.add(array[i]);
        }
        this.add(key);
        for (i = index; i < array.length; ++i) {
            this.add(array[i]);
        }
        return true;
    }

    @Override
    public Object set(int index, Object key) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void add(int index, Object key) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Object get(int index) throws IndexOutOfBoundsException {
        this.checkRange(index);
        return this.objectKeyTable[index];
    }

    @Override
    public void toArray(Object[] array) {
        System.arraycopy(this.objectKeyTable, 0, array, 0, array.length);
    }

    public void addAll(OrderedHashSet other) {
        int size = other.size();
        for (int i = 0; i < size; ++i) {
            this.add(other.get(i));
        }
    }

    public int getIndex(Object key) {
        return this.getLookup(key, key.hashCode());
    }

    public int getLargestIndex(OrderedHashSet other) {
        int max = -1;
        int size = other.size();
        for (int i = 0; i < size; ++i) {
            int index = this.getIndex(other.get(i));
            if (index <= max) continue;
            max = index;
        }
        return max;
    }

    public int getSmallestIndex(OrderedHashSet other) {
        int min = -1;
        int size = other.size();
        for (int i = 0; i < size; ++i) {
            int index = this.getIndex(other.get(i));
            if (index == -1 || min != -1 && index >= min) continue;
            min = index;
        }
        return min;
    }

    public int getCommonElementCount(Set other) {
        int count = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!other.contains(this.objectKeyTable[i])) continue;
            ++count;
        }
        return count;
    }

    public static OrderedHashSet addAll(OrderedHashSet first, OrderedHashSet second) {
        if (second == null) {
            return first;
        }
        if (first == null) {
            first = new OrderedHashSet();
        }
        first.addAll(second);
        return first;
    }

    public static OrderedHashSet add(OrderedHashSet first, Object value) {
        if (value == null) {
            return first;
        }
        if (first == null) {
            first = new OrderedHashSet();
        }
        first.add(value);
        return first;
    }

    private void checkRange(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

