/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.navigator;

import org.hsqldb.HsqlException;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowSetNavigatorDataTable
extends RowSetNavigatorData {
    public TableBase table;
    public PersistentStore store;
    RowIterator iterator;
    Row currentRow;
    int maxMemoryRowCount;
    boolean isClosed;
    Object[] tempRowData;

    public RowSetNavigatorDataTable(Session session, QuerySpecification select) {
        super(session);
        this.rangePosition = select.resultRangePosition;
        this.maxMemoryRowCount = session.getResultMemoryRowCount();
        this.visibleColumnCount = select.indexLimitVisible;
        this.table = select.resultTable.duplicate();
        this.table.store = this.store = session.sessionData.getNewResultRowStore(this.table, !select.isAggregated);
        this.isAggregate = select.isAggregated;
        this.isSimpleAggregate = select.isAggregated && !select.isGrouped;
        this.reindexTable = select.isGrouped;
        this.mainIndex = select.mainIndex;
        this.fullIndex = select.fullIndex;
        this.orderIndex = select.orderIndex;
        this.groupIndex = select.groupIndex;
        this.idIndex = select.idIndex;
        this.tempRowData = new Object[1];
    }

    public RowSetNavigatorDataTable(Session session, QuerySpecification select, RowSetNavigatorData navigator) {
        this(session, select);
        navigator.reset();
        while (navigator.hasNext()) {
            this.add(navigator.getNext());
        }
    }

    public RowSetNavigatorDataTable(Session session, QueryExpression queryExpression) {
        super(session);
        this.maxMemoryRowCount = session.getResultMemoryRowCount();
        this.table = queryExpression.resultTable.duplicate();
        this.visibleColumnCount = this.table.getColumnCount();
        this.table.store = this.store = session.sessionData.getNewResultRowStore(this.table, true);
        this.mainIndex = queryExpression.mainIndex;
        this.fullIndex = queryExpression.fullIndex;
    }

    public RowSetNavigatorDataTable(Session session, Table table) {
        super(session);
        this.maxMemoryRowCount = session.getResultMemoryRowCount();
        this.table = table;
        this.visibleColumnCount = table.getColumnCount();
        this.mainIndex = table.getPrimaryIndex();
        this.fullIndex = table.getFullIndex(session);
        this.store = table.getRowStore(session);
        this.size = (int)this.mainIndex.size(session, this.store);
        this.reset();
    }

    @Override
    public void sortFull(Session session) {
        if (this.reindexTable) {
            this.store.indexRows(session);
        }
        this.mainIndex = this.fullIndex;
        this.reset();
    }

    @Override
    public void sortOrder(Session session) {
        if (this.orderIndex != null) {
            if (this.reindexTable) {
                this.store.indexRows(session);
            }
            this.mainIndex = this.orderIndex;
            if (this.iterator != null) {
                this.iterator.release();
            }
            this.reset();
        }
    }

    @Override
    public void sortOrderUnion(Session session, SortAndSlice sortAndSlice) {
        if (sortAndSlice.index != null) {
            this.mainIndex = sortAndSlice.index;
            this.reset();
        }
    }

    @Override
    public void add(Object[] data) {
        try {
            Row row = (Row)this.store.getNewCachedObject(this.session, data, false);
            this.store.indexRow(this.session, row);
            ++this.size;
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    @Override
    void addAdjusted(Object[] data, int[] columnMap) {
        try {
            if (columnMap == null) {
                data = (Object[])ArrayUtil.resizeArrayIfDifferent(data, this.visibleColumnCount);
            } else {
                Object[] newData = new Object[this.visibleColumnCount];
                ArrayUtil.projectRow(data, columnMap, newData);
                data = newData;
            }
            this.add(data);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    @Override
    public void update(Object[] oldData, Object[] newData) {
        if (this.isSimpleAggregate) {
            return;
        }
        RowIterator it = this.groupIndex.findFirstRow(this.session, this.store, oldData);
        if (it.hasNext()) {
            Row row = it.getNextRow();
            it.removeCurrent();
            it.release();
            --this.size;
            this.add(newData);
        }
    }

    @Override
    public boolean absolute(int position) {
        return super.absolute(position);
    }

    @Override
    public Object[] getCurrent() {
        return this.currentRow.getData();
    }

    @Override
    public Row getCurrentRow() {
        return this.currentRow;
    }

    @Override
    public boolean next() {
        boolean result = super.next();
        this.currentRow = this.iterator.getNextRow();
        return result;
    }

    @Override
    public void removeCurrent() {
        if (this.currentRow != null) {
            this.iterator.removeCurrent();
            this.currentRow = null;
            --this.currentPos;
            --this.size;
        }
    }

    @Override
    public void reset() {
        super.reset();
        if (this.iterator != null) {
            this.iterator.release();
        }
        this.iterator = this.mainIndex.firstRow(this.session, this.store, 0, null);
    }

    @Override
    public void release() {
        if (this.isClosed) {
            return;
        }
        this.iterator.release();
        this.store.release();
        this.isClosed = true;
    }

    @Override
    public void clear() {
        this.table.clearAllData(this.store);
        this.size = 0;
        this.reset();
    }

    @Override
    public boolean isMemory() {
        return this.store.isMemory();
    }

    @Override
    public void read(RowInputInterface in, ResultMetaData meta) {
    }

    @Override
    public void write(RowOutputInterface out, ResultMetaData meta) {
        this.reset();
        out.writeLong(this.id);
        out.writeInt(this.size);
        out.writeInt(0);
        out.writeInt(this.size);
        while (this.hasNext()) {
            Object[] data = this.getNext();
            out.writeData(meta.getExtendedColumnCount(), meta.columnTypes, data, null, null);
        }
        this.reset();
    }

    public Object[] getData(Long rowId) {
        this.tempRowData[0] = rowId;
        RowIterator it = this.idIndex.findFirstRow(this.session, this.store, this.tempRowData, this.idIndex.getDefaultColumnMap());
        return it.getNext();
    }

    public void copy(RowSetNavigatorData other, int[] rightColumnIndexes) {
        while (other.hasNext()) {
            Object[] currentData = other.getNext();
            this.addAdjusted(currentData, rightColumnIndexes);
        }
        other.release();
    }

    @Override
    public void union(Session session, RowSetNavigatorData other) {
        int colCount = this.table.getColumnTypes().length;
        this.removeDuplicates(session);
        other.reset();
        while (other.hasNext()) {
            Object[] currentData = other.getNext();
            RowIterator it = this.findFirstRow(currentData);
            if (!it.hasNext()) {
                currentData = (Object[])ArrayUtil.resizeArrayIfDifferent(currentData, colCount);
                this.add(currentData);
            }
            it.release();
        }
        other.release();
        this.reset();
    }

    @Override
    public void intersect(Session session, RowSetNavigatorData other) {
        this.removeDuplicates(session);
        other.sortFull(session);
        while (this.hasNext()) {
            Object[] currentData = this.getNext();
            boolean hasRow = other.containsRow(currentData);
            if (hasRow) continue;
            this.removeCurrent();
        }
        other.release();
    }

    @Override
    public void intersectAll(Session session, RowSetNavigatorData other) {
        Object[] compareData = null;
        Row otherRow = null;
        Object[] otherData = null;
        this.sortFull(session);
        other.sortFull(session);
        RowIterator it = this.fullIndex.emptyIterator();
        while (this.hasNext()) {
            boolean newGroup;
            Object[] currentData = this.getNext();
            boolean bl = newGroup = compareData == null || this.fullIndex.compareRowNonUnique(session, currentData, compareData, this.fullIndex.getColumnCount()) != 0;
            if (newGroup) {
                compareData = currentData;
                it = other.findFirstRow(currentData);
            }
            Object[] objectArray = otherData = (otherRow = it.getNextRow()) == null ? null : otherRow.getData();
            if (otherData != null && this.fullIndex.compareRowNonUnique(session, currentData, otherData, this.fullIndex.getColumnCount()) == 0) continue;
            this.removeCurrent();
        }
        other.release();
    }

    @Override
    public void except(Session session, RowSetNavigatorData other) {
        this.removeDuplicates(session);
        other.sortFull(session);
        while (this.hasNext()) {
            Object[] currentData = this.getNext();
            boolean hasRow = other.containsRow(currentData);
            if (!hasRow) continue;
            this.removeCurrent();
        }
        other.release();
    }

    @Override
    public void exceptAll(Session session, RowSetNavigatorData other) {
        Object[] compareData = null;
        Row otherRow = null;
        Object[] otherData = null;
        this.sortFull(session);
        other.sortFull(session);
        RowIterator it = this.fullIndex.emptyIterator();
        while (this.hasNext()) {
            boolean newGroup;
            Object[] currentData = this.getNext();
            boolean bl = newGroup = compareData == null || this.fullIndex.compareRowNonUnique(session, currentData, compareData, this.fullIndex.getColumnCount()) != 0;
            if (newGroup) {
                compareData = currentData;
                it = other.findFirstRow(currentData);
            }
            if ((otherData = (otherRow = it.getNextRow()) == null ? null : otherRow.getData()) == null || this.fullIndex.compareRowNonUnique(session, currentData, otherData, this.fullIndex.getColumnCount()) != 0) continue;
            this.removeCurrent();
        }
        other.release();
    }

    @Override
    public boolean hasUniqueNotNullRows(Session session) {
        this.sortFull(session);
        Object[] lastRowData = null;
        while (this.hasNext()) {
            Object[] currentData = this.getNext();
            if (this.hasNull(currentData)) continue;
            if (lastRowData != null && this.fullIndex.compareRow(session, lastRowData, currentData) == 0) {
                return false;
            }
            lastRowData = currentData;
        }
        return true;
    }

    @Override
    public void removeDuplicates(Session session) {
        this.sortFull(session);
        Object[] lastRowData = null;
        while (this.next()) {
            Object[] currentData = this.getCurrent();
            if (lastRowData != null && this.fullIndex.compareRow(session, lastRowData, currentData) == 0) {
                this.removeCurrent();
                continue;
            }
            lastRowData = currentData;
        }
        this.reset();
    }

    @Override
    public void trim(int limitstart, int limitcount) {
        int i;
        if (this.size == 0) {
            return;
        }
        if (limitstart >= this.size) {
            this.clear();
            return;
        }
        if (limitstart != 0) {
            this.reset();
            for (i = 0; i < limitstart; ++i) {
                this.next();
                this.removeCurrent();
            }
        }
        if (limitcount == 0 || limitcount >= this.size) {
            return;
        }
        this.reset();
        for (i = 0; i < limitcount; ++i) {
            this.next();
        }
        while (this.hasNext()) {
            this.next();
            this.removeCurrent();
        }
    }

    @Override
    boolean hasNull(Object[] data) {
        for (int i = 0; i < this.visibleColumnCount; ++i) {
            if (data[i] != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] getGroupData(Object[] data) {
        if (this.isSimpleAggregate) {
            if (this.simpleAggregateData == null) {
                this.simpleAggregateData = data;
                return null;
            }
            return this.simpleAggregateData;
        }
        RowIterator it = this.groupIndex.findFirstRow(this.session, this.store, data);
        if (it.hasNext()) {
            Row row = it.getNextRow();
            if (this.isAggregate) {
                row.setChanged(true);
            }
            return row.getData();
        }
        return null;
    }

    @Override
    boolean containsRow(Object[] data) {
        RowIterator it = this.mainIndex.findFirstRow(this.session, this.store, data);
        boolean result = it.hasNext();
        it.release();
        return result;
    }

    @Override
    RowIterator findFirstRow(Object[] data) {
        return this.mainIndex.findFirstRow(this.session, this.store, data);
    }
}

