/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.DataFileCacheSession;
import org.hsqldb.persist.DataSpaceManager;
import org.hsqldb.persist.DirectoryBlockCachedObject;
import org.hsqldb.persist.TableSpaceManager;
import org.hsqldb.persist.TableSpaceManagerBlocks;
import org.hsqldb.persist.TableSpaceManagerSimple;
import org.hsqldb.persist.TextCache;

public class DataSpaceManagerSimple
implements DataSpaceManager {
    DataFileCache cache;
    TableSpaceManager defaultSpaceManager;
    int fileBlockSize = 4096;
    long totalFragmentSize;
    int spaceIdSequence = 8;
    DoubleIntIndex lookup;

    DataSpaceManagerSimple(DataFileCache cache) {
        this.cache = cache;
        if (cache instanceof DataFileCacheSession) {
            this.defaultSpaceManager = new TableSpaceManagerSimple(cache);
        } else if (cache instanceof TextCache) {
            this.defaultSpaceManager = new TableSpaceManagerSimple(cache);
        } else {
            int capacity = cache.database.logger.propMaxFreeBlocks;
            this.defaultSpaceManager = new TableSpaceManagerBlocks(this, 7, this.fileBlockSize, capacity, cache.getDataFileScale(), 0);
            this.initialiseSpaces();
            cache.spaceManagerPosition = 0L;
        }
        this.totalFragmentSize = cache.lostSpaceSize;
    }

    @Override
    public TableSpaceManager getDefaultTableSpace() {
        return this.defaultSpaceManager;
    }

    @Override
    public TableSpaceManager getTableSpace(int spaceId) {
        if (spaceId >= this.spaceIdSequence) {
            this.spaceIdSequence = spaceId + 1;
        }
        return this.defaultSpaceManager;
    }

    @Override
    public int getNewTableSpaceID() {
        return this.spaceIdSequence++;
    }

    @Override
    public long getFileBlocks(int tableId, int blockCount) {
        long filePosition = this.cache.enlargeFileSpace((long)blockCount * (long)this.fileBlockSize);
        return filePosition;
    }

    @Override
    public void freeTableSpace(int spaceId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeTableSpace(int spaceId, DoubleIntIndex spaceList, long offset, long limit, boolean full) {
        this.totalFragmentSize += spaceList.getTotalValues() * (long)this.cache.getDataFileScale();
        if (full) {
            if (this.cache.fileFreePosition == limit) {
                this.cache.writeLock.lock();
                try {
                    this.cache.fileFreePosition = offset;
                }
                finally {
                    this.cache.writeLock.unlock();
                }
            } else {
                this.totalFragmentSize += limit - offset;
            }
            if (spaceList.size() != 0) {
                this.lookup = new DoubleIntIndex(spaceList.size(), true);
                spaceList.copyTo(this.lookup);
                spaceList.clear();
            }
        } else {
            spaceList.compactLookupAsIntervals();
            spaceList.setValuesSearchTarget();
            spaceList.sort();
            int extra = spaceList.size() - spaceList.capacity() / 2;
            if (extra > 0) {
                spaceList.removeRange(0, extra);
                this.totalFragmentSize -= spaceList.getTotalValues() * (long)this.cache.getDataFileScale();
            }
        }
    }

    @Override
    public long getLostBlocksSize() {
        return this.totalFragmentSize + this.defaultSpaceManager.getLostBlocksSize();
    }

    @Override
    public int getFileBlockSize() {
        return 0x100000 * this.cache.getDataFileScale() / 16;
    }

    @Override
    public boolean isModified() {
        return true;
    }

    @Override
    public void initialiseSpaces() {
        long currentSize = this.cache.getFileFreePos();
        long totalBlocks = (currentSize + (long)this.fileBlockSize) / (long)this.fileBlockSize;
        long lastFreePosition = this.cache.enlargeFileSpace(totalBlocks * (long)this.fileBlockSize - currentSize);
        this.defaultSpaceManager.initialiseFileBlock(this.lookup, lastFreePosition, this.cache.getFileFreePos());
        if (this.lookup != null) {
            this.totalFragmentSize -= this.lookup.getTotalValues() * (long)this.cache.getDataFileScale();
            this.lookup = null;
        }
    }

    @Override
    public void reset() {
        this.defaultSpaceManager.reset();
    }

    @Override
    public boolean isMultiSpace() {
        return false;
    }

    @Override
    public int getFileBlockItemCount() {
        return 65536;
    }

    @Override
    public DirectoryBlockCachedObject[] getDirectoryList() {
        return new DirectoryBlockCachedObject[0];
    }
}

