/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.lib.LongLookup;
import org.hsqldb.persist.CachedObjectBase;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class DirectoryBlockCachedObject
extends CachedObjectBase {
    public static final int fileSizeFactor = 12;
    int[] tableIds;
    int[] bitmapAddress;
    char[] freeSpace;
    char[] freeSpaceBlock;

    public DirectoryBlockCachedObject(int capacity) {
        this.tableIds = new int[capacity];
        this.bitmapAddress = new int[capacity];
        this.freeSpace = new char[capacity];
        this.freeSpaceBlock = new char[capacity];
        this.hasChanged = true;
    }

    @Override
    public void read(RowInputInterface in) {
        int i;
        this.position = in.getPos();
        int capacity = this.tableIds.length;
        for (i = 0; i < capacity; ++i) {
            this.tableIds[i] = in.readInt();
        }
        for (i = 0; i < capacity; ++i) {
            this.bitmapAddress[i] = in.readInt();
        }
        for (i = 0; i < capacity; ++i) {
            this.freeSpace[i] = in.readChar();
        }
        for (i = 0; i < capacity; ++i) {
            this.freeSpaceBlock[i] = in.readChar();
        }
        this.hasChanged = false;
    }

    @Override
    public int getDefaultCapacity() {
        return this.tableIds.length;
    }

    @Override
    public int getRealSize(RowOutputInterface out) {
        return this.tableIds.length * 12;
    }

    @Override
    public void write(RowOutputInterface out) {
        this.write(out, null);
    }

    @Override
    public void write(RowOutputInterface out, LongLookup lookup) {
        int i;
        int capacity = this.tableIds.length;
        out.setStorageSize(this.storageSize);
        for (i = 0; i < capacity; ++i) {
            out.writeInt(this.tableIds[i]);
        }
        for (i = 0; i < capacity; ++i) {
            out.writeInt(this.bitmapAddress[i]);
        }
        for (i = 0; i < capacity; ++i) {
            out.writeChar(this.freeSpace[i]);
        }
        for (i = 0; i < capacity; ++i) {
            out.writeChar(this.freeSpaceBlock[i]);
        }
        out.writeEnd();
    }

    public int[] getTableIdArray() {
        return this.tableIds;
    }

    public int[] getBitmapAddressArray() {
        return this.bitmapAddress;
    }

    public char[] getFreeSpaceArray() {
        return this.freeSpace;
    }

    public char[] getFreeBlockArray() {
        return this.freeSpaceBlock;
    }
}

